C
C ROUTINE TO FIND GOOD LENGTH OF AXIS FOR DISPLAY
C
       SUBROUTINE AXLENG(N,COO,UNTHX,UNTHY,UNTHZ,XL,YL,ZL,TMAX,TMIN)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
       REAL*8 UNTHX,UNTHY,UNTHZ                       
       REAL*8 XL,YL,ZL                       
       REAL*8 COO(3,*),VEC(3,NUMATMX)
       REAL*8 TMAX,TMIN,T(NUMATMX)
       INTEGER N,I
C                                                                       
       DO 1 I=1,N
         VEC(1,I)=COO(1,I)-XL
         VEC(2,I)=COO(2,I)-YL
         VEC(3,I)=COO(3,I)-ZL
1      CONTINUE
C
       TMAX=-1.0E08
       TMIN=1.0E08
       DO 2 I=1,N
         T(I)=UNTHX*VEC(1,I)+UNTHY*VEC(2,I)+UNTHZ*VEC(3,I)
       IF(T(I).GT.TMAX) THEN
         TMAX=T(I)
       ENDIF
       IF(T(I).LT.TMIN) THEN
         TMIN=T(I)
       ENDIF
2      CONTINUE
C
       TMIN=TMIN-(TMAX-TMIN)/10.0
       TMAX=TMAX+(TMAX-TMIN)/10.0
C
       RETURN
       END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
