C
C K-MEANS CLUSTERING ROUTINE.
C
C ADAPTED FROM PROGRAM IN BOOK OF HARTIGAN, J.A. "CLUSTERING ALGORITHMS"
C NEW YORK: WILEY, 1975
C
C STOPS WHEN A CLUSTER DOESN'T POSSESS ANY DOMAINS WITH AT 
C LEAST AS MANY RESIDUES AS THE MINIMUM SPECIFIED 
C
C RETURNED IS THE MAXIMUM NUMBER OF DOMAINS (PROVIDED NCLUSTER IS SET HIGH ENOUGH)
C FOR WHICH ALL DOMAIN PAIRS SATISFY THE CRITERION FOR THE RATIO OF
C EXTERNAL TO INTERNAL MOTION OR IF NOT AT LEAST ONE DOMAIN PAIR
C                                    
C
      SUBROUTINE CLUSTER2(MM, M, N, A,  K, ITER,
     &           DMSUM1, DMSUM2, SUM, IWORK, WORK, 
     &           NDOMM,DOMIN,NRES,WINDLEN,NAAT1,NAAT2,ATLIST1,
     &           ATLIST2,COO1,COO2,IRESBEGM,
     &           IRESENDM,NSEGM,NI,CA,CP,CB,COOBB1,COOBB2,
     &           MASS,NDOMOM,NCONM,DOMCONM,
     &           DOMORDM,EXTCRIT,EXTINTM)
C
      IMPLICIT NONE
      include 'DynDom.param'
C
      INTEGER N,M,MM,I,J,JJ,K,KK,KKK,KM,KN,ITER,NC,id,is
      INTEGER DMSUM1, DMSUM2, DCLUS , CLUSIZE(NDOMX)
      INTEGER NSEG(NDOMX),IRESBEG(NDOMX,NSEGMX)
      INTEGER IRESEND(NDOMX,NSEGMX)
      INTEGER DOMIN,NRES,WINDLEN
      INTEGER NONSEG(NDOMX),NONRESBEG(NDOMX,NSEGMX)
      INTEGER NONDOM,NONRESEND(NDOMX,NSEGMX)
      INTEGER NDOM,NDOMM,NSEGM(*)
      INTEGER IRESBEGM(NDOMX,*),IRESENDM(NDOMX,*)
      INTEGER NI(*),CA(*),CB(*),CP(*)
      INTEGER DOMORDM(*),NDOMO
      INTEGER NCONM(*),DOMCONM(NDOMX,*)
      INTEGER DOMORD(NDOMX),NDOMOM
      INTEGER NCON(NDOMX),DOMCON(NDOMX,NDOMX)
      INTEGER NAAT1(*),NAAT2(*)
      INTEGER ATLIST1(NRESMX,*),ATLIST2(NRESMX,*)
      INTEGER IWORK(*),CLUSNO,NOTBEEN,CLUSYESBEF,CLUSYES 
      REAL*8 COOBB1(3,*),COOBB2(3,*),MASS(*),EXTCRIT
      REAL*8 EXTINT(NDOMX,NDOMX),EXTINTM(NDOMX,*)
      REAL*8 COO1(3,*),COO2(3,*)
      REAL*8 SUM(DMSUM1,DMSUM2,*),A(MM,*),WORK(*),ERR,SM
      LOGICAL STOPCLUS,OK,ALLOK,ALLOKDONE,BEEN
C
      BEEN=.FALSE.
      NOTBEEN=0
      CLUSYES=1
      CLUSYESBEF=1
C
      ALLOKDONE=.FALSE.
      DCLUS = 2*N + M
      DO 10 I=1,7
         DO 10 J=1,N
            DO 10 KK=1,K+1
   10          SUM(I,J,KK)=0.
C
C     LOOP ONCE FOR EACH DESIRED CLUSTER
C
      DO 130 KK=1,K
C
         IF(KK.GT.NDOMX) THEN  
           WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF DOMAINS HAS 
     & BEEN EXCEEDED: ',NDOMX,KK
           WRITE(6,'(A)')'CHANGE VALUE FOR "NDOMX" IN "DynDom.param"'
           STOP
         ENDIF
C
         WRITE(6,'(A)')
         WRITE(6,'(A,I4)')'number of clusters:',KK
C
         DO 60 NC=1,ITER
            ERR=0.
            DO 20 KKK=1,KK
               DO 20 J=1,N
                  IF(NC.EQ.1.OR.SUM(1,J,KKK).NE.SUM(3,J,KKK)) ERR=1.
   20       CONTINUE
C
C     IF NO CHANGES HAVE BEEN MADE, OUTPUT THE CLUSTER
C
            IF(ERR.EQ.0.) GO TO 70
            DO 30 KKK=1,KK
               DO 30 J=1,N
                  SUM(2,J,KKK)=0.
   30       SUM(1,J,KKK)=SUM(3,J,KKK)
            DO 50 I=1,M
               DO 40 J=1,N
   40             WORK(J)=A(I,J)
               IWORK(I)=NC
C
C     FIND BEST CLUSTER FOR CASE I
C
               CALL KMEANS(N, WORK, KK,  DMSUM1, DMSUM2, SUM,
     &                     IWORK(I), WORK(DCLUS+I))
   50       CONTINUE
   60    CONTINUE
C
   70    CONTINUE 
C
         IF(KK.EQ.1) GOTO 16
C
         CALL SEGLENG(M,KK,IWORK,NSEG,IRESBEG,IRESEND,CLUSIZE)
C
C ROTATION OF WINDOW IS ASSIGNED TO THE RESIDUE AT ITS CENTRE
C
         DO 337 I=1,KK
           DO 338 J=1,NSEG(I)
             IRESBEG(I,J)=IRESBEG(I,J)+(WINDLEN/2)
             IRESEND(I,J)=IRESEND(I,J)+(WINDLEN/2)
338        CONTINUE
337      CONTINUE
C
C CREATE NEW DOMAINS IF CLUSTERS DO NOT FORM A CONNECTED STRUCTURE
C DISREGARD DOMAINS WITH FEWER RESIDUES THAN "DOMIN"
C STOP CLUSTERING ALGORITHM IF ANY CLUSTER DOESN'T HAVE A DOMAIN
C WITH AT LEAST "DOMIN" RESIDUES
C
         CLUSYESBEF=CLUSYES 
         NDOM=KK
         CALL SEGCONNECT2(DOMIN,NDOM,NAAT1,NAAT2,
     &    ATLIST1,ATLIST2,COO1,COO2,IRESBEG,IRESEND,NSEG,NONDOM,
     &    NONRESBEG,NONRESEND,NONSEG,CLUSNO)
C
          CLUSYES=KK-CLUSNO
C         
C
C THIS IS A NEW ROUTINE TO MAKE OUTPUT A BIT CLEANER 
C IT JOINS ELIMINATED SEGMENTS THAT ARE SEPARATED BY A DISTANCE LESS THAN 
C DOMIN TO THE DOMAINS THEY ARE EMBEDDED IN
C
         CALL JOINSEG(NDOM,NSEG,IRESBEG,IRESEND,NONDOM,NONSEG,
     &    NONRESBEG,NONRESEND,DOMIN)
C
C
C THE FOLLOWING CONDITIONAL ALLOWS IT TO LOOK FOR CLUSTERS
C WITH DOMAINS LARGER THAN DOMIN EVEN IF AT THE OUTSET IT
C FINDS ONLY CLUSTERS THAT GIVE DOMAINS SMALLER THAN DOMIN
C
         IF(CLUSYES.GT.CLUSYESBEF) THEN
C
           IF(NDOM.GE.2) THEN
             BEEN=.TRUE.
           ENDIF
C
           WRITE(6,'(A,I4)')'number of domains equal to or larger than m
     &inimum domain size:',NDOM
C
C DETERMINES MOST CONNECTED DOMAIN, AND THEN SECOND MOST CONNECTED
C DOMAIN AND SO ON.
C
           CALL DOMCONNECT (NRES,NDOM,NSEG,IRESBEG,IRESEND,NDOMO,
     &  DOMORD,DOMCON,NCON)
C
C CALCULATE RATIO OF INTERDOMAIN TO INTRADOMAIN DISPLACEMENT FOR ALL
C CONNECTED DOMAIN PAIRS
C
           CALL EXTSTOP2(NRES,NDOM,NSEG,IRESBEG,IRESEND,
     &      NI,CA,CP,CB,COOBB1,COOBB2,MASS,OK,ALLOK,
     &      NDOMO,NCON,DOMCON,DOMORD,EXTCRIT,EXTINT)
C
C REMEMBER DOMAIN INFO IF ALL DOMAIN PAIRS SATISFY THE CRITERION FOR 
C THE RATIO OF INTERDOMAIN TO INTRADOMAIN DISPLACEMENT
C
           IF(ALLOK) THEN
C
             ALLOKDONE=.TRUE.
C
             NDOMM=NDOM
             DO 11 I=1,NDOMM
               NSEGM(I)=NSEG(I)
               DO 12 J=1,NSEGM(I)
                 IRESBEGM(I,J)=IRESBEG(I,J)
                 IRESENDM(I,J)=IRESEND(I,J)
12             CONTINUE
11           CONTINUE
             NDOMOM=NDOMO
             DO 13 I=1,NDOMOM
               DOMORDM(I)=DOMORD(I)
               NCONM(DOMORDM(I))=NCON(DOMORD(I))
               DO 14 J=1,NCONM(DOMORDM(I))
                 DOMCONM(DOMORDM(I),J)=DOMCON(DOMORD(I),J)
                 EXTINTM(DOMORDM(I), DOMCONM(DOMORDM(I),J))=
     &           EXTINT(DOMORD(I), DOMCON(DOMORD(I),J))
14             CONTINUE
13           CONTINUE
C
           ELSEIF(.NOT.ALLOKDONE.AND.OK) THEN
C
             NDOMM=NDOM
             DO 21 I=1,NDOMM
               NSEGM(I)=NSEG(I)
               DO 22 J=1,NSEGM(I)
                 IRESBEGM(I,J)=IRESBEG(I,J)
                 IRESENDM(I,J)=IRESEND(I,J)
22             CONTINUE
21           CONTINUE
             NDOMOM=NDOMO
             DO 23 I=1,NDOMOM
               DOMORDM(I)=DOMORD(I)
               NCONM(DOMORDM(I))=NCON(DOMORD(I))
               DO 24 J=1,NCONM(DOMORDM(I))
                 DOMCONM(DOMORDM(I),J)=DOMCON(DOMORD(I),J)
                 EXTINTM(DOMORDM(I), DOMCONM(DOMORDM(I),J))=
     &           EXTINT(DOMORD(I), DOMCON(DOMORD(I),J))
24             CONTINUE
23           CONTINUE
C
           ENDIF
C
         ELSEIF(.NOT.BEEN.AND.NOTBEEN.LE.3) THEN
           NOTBEEN=NOTBEEN+1
           WRITE(6,'(A)')'found cluster for which all domains are less t
     &han minimum domain size'
           WRITE(6,'(A)')
         ELSE
           WRITE(6,'(A)')'found cluster for which all domains are less t
     &han minimum domain size'
           WRITE(6,'(A)')'exiting clustering routine'
           WRITE(6,'(A)')
           RETURN
         ENDIF
C
C CREATE A NEW CLUSTER BY SPLITTING VARIABLE WITH LARGEST WITHIN-
C CLUSTER VARIANCE AT THAT VALUE OF THAT VARIABLE AT THE CENTER
C OF THE CLUSTER
C
16       CONTINUE
C
         SM=0.
         DO 80 J=1,N
            DO 80 KKK=1,KK
               IF(SUM(4,J,KKK).GE.SM) THEN
                  SM=SUM(4,J,KKK)
                  KM=KKK
               ENDIF
   80    CONTINUE
         KN=KK+1
         DO 90 JJ=1,N
            SUM(2,JJ,KM)=0.
            SUM(3,JJ,KM)=0.
            SUM(2,JJ,KN)=0.
   90       SUM(3,JJ,KN)=0.
         DO 110 I=1,M
            IF(IWORK(I).EQ.KM) THEN
               DO 100 JJ=1,N
                  IF(A(I,JJ).GE.SUM(1,JJ,KM)) THEN
                     SUM(2,JJ,KN)=SUM(2,JJ,KN)+1
                     SUM(3,JJ,KN)=SUM(3,JJ,KN)+A(I,JJ)
                  ELSE
                     SUM(2,JJ,KM)=SUM(2,JJ,KM)+1
                     SUM(3,JJ,KM)=SUM(3,JJ,KM)+A(I,JJ)
                  ENDIF
  100          CONTINUE
            ENDIF
  110    CONTINUE
         DO 120 JJ=1,N
            IF(SUM(2,JJ,KN).NE.0.)SUM(3,JJ,KN)=SUM(3,JJ,KN)/SUM(2,JJ,KN)
            IF(SUM(2,JJ,KM).NE.0.)SUM(3,JJ,KM)=SUM(3,JJ,KM)/SUM(2,JJ,KM)
  120    CONTINUE
  130 CONTINUE
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
