C
C ROUTINE TO DETERMINE DIHEDRAL ANGLE CHANGES OF BENDING RESIDUES
C
      SUBROUTINE DIHEDR(IPAIR,ICONA,BEGA,ENDA,ICONB,BEGB,ENDB,
     & RESPDBNUM,RESPDBTYP,UX,UY,UZ,XL,YL,ZL,AMPROT,MASS,COOBB1,
     & COOBB2,NI,CA,CP,CB,IOUT7,NRES)
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      INTEGER ICONA(*),ICONB(*),ISEG,ICON,I,IOUT7
      INTEGER BEGA(NPAIRMX,*),ENDA(NPAIRMX,*)
      INTEGER BEGB(NPAIRMX,*),ENDB(NPAIRMX,*)
      INTEGER NI(*),CA(*),CP(*),CB(*),IPAIR,IRES,NRES
      INTEGER NSEG,SEGB(NPAIRMX),SEGE(NPAIRMX)
      REAL*8 COOBB1(3,*),COOBB2(3,*),UX,UY,UZ,XL,YL,ZL,AMPROT
      REAL*8 PRO,PROB,PROA
      REAL*8 ANGLE,UNX,UNY,UNZ
      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF,MASS(*),TRACER,RMSD
      REAL*8 PERCA,PERCB,PERC
      CHARACTER*5 RESPDBNUM(*)
      CHARACTER*4 RESPDBTYP(*)
C
      WRITE (IOUT7,'(A80)') '===========================================
     &====================================='
C
      IF(IPAIR.EQ.1.OR.IPAIR.EQ.21.OR.IPAIR.EQ.31) THEN
        WRITE(IOUT7,'(A,I3,A)')'ANALYSING DIHEDRALS IN BENDING RESIDUES 
     &FOR',IPAIR,'ST PAIR'
      ELSEIF(IPAIR.EQ.2.OR.IPAIR.EQ.22.OR.IPAIR.EQ.32) THEN
        WRITE(IOUT7,'(A,I3,A)')'ANALYSING DIHEDRALS IN BENDING RESIDUES 
     &FOR',IPAIR,'ND PAIR'
      ELSEIF(IPAIR.EQ.3.OR.IPAIR.EQ.23.OR.IPAIR.EQ.33) THEN
        WRITE(IOUT7,'(A,I3,A)')'ANALYSING DIHEDRALS IN BENDING RESIDUES 
     &FOR',IPAIR,'RD PAIR'
      ELSE
        WRITE(IOUT7,'(A,I3,A)')'ANALYSING DIHEDRALS IN BENDING RESIDUES 
     &FOR',IPAIR,'TH PAIR'
      ENDIF
      WRITE(IOUT7,'(A,F6.1,A)')'ANGULAR ROTATION OF DOMAINS:',AMPROT,
     &' DEGREES'
C
C FROM FIXED TO MOVING DOMAIN
C
      DO 4 ICON=1,ICONA(IPAIR)
C
        IF(BEGA(IPAIR,ICON).EQ.0.AND.ENDA(IPAIR,ICON).EQ.0) GOTO 4
      WRITE (IOUT7,'(A80)') '-------------------------------------------
     &--------------------------------------'
        WRITE(IOUT7,'(A,A5,A,A5,A)')'ANALYSING RESIDUES',RESPDBNUM(BEGA(
     &IPAIR,ICON)),'-',RESPDBNUM(ENDA(IPAIR,ICON)),' FIXED TO MOVING DOM
     &AIN'
C
        DO 5 IRES=BEGA(IPAIR,ICON)-1,ENDA(IPAIR,ICON)-1+1
          IF(IRES.LT.1.OR.IRES.GT.NRES) GOTO 5
C
C DETERMINE ROTATION VECTOR OF TETRAHEDRON OF CURRENT RESIDUE,IRES
C
          CALL EXTCOMP2(4,1,2,3,4,MASS,COOBB1(1,NI(IRES)),
     &     COOBB2(1,NI(IRES)),VEXT,VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
          CALL ROTVEC(1,2,3,4,COOBB1(1,NI(IRES)),VEXT,TRACER,
     &     ANGLE,UNX,UNY,UNZ)
C
          PROB=UX*UNX+UY*UNY+UZ*UNZ
          PROB=ANGLE*PROB
          PROB=PROB*180.0/PI
          PERCB=PROB*100.0/AMPROT
C
C DETERMINE ROTATION VECTOR OF TETRAHEDRON OF NEXT RESIDUE, IRES+1
C
          CALL EXTCOMP2(4,1,2,3,4,MASS,COOBB1(1,NI(IRES+1)),
     &     COOBB2(1,NI(IRES+1)),VEXT,VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
          CALL ROTVEC(1,2,3,4,COOBB1(1,NI(IRES+1)),VEXT,TRACER,
     &     ANGLE,UNX,UNY,UNZ)
C
          PROA=UX*UNX+UY*UNY+UZ*UNZ
          PROA=ANGLE*PROA
          PROA=PROA*180.0/PI
          PERCA=PROA*100.0/AMPROT
          PRO=PROA-PROB
          PERC=PERCA-PERCB
C
          WRITE(IOUT7,'(A)') 
          WRITE(IOUT7,'(A4,1X,A5,A1,A4,1X,A5)')RESPDBTYP(IRES),
     &     RESPDBNUM(IRES),'-',RESPDBTYP(IRES+1),RESPDBNUM(IRES+1)
          WRITE(IOUT7,'(A)') 
C
          WRITE(IOUT7,'(A5,A,F6.1,A)')RESPDBNUM(IRES+1),':',
     &     PERCA,' percent of total'
          WRITE(IOUT7,'(A,F6.1,A,F6.1,A)')'progress in direction of axis
     &:',PRO,' degrees,',PERC,' percentage increase'    
C
          CALL TORDIFF(IRES,NI,CA,CP,CB,MASS,COOBB1,COOBB2,
     &     UX,UY,UZ,IOUT7)
C
      WRITE (IOUT7,'(A80)') '-------------------------------------------
     &--------------------------------------'
5       CONTINUE
4     CONTINUE
C
C FROM MOVING TO FIXED DOMAIN
C 
      DO 6 ICON=1,ICONB(IPAIR)
C
        IF(BEGB(IPAIR,ICON).EQ.0.AND.ENDB(IPAIR,ICON).EQ.0) GOTO 6
      WRITE (IOUT7,'(A80)') '-------------------------------------------
     &--------------------------------------'
        WRITE(IOUT7,'(A,A5,A,A5,A)')'ANALYSING RESIDUES',RESPDBNUM(BEGB(
     &IPAIR,ICON)),'-',RESPDBNUM(ENDB(IPAIR,ICON)),' MOVING TO FIXED DOM 
     &AIN'
C
        DO 7 IRES=BEGB(IPAIR,ICON)-1,ENDB(IPAIR,ICON)-1+1
          IF(IRES.LT.1.OR.IRES.GT.NRES) GOTO 7
C
C DETERMINE ROTATION VECTOR OF TETRAHEDRON OF CURRENT RESIDUE,IRES
C
          CALL EXTCOMP2(4,1,2,3,4,MASS,COOBB1(1,NI(IRES)),
     &     COOBB2(1,NI(IRES)),VEXT,VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
          CALL ROTVEC(1,2,3,4,COOBB1(1,NI(IRES)),VEXT,TRACER,
     &     ANGLE,UNX,UNY,UNZ)
C
          PROB=UX*UNX+UY*UNY+UZ*UNZ
          PROB=AMPROT-PROB*ANGLE*180.0/PI
          PERCB=PROB*100.0/AMPROT
C
C DETERMINE ROTATION VECTOR OF TETRAHEDRON OF NEXT RESIDUE, IRES+1
C
          CALL EXTCOMP2(4,1,2,3,4,MASS,COOBB1(1,NI(IRES+1)),
     &     COOBB2(1,NI(IRES+1)),VEXT,VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
          CALL ROTVEC(1,2,3,4,COOBB1(1,NI(IRES+1)),VEXT,TRACER,
     &     ANGLE,UNX,UNY,UNZ)
C
          PROA=UX*UNX+UY*UNY+UZ*UNZ
          PROA=AMPROT-PROA*ANGLE*180.0/PI
          PERCA=PROA*100.0/AMPROT
          PRO=PROA-PROB
          PERC=PERCA-PERCB
C
          WRITE(IOUT7,'(A)') 
          WRITE(IOUT7,'(A4,1X,A5,A1,A4,1X,A5)')RESPDBTYP(IRES),
     &     RESPDBNUM(IRES),'-',RESPDBTYP(IRES+1),RESPDBNUM(IRES+1)
          WRITE(IOUT7,'(A)') 
C
          WRITE(IOUT7,'(A5,A,F6.1,A)')RESPDBNUM(IRES+1),':',
     &     PERCA,' percent of total'
          WRITE(IOUT7,'(A,F6.1,A,F6.1,A)')'progress in direction of axis
     &:',PRO,' degrees,',PERC,' percentage increase'
C
          CALL TORDIFF(IRES,NI,CA,CP,CB,MASS,COOBB1,COOBB2,
     &     UX,UY,UZ,IOUT7)
C
      WRITE (IOUT7,'(A80)') '-------------------------------------------
     &--------------------------------------'
7       CONTINUE
6     CONTINUE
C
      RETURN
      END
