C
C DETERMINES INTERDOMAIN SCREW-AXES OR HINGE AXES
C
      SUBROUTINE HINGEAXES2 (NDOM,WINDLEN,NRES,NBB,RESPDBNUM,
     & RESPDBTYP,NI,CA,CP,CB,NSEG,IRESBEG,IRESEND,COOBB1,COOBB2,
     & MASS,NDOMO,NCON,DOMCON,DOMORD,EXTINT,EXTCRIT,NRES1,CHAINID1,
     & DOMSIZE,IOUT1,IOUT3,IOUT6,IOUT7)
C 
      IMPLICIT NONE
C 
      include 'DynDom.param'
C 
      INTEGER DOMORD(*),NDOMO,NDOM,K
      INTEGER NCON(*),DOMCON(NDOMX,*)
      INTEGER NBB,NRES,IAT1,IAT2,IAT3,IAT4
      INTEGER I,J,M,N,NDOMA,NDOMB,ISEG,NSEG(*)
      INTEGER DOMA,DOMB,WINDLEN,DOMSIZE(*)
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*),IRES
      INTEGER NI(*),CA(*),CB(*),CP(*),IPAIR,NRES1,NPAIR
      INTEGER NCONA(NPAIRMX),NCONB(NPAIRMX)
      INTEGER BEGCONA(NPAIRMX,NCONPMX),ENDCONA(NPAIRMX,NCONPMX)
      INTEGER BEGCONB(NPAIRMX,NCONPMX),ENDCONB(NPAIRMX,NCONPMX)
      INTEGER MSEG,SEGB(NPAIRMX),SEGE(NPAIRMX)
      INTEGER IOUT1,IOUT3,IOUT6,IOUT7,LENGTH,IEND
      REAL*8 UNTHX,UNTHY,UNTHZ,AMPROT,AMPTR,XL,YL,ZL
      REAL*8 MASS(*),RMSD,TRACER 
      REAL*8 COOBB1(3,*),COOBB2(3,*)
      REAL*8 CO1(3,NBBMX),CO2(3,NBBMX)
      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF
      REAL*8 EXTINT(NDOMX,*),EXTCRIT,PERCEXT
      CHARACTER*5 RESPDBNUM(*)
      CHARACTER*4 RESPDBTYP(*)
      CHARACTER*1 CHAINID1 
      CHARACTER*19 COLOR(NDOMX),COLORA,COLORB,COLORCON
      CHARACTER*16 COLOUR(NDOMX)
      LOGICAL DONEDOMA
C 
      CALL COLOURS(COLOR,COLOUR)
C
      WRITE(IOUT3,'(A)')'select all'
      WRITE(IOUT3,'(A)')'color grey'
      WRITE(IOUT3,'(A)')'background grey'
C
      IPAIR=0
      DO 80 I=1,NDOMO
C
        DONEDOMA=.FALSE.
        DOMA=DOMORD(I)
C 
C DOMAINS B
C 
        DO 70 J=1,NCON(DOMA)
C 
          DOMB=DOMCON(DOMA,J)
C
          IF(EXTINT(DOMA,DOMB).GE.EXTCRIT) THEN
            IF(.NOT.DONEDOMA) THEN
C
              IF(DOMA.GT.26) THEN
                WRITE(6,'(A)')'WARNING COLOURS WILL NOT BE UNIQUE'
              ENDIF
C
              WRITE (IOUT1,'(A80)') '===================================
     &============================================='
              WRITE(IOUT1,'(A)')'FIXED  DOMAIN'
              LENGTH=LEN(COLOUR(DOMA))
              CALL STRINGLENGTH(COLOUR(DOMA),LENGTH,IEND)
              WRITE(IOUT1,'(A,I3,A,A,A)')'DOMAIN NUMBER: ',DOMA,
     &' (coloured ',COLOUR(DOMA)(1:IEND),' for rasmol)'
              WRITE(IOUT1,'(A,10(A5,A1,A5,A1))')'RESIDUE NUMBERS : ',
     &(RESPDBNUM(IRESBEG(DOMA,N)),'-',
     &RESPDBNUM(IRESEND(DOMA,N)),',',N=1,NSEG(DOMA)-1),
     &RESPDBNUM(IRESBEG(DOMA,NSEG(DOMA))),
     &'-',RESPDBNUM(IRESEND(DOMA,NSEG(DOMA)))
C             WRITE(IOUT1,'(A,10(I4,A1,I4,A1))')'RESIDUE NUMBERS : ',
C    &(IRESBEG(DOMA,N),'-',IRESEND(DOMA,N),',',N=1,NSEG(DOMA)-1),
C    &IRESBEG(DOMA,NSEG(DOMA)),'-',IRESEND(DOMA,NSEG(DOMA))
              WRITE(IOUT1,'(A,I5,A)')'SIZE: ',DOMSIZE(DOMA),' RESIDUES'
C
C WRITE IN RASMOL SCRIPT FILE
C
              WRITE(IOUT3,'(A,A)')'# select fixed domain residues and co
     &lour ',COLOUR(DOMA)(1:IEND)
C
              COLORA=COLOR(DOMA)
              CALL WRITEDOM_RAS(DOMA,NSEG,IRESBEG,IRESEND,RESPDBNUM,
     &   CHAINID1,IOUT3,COLORA)
C
C
C FIT DOMAIN A OF CONFORMATION 2 TO DOMAIN A OF CONFORMATION 1 RELOCATING
C WHOLE OF CONFORMATION 2 ACCORDINGLY
C
              CALL FITDOM(NBB,DOMA,NSEG,IRESBEG,IRESEND,NI,CA,CP,CB,
     &         COOBB1,COOBB2,MASS,RMSD)
C
              WRITE (6,'(A,F8.3,A)') 'rmsd of fixed domain best fit: ',
     &RMSD,'A'
              WRITE (IOUT1,'(A,F8.3,A)') 'BACKBONE RMSD ON THIS DOMAIN: 
     &',RMSD,'A'
C
              DONEDOMA=.TRUE.
            ENDIF
C
C END OF OUTPUT FOR DOMAIN A
C
            IF(DOMB.GT.26) THEN
              WRITE(6,'(A)')'WARNING COLOURS WILL NOT BE UNIQUE'
            ENDIF
C
            IPAIR=IPAIR+1
C
            IF(IPAIR.GT.NPAIRMX) THEN
              WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF PAIRS HA
     &S BEEN EXCEEDED: ',NPAIRMX,IPAIR
              WRITE(6,'(A)')'CHANGE VALUE FOR "NPAIRMX" IN "DynDom.param
     &"'
              STOP
            ENDIF
C
            WRITE (IOUT1,'(A80)') '-------------------------------------
     &-------------------------------------------'
C
            IF(IPAIR.EQ.1.OR.IPAIR.EQ.21.OR.IPAIR.EQ.31) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'ST PAIR' 
            ELSEIF(IPAIR.EQ.2.OR.IPAIR.EQ.22.OR.IPAIR.EQ.32) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'ND PAIR' 
            ELSEIF(IPAIR.EQ.3.OR.IPAIR.EQ.23.OR.IPAIR.EQ.33) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'RD PAIR' 
            ELSE 
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'TH PAIR' 
C
            ENDIF
C
            LENGTH=LEN(COLOUR(DOMB))
            CALL STRINGLENGTH(COLOUR(DOMB),LENGTH,IEND)
            WRITE(IOUT1,'(A,I3,A,A,A)')'DOMAIN NUMBER: ',DOMB,
     &' (coloured ',COLOUR(DOMB)(1:IEND),' for rasmol)'
            WRITE(IOUT1,'(A,10(A5,A1,A5,A1))')'RESIDUE NUMBERS : ',
     &(RESPDBNUM(IRESBEG(DOMB,N)),'-',
     &RESPDBNUM(IRESEND(DOMB,N)),',',N=1,NSEG(DOMB)-1),
     &RESPDBNUM(IRESBEG(DOMB,NSEG(DOMB))),'-',
     &RESPDBNUM(IRESEND(DOMB,NSEG(DOMB)))
C           WRITE(IOUT1,'(A,10(I4,A1,I4,A1))')'RESIDUE NUMBERS : ',
C    &(IRESBEG(DOMB,N),'-',IRESEND(DOMB,N),',',N=1,NSEG(DOMB)-1),
C    &IRESBEG(DOMB,NSEG(DOMB)),'-',IRESEND(DOMB,NSEG(DOMB))
            WRITE(IOUT1,'(A,I5,A)')'SIZE: ',DOMSIZE(DOMB),' RESIDUES'
C
C WRITE IN RASMOL SCRIPT FILE
C
            WRITE(IOUT3,'(A,A)')'# select moving domain residues and col 
     &our ',COLOUR(DOMB)(1:IEND)
C
            COLORB=COLOR(DOMB)
            CALL WRITEDOM_RAS(DOMB,NSEG,IRESBEG,IRESEND,RESPDBNUM,
     &  CHAINID1,IOUT3,COLORB)
C
            M=0
            DO 40 ISEG=1,NSEG(DOMB)
              DO 30 IRES=IRESBEG(DOMB,ISEG),IRESEND(DOMB,ISEG)
              M=M+1
              IAT1=M
              CO1(1,M)=COOBB1(1,NI(IRES))
              CO1(2,M)=COOBB1(2,NI(IRES))
              CO1(3,M)=COOBB1(3,NI(IRES))
              CO2(1,M)=COOBB2(1,NI(IRES))
              CO2(2,M)=COOBB2(2,NI(IRES))
              CO2(3,M)=COOBB2(3,NI(IRES))
              M=M+1
              IAT2=M
              CO1(1,M)=COOBB1(1,CA(IRES))
              CO1(2,M)=COOBB1(2,CA(IRES))
              CO1(3,M)=COOBB1(3,CA(IRES))
              CO2(1,M)=COOBB2(1,CA(IRES))
              CO2(2,M)=COOBB2(2,CA(IRES))
              CO2(3,M)=COOBB2(3,CA(IRES))
              M=M+1
              IAT3=M
              CO1(1,M)=COOBB1(1,CP(IRES))
              CO1(2,M)=COOBB1(2,CP(IRES))
              CO1(3,M)=COOBB1(3,CP(IRES))
              CO2(1,M)=COOBB2(1,CP(IRES))
              CO2(2,M)=COOBB2(2,CP(IRES))
              CO2(3,M)=COOBB2(3,CP(IRES))
              M=M+1
              IAT4=M
              CO1(1,M)=COOBB1(1,CB(IRES))
              CO1(2,M)=COOBB1(2,CB(IRES))
              CO1(3,M)=COOBB1(3,CB(IRES))
              CO2(1,M)=COOBB2(1,CB(IRES))
              CO2(2,M)=COOBB2(2,CB(IRES))
              CO2(3,M)=COOBB2(3,CB(IRES))
30            CONTINUE
40          CONTINUE
            NDOMB=M
C 
C CALL SUBROUTINE TO DETERMINE EXTERNAL COMPONENT TO MOTION OF DOMAIN
C B IN CONFORMATION 1 TO DOMAIN B IN CONFORMATION 2
C 
            CALL EXTCOMP2(NDOMB,IAT1,IAT2,IAT3,IAT4,MASS,CO1,CO2,VEXT,
     &     VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C 
            WRITE (IOUT1,'(A,F8.3,A)') 'BACKBONE RMSD ON THIS DOMAIN: ',
     &RMSD,'A'
            WRITE(IOUT1,'(A)') 
            WRITE(IOUT1,'(A,F8.3)')'RATIO INTERDOMAIN TO INTRADOMAIN DIS
     &PLACEMENT: ',EXTINT(DOMA,DOMB)
            PERCEXT=VEXTMSF*100.0/VMSF
            IF(PERCEXT.GT.100.0) PERCEXT=100.0
              WRITE (IOUT1,'(A,F8.3)') 'PERCENTAGE EXTERNAL DISPLACEMENT
     & IN MOVING DOMAIN:',PERCEXT
C           WRITE (IOUT1,'(A17,F8.3)') 'PERCENTAGE ERROR:',
C    &      (100.0-(VEXTMSF+VINTMSF)*100.0/VMSF)
C 
C CALL ROUTINE TO LOCATE SCREW AXIS
C 
            CALL ROTVEC(IAT1,IAT2,IAT3,IAT4,CO1,VEXT,TRACER,AMPROT,
     &                UNTHX,UNTHY,UNTHZ)
C
            CALL SCREWAX(IAT1,IAT2,IAT3,IAT4,CO1,VEXT,AMPROT,
     &                     UNTHX,UNTHY,UNTHZ,AMPTR,XL,YL,ZL)
C
            AMPROT=AMPROT*180.0/PI
            WRITE (IOUT1,'(A18,F8.3,A8)') 'ANGLE OF ROTATION:',
     &     AMPROT,' DEGREES'
            WRITE (IOUT1,'(A23,F8.3,A2)') 'TRANSLATION ALONG AXIS:',
     &     AMPTR,' A'
C           WRITE (IOUT1,'(A17,6(F8.3,1X))')'AXIS PARAMETERS: ',
C    &     UNTHX,UNTHY,UNTHZ,XL,YL,ZL
C 
C DETERMINE BENDING RESIDUES 
C
            CALL HINGERES3D(NDOM,NRES,WINDLEN,DOMA,DOMB,NSEG,IRESBEG,
     &     IRESEND,NI,CA,CP,CB,COOBB1,COOBB2,MASS,UNTHX,UNTHY,UNTHZ,
     &     XL,YL,ZL,AMPROT,IPAIR,NCONA,NCONB,BEGCONA,ENDCONA,BEGCONB,
     &     ENDCONB,RESPDBNUM,RESPDBTYP,MSEG,SEGB,SEGE,IOUT1,IOUT7)
C
C CALL ROUTINE TO FIND RESIDUES NEAR AXIS
C 
            CALL AXRES(NRES,RESPDBNUM,RESPDBTYP,UNTHX,UNTHY,UNTHZ,
     &XL,YL,ZL,CA,COOBB1,MSEG,SEGB,SEGE,IOUT1)
C 
C CALL ROUTINE TO DETERMINE DEGREE OF CLOSURE MOTION
C 
            CALL CLOSURE(DOMA,DOMB,NSEG,IRESBEG,IRESEND,CA,
     &     COOBB1,UNTHX,UNTHY,UNTHZ,XL,YL,ZL,IOUT1)
C 
C CALL ROUTINE TO WRITE OUT SCREW AXIS AND SCRIPT FOR DISPLAY ON RASMOL
C 
            CALL ARROW(NBB,COOBB1,UNTHX,UNTHY,UNTHZ,
     &     XL,YL,ZL,RESPDBNUM,NRES1,IPAIR,
     &     CHAINID1,IOUT6,IOUT3,COLORA,COLORB)
C
          ENDIF
70      CONTINUE
80    CONTINUE
C
C SELECT AND COLOUR CONNECTING REGIONS GREEN
C
        COLORCON='color [0  ,255,0  ]'
C
        WRITE(IOUT3,'(A)')'# select and colour green residues involved i
     &n interdomain bending'
C
        NPAIR=IPAIR
        DO 1 IPAIR=1,NPAIR
C
          WRITE(IOUT3,'(A,I4)')'# interdomain residues for pair ',IPAIR
          IF(NCONA(IPAIR).NE.0) THEN
C
            CALL WRITECON_RAS(IPAIR,NCONA,BEGCONA,ENDCONA,RESPDBNUM,
     &       CHAINID1,IOUT3,COLORCON)
C
          ENDIF
C
          IF(NCONB(IPAIR).NE.0) THEN
C
            CALL WRITECON_RAS(IPAIR,NCONB,BEGCONB,ENDCONB,RESPDBNUM,
     &       CHAINID1,IOUT3,COLORCON)
C
          ENDIF
C
1       CONTINUE
C
      WRITE(IOUT3,'(A)')'select all'
      WRITE(IOUT3,'(A)')'wireframe off'
      WRITE(IOUT3,'(A)')'backbone 100'
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
