C 
C TO DETERMINE BENDING RESIDUES
C THE PAIR OF DOMAINS A AND B.  THE ROTATION VECTOR OF EACH WINDOW
C SEGMENT IS PROJECTED ONTO THE INTERDOMAIN SCREW AXIS FOR THAT 
C PAIR.  THE AVERAGE AND STANDARD DEVIATION IS CALCULATED FOR A AND
C B.  INTERDOMAIN RESIDUES ARE THOSE AT THE CONNECTIONS
C BETWEEN THE DOMAINS PLUS ANY OF THOSE THAT HAVE PROJECTED ROTATION
C ANGLES ABOVE THE AVERAGE PLUS ONE STANDARD DEVIATION FOR DOMAIN A
C (THE ONE FIXED IN SPACE) FROM A CONNECTING POINT WITH B, AND THOSE 
C THAT HAVE PROJECTED ROTATION ANGLES BELOW THE AVERAGE MINUS ONE
C STANDARD DEVIATION FROM A CONNECTING POINT WITH A.
C
      SUBROUTINE HINGERES3D(NDOM,NRES,WINDLEN,DOMA,DOMB,NSEG,IRESBEG,
     & IRESEND,NI,CA,CP,CB,COOBB1,COOBB2,MASS,UX,UY,UZ,XL,YL,ZL,AMPROT,
     & IPAIR,ICONA,ICONB,BEGA,ENDA,BEGB,ENDB,RESPDBNUM,RESPDBTYP,
     & MSEG,SEGB,SEGE,IOUT1,IOUT7)
C
      IMPLICIT NONE
C 
      include 'DynDom.param'
C
      INTEGER IC,IRESWIND
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*),NSEG(*)
      INTEGER NRES,IAT1,IAT2,IAT3,IAT4,ISEG,IRES	  
      INTEGER I,N,WINDLEN,DOMA,DOMB,NA,NB,NMAX
      INTEGER AEND,BEND,IDOM,NDOM
      INTEGER SEGBEGA(NCONPMX),SEGENDA(NCONPMX)
      INTEGER SEGBEGB(NCONPMX),SEGENDB(NCONPMX)
      INTEGER ICONA(*),ICONB(*)
      INTEGER BEGA(NPAIRMX,*),ENDA(NPAIRMX,*)
      INTEGER BEGB(NPAIRMX,*),ENDB(NPAIRMX,*)
      INTEGER MSEG,SEGB(*),SEGE(*)
      INTEGER NI(*),CA(*),CB(*),CP(*),IPAIR
      INTEGER IOUT1,IOUT7
      REAL*8 UNTHX,UNTHY,UNTHZ,XL,YL,ZL,AMPROT,AMPTHET
      REAL*8 AMPTR,XAX,YAX,ZAX,TRACER
      REAL*8 AMPX(NRESMX),AMPY(NRESMX),AMPZ(NRESMX)
      REAL*8 XAVA,YAVA,ZAVA,XAVB,YAVB,ZAVB
      REAL*8 XXCORA,XYCORA,XZCORA,YYCORA,YZCORA,ZZCORA
      REAL*8 XXCORB,XYCORB,XZCORB,YYCORB,YZCORB,ZZCORB
      REAL*8 UX,UY,UZ,PRO,AVA,VARA,SDA,AVB,VARB,SDB
      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF,RMSD
      REAL*8 MASS(*),PROJ(NRESMX)
      REAL*8 COOBB1(3,*),COOBB2(3,*)
      REAL*8 CO1(3,NUMATMX),CO2(3,NUMATMX)
      REAL*8 SIGMA(3,3),SIGMB(3,3),INVSIGMA(3,3),INVSIGMB(3,3),QA,QB
      CHARACTER*5 RESPDBNUM(*)
      CHARACTER*4 RESPDBTYP(*)
C 
C THREAD WINDOW THROUGH FIRST DOMAIN TO DETERMINE COMPONENTS
C OF ROTATION VECTORS ALONG INTERDOMAIN SCREW AXIS. CALCULATE AVERAGE 
C AND STANDARD DEVIATION
C
      DO 55 I=1,NCONPMX
        SEGBEGA(I)=0
        SEGENDA(I)=0
        SEGBEGB(I)=0
        SEGENDB(I)=0
        BEGA(IPAIR,I)=0
        ENDA(IPAIR,I)=0
        BEGB(IPAIR,I)=0
        ENDB(IPAIR,I)=0
55    CONTINUE
C
      AVA=0.0
      VARA=0.0
      SDA=0.0
C
      NA=0
      XAVA=0.0
      YAVA=0.0
      ZAVA=0.0
      XXCORA=0.0
      XYCORA=0.0
      XZCORA=0.0
      YYCORA=0.0
      YZCORA=0.0
      ZZCORA=0.0
      DO 40 ISEG=1,NSEG(DOMA)
        DO 42 IRES=IRESBEG(DOMA,ISEG),IRESEND(DOMA,ISEG)
          N=0
C
C FOLLOWING CONDITION IS NEEDED BECAUSE DOMAIN A CONFORMATIONS
C ARE ALREADY BEST FITTED
C
          IF(NSEG(DOMA).EQ.1.AND.(WINDLEN/2).EQ.0) GOTO 40
C 
          DO 30 IRESWIND=IRES-WINDLEN/2,IRES+WINDLEN/2
            N=N+1
            IAT1=N
            CO1(1,N)=COOBB1(1,NI(IRESWIND))
            CO1(2,N)=COOBB1(2,NI(IRESWIND))
            CO1(3,N)=COOBB1(3,NI(IRESWIND))
            CO2(1,N)=COOBB2(1,NI(IRESWIND))
            CO2(2,N)=COOBB2(2,NI(IRESWIND))
            CO2(3,N)=COOBB2(3,NI(IRESWIND))
            N=N+1
            IAT2=N
            CO1(1,N)=COOBB1(1,CA(IRESWIND))
            CO1(2,N)=COOBB1(2,CA(IRESWIND))
            CO1(3,N)=COOBB1(3,CA(IRESWIND))
            CO2(1,N)=COOBB2(1,CA(IRESWIND))
            CO2(2,N)=COOBB2(2,CA(IRESWIND))
            CO2(3,N)=COOBB2(3,CA(IRESWIND))
            N=N+1
            IAT3=N
            CO1(1,N)=COOBB1(1,CP(IRESWIND))
            CO1(2,N)=COOBB1(2,CP(IRESWIND))
            CO1(3,N)=COOBB1(3,CP(IRESWIND))
            CO2(1,N)=COOBB2(1,CP(IRESWIND))
            CO2(2,N)=COOBB2(2,CP(IRESWIND))
            CO2(3,N)=COOBB2(3,CP(IRESWIND))
            N=N+1
            IAT4=N
            CO1(1,N)=COOBB1(1,CB(IRESWIND))
            CO1(2,N)=COOBB1(2,CB(IRESWIND))
            CO1(3,N)=COOBB1(3,CB(IRESWIND))
            CO2(1,N)=COOBB2(1,CB(IRESWIND))
            CO2(2,N)=COOBB2(2,CB(IRESWIND))
            CO2(3,N)=COOBB2(3,CB(IRESWIND))
30        CONTINUE
C
          NMAX=N
C
          CALL EXTCOMP2(NMAX,IAT1,IAT2,IAT3,IAT4,MASS,CO1,CO2,VEXT,
     &     VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
C CALL SUBROUTINE TO CALCULATE THE ROTATION VECTOR AT EACH
C SEGMENT
C
          CALL ROTVEC(IAT1,IAT2,IAT3,IAT4,CO1,VEXT,TRACER,AMPTHET,
     &                UNTHX,UNTHY,UNTHZ)
C
          PRO=UX*UNTHX+UY*UNTHY+UZ*UNTHZ
          PRO=AMPTHET*PRO
          PRO=PRO*180.0/PI
          PROJ(IRES)=PRO
C
          AVA=AVA+PRO
          VARA=VARA+(PRO**2)

          AMPX(IRES)=AMPTHET*UNTHX*180.0/PI
          AMPY(IRES)=AMPTHET*UNTHY*180.0/PI
          AMPZ(IRES)=AMPTHET*UNTHZ*180.0/PI
C
          XAVA=XAVA+AMPX(IRES)
          YAVA=YAVA+AMPY(IRES)
          ZAVA=ZAVA+AMPZ(IRES)
C
          XXCORA=XXCORA+AMPX(IRES)*AMPX(IRES)
          YYCORA=YYCORA+AMPY(IRES)*AMPY(IRES)
          ZZCORA=ZZCORA+AMPZ(IRES)*AMPZ(IRES)
          XYCORA=XYCORA+AMPX(IRES)*AMPY(IRES)
          XZCORA=XZCORA+AMPX(IRES)*AMPZ(IRES)
          YZCORA=YZCORA+AMPY(IRES)*AMPZ(IRES)
C
          NA=NA+1
C
42      CONTINUE
40    CONTINUE
C
      AVA=AVA/NA
      VARA=(VARA/NA)-(AVA**2)
      SDA=SQRT(VARA)
C
      XAVA=XAVA/NA
      YAVA=YAVA/NA
      ZAVA=ZAVA/NA
      XXCORA=XXCORA/NA-(XAVA*XAVA)
      YYCORA=YYCORA/NA-(YAVA*YAVA)
      ZZCORA=ZZCORA/NA-(ZAVA*ZAVA)
      XYCORA=XYCORA/NA-(XAVA*YAVA)
      XZCORA=XZCORA/NA-(XAVA*ZAVA)
      YZCORA=YZCORA/NA-(YAVA*ZAVA)
C
      SIGMA(1,1)=XXCORA
      SIGMA(1,2)=XYCORA
      SIGMA(1,3)=XZCORA
      SIGMA(2,1)=XYCORA
      SIGMA(2,2)=YYCORA
      SIGMA(2,3)=YZCORA
      SIGMA(3,1)=XZCORA
      SIGMA(3,2)=YZCORA
      SIGMA(3,3)=ZZCORA
      CALL M_INV (SIGMA,INVSIGMA) 
C
C DO SAME FOR SECOND DOMAIN
C
      AVB=0.0
      VARB=0.0
      SDB=0.0
C
      NB=0
      XAVB=0.0
      YAVB=0.0
      ZAVB=0.0
      XXCORB=0.0
      XYCORB=0.0
      XZCORB=0.0
      YYCORB=0.0
      YZCORB=0.0
      ZZCORB=0.0
      DO 41 ISEG=1,NSEG(DOMB)
        DO 43 IRES=IRESBEG(DOMB,ISEG),IRESEND(DOMB,ISEG)
          N=0
          DO 31 IRESWIND=IRES-WINDLEN/2,IRES+WINDLEN/2
            N=N+1
            IAT1=N
            CO1(1,N)=COOBB1(1,NI(IRESWIND))
            CO1(2,N)=COOBB1(2,NI(IRESWIND))
            CO1(3,N)=COOBB1(3,NI(IRESWIND))
            CO2(1,N)=COOBB2(1,NI(IRESWIND))
            CO2(2,N)=COOBB2(2,NI(IRESWIND))
            CO2(3,N)=COOBB2(3,NI(IRESWIND))
            N=N+1
            IAT2=N
            CO1(1,N)=COOBB1(1,CA(IRESWIND))
            CO1(2,N)=COOBB1(2,CA(IRESWIND))
            CO1(3,N)=COOBB1(3,CA(IRESWIND))
            CO2(1,N)=COOBB2(1,CA(IRESWIND))
            CO2(2,N)=COOBB2(2,CA(IRESWIND))
            CO2(3,N)=COOBB2(3,CA(IRESWIND))
            N=N+1
            IAT3=N
            CO1(1,N)=COOBB1(1,CP(IRESWIND))
            CO1(2,N)=COOBB1(2,CP(IRESWIND))
            CO1(3,N)=COOBB1(3,CP(IRESWIND))
            CO2(1,N)=COOBB2(1,CP(IRESWIND))
            CO2(2,N)=COOBB2(2,CP(IRESWIND))
            CO2(3,N)=COOBB2(3,CP(IRESWIND))
            N=N+1
            IAT4=N
            CO1(1,N)=COOBB1(1,CB(IRESWIND))
            CO1(2,N)=COOBB1(2,CB(IRESWIND))
            CO1(3,N)=COOBB1(3,CB(IRESWIND))
            CO2(1,N)=COOBB2(1,CB(IRESWIND))
            CO2(2,N)=COOBB2(2,CB(IRESWIND))
            CO2(3,N)=COOBB2(3,CB(IRESWIND))
31        CONTINUE
C
          NMAX=N
C
          CALL EXTCOMP2(NMAX,IAT1,IAT2,IAT3,IAT4,MASS,CO1,CO2,VEXT,
     &     VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
C CALL SUBROUTINE TO CALCULATE THE ROTATION VECTOR AT EACH
C SEGMENT
C
          CALL ROTVEC(IAT1,IAT2,IAT3,IAT4,CO1,VEXT,TRACER,AMPTHET,
     &                UNTHX,UNTHY,UNTHZ)
C
          PRO=UX*UNTHX+UY*UNTHY+UZ*UNTHZ
          PRO=AMPTHET*PRO
          PRO=PRO*180.0/PI
          PROJ(IRES)=PRO
C
          AVB=AVB+PRO
          VARB=VARB+(PRO**2)
C
          AMPX(IRES)=AMPTHET*UNTHX*180.0/PI
          AMPY(IRES)=AMPTHET*UNTHY*180.0/PI
          AMPZ(IRES)=AMPTHET*UNTHZ*180.0/PI
C
          XAVB=XAVB+AMPX(IRES)
          YAVB=YAVB+AMPY(IRES)
          ZAVB=ZAVB+AMPZ(IRES)
C
          XXCORB=XXCORB+AMPX(IRES)*AMPX(IRES)
          YYCORB=YYCORB+AMPY(IRES)*AMPY(IRES)
          ZZCORB=ZZCORB+AMPZ(IRES)*AMPZ(IRES)
          XYCORB=XYCORB+AMPX(IRES)*AMPY(IRES)
          XZCORB=XZCORB+AMPX(IRES)*AMPZ(IRES)
          YZCORB=YZCORB+AMPY(IRES)*AMPZ(IRES)
C
          NB=NB+1
43      CONTINUE
41    CONTINUE
C
      AVB=AVB/NB
      VARB=(VARB/NB)-(AVB**2)
      SDB=SQRT(VARB)
C
      XAVB=XAVB/NB
      YAVB=YAVB/NB
      ZAVB=ZAVB/NB
      XXCORB=XXCORB/NB-(XAVB*XAVB)
      YYCORB=YYCORB/NB-(YAVB*YAVB)
      ZZCORB=ZZCORB/NB-(ZAVB*ZAVB)
      XYCORB=XYCORB/NB-(XAVB*YAVB)
      XZCORB=XZCORB/NB-(XAVB*ZAVB)
      YZCORB=YZCORB/NB-(YAVB*ZAVB)
C
      SIGMB(1,1)=XXCORB
      SIGMB(1,2)=XYCORB
      SIGMB(1,3)=XZCORB
      SIGMB(2,1)=XYCORB
      SIGMB(2,2)=YYCORB
      SIGMB(2,3)=YZCORB
      SIGMB(3,1)=XZCORB
      SIGMB(3,2)=YZCORB
      SIGMB(3,3)=ZZCORB
      CALL M_INV (SIGMB,INVSIGMB) 
C
C DETERMINE THE CONNECTIONS BETWEEN DOMAIN A AND B
C
      ICONA(IPAIR)=0
      ICONB(IPAIR)=0
      AEND=0
      BEND=0
      DO 11 IRES=1,NRES
        DO 22 IDOM=1,NDOM
          DO 33 ISEG=1,NSEG(IDOM)
            IF(IRESEND(IDOM,ISEG).EQ.IRES) THEN
              IF(IDOM.EQ.DOMA) AEND=ISEG
              IF(IDOM.EQ.DOMB) BEND=ISEG
C
C FOR ONE RESIDUE SEGMENTS
C
              IF(AEND.NE.0.AND.BEND.NE.0) THEN
C
C DETERMINE CONNECTING REGION FROM B TO A
C
                IF(IRESEND(DOMA,AEND).GT.IRESEND(DOMB,BEND)) THEN
                  ICONB(IPAIR)=ICONB(IPAIR)+1
C
                  IF(ICONB(IPAIR).GT.NCONPMX) THEN
                    WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF CO 
     &NNECTIONS BETWEEN DOMAINS HAS BEEN EXCEEDED: ',ICONB(IPAIR),NCONPM
     &X
                    WRITE(6,'(A)')'CHANGE VALUE FOR "NCONPMX" IN "DynDom
     &.param"'
                    STOP
                  ENDIF
C
                  SEGENDB(ICONB(IPAIR))=BEND
                  SEGBEGA(ICONB(IPAIR))=AEND
                  BEND=0
                  GOTO 11
C
C DETERMINE CONNECTING REGION FROM A TO B
C
                ELSEIF(IRESEND(DOMB,BEND).GT.IRESEND(DOMA,AEND)) THEN
                  ICONA(IPAIR)=ICONA(IPAIR)+1
C
                  IF(ICONA(IPAIR).GT.NCONPMX) THEN
                    WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF CO 
     &NNECTIONS BETWEEN DOMAINS HAS BEEN EXCEEDED: ',ICONA(IPAIR),NCONPM
     &X
                    WRITE(6,'(A)')'CHANGE VALUE FOR "NCONPMX" IN "DynDom
     &.param"'
                    STOP
                  ENDIF
C
                  SEGENDA(ICONA(IPAIR))=AEND
                  SEGBEGB(ICONA(IPAIR))=BEND
                  AEND=0
                  GOTO 11
                ENDIF
              ENDIF
              GOTO 11
            ENDIF
C
C DETERMINE CONNECTING REGION FROM B TO A
C
            IF(IRESBEG(IDOM,ISEG).EQ.IRES) THEN
              IF(IDOM.EQ.DOMA.AND.BEND.NE.0) THEN
                ICONB(IPAIR)=ICONB(IPAIR)+1
C
                  IF(ICONB(IPAIR).GT.NCONPMX) THEN
                    WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF CO 
     &NNECTIONS BETWEEN DOMAINS HAS BEEN EXCEEDED: ',ICONB(IPAIR),NCONPM
     &X
                    WRITE(6,'(A)')'CHANGE VALUE FOR "NCONPMX" IN "DynDom
     &.param"'
                    STOP
                  ENDIF
C
                SEGENDB(ICONB(IPAIR))=BEND
                SEGBEGA(ICONB(IPAIR))=ISEG
                AEND=0
                BEND=0
                GOTO 11
C
C DETERMINE CONNECTING REGION FROM A TO B
C
              ELSEIF(IDOM.EQ.DOMB.AND.AEND.NE.0) THEN
                ICONA(IPAIR)=ICONA(IPAIR)+1
C
                  IF(ICONA(IPAIR).GT.NCONPMX) THEN
                    WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF CO 
     &NNECTIONS BETWEEN DOMAINS HAS BEEN EXCEEDED: ',ICONA(IPAIR),NCONPM
     &X
                    WRITE(6,'(A)')'CHANGE VALUE FOR "NCONPMX" IN "DynDom
     &.param"'
                    STOP
                  ENDIF
C
                SEGENDA(ICONA(IPAIR))=AEND
                SEGBEGB(ICONA(IPAIR))=ISEG
                AEND=0
                BEND=0
                GOTO 11
              ENDIF
              AEND=0
              BEND=0
            ENDIF
33        CONTINUE
22      CONTINUE
11    CONTINUE
C
C DETERMINE BEGINNING AND END RESIDUES FOR THE CROSSINGS FROM A TO B
C
      DO 66 IC=1,ICONA(IPAIR)
        BEGA(IPAIR,IC)=IRESEND(DOMA,SEGENDA(IC))
        DO 77 IRES=IRESEND(DOMA,SEGENDA(IC)),IRESBEG(DOMA,SEGENDA(IC))
     & ,-1
C
C CALCULATION OF Q
C
          QA=0.0
          AMPX(IRES)=AMPX(IRES)-XAVA
          AMPY(IRES)=AMPY(IRES)-YAVA
          AMPZ(IRES)=AMPZ(IRES)-ZAVA
          QA=QA+AMPX(IRES)*INVSIGMA(1,1)*AMPX(IRES)
          QA=QA+AMPX(IRES)*INVSIGMA(1,2)*AMPY(IRES)
          QA=QA+AMPX(IRES)*INVSIGMA(1,3)*AMPZ(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,1)*AMPX(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,2)*AMPY(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,3)*AMPZ(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,1)*AMPX(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,2)*AMPY(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,3)*AMPZ(IRES)

          IF(QA.GE.4.6) THEN
            BEGA(IPAIR,IC)=IRES
          ELSE
            GOTO 67
          ENDIF
C
c         IF(PROJ(IRES).GE.(AVA+SDA)) THEN
c           BEGA(IPAIR,IC)=IRES
c         ELSE
c           GOTO 67
c         ENDIF
77      CONTINUE
67      CONTINUE
        ENDA(IPAIR,IC)=IRESBEG(DOMB,SEGBEGB(IC))
        DO 88 IRES=IRESBEG(DOMB,SEGBEGB(IC)),IRESEND(DOMB,SEGBEGB(IC))
C
C CALCULATION OF Q
C
          QB=0.0
          AMPX(IRES)=AMPX(IRES)-XAVB
          AMPY(IRES)=AMPY(IRES)-YAVB
          AMPZ(IRES)=AMPZ(IRES)-ZAVB
          QB=QB+AMPX(IRES)*INVSIGMB(1,1)*AMPX(IRES)
          QB=QB+AMPX(IRES)*INVSIGMB(1,2)*AMPY(IRES)
          QB=QB+AMPX(IRES)*INVSIGMB(1,3)*AMPZ(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,1)*AMPX(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,2)*AMPY(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,3)*AMPZ(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,1)*AMPX(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,2)*AMPY(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,3)*AMPZ(IRES)
C
          IF(QB.GE.4.6) THEN
            ENDA(IPAIR,IC)=IRES
          ELSE
            GOTO 66
          ENDIF
C
c         IF(PROJ(IRES).LE.(AVB-SDB)) THEN
c           ENDA(IPAIR,IC)=IRES
c         ELSE
c           GOTO 66
c         ENDIF
88      CONTINUE
66    CONTINUE
C
C DETERMINE BEGINNING AND END RESIDUES FOR THE CROSSINGS FROM B TO A
C
      DO 16 IC=1,ICONB(IPAIR)
        BEGB(IPAIR,IC)=IRESEND(DOMB,SEGENDB(IC))
        DO 17 IRES=IRESEND(DOMB,SEGENDB(IC)),IRESBEG(DOMB,SEGENDB(IC))
     & ,-1
          QB=0.0
          AMPX(IRES)=AMPX(IRES)-XAVB
          AMPY(IRES)=AMPY(IRES)-YAVB
          AMPZ(IRES)=AMPZ(IRES)-ZAVB
          QB=QB+AMPX(IRES)*INVSIGMB(1,1)*AMPX(IRES)
          QB=QB+AMPX(IRES)*INVSIGMB(1,2)*AMPY(IRES)
          QB=QB+AMPX(IRES)*INVSIGMB(1,3)*AMPZ(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,1)*AMPX(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,2)*AMPY(IRES)
          QB=QB+AMPY(IRES)*INVSIGMB(2,3)*AMPZ(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,1)*AMPX(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,2)*AMPY(IRES)
          QB=QB+AMPZ(IRES)*INVSIGMB(3,3)*AMPZ(IRES)
C
          IF(QB.GE.4.6) THEN
            BEGB(IPAIR,IC)=IRES
          ELSE
            GOTO 27
          ENDIF
C
c         IF(PROJ(IRES).LE.(AVB-SDB)) THEN
c           BEGB(IPAIR,IC)=IRES
c         ELSE
c           GOTO 27
c         ENDIF
17      CONTINUE
27      CONTINUE
        ENDB(IPAIR,IC)=IRESBEG(DOMA,SEGBEGA(IC))
        DO 18 IRES=IRESBEG(DOMA,SEGBEGA(IC)),IRESEND(DOMA,SEGBEGA(IC))
C
C CALCULATION OF Q
C
          QA=0.0
          AMPX(IRES)=AMPX(IRES)-XAVA
          AMPY(IRES)=AMPY(IRES)-YAVA
          AMPZ(IRES)=AMPZ(IRES)-ZAVA
          QA=QA+AMPX(IRES)*INVSIGMA(1,1)*AMPX(IRES)
          QA=QA+AMPX(IRES)*INVSIGMA(1,2)*AMPY(IRES)
          QA=QA+AMPX(IRES)*INVSIGMA(1,3)*AMPZ(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,1)*AMPX(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,2)*AMPY(IRES)
          QA=QA+AMPY(IRES)*INVSIGMA(2,3)*AMPZ(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,1)*AMPX(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,2)*AMPY(IRES)
          QA=QA+AMPZ(IRES)*INVSIGMA(3,3)*AMPZ(IRES)
C
          IF(QA.GE.4.6) THEN
            ENDB(IPAIR,IC)=IRES
          ELSE
            GOTO 16
          ENDIF
C
c         IF(PROJ(IRES).GE.(AVA+SDA)) THEN
c           ENDB(IPAIR,IC)=IRES
c         ELSE
c           GOTO 16
c         ENDIF
18      CONTINUE
16    CONTINUE
C
C FOLLOWING IS PURELY TO MAKE OUTPUT LOOK NICE
C
      MSEG=0
      DO 1 I=1,ICONA(IPAIR)
        MSEG=MSEG+1
        SEGB(MSEG)=BEGA(IPAIR,I)
        SEGE(MSEG)=ENDA(IPAIR,I)
1     CONTINUE
C
      DO 2 I=1,ICONB(IPAIR)
        MSEG=MSEG+1
        SEGB(MSEG)=BEGB(IPAIR,I)
        SEGE(MSEG)=ENDB(IPAIR,I)
2     CONTINUE
C
      CALL SORT(MSEG,SEGB,SEGE)
C
      DO 3 ISEG=1,MSEG-1
        IF(SEGB(ISEG+1).LE.(SEGE(ISEG)+1)) THEN
          SEGB(ISEG+1)=SEGB(ISEG)
          SEGB(ISEG)=0
          SEGE(ISEG)=0
        ENDIF
3     CONTINUE
C
      WRITE(IOUT1,'(A)')'BENDING RESIDUES (coloured green for rasmol):'
      WRITE(IOUT1,'(A)')
C
      DO 48 ISEG=1,MSEG
        IF(SEGB(ISEG).EQ.0.AND.SEGE(ISEG).EQ.0) GOTO 48
        WRITE(IOUT1,'(A18,A5,A1,A5)')'BENDING RESIDUES: ',
     &   RESPDBNUM(SEGB(ISEG)),'-',RESPDBNUM(SEGE(ISEG))
48    CONTINUE
C
C CALL ROUTINE TO DETERMINE DIHEDRAL CONTRIBUTIONS
C
C     CALL DIHEDET5(IPAIR,ICONA,BEGA,ENDA,ICONB,BEGB,ENDB,RESPDBNUM,
C    & RESPDBTYP,UX,UY,UZ,XL,YL,ZL,AMPROT,MASS,COOBB1,COOBB2,NI,CA,CP,CB
C    & ,IOUT7,NRES)
C
      CALL DIHEDR(IPAIR,ICONA,BEGA,ENDA,ICONB,BEGB,ENDB,RESPDBNUM,
     & RESPDBTYP,UX,UY,UZ,XL,YL,ZL,AMPROT,MASS,COOBB1,COOBB2,NI,CA,CP,CB
     & ,IOUT7,NRES)
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
