C
C SUBROUTINE TO READ INPUT FILE AND INITIALIZE OUTPUT
C
      SUBROUTINE INOUTPUTR(IN1,IN2,IOUT1,IOUT3,IOUT4,IOUT6,
     &  IOUT7,CHAINID1,CHAINID2,NCLUSTER,ITER,DOMIN,WINDLEN,
     &   EXTCRIT,FILEIN1,IEND1,FILEIN2,IEND2)
C
      IMPLICIT NONE
C 
      include 'DynDom.param'
C
      INTEGER NCLUSTER,ITER,DOMIN,WINDLEN,J
      INTEGER IN,IN1,IN2,IOUT1,IOUT3,IOUT4,IOUT5,IOUT6,IOUT7
      INTEGER LENGTH,IEND,IEND1,IEND2,IEND4,IEND6
      INTEGER KEYEND,IARGC,ODDY
      REAL*8 EXTCRIT
      CHARACTER*200 INPO
      CHARACTER*1 CHAINID1,CHAINID2
      CHARACTER*200 TITLE,COMMAND 
      CHARACTER*200 FILEI,FILEIN1,FILEIN2
      CHARACTER*200 FILEO1,FILEO3,FILEO4,FILEO5,FILEO6,FILEO7
      LOGICAL NOTHING,TITLEY,FILE1Y,FILE2Y,CLUSY,ITERY,WINDLENY
      LOGICAL DOMINY,RATIOY
C
      IN=11
      IN1=12
      IN2=13
      IOUT1=14
      IOUT3=16
      IOUT4=17
      IOUT6=19
      IOUT7=20
C
      TITLEY=.FALSE.
      FILE1Y=.FALSE.
      FILE2Y=.FALSE.
      CLUSY=.FALSE.
      ITERY=.FALSE.
      WINDLENY=.FALSE.
      DOMINY=.FALSE.
      RATIOY=.FALSE.
C
      J=IARGC()
      CALL GETARG(J,FILEI)
C
      IF(J.EQ.0) THEN
        WRITE(6,'(A)')'command file name?'
        READ(5,'(A)')FILEI
      ELSEIF(J.EQ.1) THEN
      	CALL GETARG(1,FILEI)
      ELSE
        WRITE(6,*)'ONLY ARGUMENT REQUIRED IS THE COMMAND FILE NAME'
        STOP
      ENDIF
C
      WRITE(6,'(A)')'***************************************************
     &*****'
      WRITE(6,'(A)')'DynDom Reference:'
      WRITE(6,'(A)')
      WRITE(6,'(A)')'Hayward, S. and Berendsen, H.J.C.'
      WRITE(6,'(A)')'"Systematic Analysis of Domain Motions in Proteins'
      WRITE(6,'(A)')'from Conformational Change: New Results on Citrate'
      WRITE(6,'(A)')'Synthase and T4 Lysozyme."'
      WRITE(6,'(A)')'Proteins, Vol 30 144-154,1998'
      WRITE(6,'(A)')
      WRITE(6,'(A)')'***************************************************
     &*****'
      WRITE(6,'(A)')
      WRITE(6,'(A)')'Info on DynDom can be found at the DynDom HOME PAGE
     &'
      WRITE(6,'(A)')
      WRITE(6,'(A)')'http://www.sys.uea.ac.uk/~sjh/DynDom/dyndom.home.ht
     &ml'
      WRITE(6,'(A)')
      WRITE(6,'(A)')'***************************************************
     &*****'
C
      OPEN (IN,FILE=FILEI,STATUS='OLD',FORM='FORMATTED')
C
10    READ(IN,'(A)',END=20)INPO
      KEYEND=1
      CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
C
      IF(INPO((KEYEND):(KEYEND+4)).EQ.'title') THEN
        KEYEND=KEYEND+5
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          TITLEY=.TRUE.
          TITLE=INPO(KEYEND:)
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+8)).EQ.'filename1') THEN
        KEYEND=KEYEND+9
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          FILE1Y=.TRUE.
          FILEIN1=INPO(KEYEND:)
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+7)).EQ.'chain1id') THEN
        KEYEND=KEYEND+8
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        CHAINID1=INPO(KEYEND:)
C
      ELSEIF(INPO((KEYEND):(KEYEND+8)).EQ.'filename2') THEN
        KEYEND=KEYEND+9
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          FILE2Y=.TRUE.
          FILEIN2=INPO(KEYEND:)
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+7)).EQ.'chain2id') THEN
        KEYEND=KEYEND+8
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        CHAINID2=INPO(KEYEND:)
C
      ELSEIF(INPO((KEYEND):(KEYEND+7)).EQ.'clusters') THEN
        KEYEND=KEYEND+8
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          CLUSY=.TRUE.
          READ(INPO(KEYEND:),*)NCLUSTER
          IF(NCLUSTER.LE.0) CLUSY=.FALSE.
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+9)).EQ.'iterations') THEN
        KEYEND=KEYEND+10
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          ITERY=.TRUE.
          READ(INPO(KEYEND:),*)ITER
          IF(ITER.LE.0) ITERY=.FALSE.
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+5)).EQ.'window') THEN
        KEYEND=KEYEND+6
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          WINDLENY=.TRUE.
          READ(INPO(KEYEND:),*)WINDLEN
          ODDY=(WINDLEN/2)*2
          IF(WINDLEN.EQ.ODDY.AND.WINDLEN.GT.0) THEN
            WRITE(6,'(A,I3)')'SORRY WINDOW LENGTH MUST BE ODD AS CENTRAL
     & RESIDUE MUST BE DEFINED; SET TO: ',WINDLEN-1
            WINDLEN=WINDLEN-1
          ENDIF
          IF(WINDLEN.LE.0) WINDLENY=.FALSE.
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+4)).EQ.'ratio') THEN
        KEYEND=KEYEND+5
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          RATIOY=.TRUE.
          READ(INPO(KEYEND:),*)EXTCRIT
          IF(EXTCRIT.LE.0) RATIOY=.FALSE.
          IF(EXTCRIT.LT.1.0) THEN
             WRITE(6,'(A)')
             WRITE(6,'(A)')'WARNING "ratio" < 1.0'
             WRITE(6,'(A)')'THE LOWER THE VALUE OF "ratio",THE LESS'
             WRITE(6,'(A)')'MEANINGFUL YOUR RESULTS WILL BECOME'
             WRITE(6,'(A)')
          ENDIF
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+5)).EQ.'domain') THEN
        KEYEND=KEYEND+6
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          DOMINY=.TRUE.
          READ(INPO(KEYEND:),*)DOMIN
          IF(DOMIN.LE.0) THEN
            DOMINY=.FALSE.
          ENDIF
        ENDIF
C
      ENDIF
C
      GOTO 10  
C
20    CONTINUE
C
      IF(.NOT.TITLEY) THEN
        WRITE(6,'(A)')'WARNING NO TITLE; PLEASE GIVE ONE'
        READ(5,'(A)')TITLE
      ENDIF
C
      IF(.NOT.FILE1Y) THEN
        WRITE(6,'(A)')'NO FILENAME FOR CONFORMER 1'
        STOP
      ENDIF
C
      IF(.NOT.FILE2Y) THEN
        WRITE(6,'(A)')'NO FILENAME FOR CONFORMER 2'
        STOP
      ENDIF
C
      IF(.NOT.CLUSY) THEN
CC      WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR NO OF CLUSTERS=20'
        NCLUSTER=20
      ENDIF
C
      IF(.NOT.ITERY) THEN
CC      WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR NO OF ITERATIONS=100'
        ITER=100
      ENDIF
C
      IF(.NOT.WINDLENY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR WINDOW LENGTH=5'
        WINDLEN=5
      ENDIF
C
      IF(.NOT.RATIOY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR RATIO=1.0'
        EXTCRIT=1.0
      ENDIF
C
      IF(.NOT.DOMINY) THEN
        WRITE(6,'(A)')'MINIMUM DOMAIN SIZE WILL BE SET TO 20 RESIDUES'
        DOMIN=20
      ENDIF
C
C OPEN PDB FILES
C
      OPEN (IN1,FILE=FILEIN1,STATUS='OLD',FORM='FORMATTED')
      IF(FILEIN1.NE.FILEIN2) THEN  
        OPEN(IN2,FILE=FILEIN2,STATUS='OLD',FORM='FORMATTED')
      ELSE
        IN2=IN1
      ENDIF
C
      LENGTH=LEN(TITLE)
      CALL STRINGLENGTH(TITLE,LENGTH,IEND)
      FILEO1=TITLE(1:IEND)//'_info'
      FILEO3=TITLE(1:IEND)//'_rasscript'
      FILEO4=TITLE(1:IEND)//'_rotvecs'
      FILEO6=TITLE(1:IEND)//'_pdb'
      FILEO7=TITLE(1:IEND)//'_dihedral'
C
C OPEN OUTPUT FILES
C
      OPEN (IOUT1,FILE=FILEO1,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT1,'(A)')'DynDom Version 1.5'
      WRITE(IOUT1,'(A)')TITLE(1:IEND)
C
      WRITE(IOUT1,'(A,F5.1,A)')'cutoff for definition for effective hing
     &e axis and mechanical hinge: ',EFFCUT,' A'
C
      WRITE(IOUT1,'(A,F5.1,A)')'distance criterion for a pair of atoms t
     &o be in contact: ',DISTCRIT,' A'
C
      LENGTH=LEN(FILEIN1)
      CALL STRINGLENGTH(FILEIN1,LENGTH,IEND1)
      WRITE(IOUT1,'(A26,A)')'file name of conformer 1: ',
     & FILEIN1(1:IEND1)
      WRITE(IOUT1,'(A10,A)')'chain id: ',CHAINID1
C
      LENGTH=LEN(FILEIN2)
      CALL STRINGLENGTH(FILEIN2,LENGTH,IEND2)
      WRITE(IOUT1,'(A26,A)')'file name of conformer 2: ',
     & FILEIN2(1:IEND2)
      WRITE(IOUT1,'(A10,A)')'chain id: ',CHAINID2
C
      WRITE(IOUT1,'(A15,I4)')'window length: ',WINDLEN
      WRITE(IOUT1,'(A45,F8.3)')'minimum ratio of external to internal mo
     &tion: ',EXTCRIT
      WRITE(IOUT1,'(A20,I4)')'minimum domain size: ',DOMIN
C
      OPEN (IOUT3,FILE=FILEO3,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT3,'(A)')'#DynDom Version 1.5'
      WRITE(IOUT3,'(A)')'#'//TITLE(1:IEND)
C
      OPEN (IOUT4,FILE=FILEO4,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT4,'(A)')'DynDom Version 1.5'
      WRITE(IOUT4,'(A)')TITLE(1:IEND)
C
      OPEN (IOUT6,FILE=FILEO6,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT6,'(A)')'DynDom Version 1.5'
      WRITE(IOUT6,'(A)')TITLE(1:IEND)
C
      OPEN (IOUT7,FILE=FILEO7,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT7,'(A)')'DynDom Version 1.5'
      WRITE(IOUT7,'(A)')TITLE(1:IEND)
C
      WRITE(IOUT7,'(A)')'A: rotation of psi dihedral at 1st residue'
      WRITE(IOUT7,'(A)')'B: rotation of phi dihedral at 2nd residue'
      WRITE(IOUT7,'(A)')'F: scalar product of psi dihedral axis of 1st r
     &esidue in 1st conformation with screw axis'
      WRITE(IOUT7,'(A)')'G: scalar product of phi dihedral axis of 2nd r
     &esidue in 1st conformation with screw axis'
      WRITE(IOUT7,'(A)')'H: scalar product of psi dihedral axis of 1st r
     &esidue in 2nd conformation with screw axis'
      WRITE(IOUT7,'(A)')'I: scalar product of phi dihedral axis of 2nd r
     &esidue in 2nd conformation with screw axis'
      WRITE(IOUT7,'(A)')'all angles in degrees'
C
      CLOSE(IN)
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
