C
C SUBROUTINE TO CALCULATE ROTATION VECTOR AT RESIDUE BY
C CALCUALTING CURL AT N-CA-CB-C TETRAHEDRON
C 
      SUBROUTINE ROTVEC (IAT1,IAT2,IAT3,IAT4,CO,V,TRACER,AMPTHET,
     &                    UNTHX,UNTHY,UNTHZ)
C 
      IMPLICIT NONE
C 
      INTEGER I,J,IAT1,IAT2,IAT3,IAT4
      REAL*8 V(*)
      REAL*8 CO(3,*),CURLX,CURLY,CURLZ
      REAL*8 THEX,THEY,THEZ
      REAL*8 DMATRIX(3,3),DINV(3,3)
      REAL*8 DVX(3),DVY(3),DVZ(3)
      REAL*8 DX(3),DY(3),DZ(3)
      REAL*8 TRACER,COSINE,AMPTHET,UNTHX,UNTHY,UNTHZ
C 
      DMATRIX(1,1)=CO(1,IAT2)-CO(1,IAT1)
      DMATRIX(1,2)=CO(2,IAT2)-CO(2,IAT1)
      DMATRIX(1,3)=CO(3,IAT2)-CO(3,IAT1)
      DMATRIX(2,1)=CO(1,IAT3)-CO(1,IAT1)
      DMATRIX(2,2)=CO(2,IAT3)-CO(2,IAT1)
      DMATRIX(2,3)=CO(3,IAT3)-CO(3,IAT1)
      DMATRIX(3,1)=CO(1,IAT4)-CO(1,IAT1)
      DMATRIX(3,2)=CO(2,IAT4)-CO(2,IAT1)
      DMATRIX(3,3)=CO(3,IAT4)-CO(3,IAT1)
      CALL M_INV (DMATRIX,DINV)
C 
C CHANGE IN X-COMPONENT
C 
      DVX(1)=V(2*3-2)-V(1*3-2)
      DVX(2)=V(3*3-2)-V(1*3-2)
      DVX(3)=V(4*3-2)-V(1*3-2)
C 
      DX(1)=0.0
      DX(2)=0.0
      DX(3)=0.0
      DO 20 I=1,3
        DO 10 J=1,3
          DX(I)=DX(I)+DINV(I,J)*DVX(J)
10      CONTINUE
20    CONTINUE
C 
C CHANGE IN Y-COMPONENT
C 
      DVY(1)=V(2*3-1)-V(1*3-1)
      DVY(2)=V(3*3-1)-V(1*3-1)
      DVY(3)=V(4*3-1)-V(1*3-1)
C 
      DY(1)=0.0
      DY(2)=0.0
      DY(3)=0.0
      DO 40 I=1,3
        DO 30 J=1,3
          DY(I)=DY(I)+DINV(I,J)*DVY(J)
30      CONTINUE
40    CONTINUE
C 
C CHANGE IN Z-COMPONENT
C 
      DVZ(1)=V(2*3)-V(1*3)
      DVZ(2)=V(3*3)-V(1*3)
      DVZ(3)=V(4*3)-V(1*3)
C 
      DZ(1)=0.0
      DZ(2)=0.0
      DZ(3)=0.0
      DO 60 I=1,3
        DO 50 J=1,3
          DZ(I)=DZ(I)+DINV(I,J)*DVZ(J)
50      CONTINUE
60    CONTINUE
C 
C CALCULATE CURL
C 
      CURLX=DZ(2)-DY(3)
      CURLY=DX(3)-DZ(1)
      CURLZ=DY(1)-DX(2)
C 
      THEX=CURLX/2.0
      THEY=CURLY/2.0
      THEZ=CURLZ/2.0
C 
      AMPTHET=SQRT(THEX**2+THEY**2+THEZ**2)
      UNTHX=THEX/AMPTHET
      UNTHY=THEY/AMPTHET
      UNTHZ=THEZ/AMPTHET
      COSINE=(TRACER-1)*0.5
      AMPTHET=ACOS(COSINE)
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
