C 
C TO DETERMINE BENDING RESIDUES
C THE PAIR OF DOMAINS A AND B.  THE ROTATION VECTOR OF EACH WINDOW
C SEGMENT IS PROJECTED ONTO THE INTERDOMAIN SCREW AXIS FOR THAT 
C PAIR.  THE AVERAGE AND STANDARD DEVIATION IS CALCULATED FOR A AND
C B.  INTERDOMAIN RESIDUES ARE THOSE AT THE CONNECTIONS
C BETWEEN THE DOMAINS PLUS ANY OF THOSE THAT HAVE PROJECTED ROTATION
C ANGLES ABOVE THE AVERAGE PLUS ONE STANDARD DEVIATION FOR DOMAIN A
C (THE ONE FIXED IN SPACE) FROM A CONNECTING POINT WITH B, AND THOSE 
C THAT HAVE PROJECTED ROTATION ANGLES BELOW THE AVERAGE MINUS ONE
C STANDARD DEVIATION FROM A CONNECTING POINT WITH A.
C
      SUBROUTINE HINGERES3D(NDOM,NRES,WINDLEN,DOMA,DOMB,NSEG,NSEGL,
     & IRESBEG,IRESEND,IRESBEGL,IRESENDL,NI,CA,CP,CB,COO1,COO2,NAAT1,
     & NAAT2,ATLIST1,ATLIST2,COOBB1,COOBB2,NCLUS,MASS,AMPROT,
     & RESPDBNUM,RESPDBTYP,
     & IOUT1,IOUT7,NCLUSTER,ROT,AMPTHET,bendres,NB,DOMCONres,NKON,ND,
     & KEYRES,RESCONT,NC,UNTHX,UNTHY,UNTHZ)
C
      IMPLICIT NONE
C 
      include 'DynDom.param'
C
      INTEGER NCLUSTER,ICLUS,KEYRES!,ICON,ICONRES,IRESWIND,IC
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*),NSEG(NDOMX),ND(NDOMX)
      INTEGER IRESBEGL(NDOMX,NSEGMX,NCLUSMX),NKON(NDOMX)
      INTEGER IRESENDL(NDOMX,NSEGMX,NCLUSMX)
      INTEGER NRES,ISEG,IRES,IRES1!,IRES2,IAT(NDOMX),IAT1,IAT2,IAT3,IAT4	  
      INTEGER I,WINDLEN,DOMA,DOMB,NA,NB(NCLUSMX),NC(NDOMX)!,NMAX,J
      INTEGER IDOM,NDOM,ISEG1,JSEG1,JRES1,NCLUS!,BEND,AEND,ISEG2
      INTEGER NSEGL(NDOMX,*)
c      INTEGER Contactres2(NDOMX,NSEGMX)
      INTEGER DOMCONRES(NDOMX,*)!,DOMCON(NDOMX,nresmx),N(NDOMX)
      INTEGER BENDRES(NCLUSMX,NSEGMX)!,CONTACTRES1(NCLUSMX,NSEGMX)
c      INTEGER CONTRESCON11(NCLUSMX,NSEGMX),CONTRESCON12(NCLUSMX,NSEGMX)
c      INTEGER CONTRESCON21(NCLUSMX,NSEGMX),CONTRESCON22(NCLUSMX,NSEGMX)
c      INTEGER CONTRES1(NCLUSMX,NSEGMX),CONTRES2(NCLUSMX,NSEGMX)
      INTEGER RESCONT(NDOMX,NSEGMX)!,NCONRES(NDOMX,NRESMX)
      INTEGER ATLIST1(NRESMX,*),ATLIST2(NRESMX,*),NAAT1(*),NAAT2(*)
      INTEGER NI(*),CA(*),CB(*),CP(*)!,IPAIR
      INTEGER IOUT1,IOUT7
      REAL*8 UNTHX,UNTHY,UNTHZ,AMPROT,AMPTHET!,XL,YL,ZL,
c      REAL*8 AMPTR,XAX,YAX,ZAX,TRACER
      REAL*8 AMPX(NRESMX),AMPY(NRESMX),AMPZ(NRESMX)
      REAL*8 XAVA,YAVA,ZAVA!,XAVB,YAVB,ZAVB
      REAL*8 XXCORA,XYCORA,XZCORA,YYCORA,YZCORA,ZZCORA
c      REAL*8 XXCORB,XYCORB,XZCORB,YYCORB,YZCORB,ZZCORB
      REAL*8 AVA,VARA,SDA!,PRO,AVB,VARB,SDB,UX,UY,UZ
c      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF,RMSD
      REAL*8 MASS(*)!,PROJ(NRESMX)
      REAL*8 COOBB1(3,*),COOBB2(3,*)
      REAL*8 COO1(3,*),COO2(3,*)
      REAL*8 ROT(NBLOCKMX,3),Q
c      REAL*8 CO1(3,NUMATMX),CO2(3,NUMATMX)
      REAL*8 SIGMA(3,3),INVSIGMA(3,3)!,SIGMB(3,3),INVSIGMB(3,3),QA,QB
c      REAL*8 X1,Y1,Z1,X2,Y2,Z2,DIST1,X21,Y21,Z21,X22,Y22,Z22,DIST2
      CHARACTER*5 RESPDBNUM(*)
      CHARACTER*4 RESPDBTYP(*)
c      LOGICAL CON1,CON2,SET1,SET3
      
C============================================================== 
C THREAD WINDOW THROUGH FIRST Cluster 
C OF ROTATION VECTORS ALONG . CALCULATE AVERAGE 
C AND STANDARD DEVIATION 'the value of Q ' for bending residues'
C===============================================================

C
      AVA=0.0
      VARA=0.0
      SDA=0.0  

      DO 100 ICLUS = 1,NCLUS
        NA=0
        XAVA=0.0
        YAVA=0.0
        ZAVA=0.0
        XXCORA=0.0
        XYCORA=0.0
        XZCORA=0.0
        YYCORA=0.0
        YZCORA=0.0
        ZZCORA=0.0
       
       NB(ICLUS)=0   
       
       DO 40 ISEG=1,NSEGL(ICLUS,NCLUS)
        DO 42 IRES=IRESBEGL(ICLUS,ISEG,NCLUS),IRESENDL(ICLUS,ISEG,NCLUS)

          AMPX(IRES)= ROT(IRES,1)*180.0/PI
          AMPY(IRES)= ROT(IRES,2)*180.0/PI
          AMPZ(IRES)= ROT(IRES,3)*180.0/PI
 
          XAVA=XAVA+AMPX(IRES)
          YAVA=YAVA+AMPY(IRES)
          ZAVA=ZAVA+AMPZ(IRES)

          XXCORA=XXCORA+AMPX(IRES)*AMPX(IRES)
          YYCORA=YYCORA+AMPY(IRES)*AMPY(IRES)
          ZZCORA=ZZCORA+AMPZ(IRES)*AMPZ(IRES)
          XYCORA=XYCORA+AMPX(IRES)*AMPY(IRES)
          XZCORA=XZCORA+AMPX(IRES)*AMPZ(IRES)
          YZCORA=YZCORA+AMPY(IRES)*AMPZ(IRES)

         NA=NA+1 
42      CONTINUE
40     CONTINUE

C
          AVA=AVA/NA
      
C
         XAVA=XAVA/NA
         YAVA=YAVA/NA
         ZAVA=ZAVA/NA
         XXCORA=XXCORA/NA-(XAVA*XAVA)
         YYCORA=YYCORA/NA-(YAVA*YAVA)
         ZZCORA=ZZCORA/NA-(ZAVA*ZAVA)
         XYCORA=XYCORA/NA-(XAVA*YAVA)
         XZCORA=XZCORA/NA-(XAVA*ZAVA)
         YZCORA=YZCORA/NA-(YAVA*ZAVA)
C
         SIGMA(1,1)=XXCORA
         SIGMA(1,2)=XYCORA
         SIGMA(1,3)=XZCORA
         SIGMA(2,1)=XYCORA
         SIGMA(2,2)=YYCORA
         SIGMA(2,3)=YZCORA
         SIGMA(3,1)=XZCORA
         SIGMA(3,2)=YZCORA
         SIGMA(3,3)=ZZCORA
         CALL M_INV (SIGMA,INVSIGMA) 
      
C===========================================
C CALCULATION OF Q determination of set1
C =========================================
        
       DO 99 ISEG=1,NSEGL(ICLUS,NCLUS)
        DO 98 IRES=IRESBEGL(ICLUS,ISEG,NCLUS),IRESENDL(ICLUS,ISEG,NCLUS) 
          Q=0.0
          AMPX(IRES)=AMPX(IRES)-XAVA
          AMPY(IRES)=AMPY(IRES)-YAVA
          AMPZ(IRES)=AMPZ(IRES)-ZAVA
          Q=Q+AMPX(IRES)*INVSIGMA(1,1)*AMPX(IRES)
          Q=Q+AMPX(IRES)*INVSIGMA(1,2)*AMPY(IRES)
          Q=Q+AMPX(IRES)*INVSIGMA(1,3)*AMPZ(IRES)
          Q=Q+AMPY(IRES)*INVSIGMA(2,1)*AMPX(IRES)
          Q=Q+AMPY(IRES)*INVSIGMA(2,2)*AMPY(IRES)
          Q=Q+AMPY(IRES)*INVSIGMA(2,3)*AMPZ(IRES)
          Q=Q+AMPZ(IRES)*INVSIGMA(3,1)*AMPX(IRES)
          Q=Q+AMPZ(IRES)*INVSIGMA(3,2)*AMPY(IRES)
          Q=Q+AMPZ(IRES)*INVSIGMA(3,3)*AMPZ(IRES)
     
          IF(Q.GE.4.3) THEN  
            NB(ICLUS)=NB(ICLUS)+1             
            BENDRES(ICLUS,NB(ICLUS))=IRES
          ENDIF  
98      CONTINUE
99     CONTINUE
100   CONTINUE

c       CALL SET2(NRES,NDOM,NSEG,IRESBEG,IRESEND,COO1,COO2,NAAT1,NAAT2,
c     & ATLIST1,ATLIST2,COOBB1,COOBB2,ND,DOMCON,DOMCONRES)


C==================================================================
C   DETERMINING THE intersection of residues from SET1 & SET2
C   which are certainly invloved in control. this is set3
C==================================================================


       KEYRES=0
       DO 111 IDOM=1,NDOM
         NC(IDOM)=0
        DO 444 ISEG1=1,NKON(IDOM)
	
	IRES1=DOMCONres(IDOM,ISEG1)
       DO 11 I=1,NCLUS
        DO 222 JSEG1=1,NB(I)
	  JRES1=BENDRES(I,JSEG1)
C	     WRITe(6,*)'set3  IRES1 ',IRES1,' JRES1 ',JRES1
	    IF (IRES1.EQ.JRES1)THEN
	     IF ((BENDRES(I,JSEG1)) .NE. (BENDRES(I,JSEG1-1))) THEN 
	      NC(IDOM)=NC(IDOM)+1
	      KEYRES=KEYRES+1
c	      WRITE(6,*)' KEY RES ',KEYRES,JRES1,IRES1
	      RESCONT(IDOM,NC(IDOM))=JRES1  
	      ENDIF   
	    ENDIF

222     CONTINUE  
11     CONTINUE
444	   CONTINUE 
111       CONTINUE
       WRITE(6,*)'NO OF KEY RES = ',KEYRES 
         
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
