C
C SUBROUTINE TO READ INPUT FILE AND INITIALIZE OUTPUT


      SUBROUTINE INOUTPUTR(IN1,IN2,IOUT1,IOUT4,IOUT6,IOUT7,
     &                     NCLUSTER,ITER,GRDSIZE,BLKSIZE,PEROCC,
     &                     DOMIN,EXTCRIT,FILEIN1,FILEIN2)
C
      IMPLICIT NONE
C 
      include 'DynDom.param'
C
      INTEGER NCLUSTER,ITER,DOMIN,J
      INTEGER IN,IN1,IN2,IOUT1,IOUT4,IOUT6,IOUT7
      INTEGER IOUT0,IOUT00,BLKSIZE
      INTEGER LENGTH,IEND,IEND1,IEND2
      INTEGER KEYEND,IARGC
      REAL*8 EXTCRIT,PEROCC,GRDSIZE
      CHARACTER*300 INPO
      CHARACTER*200 TITLE 
      CHARACTER*200 FILEI,FILEIN1,FILEIN2
      CHARACTER*200 FILEO1,FILEO4,FILEO6
      LOGICAL NOTHING,TITLEY,FILE1Y,FILE2Y,CLUSY,ITERY,BLOCKY,GRIDY
      LOGICAL DOMINY,RATIOY,PEROCCY,VOLUMEY
C
      IN=11
      IN1=12
      IN2=13
      IOUT1=14
      IOUT0=15  
      IOUT00=16 
      IOUT4=17
      IOUT6=19
      IOUT7=20
C
      TITLEY=.FALSE.
      FILE1Y=.FALSE.
      FILE2Y=.FALSE.
      CLUSY=.FALSE.
      ITERY=.FALSE.
      BLOCKY=.FALSE.
      PEROCCY=.FALSE.
      DOMINY=.FALSE.
      RATIOY=.FALSE.
      VOLUMEY=.FALSE.
      GRIDY=.FALSE.
C
      J=IARGC()
      CALL GETARG(J,FILEI)

      IF(J.EQ.0) THEN
        WRITE(6,'(A)')'command file name?'
        READ(5,'(A)')FILEI
      ELSEIF(J.EQ.1) THEN
      	CALL GETARG(1,FILEI)
      ELSE
        WRITE(6,*)'ONLY ARGUMENT REQUIRED IS THE COMMAND FILE NAME'
        STOP
      ENDIF
C
c      WRITE(6,'(A)')'***************************************************
c     &*****'
c      WRITE(6,'(A)')'DynDom3D Reference:'
c      WRITE(6,'(A)') THIS METHODOLOGY IS AN EXTENSION OF THE MONOMERIC 
C     &VERSION DynDom1.5
c      WRITE(6,'(A)')
c      WRITE(6,'(A)')'Hayward, S. and Berendsen, H.J.C.'
c      WRITE(6,'(A)')'"Systematic Analysis of Domain Motions in Proteins'
c      WRITE(6,'(A)')'from Conformational Change: New Results on Citrate'
c      WRITE(6,'(A)')'Synthase and T4 Lysozyme."'
c      WRITE(6,'(A)')'Proteins, Vol 30 144-154,1998'
c      WRITE(6,'(A)')
c      WRITE(6,'(A)')'***************************************************
c     &*****'
c      WRITE(6,'(A)')
c      WRITE(6,'(A)')'MORE INFORMATION on DynDom3D can be found at the DynDom HOME PAGE
c     &'
c      WRITE(6,'(A)')
c      WRITE(6,'(A)')'http://www.cmp.uea.ac.uk/dyndom'
c     WRITE(6,'(A)')
c     WRITE(6,'(A)')'***************************************************
c     &*****'
C
      OPEN (IN,FILE=FILEI,STATUS='OLD',FORM='FORMATTED')
C
10    READ(IN,'(A)',END=20)INPO
      KEYEND=1
      CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
C
      IF(INPO((KEYEND):(KEYEND+4)).EQ.'title') THEN
        KEYEND=KEYEND+5
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          TITLEY=.TRUE.
          TITLE=INPO(KEYEND:)
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+8)).EQ.'filename1') THEN
        KEYEND=KEYEND+9
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          FILE1Y=.TRUE.
          FILEIN1=INPO(KEYEND:)
        ENDIF
C

      ELSEIF(INPO((KEYEND):(KEYEND+8)).EQ.'filename2') THEN
        KEYEND=KEYEND+9
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          FILE2Y=.TRUE.
          FILEIN2=INPO(KEYEND:)
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+7)).EQ.'clusters') THEN
        KEYEND=KEYEND+8
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          CLUSY=.TRUE.
          READ(INPO(KEYEND:),*)NCLUSTER
          IF(NCLUSTER.LE.0) CLUSY=.FALSE.
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+9)).EQ.'iterations') THEN
        KEYEND=KEYEND+10
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          ITERY=.TRUE.
          READ(INPO(KEYEND:),*)ITER
          IF(ITER.LE.0) ITERY=.FALSE.
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+7)).EQ.'gridsize') THEN
        KEYEND=KEYEND+8
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          GRIDY=.TRUE.
          READ(INPO(KEYEND:),*)GRDSIZE
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+10)).EQ.'blockfactor') THEN
        KEYEND=KEYEND+11
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          BLOCKY=.TRUE.
          READ(INPO(KEYEND:),*)BLKSIZE
        ENDIF

      ELSEIF(INPO((KEYEND):(KEYEND+8)).EQ.'occupancy') THEN
        KEYEND=KEYEND+9
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          PEROCCY=.TRUE.
          READ(INPO(KEYEND:),*)PEROCC
        ENDIF
C        

      ELSEIF(INPO((KEYEND):(KEYEND+4)).EQ.'ratio') THEN
        KEYEND=KEYEND+5
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          RATIOY=.TRUE.
          READ(INPO(KEYEND:),*)EXTCRIT
          IF(EXTCRIT.LE.0) RATIOY=.FALSE.
          IF(EXTCRIT.LT.1.0) THEN
             WRITE(6,'(A)')
             WRITE(6,'(A)')'WARNING "ratio" < 1.0'
             WRITE(6,'(A)')'THE LOWER THE VALUE OF "ratio",THE LESS'
             WRITE(6,'(A)')'MEANINGFUL YOUR RESULTS WILL BECOME'
             WRITE(6,'(A)')
          ENDIF
        ENDIF
C
      ELSEIF(INPO((KEYEND):(KEYEND+5)).EQ.'domain') THEN
        KEYEND=KEYEND+6
        CALL SPACEREMOVE(INPO,KEYEND,NOTHING)
        IF(.NOT.NOTHING) THEN
          DOMINY=.TRUE.
          READ(INPO(KEYEND:),*)DOMIN
          IF(DOMIN.LE.0) THEN
            DOMINY=.FALSE.
          ENDIF
        ENDIF
C
      ENDIF
C
      GOTO 10  
C
20    CONTINUE
C
      IF(.NOT. TITLEY) THEN
        WRITE(6,'(A)')'WARNING NO TITLE; PLEASE GIVE ONE'
        READ(5,'(A)')TITLE
      ENDIF
C
      IF(.NOT. FILE1Y) THEN
        WRITE(6,'(A)')'NO FILENAME FOR CONFORMER 1'
        STOP
      ENDIF
C
      IF(.NOT. FILE2Y) THEN
        WRITE(6,'(A)')'NO FILENAME FOR CONFORMER 2'
        STOP
      ENDIF
C
      IF(.NOT. CLUSY) THEN
C       WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR NO OF CLUSTERS=20'
        NCLUSTER=20
      ENDIF
C
      IF(.NOT. ITERY) THEN
C      WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR NO OF ITERATIONS=100'
        ITER=100
      ENDIF
C
      IF(.NOT. GRIDY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR GRIDSIZE = 4'
        GRDSIZE=4.0
      ENDIF
C
      IF(.NOT. BLOCKY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR BLOCKSIZE = 2'
        BLKSIZE=2
      ENDIF
C      
      IF(.NOT. PEROCCY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR OCCUPANCY FACTOR = 0.6'
        PEROCC=0.6
      ENDIF
C      
     
C
      IF(.NOT. RATIOY) THEN
        WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR RATIO=1.0'
        EXTCRIT=1.0
      ENDIF
C
      IF(.NOT. DOMINY) THEN
        WRITE(6,'(A)')'MINIMUM DOMAIN SIZE WILL BE SET TO 200 ATOMS'
        DOMIN=200
      ENDIF
C

C OPEN PDB FILES
C
      OPEN (IN1,FILE=FILEIN1,STATUS='OLD',FORM='FORMATTED')
      IF(FILEIN1.NE.FILEIN2) THEN  
        OPEN(IN2,FILE=FILEIN2,STATUS='OLD',FORM='FORMATTED')
      ELSE
        IN2=IN1
      ENDIF
C
      LENGTH=LEN(TITLE)
      CALL STRINGLENGTH(TITLE,LENGTH,IEND)
      FILEO1=TITLE(1:IEND)//'_info.txt'
      FILEO4=TITLE(1:IEND)//'_rotvecs.pdb'
      FILEO6=TITLE(1:IEND)//'_structure.pdb'
c======================================================
C CHECK THE CONDITION OF GRIDLENGTH AND BLOCKFACTOR. IF 
C BLOCK FACTOR IS GREATER THAN OR EQUAL TO GRID LENGTH
C SUGGEST THE USER TO REDUCE IT
C========================================================
C CHECK GRIDLENGTH
C-----------------------------------------------
c     IF (GRDSIZE .LT. 3.0 .OR. GRDSIZE .GT. 9.0) THEN
c       IF (GRDSIZE .LT. 3.0)THEN
c           WRITE(6,'(A)')
c           WRITE(6,'(A)')'WARNING "gridlength" IS SET TO LOW VALUE ' 
c    GRDSIZE=3.0
c           WRITE(6,'(A)')	    
c           WRITE(6,'(A)')'SETTING LOWEST VALUE FOR GRIDLENGTH : 3.0'
c          WRITE(6,'(A)')'PLEASE CHOOSE GRIDLENGTH  BETWEEN 3.0 TO 9.0 '
c          WRITE(6,'(A)')	   	    	    
c       END IF  
cC
c       IF (GRDSIZE .GT. 9.0)THEN
c           WRITE(6,'(A)')
c           WRITE(6,'(A)')'WARNING "gridlength" IS SET TO HIGH VALUE ' 
c           WRITE(6,'(A)')	    
c    GRDSIZE=9.0
c           WRITE(6,'(A)')'SETTING MAXIMUM VALUE FOR GRIDLENGTH : 9.0 '
c               WRITE(6,'(A)')'PLEASE REMEMBER YOU MAY HAVE TO INCREASE  
c    &THE APPROPRIATE PARAMETERS IN "DynDom.param" FILE AND RECOMPILE IF
c    & REQUIRED'
c           WRITE(6,'(A)')     	    	    
c       END IF  
cC	
c     END IF
C----------------------------------------------------
C CHECK BLOCKLENGTH     
C---------------------------------------------------
      IF (BLKSIZE .LT.2) THEN
        WRITE(6,'(A)')'PLEASE CHOOSE A BLOCKFACTOR FROM 2 TO 5'
	BLKSIZE=2
	WRITE(6,'(A)')'SETTING DEFAULT VALUE FOR BLOCKFACTOR : 2 '
        WRITE(6,'(A)')	
      END IF
C
      IF (BLKSIZE .GT. 5) THEN      
        WRITE(6,'(A)')
         WRITE(6,'(A)')'WARNING "blockfactor" IS SET TO HIGH VALUE '
         WRITE(6,'(A)')     	    	           
         BLKSIZE=5
         WRITE(6,'(A)')
         WRITE(6,'(A)')'SETTING BLOCKFACTOR TO : 5 '       
         WRITE(6,'(A)')       
      END IF	
C       

C-------------------------------------------------       
C CHECK IF BLCOKFACTOR IS STILL A HIGHER VALUE
C--------------------------------------------------        
c        IF (GRDSIZE .EQ. 3.0 .AND. BLKSIZE .GT. 4.0)THEN
c           BLKSIZE=4.0
c        END IF
c        WRITE(6,'(A32,I4)')'NEW "blockfactor" VALUE IS : ',BLKSIZE
c       ELSEIF(BLKSIZE .EQ. GRDSIZE .AND. BLKSIZE .GT. 5) THEN
c        BLKSIZE=5
c        WRITE(6,'(A32,I4)')'NEW "blockfactor" VALUE IS : ',BLKSIZE	
c       END IF	
c========================================================
C============================================================
C OPENING OUTPUT FILES 
C============================================================   
c
      OPEN (IOUT1,FILE=FILEO1,STATUS='UNKNOWN',FORM='FORMATTED')
c      
c===============================================================
c writing out the input information in the Info file
c--------------------------------------------------------------      
      WRITE(IOUT1,'(A)')'DynDom3D INFORMATION FILE  version 1.04'
      WRITE(IOUT1,'(A)')' '
      WRITE(IOUT1,'(A)')' IMPORTANT NOTE : ' 
      WRITE(IOUT1,'(A)')' '                  
         WRITE(IOUT1,'(A)')'COLOUR ACCORDING TO TEMPERATURE IN RASMOL TO
     & VISUALISE DOMAINS '
      WRITE(IOUT1,'(A)')' '
              WRITE (IOUT1,'(A80)') '===================================
     &============================================='      
      WRITE(IOUT1,'(A)')'DynDom3D INPUT :'     
      WRITE(IOUT1,'(A30)')'INPUT FILES  '
      WRITE(IOUT1,'(A30)')'***********  '      
      LENGTH=LEN(FILEIN1)
      CALL STRINGLENGTH(FILEIN1,LENGTH,IEND1)
      WRITE(IOUT1,'(A26,A)')'FILE NAME OF CONFORMER 1: ',
     & FILEIN1(1:IEND1)
cC
      WRITE(IOUT1,'(A)')'           '
C      
      LENGTH=LEN(FILEIN2)
      CALL STRINGLENGTH(FILEIN2,LENGTH,IEND2)
      WRITE(IOUT1,'(A26,A)')'FILE NAME OF CONFORMER 2: ',
     & FILEIN2(1:IEND2)
              WRITE (IOUT1,'(A80)') '-----------------------------------
     &---------------------------------------------'      
      WRITE(IOUT1,'(A50)')'PARAMETERS USED TO DETERMINE DYNAMIC DOMAINS'
      WRITE(IOUT1,'(A)')'         '
      WRITE(IOUT1,'(A25,F4.2)')'GRID LENGTH: ',GRDSIZE
      WRITE(IOUT1,'(A25,I4)')'BLOCK FACTOR: ',BLKSIZE
      WRITE(IOUT1,'(A25,F5.2,A)')'OCCUPANCY PERCENTAGE: ',PEROCC*100,'%'
      WRITE(IOUT1,'(A25,I5,A6)')'MINIMUM DOMAIN SIZE: ',DOMIN,' ATOMS'
      WRITE(IOUT1,'(A45,F8.3)')'MINIMUM RATIO OF EXTERNAL TO INTERNAL MO
     &TION: ',EXTCRIT      
C
      WRITE(IOUT1,'(A,F5.1,A)')'DISTANCE CRITERION FOR A PAIR OF ATOMS T
     &O BE IN CONTACT: ',atDISTCRIT,' A'
      WRITE(IOUT1,'(A,F5.1,A)')'DISTANCE CRITERION FOR PAIR OF DOMAINS T
     &O BE IN CONTACT: ',domDISTCRIT,' A'

C
C              WRITE (IOUT1,'(A80)') '===================================
C     &============================================='
      OPEN (IOUT4,FILE=FILEO4,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT4,'(A)')'DYNDOM3D VERSION 1.04'
       WRITE(IOUT4,'(A)')'# COLOUR ACCORDING TO TEMPERATURE IN RASMOL TO
     & VISUALISE CLUSTERS '
      
      WRITE(IOUT4,'(A)')TITLE(1:IEND)
C
      OPEN (IOUT6,FILE=FILEO6,STATUS='UNKNOWN',FORM='FORMATTED')
      WRITE(IOUT6,'(A)')'DYNDOM3D VERSION 1.04'
            WRITE(IOUT6,'(A)')TITLE(1:IEND)
       WRITE(IOUT6,'(A)')'# COLOUR ACCORDING TO TEMPERATURE IN RASMOL TO
     & VISUALISE DOMAINS '
	    
C
C
      CLOSE(IN)
C
      RETURN
      END
      
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2005.
C     DynDom MULTISUBUNIT VERSION
C
C-------------------------------------------------------------
C
