/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.Atom;
import java.util.ArrayList;

public class AminoAcid {
    private String aminoAcidID;
    private String aminoAcidName;
    private ArrayList<Atom> atoms;
    private ArrayList<Atom> pureAtoms = new ArrayList();
    private ArrayList<String> atomSeq = new ArrayList();
    private ArrayList<Integer> atomSeqIndex = new ArrayList();
    private boolean aminoAcid;

    public AminoAcid(String aminoAcidID, String aminoAcidName, ArrayList<Atom> atoms, boolean aminoAcid) {
        this.aminoAcidID = aminoAcidID;
        this.aminoAcidName = aminoAcidName;
        this.atoms = atoms;
        this.extractAtoms();
        this.extractAtomSequence();
        this.aminoAcid = aminoAcid;
    }

    public final void extractAtoms() {
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (!this.atoms.get((int)i).prefix.equals("ATOM")) continue;
            this.pureAtoms.add(this.atoms.get(i));
            this.atomSeqIndex.add(new Integer(i));
        }
    }

    public boolean isAminoAcid() {
        return this.aminoAcid;
    }

    public String getAminoAcidID() {
        return this.aminoAcidID;
    }

    public void setAminoAcid(boolean aminoAcid) {
        this.aminoAcid = aminoAcid;
    }

    public void setAminoAcidID(String aminoAcidID) {
        this.aminoAcidID = aminoAcidID;
    }

    public void setAminoAcidName(String aminoAcidName) {
        this.aminoAcidName = aminoAcidName;
    }

    public void setAtomSeq(ArrayList<String> atomSeq) {
        this.atomSeq = atomSeq;
    }

    public void setAtomSeqIndex(ArrayList<Integer> atomSeqIndex) {
        this.atomSeqIndex = atomSeqIndex;
    }

    public void setAtoms(ArrayList<Atom> atoms) {
        this.atoms = atoms;
    }

    public void setPureAtoms(ArrayList<Atom> pureAtoms) {
        this.pureAtoms = pureAtoms;
    }

    public String getAminoAcidName() {
        return this.aminoAcidName;
    }

    public ArrayList<String> getAtomSeq() {
        return this.atomSeq;
    }

    public ArrayList<Integer> getAtomSeqIndex() {
        return this.atomSeqIndex;
    }

    public ArrayList<Atom> getAtoms() {
        return this.atoms;
    }

    public ArrayList<Atom> getPureAtoms() {
        return this.pureAtoms;
    }

    public final void extractAtomSequence() {
        for (Atom eachAtom : this.pureAtoms) {
            this.atomSeq.add(eachAtom.atomType);
        }
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        for (Atom eachAtom : this.atoms) {
            strb.append(eachAtom.toString());
            strb.append("\n");
        }
        return strb.toString();
    }

    public void printr() {
        StringBuilder strb = new StringBuilder();
        strb.append("Amino Acid: ");
        strb.append(this.aminoAcidID);
        strb.append(" ");
        strb.append(this.aminoAcidName);
        strb.append("\n");
        strb.append(this.atoms.size());
        strb.append(" atoms overall\n");
        strb.append(this.pureAtoms.size());
        strb.append(" standard atoms\n\n");
        System.out.print(strb.toString());
    }
}

