/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

public class Atom {
    public String prefix;
    public String atomID;
    public String atomType;
    public String otherChar;
    public String aminoAcidName;
    public String chain;
    public String aminoAcidNo;
    public String endLine;
    private double x;
    private double y;
    private double z;
    private double cluster;
    private boolean print;

    public Atom(String prefix, String atomID, String atomType, String otherChar, String aminoAcidName, String chain, String aminoAcidNo, String endLine, double x, double y, double z) {
        this.prefix = prefix;
        this.atomID = atomID;
        this.atomType = atomType;
        this.otherChar = otherChar;
        this.aminoAcidName = aminoAcidName;
        this.chain = chain;
        this.aminoAcidNo = aminoAcidNo;
        this.endLine = endLine;
        this.cluster = -1.0;
        this.x = x;
        this.y = y;
        this.z = z;
        this.print = true;
    }

    public String toString() {
        if (this.print) {
            int count;
            StringBuilder strb = new StringBuilder();
            strb.append(this.prefix);
            for (count = 6 - this.prefix.length(); count > 0; --count) {
                strb.append(" ");
            }
            for (count = 5 - this.atomID.length(); count > 0; --count) {
                strb.append(" ");
            }
            strb.append(this.atomID);
            if (count == 3) {
                strb.append("  ");
            } else if (count == 4) {
                strb.append("  ");
            } else {
                for (count = 5 - this.atomType.length(); count > 0; --count) {
                    strb.append(" ");
                }
            }
            strb.append(this.atomType);
            if (count == 3) {
                strb.append(" ");
            } else if (count == 4) {
                strb.append("  ");
            }
            strb.append(this.otherChar);
            for (count = 3 - this.aminoAcidName.length(); count > 0; --count) {
                strb.append(" ");
            }
            strb.append(this.aminoAcidName);
            for (count = 2 - this.chain.length(); count > 0; --count) {
                strb.append(" ");
            }
            strb.append(this.chain);
            for (count = 4 - this.aminoAcidNo.length(); count > 0; --count) {
                strb.append(" ");
            }
            strb.append(this.aminoAcidNo);
            strb.append("    ");
            strb.append(String.format("%8.3f", this.x));
            strb.append(String.format("%8.3f", this.y));
            strb.append(String.format("%8.3f", this.z));
            if (this.cluster > -1.0) {
                strb.append("     ");
                strb.append(String.format("%6.2f", this.cluster));
            }
            return strb.toString();
        }
        return "";
    }

    public void setPrint(boolean canPrint) {
        this.print = canPrint;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getCluster() {
        return this.cluster;
    }

    public void setCluster(double cluster) {
        this.cluster = cluster;
    }
}

