/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import java.util.ArrayList;
import java.util.Iterator;

public class Chain {
    public String chainID;
    public ArrayList<AminoAcid> aminoAcids;
    public ArrayList<String> sequence;
    public ArrayList<String> sequenceRef;
    public ArrayList<AminoAcid> nonAminos;
    public ArrayList<AminoAcid> allAminos;
    public String terminator;
    public boolean HETATMend = false;

    public Chain(String chainID, ArrayList<AminoAcid> aminoAcids, ArrayList<String> sequence, ArrayList<String> sequenceRef, ArrayList<AminoAcid> nonAminos, String terminator) {
        this.chainID = chainID;
        this.aminoAcids = aminoAcids;
        this.sequence = sequence;
        this.sequenceRef = sequenceRef;
        this.nonAminos = nonAminos;
        this.terminator = terminator;
        this.allAminos = (ArrayList)aminoAcids.clone();
        this.addNonAminos();
    }

    public final void addNonAminos() {
        if (!this.allAminos.isEmpty()) {
            for (AminoAcid eachNonAmino : this.nonAminos) {
                Iterator<AminoAcid> aminoIterator = this.allAminos.iterator();
                int index = 0;
                AminoAcid amino = aminoIterator.next();
                int aminoNumber = Integer.parseInt(amino.getAminoAcidID());
                int nonAminoNumber = Integer.parseInt(eachNonAmino.getAminoAcidID());
                while (aminoIterator.hasNext() && aminoNumber < nonAminoNumber) {
                    amino = aminoIterator.next();
                    aminoNumber = Integer.parseInt(amino.getAminoAcidID());
                    ++index;
                }
                this.allAminos.add(index, eachNonAmino);
            }
        } else {
            this.allAminos = this.nonAminos;
            this.HETATMend = true;
        }
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        if (!this.HETATMend) {
            for (AminoAcid eachAmino : this.aminoAcids) {
                strb.append(eachAmino.toString());
            }
            strb.append(this.terminator);
            strb.append("\n");
        } else {
            for (AminoAcid eachAmino : this.allAminos) {
                strb.append(eachAmino.toString());
            }
            strb.append(this.terminator);
            strb.append("\n");
        }
        return strb.toString();
    }

    public String toStringAll() {
        StringBuilder strb = new StringBuilder();
        for (AminoAcid eachAmino : this.allAminos) {
            strb.append(eachAmino.toString());
        }
        strb.append(this.terminator);
        strb.append("\n");
        return strb.toString();
    }

    public void printr() {
        System.out.println("Chain " + this.chainID);
        System.out.println();
        if (!this.HETATMend) {
            for (AminoAcid eachAmino : this.aminoAcids) {
                eachAmino.printr();
            }
        } else {
            System.out.println("END OF FILE HETATMs");
            System.out.println("");
            for (AminoAcid eachAmino : this.allAminos) {
                eachAmino.printr();
            }
        }
    }

    public void printrAll() {
        System.out.println("Chain " + this.chainID);
        if (this.HETATMend) {
            System.out.println("END OF FILE HETATMs");
            System.out.println("");
        }
        System.out.println();
        for (AminoAcid eachAmino : this.allAminos) {
            eachAmino.printr();
        }
    }

    public void printSequence() {
        StringBuilder strb = new StringBuilder();
        strb.append("Chain: ");
        strb.append(this.chainID);
        strb.append("\n");
        for (int i = 0; i < this.sequence.size(); ++i) {
            strb.append(this.sequenceRef.get(i));
            strb.append(": ");
            strb.append(this.sequence.get(i));
            strb.append("\n");
        }
        strb.append("END\n\n");
        System.out.print(strb.toString());
    }

    public void printTwoSequences(Chain otherSequence) {
        int i;
        StringBuilder strb = new StringBuilder();
        strb.append("SEQ1 & SEQ2 Chain:");
        strb.append(this.chainID);
        strb.append("\n");
        strb.append("# of Aminos: SEQ1 = ");
        strb.append(this.sequence.size());
        strb.append("; SEQ2 = ");
        strb.append(otherSequence.sequence.size());
        strb.append("\n");
        int extra = 0;
        for (i = 0; i < this.sequence.size() && i < otherSequence.sequence.size(); ++i) {
            strb.append(this.sequenceRef.get(i));
            strb.append(": ");
            strb.append(this.sequence.get(i));
            strb.append("   ");
            strb.append(otherSequence.sequenceRef.get(i));
            strb.append(": ");
            strb.append(otherSequence.sequence.get(i));
            strb.append("\n");
            extra = i + 1;
        }
        if (extra < this.sequence.size()) {
            for (i = extra; i < this.sequence.size(); ++i) {
                strb.append(this.sequenceRef.get(i));
                strb.append(": ");
                strb.append(this.sequence.get(i));
                strb.append("\n");
            }
        }
        if (extra < otherSequence.sequence.size()) {
            for (i = extra; i < otherSequence.sequence.size(); ++i) {
                strb.append("---------- ");
                strb.append(otherSequence.sequenceRef.get(i));
                strb.append(": ");
                strb.append(otherSequence.sequence.get(i));
                strb.append("\n");
            }
        }
        strb.append("END\n\n");
        System.out.print(strb.toString());
    }

    public int countAllAtoms() {
        int total = 0;
        for (AminoAcid aa : this.allAminos) {
            total += aa.getAtoms().size();
        }
        return total;
    }
}

