/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.Blosum62;
import PDBTool.Chain;
import PDBTool.Nuc44;
import PDBTool.ScoringMatrix;
import java.util.ArrayList;
import java.util.HashMap;

public class DynamicProgramming {
    private String fileOne;
    private String fileTwo;
    private Chain chainOne;
    private Chain chainTwo;
    private int[][] matrix;
    private int[][] tracebackmatrix;
    private ScoringMatrix scoring_matrix;
    private int gapPenalty = 8;
    private boolean aminoAcid;

    public DynamicProgramming(Chain chainOne, Chain chainTwo, String fileOne, String fileTwo, boolean aminoAcid) {
        this.fileOne = fileOne;
        this.fileTwo = fileTwo;
        this.chainOne = chainOne;
        this.chainTwo = chainTwo;
        int toplength = chainOne.sequence.size() + 1;
        int sidelength = chainTwo.sequence.size() + 1;
        this.matrix = new int[toplength][sidelength];
        this.tracebackmatrix = new int[toplength][sidelength];
        this.aminoAcid = aminoAcid;
        this.scoring_matrix = aminoAcid ? new Blosum62() : new Nuc44();
    }

    public void doDynamicProgramming() {
        for (int row = 1; row < this.matrix[0].length; ++row) {
            int actualRow = row - 1;
            String chainTwoPro = this.chainTwo.sequence.get(actualRow);
            HashMap hash = this.scoring_matrix.hash;
            int chainTwoHashIndex = (Integer)this.scoring_matrix.hash.get(chainTwoPro);
            for (int col = 1; col < this.matrix.length; ++col) {
                int actualCol = col - 1;
                String chainOnePro = this.chainOne.sequence.get(actualCol);
                int chainOneHashIndex = (Integer)this.scoring_matrix.hash.get(chainOnePro);
                int chainJoinScore = this.scoring_matrix.matrix[chainOneHashIndex][chainTwoHashIndex];
                int aboveScore = this.matrix[col][actualRow] - this.gapPenalty;
                int leftScore = this.matrix[actualCol][row] - this.gapPenalty;
                int noGapScore = this.matrix[actualCol][actualRow] + chainJoinScore;
                int topLeftMax = Math.max(aboveScore, leftScore);
                this.tracebackmatrix[col][row] = noGapScore >= aboveScore ? (noGapScore >= leftScore ? 3 : 2) : (aboveScore >= leftScore ? 1 : 2);
                this.matrix[col][row] = Math.max(topLeftMax, noGapScore);
            }
        }
    }

    public Chain getChainOne() {
        return this.chainOne;
    }

    public Chain getChainTwo() {
        return this.chainTwo;
    }

    public String getFileOne() {
        return this.fileOne;
    }

    public String getFileTwo() {
        return this.fileTwo;
    }

    public ArrayList<ArrayList<Integer>> doTraceback() {
        int i;
        ArrayList<ArrayList<Integer>> eachChain = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> chainA = new ArrayList<Integer>();
        ArrayList<Integer> chainB = new ArrayList<Integer>();
        int startrow = this.tracebackmatrix[0].length - 1;
        int startcol = this.tracebackmatrix.length - 1;
        boolean endrow = false;
        boolean endcol = false;
        int bestrow = this.matrix[0].length - 1;
        int bestcol = this.matrix.length - 1;
        while (!endrow) {
            if (startrow == 1) {
                endrow = true;
            }
            if (this.matrix[startcol][startrow] > this.matrix[bestcol][bestrow]) {
                bestrow = startrow;
                bestcol = startcol;
            }
            --startrow;
        }
        startrow = this.tracebackmatrix[0].length - 1;
        while (!endcol) {
            if (startcol == 1) {
                endcol = true;
            }
            if (this.matrix[startcol][startrow] > this.matrix[bestcol][bestrow]) {
                bestrow = startrow;
                bestcol = startcol;
            }
            --startcol;
        }
        boolean end = false;
        int row = bestrow;
        int col = bestcol;
        if (bestrow != this.matrix[0].length - 1) {
            for (i = this.matrix[0].length - 2; i > bestrow - 1; --i) {
                chainB.add(new Integer(i));
            }
        } else if (bestcol != this.matrix.length - 1) {
            for (i = this.matrix.length - 2; i > bestcol - 1; --i) {
                chainA.add(new Integer(i));
            }
        }
        while (!end) {
            if (row == 0 || col == 0) {
                end = true;
            }
            if (this.tracebackmatrix[col][row] == 3) {
                --col;
                --row;
                continue;
            }
            if (this.tracebackmatrix[col][row] == 2) {
                chainA.add(new Integer(--col));
                continue;
            }
            if (this.tracebackmatrix[col][row] != 1) continue;
            chainB.add(new Integer(--row));
        }
        if (row != 0) {
            for (i = row - 1; i >= 0; --i) {
                chainB.add(new Integer(i));
            }
        } else if (col != 0) {
            for (i = col - 1; i >= 0; --i) {
                chainA.add(new Integer(i));
            }
        }
        eachChain.add(chainA);
        eachChain.add(chainB);
        return eachChain;
    }

    public String deleteInsertions(ArrayList<ArrayList<Integer>> eachChain) {
        ArrayList<Integer> chainA = eachChain.get(0);
        ArrayList<Integer> chainB = eachChain.get(1);
        StringBuilder strb = new StringBuilder();
        strb.append("AMINO ACID REMOVAL, CHAIN ");
        strb.append(this.chainOne.chainID);
        strb.append("\n\n");
        strb.append("SEQ1 = ");
        strb.append(this.fileOne);
        strb.append(", SEQ2 = ");
        strb.append(this.fileTwo);
        strb.append("\n\n");
        strb.append("SEQ1 - REMOVED\n");
        for (Integer eachInt : chainA) {
            strb.append(this.chainOne.sequence.get(eachInt));
            strb.append(this.chainOne.sequenceRef.get(eachInt));
            strb.append("\n");
            this.chainOne.sequence.remove(eachInt);
            this.chainOne.sequenceRef.remove(eachInt);
            this.chainOne.allAminos.remove(eachInt);
            if (this.aminoAcid) {
                this.chainOne.aminoAcids.remove(eachInt);
                continue;
            }
            try {
                this.chainOne.nonAminos.remove(eachInt);
            }
            catch (IndexOutOfBoundsException ex) {
                System.out.println(ex);
            }
        }
        strb.append("END SEQ1 - REMOVED\n\n");
        strb.append("SEQ2 - REMOVED\n");
        for (Integer eachInt : chainB) {
            strb.append(this.chainTwo.sequence.get(eachInt));
            strb.append(this.chainTwo.sequenceRef.get(eachInt));
            strb.append("\n");
            this.chainTwo.sequence.remove(eachInt);
            this.chainTwo.sequenceRef.remove(eachInt);
            this.chainTwo.allAminos.remove(eachInt);
            if (this.aminoAcid) {
                this.chainTwo.aminoAcids.remove(eachInt);
                continue;
            }
            this.chainTwo.nonAminos.remove(eachInt);
        }
        strb.append("END SEQ2 - REMOVED\n\n");
        return strb.toString();
    }

    public void printMatrix() {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < this.matrix[0].length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                strb.append(this.matrix[j][i]);
                strb.append("  ");
            }
            strb.append("\n");
        }
        System.out.print(strb.toString());
    }

    public void printTracebackMatrix() {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < this.tracebackmatrix[0].length; ++i) {
            for (int j = 0; j < this.tracebackmatrix.length; ++j) {
                strb.append(this.tracebackmatrix[j][i]);
                strb.append("  ");
            }
            strb.append("\n");
        }
        System.out.print(strb.toString());
    }
}

