/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Chain;
import java.util.ArrayList;

public class DynamicProgrammingAtoms {
    public ArrayList<String> atomsOne;
    public ArrayList<String> atomsTwo;
    public ArrayList<Integer> atomsOneIndex;
    public ArrayList<Integer> atomsTwoIndex;
    public String fileOne;
    public String fileTwo;
    public int[][] matrix;
    public int[][] tracebackmatrix;
    int gapPenalty = -1;
    Chain chainOneRef;
    Chain chainTwoRef;
    StringBuilder insStrb;
    StringBuilder confStrb;

    public DynamicProgrammingAtoms(ArrayList<String> atomsOne, ArrayList<String> atomsTwo, ArrayList<Integer> atomsOneIndex, ArrayList<Integer> atomsTwoIndex, Chain chainOneRef, Chain chainTwoRef, String fileOne, String fileTwo) {
        this.atomsOne = atomsOne;
        this.atomsTwo = atomsTwo;
        this.atomsOneIndex = atomsOneIndex;
        this.atomsTwoIndex = atomsTwoIndex;
        int toplength = atomsOne.size() + 1;
        int sidelength = atomsTwo.size() + 1;
        this.matrix = new int[toplength][sidelength];
        this.tracebackmatrix = new int[toplength][sidelength];
        this.chainOneRef = chainOneRef;
        this.chainTwoRef = chainTwoRef;
        this.fileOne = fileOne;
        this.fileTwo = fileTwo;
        this.insStrb = new StringBuilder();
        this.confStrb = new StringBuilder();
    }

    public void doDynamicProgramming() {
        for (int row = 1; row < this.matrix[0].length; ++row) {
            int actualRow = row - 1;
            String chainTwoAtom = this.atomsTwo.get(actualRow);
            for (int col = 1; col < this.matrix.length; ++col) {
                int actualCol = col - 1;
                String chainOneAtom = this.atomsOne.get(actualCol);
                int chainJoinScore = chainOneAtom.equals(chainTwoAtom) ? 10 : 0;
                int aboveScore = this.matrix[col][actualRow] - this.gapPenalty;
                int leftScore = this.matrix[actualCol][row] - this.gapPenalty;
                int noGapScore = this.matrix[actualCol][actualRow] + chainJoinScore;
                int topLeftMax = Math.max(aboveScore, leftScore);
                this.tracebackmatrix[col][row] = noGapScore >= aboveScore ? (noGapScore >= leftScore ? 3 : 2) : (aboveScore >= leftScore ? 1 : 2);
                this.matrix[col][row] = Math.max(topLeftMax, noGapScore);
            }
        }
    }

    public ArrayList<ArrayList<Integer>> doTraceback() {
        int i;
        ArrayList<ArrayList<Integer>> eachChain = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> chainA = new ArrayList<Integer>();
        ArrayList<Integer> chainB = new ArrayList<Integer>();
        int startrow = this.tracebackmatrix[0].length - 1;
        int startcol = this.tracebackmatrix.length - 1;
        int bestrow = startrow;
        int bestcol = startcol;
        boolean end = false;
        int row = bestrow;
        int col = bestcol;
        if (bestrow != this.matrix[0].length - 1) {
            for (i = this.matrix[0].length - 2; i > bestrow - 1; --i) {
                chainB.add(new Integer(i));
            }
        } else if (bestcol != this.matrix.length - 1) {
            for (i = this.matrix.length - 2; i > bestcol - 1; --i) {
                chainA.add(new Integer(i));
            }
        }
        while (!end) {
            if (row == 0 || col == 0) {
                end = true;
            }
            if (this.tracebackmatrix[col][row] == 3) {
                --col;
                --row;
                continue;
            }
            if (this.tracebackmatrix[col][row] == 2) {
                chainA.add(new Integer(--col));
                continue;
            }
            if (this.tracebackmatrix[col][row] != 1) continue;
            chainB.add(new Integer(--row));
        }
        if (row != 0) {
            for (i = row - 1; i >= 0; --i) {
                chainB.add(new Integer(i));
            }
        } else if (col != 0) {
            for (i = col - 1; i >= 0; --i) {
                chainA.add(new Integer(i));
            }
        }
        eachChain.add(chainA);
        eachChain.add(chainB);
        return eachChain;
    }

    public ArrayList<Chain> deleteInsertions(ArrayList<ArrayList<Integer>> eachChain, Chain chainOne, Chain chainTwo, int aminoAcidIndex) {
        int d;
        int i;
        ArrayList<Integer> deleteFromAtoms;
        String atomForDeletion;
        int realIndex;
        ArrayList<Integer> chainADel = eachChain.get(0);
        ArrayList<Integer> chainBDel = eachChain.get(1);
        boolean stop = false;
        AminoAcid realAmino = chainOne.allAminos.get(aminoAcidIndex);
        for (Integer eachInt : chainADel) {
            this.insStrb.append(this.fileOne);
            this.insStrb.append("  Chain: ");
            this.insStrb.append(chainOne.chainID);
            this.insStrb.append("  Amino: ");
            this.insStrb.append(this.chainOneRef.allAminos.get(aminoAcidIndex).getAminoAcidID());
            this.insStrb.append(" ");
            this.insStrb.append(this.chainOneRef.allAminos.get(aminoAcidIndex).getAminoAcidName());
            this.insStrb.append("  Atom: ");
            this.insStrb.append(this.atomsOne.get(eachInt));
            this.insStrb.append(" ");
            this.insStrb.append(this.atomsOneIndex.get(eachInt));
            this.insStrb.append(" - INSERTION\n");
            realAmino.getAtomSeq().remove(eachInt);
            realAmino.getPureAtoms().remove(eachInt);
            realIndex = realAmino.getAtomSeqIndex().get(eachInt);
            atomForDeletion = realAmino.getAtoms().get((int)realIndex).atomID;
            deleteFromAtoms = new ArrayList<Integer>();
            while (!stop) {
                if (realAmino.getAtoms().size() > realIndex && realAmino.getAtoms().get((int)realIndex).atomID.equals(atomForDeletion)) {
                    deleteFromAtoms.add(realIndex);
                } else {
                    stop = true;
                }
                ++realIndex;
            }
            stop = false;
            for (i = deleteFromAtoms.size() - 1; i >= 0; --i) {
                realAmino.getAtoms().remove((Integer)deleteFromAtoms.get(i));
                for (d = eachInt + 1; d < realAmino.getAtomSeqIndex().size(); ++d) {
                    realAmino.getAtomSeqIndex().set(d, new Integer(realAmino.getAtomSeqIndex().get(d) - 1));
                }
            }
            realAmino.getAtomSeqIndex().remove(eachInt);
        }
        chainOne.allAminos.set(aminoAcidIndex, realAmino);
        realAmino = chainTwo.allAminos.get(aminoAcidIndex);
        for (Integer eachInt : chainBDel) {
            this.insStrb.append(this.fileTwo);
            this.insStrb.append("  Chain: ");
            this.insStrb.append(chainTwo.chainID);
            this.insStrb.append("  Amino: ");
            this.insStrb.append(this.chainTwoRef.allAminos.get(aminoAcidIndex).getAminoAcidID());
            this.insStrb.append(" ");
            this.insStrb.append(this.chainTwoRef.allAminos.get(aminoAcidIndex).getAminoAcidName());
            this.insStrb.append("  Atom: ");
            this.insStrb.append(this.atomsTwo.get(eachInt));
            this.insStrb.append(" ");
            this.insStrb.append(this.atomsTwoIndex.get(eachInt));
            this.insStrb.append(" - INSERTION\n");
            realAmino.getAtomSeq().remove(eachInt);
            realAmino.getPureAtoms().remove(eachInt);
            realIndex = realAmino.getAtomSeqIndex().get(eachInt);
            atomForDeletion = realAmino.getAtoms().get((int)realIndex).atomID;
            deleteFromAtoms = new ArrayList();
            while (!stop) {
                if (realAmino.getAtoms().size() > realIndex && realAmino.getAtoms().get((int)realIndex).atomID.equals(atomForDeletion)) {
                    deleteFromAtoms.add(realIndex);
                } else {
                    stop = true;
                }
                ++realIndex;
            }
            realAmino.getAtomSeqIndex().remove(eachInt);
            stop = false;
            for (i = deleteFromAtoms.size() - 1; i >= 0; --i) {
                realAmino.getAtoms().remove((Integer)deleteFromAtoms.get(i));
                for (d = eachInt.intValue(); d < realAmino.getAtomSeqIndex().size(); ++d) {
                    realAmino.getAtomSeqIndex().set(d, new Integer(realAmino.getAtomSeqIndex().get(d) - 1));
                }
            }
        }
        chainTwo.allAminos.set(aminoAcidIndex, realAmino);
        ArrayList<Chain> returnedChains = new ArrayList<Chain>();
        returnedChains.add(chainOne);
        returnedChains.add(chainTwo);
        return returnedChains;
    }

    public ArrayList<Chain> deleteConflicts(Chain chainOne, Chain chainTwo, int aminoAcidIndex) {
        ArrayList<String> seq1 = chainOne.allAminos.get(aminoAcidIndex).getAtomSeq();
        ArrayList<String> seq2 = chainTwo.allAminos.get(aminoAcidIndex).getAtomSeq();
        AminoAcid realAminoOne = chainOne.allAminos.get(aminoAcidIndex);
        AminoAcid realAminoTwo = chainTwo.allAminos.get(aminoAcidIndex);
        boolean stop = false;
        StringBuilder strb = new StringBuilder();
        for (int i = seq1.size() - 1; i >= 0; --i) {
            int d;
            int j;
            if (seq1.get(i).equals(seq2.get(i))) continue;
            strb.append(this.fileOne);
            strb.append("/");
            strb.append(this.fileTwo);
            strb.append("  Chains: ");
            strb.append(chainOne.chainID);
            strb.append("/");
            strb.append(chainTwo.chainID);
            strb.append("  Atoms: ");
            strb.append(chainOne.allAminos.get(aminoAcidIndex).getAtomSeqIndex().get(i));
            strb.append("/");
            strb.append(chainTwo.allAminos.get(aminoAcidIndex).getAtomSeqIndex().get(i));
            strb.append(" ");
            strb.append(chainOne.allAminos.get(aminoAcidIndex).getAtomSeq().get(i));
            strb.append("/");
            strb.append(chainTwo.allAminos.get(aminoAcidIndex).getAtomSeq().get(i));
            strb.append(" - CONFLICT\n");
            realAminoOne.getAtomSeq().remove(i);
            realAminoOne.getPureAtoms().remove(i);
            realAminoTwo.getAtomSeq().remove(i);
            realAminoTwo.getPureAtoms().remove(i);
            int realIndexOne = realAminoOne.getAtomSeqIndex().get(i);
            int realIndexTwo = realAminoTwo.getAtomSeqIndex().get(i);
            String atomForDeletionOne = realAminoOne.getAtoms().get((int)realIndexOne).atomID;
            String atomForDeletionTwo = realAminoTwo.getAtoms().get((int)realIndexTwo).atomID;
            ArrayList<Integer> deleteFromAtomsOne = new ArrayList<Integer>();
            ArrayList<Integer> deleteFromAtomsTwo = new ArrayList<Integer>();
            while (!stop) {
                if (realAminoOne.getAtoms().size() > realIndexOne && realAminoOne.getAtoms().get((int)realIndexOne).atomID.equals(atomForDeletionOne)) {
                    deleteFromAtomsOne.add(realIndexOne);
                    ++realIndexOne;
                    continue;
                }
                stop = true;
            }
            stop = false;
            while (!stop) {
                if (realAminoTwo.getAtoms().size() > realIndexTwo && realAminoTwo.getAtoms().get((int)realIndexTwo).atomID.equals(atomForDeletionTwo)) {
                    deleteFromAtomsTwo.add(realIndexTwo);
                    ++realIndexTwo;
                    continue;
                }
                stop = true;
            }
            stop = false;
            realAminoOne.getAtomSeqIndex().remove(i);
            realAminoTwo.getAtomSeqIndex().remove(i);
            for (j = deleteFromAtomsOne.size() - 1; j >= 0; --j) {
                realAminoOne.getAtoms().remove((Integer)deleteFromAtomsOne.get(j));
                for (d = i + 1; d < realAminoOne.getAtomSeqIndex().size(); ++d) {
                    realAminoOne.getAtomSeqIndex().set(d, new Integer(realAminoOne.getAtomSeqIndex().get(d) - 1));
                }
            }
            for (j = deleteFromAtomsTwo.size() - 1; j >= 0; --j) {
                realAminoTwo.getAtoms().remove((Integer)deleteFromAtomsTwo.get(j));
                for (d = i + 1; d < realAminoTwo.getAtomSeqIndex().size(); ++d) {
                    realAminoTwo.getAtomSeqIndex().set(d, new Integer(realAminoTwo.getAtomSeqIndex().get(d) - 1));
                }
            }
            chainOne.allAminos.set(aminoAcidIndex, realAminoOne);
            chainTwo.allAminos.set(aminoAcidIndex, realAminoTwo);
        }
        if (!strb.toString().equals("")) {
            this.confStrb.append(strb.toString());
            this.confStrb.append("\n");
        }
        ArrayList<Chain> returnedChains = new ArrayList<Chain>();
        returnedChains.add(chainOne);
        returnedChains.add(chainTwo);
        return returnedChains;
    }

    public void printMatrix() {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < this.matrix[0].length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                strb.append(this.matrix[j][i]);
                strb.append("  ");
            }
            strb.append("\n");
        }
        System.out.print(strb.toString());
    }

    public void printTracebackMatrix() {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < this.tracebackmatrix[0].length; ++i) {
            for (int j = 0; j < this.tracebackmatrix.length; ++j) {
                strb.append(this.tracebackmatrix[j][i]);
                strb.append("  ");
            }
            strb.append("\n");
        }
        System.out.print(strb.toString());
    }

    public String getActionReport() {
        return this.insStrb.toString() + this.confStrb.toString();
    }
}

