/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import PDBTool.DynamicProgramming;
import PDBTool.DynamicProgrammingAtoms;
import PDBTool.PDBFile;
import PDBTool.PDBReader;
import PDBTool.StructureReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.biojava.nbio.structure.StructureIO;

public class Interface {
    public String aminoInsertionReport = "";
    public String atomReport = "";

    public void runInterface() throws Exception {
        String directory1 = Interface.runInterfaceDirectory("first");
        String filename1 = Interface.runInterfaceFilename("first");
        String directory2 = Interface.runInterfaceDirectory("second");
        String filename2 = Interface.runInterfaceFilename("second");
        String outputfolder = Interface.runInterfaceOutput();
        this.run(directory1, filename1, directory2, filename2, outputfolder);
    }

    public ArrayList<PDBFile> run(String directory1, String pdb1, String directory2, String pdb2, String outputfolder) throws Exception {
        ArrayList<PDBFile> newPDBsA = new ArrayList<PDBFile>();
        ArrayList<PDBFile> newPDBsB = new ArrayList<PDBFile>();
        StringBuilder errorReportStrb = new StringBuilder();
        boolean stop = false;
        PDBReader pdbrA = new PDBReader(pdb1, directory1);
        PDBReader pdbrB = new PDBReader(pdb2, directory2);
        PDBFile pdbfileA = pdb1.endsWith(".cif") ? StructureReader.mmCifToPDB(pdb1) : pdbrA.read(false);
        PDBFile pdbfileB = pdb2.endsWith(".cif") ? StructureReader.mmCifToPDB(pdb2) : pdbrB.read(false);
        System.out.println("aligning files");
        ArrayList<PDBFile> newPDBs = this.alignTwoFiles(pdbfileA, pdbfileB, 1);
        System.out.println("files aligned");
        errorReportStrb.append("MODEL 1 *****************\n");
        errorReportStrb.append(Interface.checkForErrors(newPDBs.get(0), newPDBs.get(1)));
        int model = 1;
        while (!stop) {
            ++model;
            newPDBsA.add(newPDBs.get(0));
            newPDBsB.add(newPDBs.get(1));
            pdbrA = new PDBReader(pdb1, newPDBs.get(0).getPostAtom(), true);
            pdbrB = new PDBReader(pdb2, newPDBs.get(1).getPostAtom(), true);
            pdbfileA = pdbrA.read(false);
            pdbfileB = pdbrB.read(false);
            if (!(pdbfileA.getChains().isEmpty() || pdbfileA.getChains().get((int)0).aminoAcids.isEmpty() || pdbfileB.getChains().isEmpty() || pdbfileB.getChains().get((int)0).aminoAcids.isEmpty())) {
                newPDBs = this.alignTwoFiles(pdbfileA, pdbfileB, model);
                errorReportStrb.append("MODEL ");
                errorReportStrb.append(model);
                errorReportStrb.append(" *****************\n");
                errorReportStrb.append(Interface.checkForErrors(newPDBs.get(0), newPDBs.get(1)));
                continue;
            }
            stop = true;
        }
        if (!((PDBFile)newPDBsA.get(0)).getChains().isEmpty() && !((PDBFile)newPDBsB.get(0)).getChains().isEmpty()) {
            return this.exportToFile((ArrayList)newPDBsA.clone(), (ArrayList)newPDBsB.clone(), outputfolder, errorReportStrb.toString());
        }
        throw new Exception("There was an error reading the files. No acceptable residues are present.");
    }

    public ArrayList<PDBFile> run(String directory1, String pdb1, String directory2, String pdb2, String outputfolder, String chain1, String chain2) throws Exception {
        ArrayList<PDBFile> newPDBsA = new ArrayList<PDBFile>();
        ArrayList<PDBFile> newPDBsB = new ArrayList<PDBFile>();
        StringBuilder errorReportStrb = new StringBuilder();
        boolean stop = false;
        StructureIO.StructureFiletype sft = StructureIO.guessFiletype((String)(directory1 + pdb1));
        PDBReader pdbrA = new PDBReader(pdb1, directory1);
        PDBReader pdbrB = new PDBReader(pdb2, directory2);
        PDBFile pdbfileA = pdbrA.read(chain1, false);
        PDBFile pdbfileB = pdbrB.read(chain2, false);
        ArrayList<PDBFile> newPDBs = this.alignTwoFiles(pdbfileA, pdbfileB, 1);
        errorReportStrb.append("MODEL 1 *****************\n");
        errorReportStrb.append(Interface.checkForErrors(newPDBs.get(0), newPDBs.get(1)));
        int model = 1;
        while (!stop) {
            ++model;
            newPDBsA.add(newPDBs.get(0));
            newPDBsB.add(newPDBs.get(1));
            pdbrA = new PDBReader(pdb1, newPDBs.get(0).getPostAtom(), true);
            pdbrB = new PDBReader(pdb2, newPDBs.get(1).getPostAtom(), true);
            pdbfileA = pdbrA.read(false);
            pdbfileB = pdbrB.read(false);
            if (!(pdbfileA.getChains().isEmpty() || pdbfileA.getChains().get((int)0).aminoAcids.isEmpty() || pdbfileB.getChains().isEmpty() || pdbfileB.getChains().get((int)0).aminoAcids.isEmpty())) {
                newPDBs = this.alignTwoFiles(pdbfileA, pdbfileB, model);
                errorReportStrb.append("MODEL ");
                errorReportStrb.append(model);
                errorReportStrb.append(" *****************\n");
                errorReportStrb.append(Interface.checkForErrors(newPDBs.get(0), newPDBs.get(1)));
                continue;
            }
            stop = true;
        }
        if (!((PDBFile)newPDBsA.get(0)).getChains().isEmpty() && !((PDBFile)newPDBsB.get(0)).getChains().isEmpty()) {
            return this.exportToFile(newPDBsA, newPDBsB, outputfolder, errorReportStrb.toString());
        }
        throw new Exception("There was an error reading the files. No acceptable residues are present.");
    }

    private static String runInterfaceDirectory(String filenumber) throws Exception {
        System.out.println("Please enter the PATH of the " + filenumber + " file you wish to use as input (don't include the file name)");
        Scanner scan = new Scanner(System.in);
        String directory = scan.nextLine();
        if (directory.equals("")) {
            throw new Exception("Please specify a valid file path");
        }
        System.out.println("");
        return directory;
    }

    private static String runInterfaceFilename(String filenumber) throws Exception {
        System.out.println("Please enter the NAME AND EXTENSION of the " + filenumber + " file you wish to use as input (don't include the directory)");
        Scanner scan = new Scanner(System.in);
        String filename = scan.nextLine();
        String[] split = filename.split("\\.");
        if (filename.equals("") || filename.split("\\.").length < 2) {
            throw new Exception("Please specify a valid filename and extension");
        }
        System.out.println("");
        return filename;
    }

    private static String runInterfaceOutput() throws Exception {
        System.out.println("Please enter the PATH to the folder in which you would like the files to be output");
        Scanner scan = new Scanner(System.in);
        String output = scan.nextLine();
        if (output.equals("")) {
            throw new Exception("Please specify a valid destination for the output");
        }
        if (!output.endsWith("/")) {
            output = output + "/";
        }
        System.out.println("");
        return output;
    }

    private ArrayList<PDBFile> alignTwoFiles(PDBFile pdbA, PDBFile pdbB, int model) throws Exception {
        ArrayList<PDBFile> newFiles = new ArrayList<PDBFile>();
        for (int i = 0; i < pdbA.getChains().size() && i < pdbB.getChains().size(); ++i) {
            System.out.println(" - Chain: " + i);
            if (!pdbA.getChains().get((int)i).aminoAcids.isEmpty() && !pdbB.getChains().get((int)i).aminoAcids.isEmpty()) {
                newFiles = this.dynamicProgrammingPair(i, pdbA, pdbB, model, true);
                pdbA = newFiles.get(0);
                pdbB = newFiles.get(1);
                System.out.println("first chain count: " + pdbA.getChains().get(i).countAllAtoms());
                System.out.println("second chain count: " + pdbB.getChains().get(i).countAllAtoms());
                continue;
            }
            if (pdbA.getChains().get((int)i).nonAminos.isEmpty() || pdbB.getChains().get((int)i).nonAminos.isEmpty() || pdbA.getChains().get((int)i).sequence.size() <= 0 || pdbB.getChains().get((int)i).sequence.size() <= 0) continue;
            newFiles = this.dynamicProgrammingPair(i, pdbA, pdbB, model, false);
            pdbA = newFiles.get(0);
            pdbB = newFiles.get(1);
            System.out.println("first chain count: " + pdbA.getChains().get(i).countAllAtoms());
            System.out.println("second chain count: " + pdbB.getChains().get(i).countAllAtoms());
        }
        if (!newFiles.isEmpty()) {
            return newFiles;
        }
        throw new Exception("The files could not be aligned. Please ensure the PDB files entered as input match the standard criteria for this system.");
    }

    private ArrayList<PDBFile> dynamicProgrammingPair(int chainIndex, PDBFile pdb1, PDBFile pdb2, int model, boolean aminoAcids) {
        DynamicProgramming dp = new DynamicProgramming(pdb1.getChains().get(chainIndex), pdb2.getChains().get(chainIndex), pdb1.getFile(), pdb2.getFile(), aminoAcids);
        dp.doDynamicProgramming();
        ArrayList<ArrayList<Integer>> eachChain = dp.doTraceback();
        this.aminoInsertionReport = this.aminoInsertionReport + "MODEL " + model + " ***************************\n\n";
        this.aminoInsertionReport = this.aminoInsertionReport + dp.deleteInsertions(eachChain);
        PDBFile pdb1copy = new PDBFile(pdb1, pdb2.getFile());
        PDBFile pdb2copy = new PDBFile(pdb2, pdb1.getFile());
        pdb1copy.getChains().set(chainIndex, dp.getChainOne());
        pdb2copy.getChains().set(chainIndex, dp.getChainTwo());
        this.atomReport = this.atomReport + "MODEL " + model + " ***************************\n\n";
        this.atomReport = this.atomReport + "REMOVED ATOMS AND REASONS\n\n";
        for (int i = 0; i < pdb1copy.getChains().get((int)chainIndex).allAminos.size(); ++i) {
            ArrayList<String> atomSeq1 = pdb1copy.getChains().get((int)chainIndex).allAminos.get(i).getAtomSeq();
            ArrayList<Integer> atomSeq1Index = pdb1copy.getChains().get((int)chainIndex).allAminos.get(i).getAtomSeqIndex();
            ArrayList<String> atomSeq2 = pdb2copy.getChains().get((int)chainIndex).allAminos.get(i).getAtomSeq();
            ArrayList<Integer> atomSeq2Index = pdb2copy.getChains().get((int)chainIndex).allAminos.get(i).getAtomSeqIndex();
            DynamicProgrammingAtoms dpa = new DynamicProgrammingAtoms(atomSeq1, atomSeq2, atomSeq1Index, atomSeq2Index, pdb1copy.getChains().get(chainIndex), pdb2copy.getChains().get(chainIndex), pdb1copy.getFile(), pdb2copy.getFile());
            dpa.doDynamicProgramming();
            eachChain = dpa.doTraceback();
            ArrayList<Chain> newChains = dpa.deleteInsertions(eachChain, pdb1copy.getChains().get(chainIndex), pdb2copy.getChains().get(chainIndex), i);
            newChains = dpa.deleteConflicts(newChains.get(0), newChains.get(1), i);
            pdb1copy.getChains().set(chainIndex, newChains.get(0));
            pdb2copy.getChains().set(chainIndex, newChains.get(1));
            this.atomReport = this.atomReport + dpa.getActionReport();
        }
        this.atomReport = this.atomReport + "\n";
        ArrayList<PDBFile> newPDBs = new ArrayList<PDBFile>();
        newPDBs.add(pdb1copy);
        newPDBs.add(pdb2copy);
        return newPDBs;
    }

    private static String checkForErrors(PDBFile pdbA, PDBFile pdbB) {
        StringBuilder errorStrb = new StringBuilder();
        for (int i = 0; i < pdbA.getChains().size() && i < pdbB.getChains().size(); ++i) {
            StringBuilder mismatchStrb = new StringBuilder();
            Chain chainA = pdbA.getChains().get(i);
            Chain chainB = pdbB.getChains().get(i);
            if (chainA.aminoAcids.isEmpty() || chainB.aminoAcids.isEmpty()) continue;
            if (chainA.aminoAcids.size() != chainB.aminoAcids.size()) {
                errorStrb.append("Chain lengths differ for chain ");
                errorStrb.append(chainA.chainID);
                errorStrb.append("/");
                errorStrb.append(chainB.chainID);
                errorStrb.append(" in files ");
                errorStrb.append(pdbA.getFile());
                errorStrb.append("/");
                errorStrb.append(pdbB.getFile());
                errorStrb.append("\n");
            }
            for (int aminoIndex = 0; aminoIndex < chainA.aminoAcids.size() && aminoIndex < chainB.aminoAcids.size(); ++aminoIndex) {
                Atom atomA;
                AminoAcid aminoAcidA = chainA.aminoAcids.get(aminoIndex);
                AminoAcid aminoAcidB = chainB.aminoAcids.get(aminoIndex);
                int finalAtomIndex = 0;
                int atomIndex = 0;
                while (atomIndex < aminoAcidA.getPureAtoms().size() && atomIndex < aminoAcidB.getPureAtoms().size()) {
                    atomA = aminoAcidA.getPureAtoms().get(atomIndex);
                    Atom atomB = aminoAcidA.getPureAtoms().get(atomIndex);
                    if (!atomA.atomType.equals(atomB.atomType)) {
                        errorStrb.append("Atom mismatch at amino pair ");
                        errorStrb.append(aminoAcidA.getAminoAcidID());
                        errorStrb.append(":");
                        errorStrb.append(aminoAcidA.getAminoAcidName());
                        errorStrb.append("/");
                        errorStrb.append(aminoAcidB.getAminoAcidID());
                        errorStrb.append(":");
                        errorStrb.append(aminoAcidB.getAminoAcidName());
                        errorStrb.append(" in files ");
                        errorStrb.append(pdbA.getFile());
                        errorStrb.append("/");
                        errorStrb.append(pdbB.getFile());
                        errorStrb.append(" in chain ");
                        errorStrb.append(chainA.chainID);
                        errorStrb.append("/");
                        errorStrb.append(chainB.chainID);
                        errorStrb.append(": ");
                        errorStrb.append(atomA.atomType);
                        errorStrb.append("/");
                        errorStrb.append(atomB.atomType);
                        errorStrb.append("\n");
                    }
                    finalAtomIndex = atomIndex++;
                }
                int finalAtomIndexCopy = ++finalAtomIndex;
                if (finalAtomIndex != aminoAcidA.getPureAtoms().size()) {
                    errorStrb.append("Extra atoms present in file ");
                    errorStrb.append(pdbA.getFile());
                    errorStrb.append(" at amino pair ");
                    errorStrb.append(aminoAcidA.getAminoAcidID());
                    errorStrb.append(":");
                    errorStrb.append(aminoAcidA.getAminoAcidName());
                    errorStrb.append("/");
                    errorStrb.append(aminoAcidB.getAminoAcidID());
                    errorStrb.append(":");
                    errorStrb.append(aminoAcidB.getAminoAcidName());
                    errorStrb.append(" in chain ");
                    errorStrb.append(chainA.chainID);
                    errorStrb.append("/");
                    errorStrb.append(chainB.chainID);
                    errorStrb.append(":");
                    errorStrb.append("\n");
                    while (finalAtomIndex < aminoAcidA.getPureAtoms().size()) {
                        atomA = aminoAcidA.getPureAtoms().get(finalAtomIndex);
                        errorStrb.append("ATOM");
                        errorStrb.append(atomA.atomID);
                        errorStrb.append(":");
                        errorStrb.append(atomA.atomType);
                        errorStrb.append("\n");
                        ++finalAtomIndex;
                    }
                }
                if (finalAtomIndexCopy == aminoAcidB.getPureAtoms().size()) continue;
                errorStrb.append("Extra atoms present in file ");
                errorStrb.append(pdbB.getFile());
                errorStrb.append(" at amino pair ");
                errorStrb.append(aminoAcidA.getAminoAcidID());
                errorStrb.append(":");
                errorStrb.append(aminoAcidA.getAminoAcidName());
                errorStrb.append("/");
                errorStrb.append(aminoAcidB.getAminoAcidID());
                errorStrb.append(":");
                errorStrb.append(aminoAcidB.getAminoAcidName());
                errorStrb.append(" in chain ");
                errorStrb.append(chainA.chainID);
                errorStrb.append("/");
                errorStrb.append(chainB.chainID);
                errorStrb.append(":");
                errorStrb.append("\n");
                while (finalAtomIndexCopy < aminoAcidB.getPureAtoms().size()) {
                    Atom atomB = aminoAcidB.getPureAtoms().get(finalAtomIndexCopy);
                    errorStrb.append("ATOM");
                    errorStrb.append(atomB.atomID);
                    errorStrb.append(":");
                    errorStrb.append(atomB.atomType);
                    errorStrb.append("\n");
                    ++finalAtomIndexCopy;
                }
            }
            int mismatchCount = 0;
            int finalAminoIndex = 0;
            int j = 0;
            while (j < chainA.aminoAcids.size() && j < chainB.aminoAcids.size()) {
                AminoAcid aminoAcidA = chainA.aminoAcids.get(j);
                AminoAcid aminoAcidB = chainB.aminoAcids.get(j);
                if (!aminoAcidA.getAminoAcidName().equals(aminoAcidB.getAminoAcidName())) {
                    mismatchStrb.append(aminoAcidA.getAminoAcidID());
                    mismatchStrb.append(":");
                    mismatchStrb.append(aminoAcidA.getAminoAcidName());
                    mismatchStrb.append("/");
                    mismatchStrb.append(aminoAcidB.getAminoAcidID());
                    mismatchStrb.append(":");
                    mismatchStrb.append(aminoAcidB.getAminoAcidName());
                    mismatchStrb.append("\n");
                    ++mismatchCount;
                }
                finalAminoIndex = j++;
            }
            if (mismatchCount != 0) {
                errorStrb.append("WARNING: Amino Acid Mismatches. Files:");
                errorStrb.append(pdbA.getFile());
                errorStrb.append("/");
                errorStrb.append(pdbB.getFile());
                errorStrb.append(" Chain:");
                errorStrb.append(chainA.chainID);
                errorStrb.append("/");
                errorStrb.append(chainB.chainID);
                errorStrb.append("\n");
                errorStrb.append(mismatchStrb.toString());
            }
            int finalAminoIndexCopy = ++finalAminoIndex;
            if (finalAminoIndex != chainA.aminoAcids.size()) {
                errorStrb.append("Extra aminos present in file ");
                errorStrb.append(pdbA.getFile());
                errorStrb.append(" in chain ");
                errorStrb.append(chainA.chainID);
                errorStrb.append("\n");
                while (finalAminoIndex < chainA.aminoAcids.size()) {
                    AminoAcid aminoAcidA = chainA.aminoAcids.get(finalAminoIndex);
                    errorStrb.append("AMINO");
                    errorStrb.append(aminoAcidA.getAminoAcidID());
                    errorStrb.append(":");
                    errorStrb.append(aminoAcidA.getAminoAcidName());
                    errorStrb.append("\n");
                    ++finalAminoIndex;
                }
            }
            if (finalAminoIndexCopy == chainB.aminoAcids.size()) continue;
            errorStrb.append("Extra aminos present in file ");
            errorStrb.append(pdbB.getFile());
            errorStrb.append(" in chain ");
            errorStrb.append(chainB.chainID);
            errorStrb.append("\n");
            while (finalAminoIndexCopy < chainB.aminoAcids.size()) {
                AminoAcid aminoAcidB = chainB.aminoAcids.get(finalAminoIndexCopy);
                errorStrb.append("AMINO");
                errorStrb.append(aminoAcidB.getAminoAcidID());
                errorStrb.append(":");
                errorStrb.append(aminoAcidB.getAminoAcidName());
                errorStrb.append("\n");
                ++finalAminoIndexCopy;
            }
        }
        if (errorStrb.toString().equals("")) {
            return "ERROR REPORT FOR MATCHED FILES: " + pdbA.getFile() + "/" + pdbB.getFile() + "\n\nNo errors or warnings to report. The files are in one-to-one correspondence with one another.\n\n";
        }
        return "ERROR REPORT FOR MATCHED FILES: " + pdbA.getFile() + "/" + pdbB.getFile() + "\n\n" + errorStrb.toString() + "\n\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<PDBFile> exportToFile(ArrayList<PDBFile> pdbsA, ArrayList<PDBFile> pdbsB, String outputfolder, String errorReport) {
        OutputStreamWriter fstream = null;
        ArrayList<PDBFile> outfiles = new ArrayList<PDBFile>();
        try {
            int atomSize;
            PDBFile pdbcopy;
            int i;
            System.out.println("exporting to output folder...");
            ArrayList<Chain> removeA = new ArrayList<Chain>();
            ArrayList<Chain> removeB = new ArrayList<Chain>();
            for (i = 0; i < pdbsA.size(); ++i) {
                Iterator<PDBFile> pdba = pdbsA.get(i);
                PDBFile pdbb = pdbsB.get(i);
                for (int j = 0; j < Math.max(((PDBFile)((Object)pdba)).getChains().size(), pdbb.getChains().size()); ++j) {
                    int bi;
                    AminoAcid aa;
                    int ai;
                    boolean stop = false;
                    if (j >= ((PDBFile)((Object)pdba)).getChains().size()) {
                        removeB.add(pdbb.getChains().get(j));
                        stop = true;
                    }
                    if (j >= pdbb.getChains().size()) {
                        removeA.add(((PDBFile)((Object)pdba)).getChains().get(j));
                        stop = true;
                    }
                    if (stop) continue;
                    Chain cha = ((PDBFile)((Object)pdba)).getChains().get(j);
                    Chain chb = pdbb.getChains().get(j);
                    if (cha.aminoAcids.size() != chb.aminoAcids.size()) {
                        cha.aminoAcids.clear();
                        chb.aminoAcids.clear();
                        for (ai = cha.allAminos.size() - 1; ai >= 0; --ai) {
                            aa = cha.allAminos.get(ai);
                            if (!aa.isAminoAcid()) continue;
                            cha.allAminos.remove(aa);
                        }
                        for (bi = chb.allAminos.size() - 1; bi >= 0; --bi) {
                            aa = chb.allAminos.get(bi);
                            if (!aa.isAminoAcid()) continue;
                            chb.allAminos.remove(aa);
                        }
                    }
                    if (cha.nonAminos.size() != chb.nonAminos.size()) {
                        cha.nonAminos.clear();
                        chb.nonAminos.clear();
                        for (ai = cha.allAminos.size() - 1; ai >= 0; --ai) {
                            aa = cha.allAminos.get(ai);
                            if (aa.isAminoAcid()) continue;
                            cha.allAminos.remove(aa);
                        }
                        for (bi = chb.allAminos.size() - 1; bi >= 0; --bi) {
                            aa = chb.allAminos.get(bi);
                            if (aa.isAminoAcid()) continue;
                            chb.allAminos.remove(aa);
                        }
                    }
                    if (cha.allAminos.size() == chb.allAminos.size()) continue;
                    removeA.add(cha);
                    removeB.add(chb);
                }
                ((PDBFile)((Object)pdba)).getChains().removeAll(removeA);
                pdbb.getChains().removeAll(removeB);
            }
            for (PDBFile eachPDB : pdbsA) {
                for (Chain eachChain : eachPDB.getChains()) {
                    if (!eachChain.aminoAcids.isEmpty() || !eachChain.nonAminos.isEmpty()) continue;
                    removeA.add(eachChain);
                }
                eachPDB.getChains().removeAll(removeA);
            }
            for (PDBFile eachPDB : pdbsB) {
                for (Chain eachChain : eachPDB.getChains()) {
                    if (!eachChain.aminoAcids.isEmpty() || !eachChain.nonAminos.isEmpty()) continue;
                    removeB.add(eachChain);
                }
                eachPDB.getChains().removeAll(removeB);
            }
            for (i = pdbsA.size() - 2; i >= 0; --i) {
                pdbcopy = pdbsA.get(i);
                if (pdbcopy.getPostAtom().contains("ENDMDL")) {
                    pdbcopy.setPostAtom("ENDMDL\n");
                } else {
                    pdbcopy.setPostAtom("");
                }
                pdbsA.set(i, pdbcopy);
            }
            for (i = pdbsB.size() - 2; i >= 0; --i) {
                pdbcopy = pdbsB.get(i);
                if (pdbcopy.getPostAtom().contains("ENDMDL")) {
                    pdbcopy.setPostAtom("ENDMDL\n");
                } else {
                    pdbcopy.setPostAtom("");
                }
                pdbsB.set(i, pdbcopy);
            }
            StringBuilder strbA = new StringBuilder();
            int maxPDBs = pdbsA.size() > pdbsB.size() ? pdbsA.size() : pdbsB.size();
            int minPDBs = pdbsA.size() < pdbsB.size() ? pdbsA.size() : pdbsB.size();
            int diffPDBs = maxPDBs - minPDBs;
            if (pdbsA.size() > minPDBs) {
                pdbsA.subList(pdbsA.size() - diffPDBs, pdbsA.size()).clear();
            }
            if (pdbsB.size() > minPDBs) {
                pdbsB.subList(pdbsB.size() - diffPDBs, pdbsB.size()).clear();
            }
            for (int p = 0; p < minPDBs; ++p) {
                int maxChains = pdbsA.get(p).getChains().size() > pdbsB.get(p).getChains().size() ? pdbsA.get(p).getChains().size() : pdbsB.get(p).getChains().size();
                int minChains = pdbsA.get(p).getChains().size() < pdbsB.get(p).getChains().size() ? pdbsA.get(p).getChains().size() : pdbsB.get(p).getChains().size();
                int diffChains = maxChains - minChains;
                if (pdbsA.get(p).getChains().size() > minChains) {
                    pdbsA.get(p).getChains().subList(pdbsA.get(p).getChains().size() - diffChains, pdbsA.get(p).getChains().size()).clear();
                }
                if (pdbsB.get(p).getChains().size() <= minChains) continue;
                pdbsB.get(p).getChains().subList(pdbsB.get(p).getChains().size() - diffChains, pdbsB.get(p).getChains().size()).clear();
            }
            for (PDBFile pdb : pdbsA) {
                strbA.append(pdb.toString());
            }
            StringBuilder strbB = new StringBuilder();
            for (PDBFile pdb : pdbsB) {
                strbB.append(pdb.toString());
            }
            ArrayList<String> fileNames = new ArrayList<String>();
            String fileName = pdbsA.get(0).getFile() + "_ALIGNED_" + pdbsA.get(0).getFileAligned() + "." + pdbsA.get(0).getFileextension();
            fstream = new FileWriter(outputfolder + fileName.replaceAll("/", "_"));
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(strbA.toString());
            out.close();
            System.out.println(fileName + " exported");
            fileNames.add(fileName.replaceAll("/", "_"));
            fileName = pdbsB.get(0).getFile() + "_ALIGNED_" + pdbsB.get(0).getFileAligned() + "." + pdbsB.get(0).getFileextension();
            fstream = new FileWriter(outputfolder + fileName.replaceAll("/", "_"));
            out = new BufferedWriter(fstream);
            out.write(strbB.toString());
            out.close();
            System.out.println(fileName + " exported");
            fileNames.add(fileName.replaceAll("/", "_"));
            fileName = pdbsA.get(0).getFile() + "_ALIGNED_" + pdbsA.get(0).getFileAligned() + "_REPORT.txt";
            fstream = new FileWriter(outputfolder + fileName.replaceAll("/", "_"));
            out = new BufferedWriter(fstream);
            out.write("ATOM REPORT FOR " + (String)fileNames.get(0) + " \n");
            for (PDBFile pdb : pdbsA) {
                for (Chain chain : pdb.getChains()) {
                    atomSize = 0;
                    for (AminoAcid amino : chain.allAminos) {
                        atomSize += amino.getAtoms().size();
                    }
                    out.write("Chain " + chain.chainID + ": " + chain.allAminos.size() + " Amino Acids, " + atomSize + " Atoms\n");
                }
            }
            out.write("\nATOM REPORT FOR " + (String)fileNames.get(1) + " \n");
            for (PDBFile pdb : pdbsB) {
                for (Chain chain : pdb.getChains()) {
                    atomSize = 0;
                    for (AminoAcid amino : chain.allAminos) {
                        atomSize += amino.getAtoms().size();
                    }
                    out.write("Chain " + chain.chainID + ": " + chain.allAminos.size() + " Amino Acids, " + atomSize + " Atoms\n");
                }
            }
            out.write("\nSEE END OF THIS FILE FOR ERROR REPORT*******\n\n" + this.aminoInsertionReport + this.atomReport + errorReport);
            out.close();
            System.out.println(fileName + " exported");
            outfiles.addAll(pdbsA);
            outfiles.addAll(pdbsB);
        }
        catch (IOException ex) {
            Logger.getLogger(Interface.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Interface.class.getName()).log(Level.SEVERE, (String)null, ex);
            }
        }
        return outfiles;
    }
}

