/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import PDBTool.ScrewAxArrowResults;
import dyndom3D.DomainPair;
import java.util.ArrayList;
import org.la4j.Vector;

public class PDBFile {
    private String preAtom;
    private ArrayList<Chain> chains;
    private String postAtom;
    private String file;
    private String fileextension;
    private String fileAligned = "NULL";
    private int model;

    public PDBFile(String preAtom, ArrayList<Chain> chains, String postAtom, String file, String fileextension) {
        this.preAtom = preAtom;
        this.chains = chains;
        this.postAtom = postAtom;
        this.file = file;
        this.fileextension = fileextension;
    }

    public PDBFile() {
        this.preAtom = "";
        this.chains = new ArrayList();
        this.postAtom = "";
    }

    public PDBFile(PDBFile pdb, String fileAligned) {
        this.preAtom = pdb.preAtom;
        this.chains = pdb.chains;
        this.postAtom = pdb.postAtom;
        this.file = pdb.file;
        this.fileextension = pdb.fileextension;
        this.fileAligned = fileAligned;
    }

    public PDBFile(String preAtom, ArrayList<Chain> chains, String postAtom, String file, String fileextension, int model) {
        this.preAtom = preAtom;
        this.chains = chains;
        this.postAtom = postAtom;
        this.file = file;
        this.fileextension = fileextension;
        this.model = model;
    }

    public int getModel() {
        return this.model;
    }

    public void setModel(int model) {
        this.model = model;
    }

    public ArrayList<Chain> getChains() {
        return this.chains;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileAligned() {
        return this.fileAligned;
    }

    public String getFileextension() {
        return this.fileextension;
    }

    public String getPostAtom() {
        return this.postAtom;
    }

    public String getPreAtom() {
        return this.preAtom;
    }

    public void setPostAtom(String postAtom) {
        this.postAtom = postAtom;
    }

    public void setChains(ArrayList<Chain> chains) {
        this.chains = chains;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setFileAligned(String fileAligned) {
        this.fileAligned = fileAligned;
    }

    public void setFileextension(String fileextension) {
        this.fileextension = fileextension;
    }

    public void setPreAtom(String preAtom) {
        this.preAtom = preAtom;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.preAtom);
        for (Chain eachChain : this.chains) {
            strb.append(eachChain.toString());
        }
        strb.append(this.postAtom);
        return strb.toString();
    }

    public String toStringAll() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.preAtom);
        for (Chain eachChain : this.chains) {
            strb.append(eachChain.toStringAll());
        }
        strb.append(this.postAtom);
        return strb.toString();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void printr() {
        for (Chain eachChain : this.chains) {
            eachChain.printr();
        }
    }

    public void printrAll() {
        for (Chain eachChain : this.chains) {
            eachChain.printrAll();
        }
    }

    public int countAllAtoms() {
        int total = 0;
        for (Chain eachChain : this.chains) {
            total += eachChain.countAllAtoms();
        }
        return total;
    }

    private Atom buildAtom(Vector arrowcoord, int clusterid) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        strb.append("    ");
        strb.append(String.format("%8.3f", arrowcoord.get(0)));
        strb.append(String.format("%8.3f", arrowcoord.get(1)));
        strb.append(String.format("%8.3f", arrowcoord.get(2)));
        strb.append("     ");
        strb.append(String.format("%6.2f", clusterid));
        String chainStr = "A";
        Atom atom = new Atom("ATOM", "" + i, "CA", " ", "GLY", chainStr, "" + i, strb.toString(), arrowcoord.get(0), arrowcoord.get(1), arrowcoord.get(2));
        atom.setCluster(clusterid);
        return atom;
    }

    public void addScrewAxes(DomainPair tempdom, double ratio) {
        int arrowchainindex = 1;
        ScrewAxArrowResults axis = tempdom.getScrewaxisresults();
        if (axis.getRatio() >= ratio) {
            Chain arrowchain = new Chain("A" + arrowchainindex, new ArrayList<AminoAcid>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<AminoAcid>(), "");
            int i = 0;
            ArrayList<Atom> atomlist = new ArrayList<Atom>();
            for (Vector arrowcoord : axis.getArrowCoordinates()) {
                atomlist.add(this.buildAtom(arrowcoord, tempdom.getFirstDomain().getId()));
            }
            arrowchain.allAminos.add(new AminoAcid("" + i++, "GLY", atomlist, true));
            atomlist = new ArrayList();
            for (Vector headcoord : axis.getHeadCoordinates()) {
                atomlist.add(this.buildAtom(headcoord, tempdom.getSecondDomain().getId()));
            }
            arrowchain.allAminos.add(new AminoAcid("" + i++, "GLY", atomlist, true));
            ++arrowchainindex;
            this.chains.add(arrowchain);
        }
    }

    public void addScrewAxes(ArrayList<DomainPair> tempdomains, double ratio) {
        for (DomainPair tempdom : tempdomains) {
            this.addScrewAxes(tempdom, ratio);
        }
    }
}

