/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Blosum62;
import PDBTool.Chain;
import PDBTool.Nuc44;
import PDBTool.PDBFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PDBReader {
    FileInputStream fstream;
    InputStream in;
    BufferedReader br;
    String directory;
    String file;
    String fileextension;
    ArrayList<String> acceptablePrefix = new ArrayList();

    public PDBReader(String file, String directory) throws Exception {
        this.acceptablePrefix.add("ATOM");
        this.acceptablePrefix.add("ANISOU");
        this.acceptablePrefix.add("SIGATM");
        this.acceptablePrefix.add("SIGUIJ");
        this.acceptablePrefix.add("HETATM");
        if (!directory.equals("") && !directory.endsWith("/")) {
            directory = directory + "/";
        }
        String[] split = file.split("\\.");
        this.directory = directory;
        this.file = split[0];
        this.fileextension = split.length != 1 ? split[1] : "pdb";
        this.fstream = new FileInputStream(directory + file);
        this.in = new DataInputStream(this.fstream);
        this.br = new BufferedReader(new InputStreamReader(this.in));
    }

    public PDBReader(String file, String data, boolean irrelevant) {
        this.acceptablePrefix.add("ATOM");
        this.acceptablePrefix.add("ANISOU");
        this.acceptablePrefix.add("SIGATM");
        this.acceptablePrefix.add("SIGUIJ");
        this.acceptablePrefix.add("HETATM");
        String[] split = file.split("\\.");
        this.file = split[0];
        this.fileextension = split.length != 1 ? split[1] : "pdb";
        this.in = new ByteArrayInputStream(data.getBytes());
        this.br = new BufferedReader(new InputStreamReader(this.in));
    }

    public PDBFile read(boolean headerOnly) throws Exception {
        return this.read("", headerOnly);
    }

    public PDBFile read(String chainlist, boolean headerOnly) throws Exception {
        String line;
        String chainID = "";
        boolean endCheck = false;
        ArrayList<Atom> aminoAcid = new ArrayList<Atom>();
        ArrayList<AminoAcid> chain = new ArrayList<AminoAcid>();
        String previousAmino = null;
        String previousName = null;
        ArrayList<String> sequence = new ArrayList<String>();
        ArrayList<String> sequenceRef = new ArrayList<String>();
        ArrayList<Object> chains = new ArrayList<Object>();
        boolean chainCount = false;
        ArrayList<AminoAcid> nonAminos = new ArrayList<AminoAcid>();
        StringBuilder strbuild = new StringBuilder();
        Blosum62 blosum = new Blosum62();
        int model = 1;
        while ((line = this.br.readLine()) != null && line.length() >= 4 && !line.substring(0, 4).equals("ATOM")) {
            strbuild.append(line);
            strbuild.append("\n");
            if (!line.startsWith("MODEL")) continue;
            try {
                System.out.println(line);
                String mdlstr = line.substring(10, 14);
                model = Integer.parseInt(mdlstr.trim());
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        String preAtom = strbuild.toString();
        if (line == null || headerOnly) {
            return new PDBFile(preAtom, new ArrayList<Chain>(), "", this.file, this.fileextension);
        }
        do {
            AminoAcid aminoAcidObj;
            String prefix;
            if (line.length() < 6) {
                line = line + "      ";
            }
            if ((prefix = line.substring(0, 6).trim()).length() > 3 && !prefix.substring(0, 3).equals("TER")) {
                if (!this.acceptablePrefix.contains(prefix)) {
                    endCheck = true;
                }
                if (!endCheck) {
                    if (prefix.equals("ANISOU")) continue;
                    String atomID = line.substring(6, 11).trim();
                    String atomType = line.substring(11, 16).trim();
                    String otherChar = line.substring(16, 17);
                    String aminoAcidName = line.substring(17, 20).trim();
                    chainID = line.substring(20, 22).trim();
                    String aminoAcidNumber = line.substring(22, 26).trim();
                    String endLine = line.substring(26);
                    try {
                        String string = line.substring(30, 38);
                        String y = line.substring(38, 46);
                        String z = line.substring(46, 54);
                        Atom atom = new Atom(prefix, atomID, atomType, otherChar, aminoAcidName, chainID, aminoAcidNumber, endLine, Double.parseDouble(string), Double.parseDouble(y), Double.parseDouble(z));
                        if (previousAmino == null || line.substring(0, 3).equals("TER")) {
                            previousAmino = aminoAcidNumber;
                            previousName = aminoAcidName;
                            aminoAcid.add(atom);
                            continue;
                        }
                        if (previousAmino.equals(aminoAcidNumber)) {
                            aminoAcid.add(atom);
                            continue;
                        }
                        AminoAcid aminoAcidObj2 = new AminoAcid(previousAmino, previousName, aminoAcid, blosum.hash.containsKey(previousName));
                        if (aminoAcidObj2.getAminoAcidID() == null) {
                            aminoAcidObj2.setAminoAcidID(aminoAcidObj2.getAtoms().get((int)0).aminoAcidNo);
                        }
                        if (aminoAcidObj2.getAminoAcidName() == null) {
                            aminoAcidObj2.setAminoAcidName(aminoAcidObj2.getAtoms().get((int)0).aminoAcidName);
                        }
                        if (blosum.hash.containsKey(previousName)) {
                            sequence.add(previousName);
                            sequenceRef.add(previousAmino);
                            chain.add(aminoAcidObj2);
                        } else if (new Nuc44().hash.containsKey(previousName)) {
                            nonAminos.add(aminoAcidObj2);
                            sequence.add(previousName);
                            sequenceRef.add(previousAmino);
                        }
                        previousAmino = aminoAcidNumber;
                        previousName = aminoAcidName;
                        aminoAcid = new ArrayList();
                        aminoAcid.add(atom);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Atom failed");
                    }
                    continue;
                }
                if (!aminoAcid.isEmpty()) {
                    aminoAcidObj = new AminoAcid(previousAmino, previousName, aminoAcid, blosum.hash.containsKey(previousName));
                    if (aminoAcidObj.getAminoAcidID() == null) {
                        aminoAcidObj.setAminoAcidID(aminoAcidObj.getAtoms().get((int)0).aminoAcidNo);
                    }
                    if (aminoAcidObj.getAminoAcidName() == null) {
                        aminoAcidObj.setAminoAcidName(aminoAcidObj.getAtoms().get((int)0).aminoAcidName);
                    }
                    if (blosum.hash.containsKey(previousName)) {
                        sequence.add(previousName);
                        sequenceRef.add(previousAmino);
                        chain.add(aminoAcidObj);
                    } else if (new Nuc44().hash.containsKey(previousName)) {
                        sequence.add(previousName);
                        sequenceRef.add(previousAmino);
                        nonAminos.add(aminoAcidObj);
                    }
                }
                Chain chainObject = new Chain(chainID, chain, sequence, sequenceRef, nonAminos, line);
                chains.add(chainObject);
                continue;
            }
            if (previousAmino == null) continue;
            aminoAcidObj = new AminoAcid(previousAmino, previousName, aminoAcid, blosum.hash.containsKey(previousName));
            if (aminoAcidObj.getAminoAcidID() == null) {
                aminoAcidObj.setAminoAcidID(aminoAcidObj.getAtoms().get((int)0).aminoAcidNo);
            }
            if (aminoAcidObj.getAminoAcidName() == null) {
                aminoAcidObj.setAminoAcidName(aminoAcidObj.getAtoms().get((int)0).aminoAcidName);
            }
            if (blosum.hash.containsKey(previousName)) {
                sequence.add(previousName);
                sequenceRef.add(previousAmino);
                chain.add(aminoAcidObj);
            } else if (new Nuc44().hash.containsKey(previousName)) {
                sequence.add(previousName);
                sequenceRef.add(previousAmino);
                nonAminos.add(aminoAcidObj);
            }
            String[] chainObject = new Chain(chainID, chain, sequence, sequenceRef, nonAminos, line);
            chains.add(chainObject);
            previousAmino = null;
            previousName = null;
            sequence = new ArrayList();
            sequenceRef = new ArrayList();
            chain = new ArrayList();
            nonAminos = new ArrayList();
            aminoAcid = new ArrayList();
        } while ((line = this.br.readLine() + " ") != null && !endCheck && !line.substring(0, 4).equals("END "));
        strbuild = new StringBuilder();
        strbuild.append(line);
        strbuild.append("\n");
        while ((line = this.br.readLine()) != null) {
            strbuild.append(line);
            strbuild.append("\n");
        }
        ArrayList<Chain> tmpChains = new ArrayList<Chain>();
        if (chainlist.isEmpty()) {
            tmpChains = chains;
        } else {
            String[] wantedChains;
            for (String s : wantedChains = chainlist.split(",")) {
                for (Chain chain2 : chains) {
                    String chainCode = "" + s.charAt(0);
                    boolean isHetAtm = s.length() > 1;
                    boolean isSameChain = chain2.chainID.equals(chainCode) && chain2.HETATMend == isHetAtm;
                    if (!isSameChain) continue;
                    tmpChains.add(chain2);
                }
            }
        }
        String endOfFile = strbuild.toString();
        this.in.close();
        PDBFile pdb = new PDBFile(preAtom, tmpChains, endOfFile, this.file, this.fileextension);
        return pdb;
    }
}

