/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.PointOnScrewAxResults;
import org.la4j.Matrix;
import org.la4j.Vector;

public class PointOnScrewAxFinder {
    private final int n;
    private final Matrix coordinates;
    private final Vector v;
    private final double ampthet;
    private final Vector unitVector;
    private PointOnScrewAxResults results;

    public PointOnScrewAxFinder(int n, Matrix coordinates, Vector v, double ampthet, Vector unitVector) {
        this.n = n;
        this.coordinates = coordinates;
        this.v = v;
        this.ampthet = ampthet;
        this.unitVector = unitVector;
    }

    public PointOnScrewAxResults determineScrewAx() {
        double amptr = this.v.get(0) * this.unitVector.get(0) + this.v.get(1) * this.unitVector.get(1) + this.v.get(2) * this.unitVector.get(2);
        Vector trprk1 = Vector.fromArray((double[])new double[]{amptr * this.unitVector.get(0), amptr * this.unitVector.get(1), amptr * this.unitVector.get(2)});
        Vector rot = this.v.subtract(trprk1);
        double amprot = Math.sqrt(Math.pow(rot.get(0), 2.0) + Math.pow(rot.get(1), 2.0) + Math.pow(rot.get(2), 2.0));
        Vector unitRot = amprot == 0.0 ? Vector.zero((int)3) : rot.divide(amprot);
        Vector axDir = Vector.fromArray((double[])new double[]{unitRot.get(1) * this.unitVector.get(2) - unitRot.get(2) * this.unitVector.get(1), unitRot.get(2) * this.unitVector.get(0) - unitRot.get(0) * this.unitVector.get(2), unitRot.get(0) * this.unitVector.get(1) - unitRot.get(1) * this.unitVector.get(0)});
        double htan = 2.0 * Math.tan(0.5 * this.ampthet);
        Vector rvec = axDir.multiply(amprot).divide(htan);
        Vector axisPoint = this.coordinates.getRow(this.n).add(rot.multiply(0.5)).subtract(rvec);
        this.results = new PointOnScrewAxResults(amptr, axisPoint);
        return this.results;
    }
}

