/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import PDBTool.PDBFile;
import PDBTool.PointOnScrewAxFinder;
import PDBTool.PointOnScrewAxResults;
import PDBTool.ScrewAxArrowResults;
import dyndom3D.Convert;
import dyndom3D.Displacer;
import dyndom3D.DisplacerResults;
import dyndom3D.Domain;
import dyndom3D.Fitter;
import dyndom3D.FitterResults;
import global.GlobalIncludes;
import java.util.ArrayList;
import org.la4j.Matrix;
import org.la4j.Vector;

public class ScrewAxArrowFinder {
    private final Domain firstdomain;
    private final Domain seconddomain;
    private final Matrix allcoordinates_conf1;
    private final Matrix allcoordinates_conf2;
    private final Matrix domain1_conf1;
    private final Matrix domain1_conf2;
    private final Matrix domain2_conf1;
    private final boolean doPlus = false;
    private final Matrix domain2_conf2;
    private final int domain1;
    private final int domain2;

    public ScrewAxArrowFinder(Matrix allcoordinates_conf1, Matrix allcoordinates_conf2, Matrix domain1_conf1, Matrix domain1_conf2, Matrix domain2_conf1, Matrix domain2_conf2, Domain firstdomain, Domain seconddomain) {
        this.allcoordinates_conf1 = allcoordinates_conf1.transpose().copy();
        this.allcoordinates_conf2 = allcoordinates_conf2.transpose().copy();
        this.domain1_conf1 = domain1_conf1.transpose().copy();
        this.domain1_conf2 = domain1_conf2.transpose().copy();
        this.domain2_conf1 = domain2_conf1.transpose().copy();
        this.domain2_conf2 = domain2_conf2.transpose().copy();
        this.firstdomain = firstdomain;
        this.seconddomain = seconddomain;
        this.domain1 = firstdomain.getId();
        this.domain2 = seconddomain.getId();
    }

    public int getDomain1() {
        return this.domain1;
    }

    public int getDomain2() {
        return this.domain2;
    }

    private double findRatio(String pref) {
        double[][] allc1 = Convert.matrToArray(this.allcoordinates_conf1.copy(), false);
        double[][] allc2 = Convert.matrToArray(this.allcoordinates_conf2.copy(), false);
        double[] masses = new double[allc1.length];
        Matrix domain1_conf1_copy = this.domain1_conf1.copy();
        Matrix domain1_conf2_copy = this.domain1_conf2.copy();
        Matrix domain2_conf1_copy = this.domain2_conf1.copy();
        Matrix domain2_conf2_copy = this.domain2_conf2.copy();
        for (int i = 0; i < allc1.length; ++i) {
            masses[i] = i < this.domain1_conf1.rows() ? 1.0 / (double)domain1_conf1_copy.rows() : 1.0 / (double)this.domain2_conf1.rows();
        }
        Fitter fitter = new Fitter();
        FitterResults fitres = fitter.run(Matrix.from2DArray((double[][])allc1), Matrix.from2DArray((double[][])allc2), Vector.fromArray((double[])masses), pref);
        allc2 = Convert.matrToArray(fitres.getFittedCoordinates(), false);
        allc1 = Convert.matrToArray(fitres.getFittedRefCoordinates(), false);
        double[][] d1c1 = new double[domain1_conf1_copy.rows()][3];
        System.arraycopy(allc1, 0, d1c1, 0, domain1_conf1_copy.rows());
        double[][] d1c2 = new double[domain1_conf2_copy.rows()][3];
        System.arraycopy(allc2, 0, d1c2, 0, domain1_conf2_copy.rows());
        double[][] d2c1 = new double[domain2_conf1_copy.rows()][3];
        for (int j = 0; j < domain2_conf1_copy.rows(); ++j) {
            d2c1[j] = allc1[domain1_conf1_copy.rows() + j];
        }
        double[][] d2c2 = new double[domain2_conf2_copy.rows()][3];
        for (int k = 0; k < domain2_conf2_copy.rows(); ++k) {
            d2c2[k] = allc2[domain1_conf2_copy.rows() + k];
        }
        double ndoma = domain1_conf1_copy.rows();
        double ndomb = domain2_conf1_copy.rows();
        DisplacerResults disp1 = Displacer.displacement(d1c1, d1c2, true, pref + "disp1");
        DisplacerResults disp2 = Displacer.displacement(d2c1, d2c2, true, pref + "disp2");
        this.firstdomain.setRmsd(disp1.getRmsd());
        this.seconddomain.setRmsd(disp2.getRmsd());
        double vext = disp1.getExternalDisplacement() / ndoma + disp2.getExternalDisplacement() / ndomb;
        double vint = disp1.getInternalDisplacement() / ndoma + disp2.getInternalDisplacement() / ndomb;
        return Math.sqrt(vext / vint);
    }

    private Chain buildChain(double[][] coordinates, String chainid, int b) {
        Chain chain = new Chain(chainid, new ArrayList<AminoAcid>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<AminoAcid>(), "");
        for (int j = 0; j < coordinates.length; ++j) {
            StringBuilder strb = new StringBuilder();
            int i = 0;
            strb.append("    ");
            double x = coordinates[j][0];
            double y = coordinates[j][1];
            double z = coordinates[j][2];
            strb.append(String.format("%8.3f", x));
            strb.append(String.format("%8.3f", y));
            strb.append(String.format("%8.3f", z));
            strb.append("     ");
            strb.append(String.format("%6.2f", b));
            ArrayList<Atom> atomlist = new ArrayList<Atom>();
            String chainStr = chainid;
            Atom atom = new Atom("ATOM", "" + i, "CA", " ", "GLY", chainStr, "" + i, strb.toString(), x, y, z);
            atom.setCluster(b);
            atomlist.add(atom);
            chain.allAminos.add(new AminoAcid("" + i, "GLY", atomlist, true));
        }
        return chain;
    }

    private void testOutput(double[][] dom1c1, double[][] dom1c2, double[][] dom2c1, double[][] dom2c2, ScrewAxArrowResults results) {
        PDBFile pdb = new PDBFile();
        String filename = "testfile-dom" + this.domain1 + "-dom" + this.domain2 + ".pdb";
        pdb.setFile(filename);
        pdb.getChains().add(this.buildChain(dom1c1, "A", 1));
        pdb.getChains().add(this.buildChain(dom1c2, "B", 2));
        pdb.getChains().add(this.buildChain(dom2c1, "C", 3));
        pdb.getChains().add(this.buildChain(dom2c2, "D", 4));
        StringBuilder sb = new StringBuilder(pdb.toStringAll());
        GlobalIncludes.writeFile(filename, sb);
    }

    public ScrewAxArrowResults determineScrewAx(String pref) {
        Matrix dom1c1copy = this.domain1_conf1.copy();
        Matrix dom1c2copy = this.domain1_conf2.copy();
        Fitter fitter = new Fitter();
        FitterResults fitresults = fitter.run(dom1c1copy, dom1c2copy, pref + "fitfixeddom");
        Vector vxc1 = fitresults.getXc1();
        double[] xc1 = Convert.vecToArray(vxc1);
        double[] xc2 = Convert.vecToArray(fitresults.getXc2());
        dom1c2copy = fitresults.getFittedCoordinates();
        for (int i = 0; i < dom1c2copy.rows(); ++i) {
            dom1c2copy.setRow(i, dom1c2copy.getRow(i).add(vxc1));
        }
        double[][] rotMatrx = fitresults.getRotationMatrix();
        double[][] domain2_conf2_fit = Convert.matrToArray(this.domain2_conf2.copy(), false);
        for (int j = 0; j < domain2_conf2_fit.length; ++j) {
            int i1;
            for (int n = 0; n < 3; ++n) {
                domain2_conf2_fit[j][n] = domain2_conf2_fit[j][n] - xc2[n];
            }
            double x = domain2_conf2_fit[j][0];
            double y = domain2_conf2_fit[j][1];
            double z = domain2_conf2_fit[j][2];
            for (i1 = 0; i1 < 3; ++i1) {
                domain2_conf2_fit[j][i1] = rotMatrx[i1][0] * x + rotMatrx[i1][1] * y + rotMatrx[i1][2] * z;
            }
            for (i1 = 0; i1 < 3; ++i1) {
                domain2_conf2_fit[j][i1] = domain2_conf2_fit[j][i1] + xc1[i1];
            }
        }
        DisplacerResults displacement = Displacer.displacement(Convert.matrToArray(this.domain2_conf1.copy(), false), domain2_conf2_fit, true, pref + "displace");
        Vector v = Vector.fromArray((double[])displacement.getDisplacementVector());
        double theta = displacement.getTheta();
        double ratio = this.findRatio(pref + "findrat");
        Vector unitVector = displacement.getUnitVector();
        int ni = domain2_conf2_fit.length - 1;
        PointOnScrewAxFinder screwaxfinder = new PointOnScrewAxFinder(ni, this.domain2_conf1, v, theta, unitVector);
        PointOnScrewAxResults screwaxresults = screwaxfinder.determineScrewAx();
        Vector axisPoint = screwaxresults.getAxisPoint();
        ArrayList<Vector> tempCoordinates = new ArrayList<Vector>();
        Vector a = axisPoint;
        Vector b = axisPoint.add(unitVector);
        Vector ab = b.subtract(a);
        tempCoordinates.add(a);
        tempCoordinates.add(a.add(unitVector.multiply(20.0)));
        for (int k = 0; k < this.allcoordinates_conf1.rows(); ++k) {
            Vector ap = this.allcoordinates_conf1.getRow(k).subtract(a);
            tempCoordinates.add(a.add(ab.multiply(ab.innerProduct(ap) / ab.innerProduct(ab))));
        }
        double maxDim = Double.MIN_VALUE;
        double minDim = Double.MAX_VALUE;
        Vector maxVec = Vector.zero((int)3);
        Vector minVec = Vector.zero((int)3);
        for (Vector vec : tempCoordinates) {
            Vector divs = Vector.zero((int)3);
            Vector diff = vec.subtract(a);
            for (int n = 0; n < 3; ++n) {
                divs.set(n, diff.get(n) / ab.get(n));
            }
            double sum = divs.sum();
            if (sum < minDim) {
                minDim = sum;
                minVec = vec;
            }
            if (!(sum > maxDim)) continue;
            maxDim = sum;
            maxVec = vec;
        }
        int numsteps = 10;
        Vector dist = maxVec.subtract(minVec).divide((double)numsteps);
        ArrayList<Vector> axisCoordinates = new ArrayList<Vector>();
        for (int m = 0; m < numsteps; ++m) {
            axisCoordinates.add(minVec.add(dist.multiply((double)m)));
        }
        axisCoordinates.add(a);
        axisCoordinates.add(b);
        ArrayList<Vector> headCoordinates = new ArrayList<Vector>();
        headCoordinates.add(maxVec);
        headCoordinates.add(maxVec.add(dist));
        ScrewAxArrowResults results = new ScrewAxArrowResults(axisCoordinates, headCoordinates, axisPoint, b, ab, ratio, theta, screwaxresults.getAmptr());
        return results;
    }
}

