/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import java.util.ArrayList;
import org.la4j.Vector;

public class ScrewAxArrowResults {
    private final ArrayList<Vector> arrowCoordinates;
    private final ArrayList<Vector> headCoordinates;
    private final Vector pointonaxis;
    private final double ratio;
    private final Vector p1;
    private final Vector unitVector;
    private final double theta;
    private final double amptr;

    public ScrewAxArrowResults(ArrayList<Vector> arrowCoordinates, ArrayList<Vector> headCoordinates, Vector pointonaxis, Vector p1, Vector unitVector, double ratio, double theta, double amptr) {
        this.arrowCoordinates = arrowCoordinates;
        this.headCoordinates = headCoordinates;
        this.pointonaxis = pointonaxis;
        this.p1 = p1;
        this.ratio = ratio;
        this.theta = theta;
        this.amptr = amptr;
        this.unitVector = unitVector;
    }

    public ArrayList<Vector> getHeadCoordinates() {
        return this.headCoordinates;
    }

    public Vector getPointonaxis() {
        return this.pointonaxis;
    }

    public double getRatio() {
        return this.ratio;
    }

    public Vector getP1() {
        return this.p1;
    }

    public ArrayList<Vector> getArrowCoordinates() {
        return this.arrowCoordinates;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getAmptr() {
        return this.amptr;
    }

    public Vector getUnitVector() {
        return this.unitVector;
    }

    public double getDistanceToCoMLine(Vector comline, Vector comDomain1) {
        double px = this.unitVector.get(1) * comline.get(2) - this.unitVector.get(2) * comline.get(1);
        double py = this.unitVector.get(2) * comline.get(0) - this.unitVector.get(0) * comline.get(2);
        double pz = this.unitVector.get(0) * comline.get(1) - this.unitVector.get(1) * comline.get(0);
        double p = Math.sqrt(px * px + py * py + pz * pz);
        double dx = this.pointonaxis.get(0) - comDomain1.get(0);
        double dy = this.pointonaxis.get(1) - comDomain1.get(1);
        double dz = this.pointonaxis.get(2) - comDomain1.get(2);
        double dist = dx * (px /= p) + dy * (py /= p) + dz * (pz /= p);
        return Math.abs(dist);
    }

    public double getAngleToCoMLine(Vector comline) {
        double gtw = 0.0;
        for (int i = 0; i < 3; ++i) {
            gtw += comline.get(i) * this.unitVector.get(i);
        }
        double degrees = Math.toDegrees(Math.acos(gtw));
        if (degrees > 90.0) {
            degrees = 180.0 - degrees;
        }
        return degrees;
    }

    public double getDegreeOfClosure(Vector comline) {
        double gtw = 0.0;
        for (int i = 0; i < 3; ++i) {
            gtw += comline.get(i) * this.unitVector.get(i);
        }
        Vector clos = Vector.zero((int)3);
        for (int j = 0; j < 3; ++j) {
            clos.set(j, Math.pow(this.unitVector.get(j) - gtw * comline.get(j), 2.0));
        }
        return clos.sum() * 100.0;
    }
}

