/*
 * Decompiled with CFR 0.152.
 */
package PDBTool;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Blosum62;
import PDBTool.Chain;
import PDBTool.Nuc44;
import PDBTool.PDBFile;
import PDBTool.PDBReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;

public class StructureReader {
    public static void displayCif(String filename) {
        AtomCache cache = new AtomCache();
        cache.setUseMmCif(true);
        StructureIO.setAtomCache((AtomCache)cache);
        try {
            System.out.println("reading mmcif");
            FileInputStream inStream = new FileInputStream(filename);
            SimpleMMcifParser simpleMMcifParser = new SimpleMMcifParser();
            SimpleMMcifConsumer consumer = new SimpleMMcifConsumer();
            simpleMMcifParser.addMMcifConsumer((MMcifConsumer)consumer);
            simpleMMcifParser.parse(new BufferedReader(new InputStreamReader(inStream)));
            System.out.println("getting cif structure");
            Structure cif = consumer.getStructure();
            System.out.println("writing cif structure");
            FileWriter fstream = new FileWriter("test.cif");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(cif.toMMCIF());
            out.close();
            System.out.println("written");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    public static PDBFile mmCifToPDB(String filename) {
        PDBFile pdb = new PDBFile();
        AtomCache cache = new AtomCache();
        cache.setUseMmCif(true);
        StructureIO.setAtomCache((AtomCache)cache);
        String prefix = filename.substring(0, filename.indexOf("."));
        try {
            System.out.println("reading mmcif");
            FileInputStream inStream = new FileInputStream(filename);
            SimpleMMcifParser simpleMMcifParser = new SimpleMMcifParser();
            SimpleMMcifConsumer consumer = new SimpleMMcifConsumer();
            simpleMMcifParser.addMMcifConsumer((MMcifConsumer)consumer);
            simpleMMcifParser.parse(new BufferedReader(new InputStreamReader(inStream)));
            System.out.println("getting cif structure");
            Structure cif = consumer.getStructure();
            System.out.println("converting to pdb");
            PDBReader pdbreader = new PDBReader(filename, cif.toPDB(), true);
            System.out.println("reading pdb");
            pdb = pdbreader.read(true);
            for (org.biojava.nbio.structure.Chain chain : cif.getPolyChains()) {
                ArrayList<AminoAcid> aminoAcids = new ArrayList<AminoAcid>();
                ArrayList<AminoAcid> nonAminoAcids = new ArrayList<AminoAcid>();
                ArrayList<String> sequence = new ArrayList<String>();
                ArrayList<String> sequenceRef = new ArrayList<String>();
                for (Group group : chain.getAtomGroups()) {
                    ArrayList<Atom> atoms = new ArrayList<Atom>();
                    boolean isAminoAcid = group.isAminoAcid() && new Blosum62().hash.containsKey(group.getPDBName());
                    for (org.biojava.nbio.structure.Atom atom : group.getAtoms()) {
                        Atom pdbAtom = new Atom("ATOM", "" + atom.getPDBserial() / 100000, atom.getName(), " ", group.getPDBName(), chain.getId(), group.getResidueNumber().toString(), " ", atom.getX(), atom.getY(), atom.getZ());
                        atoms.add(pdbAtom);
                    }
                    AminoAcid aa = new AminoAcid("" + group.getResidueNumber(), group.getPDBName(), atoms, isAminoAcid);
                    if (isAminoAcid) {
                        aminoAcids.add(aa);
                        sequence.add(group.getPDBName());
                        sequenceRef.add(group.getResidueNumber().toString());
                        continue;
                    }
                    if (!new Nuc44().hash.containsKey(group.getPDBName())) continue;
                    sequence.add(group.getPDBName());
                    nonAminoAcids.add(aa);
                    sequenceRef.add(group.getResidueNumber().toString());
                }
                Chain pdbChain = new Chain(chain.getId(), aminoAcids, sequence, sequenceRef, nonAminoAcids, "TER");
                pdb.getChains().add(pdbChain);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(StructureReader.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        return pdb;
    }
}

