/*
 * Decompiled with CFR 0.152.
 */
package dd3d.rebuilt;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import PDBTool.Interface;
import PDBTool.PDBFile;
import PDBTool.PDBReader;
import PDBTool.ScrewAxArrowFinder;
import dyndom3D.Convert;
import dyndom3D.Domain;
import dyndom3D.DomainBuilder;
import dyndom3D.DomainPair;
import dyndom3D.Engine;
import dyndom3D.Lines;
import dyndom3D.Parameters;
import dyndom3D.RunResults;
import global.GlobalIncludes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.la4j.Matrix;

public class DD3DRebuilt {
    public static void main(String[] args) {
        int blockfactor = 4;
        double gridlength = 2.0;
        double occ = 0.4;
        double hingethres = 0.51;
        String outputpref = "1cts-2cts";
        Parameters params = new Parameters(gridlength, blockfactor, occ, 25, outputpref, "C:\\Users\\Ruth\\Documents\\DynDom6D\\DynDom6D\\DynDom6D\\1cts.pdb", "C:\\Users\\Ruth\\Documents\\DynDom6D\\DynDom6D\\DynDom6D\\2cts.pdb");
        params.setStoppingratio(1.0);
        params.setSaveOutput(true);
        params.setRatiocriteria(Parameters.SavingCriteria.ANYDOMAINPAIRS);
        params.setAtomVoting(false);
        params.setConfidenceThreshold(hingethres);
        params.setFeaturescaling(Parameters.FeatureScaling.PCA);
        try {
            DD3DRebuilt.runSingle(params);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private static void optCase(String startconf, String endconf, String outputdir, String outputpref) {
        for (int blockfactor = 2; blockfactor <= 4; ++blockfactor) {
            for (double occ = 0.2; occ <= 0.9; occ += 0.1) {
                for (double hingethres = 0.2; hingethres <= 1.0; hingethres += 0.1) {
                    for (double gridlength = 3.0; gridlength <= 12.0; gridlength += 0.5) {
                        String filename = outputpref + "occ" + String.format("%.2f", occ) + "-ht" + String.format("%.2f", hingethres) + "-gl" + String.format("%.2f", gridlength) + "-bf" + blockfactor;
                        System.out.println(filename);
                        if (new File(outputdir + "/" + filename + "-session.pml").exists()) {
                            System.out.println("exists");
                            continue;
                        }
                        Parameters params = new Parameters(gridlength, blockfactor, occ, 200, filename, startconf, endconf);
                        params.getFiles().setBulk_outputFolder(outputdir);
                        params.setStoppingratio(1.0);
                        params.setSaveOutput(true);
                        params.setBulkMode(true);
                        params.setRatiocriteria(Parameters.SavingCriteria.ALLDOMAINPAIRS);
                        params.setAtomVoting(false);
                        params.setConfidenceThreshold(hingethres);
                        try {
                            DD3DRebuilt.runSingle(params);
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println(ex);
                            System.out.println(filename);
                        }
                    }
                }
            }
        }
    }

    private static void optCaseLow(String startconf, String endconf, String outputdir, String outputpref) {
        for (double occ = 0.1; occ < 0.2; occ += 0.1) {
            for (double hingethres = 0.1; hingethres < 2.0; hingethres += 0.1) {
                for (double gridlength = 1.0; gridlength <= 12.0; gridlength += 0.5) {
                    for (int blockfactor = 1; blockfactor <= 8; ++blockfactor) {
                        String filename = outputpref + "occ" + String.format("%.2f", occ) + "-ht" + String.format("%.2f", hingethres) + "-gl" + String.format("%.2f", gridlength) + "-bf" + blockfactor;
                        System.out.println(filename);
                        Parameters params = new Parameters(gridlength, blockfactor, occ, 200, filename, startconf, endconf);
                        params.getFiles().setBulk_outputFolder(outputdir);
                        params.setStoppingratio(1.0);
                        params.setSaveOutput(true);
                        params.setBulkMode(true);
                        params.setRatiocriteria(Parameters.SavingCriteria.ALLDOMAINPAIRS);
                        params.setAtomVoting(false);
                        params.setConfidenceThreshold(hingethres);
                        try {
                            DD3DRebuilt.runSingle(params);
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println(ex);
                            System.out.println(filename);
                        }
                    }
                }
            }
        }
    }

    private static double[][] getCoordinates(PDBFile pdb) {
        int n = pdb.countAllAtoms();
        double[][] coordinates = new double[n][3];
        int[] residues = new int[n];
        int[] residueCount = new int[n];
        ArrayList<String> tmpatomIdNumbers = new ArrayList<String>();
        int index = 0;
        int curresind = 0;
        int curres = 0;
        try {
            curres = Integer.parseInt(pdb.getChains().get((int)0).aminoAcids.get(0).getAminoAcidID());
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("err");
        }
        for (int i = 0; i < pdb.getChains().size(); ++i) {
            Chain chain = pdb.getChains().get(i);
            ArrayList<AminoAcid> aalist = chain.aminoAcids.size() > 0 ? chain.aminoAcids : chain.nonAminos;
            for (int j = 0; j < aalist.size(); ++j) {
                AminoAcid residue = aalist.get(j);
                for (int k = 0; k < residue.getAtoms().size(); ++k) {
                    Atom atm = residue.getAtoms().get(k);
                    tmpatomIdNumbers.add(atm.atomID);
                    try {
                        coordinates[index][0] = atm.getX();
                        coordinates[index][1] = atm.getY();
                        coordinates[index][2] = atm.getZ();
                        residues[index] = Integer.parseInt(residue.getAminoAcidID());
                        if (curres != residues[index]) {
                            curres = residues[index];
                        }
                        residueCount[index] = ++curresind;
                    }
                    catch (Exception ex) {
                        System.out.println("index: " + index);
                        System.out.println("ex: " + ex);
                    }
                    ++index;
                }
            }
        }
        return coordinates;
    }

    private static DomainPair buildDomainPair(Domain dom1, Domain dom2) {
        Matrix dom1c1 = dom1.getStartCoordinates().copy();
        Matrix dom1c2 = dom1.getEndCoordinates().copy();
        Matrix dom1c1_saved = dom1c1.copy();
        Matrix dom1c2_saved = dom1c2.copy();
        int d1size = dom1c1.columns();
        int d2size = dom1c2.columns();
        Matrix dom2c1 = dom2.getStartCoordinates().copy();
        Matrix dom2c1_saved = dom2c1.copy();
        Matrix dom2c2 = dom2.getEndCoordinates().copy();
        Matrix dom2c2_saved = dom2c2.copy();
        Matrix comb21c1 = Lines.append(dom1c1, dom2c1, true);
        Matrix comb21c2 = Lines.append(dom1c2, dom2c2, true);
        System.out.println("comb21c1");
        double[][] inds = new double[comb21c1.columns()][1];
        for (int k = 0; k < inds.length; ++k) {
            inds[k][0] = k < dom1.getStartCoordinates().columns() ? 1.0 : 2.0;
        }
        GlobalIncludes.writeCsv("inds", inds);
        System.out.println(dom1.getStartCoordinates().columns());
        System.out.println(dom2.getStartCoordinates().columns());
        System.out.println(comb21c1.columns());
        GlobalIncludes.writeCsv("comb21c1x", Convert.vecToArray(comb21c1.getRow(0)));
        GlobalIncludes.writeCsv("comb21c1y", Convert.vecToArray(comb21c1.getRow(1)));
        GlobalIncludes.writeCsv("comb21c1z", Convert.vecToArray(comb21c1.getRow(2)));
        GlobalIncludes.writeCsv("comb21c2", Convert.matrToArray(comb21c2, true));
        ScrewAxArrowFinder ax = new ScrewAxArrowFinder(comb21c1, comb21c2, dom1c1_saved, dom1c2_saved, dom2c1_saved, dom2c2_saved, dom1, dom2);
        Parameters params = new Parameters();
        params.getFiles().setFromPrefix("ddtest");
        DomainPair dom1_dom2 = new DomainPair(dom1, dom2, ax, params);
        return dom1_dom2;
    }

    public static void runTest() {
        try {
            Scanner scan = new Scanner(new File("nva_domains"));
            DomainBuilder[] domainBuilders = new DomainBuilder[3];
            ArrayList indices = new ArrayList();
            for (int i = 0; i < domainBuilders.length; ++i) {
                domainBuilders[i] = new DomainBuilder(i + 1);
            }
            try {
                PDBReader pdbreaderstart = new PDBReader("nva_start.pdb", "");
                PDBFile startpdb = pdbreaderstart.read(false);
                PDBReader pdbreader = new PDBReader("nva_end.pdb", "");
                PDBFile endpdb = pdbreader.read(false);
                double[][] endcoordinates = DD3DRebuilt.getCoordinates(endpdb);
                double[][] startcoordinates = new double[endcoordinates.length][3];
                int k = 0;
                while (scan.hasNext()) {
                    String line = scan.nextLine();
                    String[] parts = line.split(",");
                    double x = Double.parseDouble(parts[0]);
                    double y = Double.parseDouble(parts[1]);
                    double z = Double.parseDouble(parts[2]);
                    switch (Integer.parseInt(parts[3])) {
                        case 1: {
                            domainBuilders[0].addSet(new double[]{x, y, z}, endcoordinates[k], k);
                            break;
                        }
                        case 2: {
                            domainBuilders[1].addSet(new double[]{x, y, z}, endcoordinates[k], k);
                            break;
                        }
                        case 3: {
                            domainBuilders[2].addSet(new double[]{x, y, z}, endcoordinates[k], k);
                        }
                    }
                    ++k;
                }
                Domain[] domains = new Domain[3];
                for (int j = 0; j < domains.length; ++j) {
                    domains[j] = domainBuilders[j].build();
                }
                System.out.println(domains[2].getStartCoordinates().toString());
                System.out.println("");
                DomainPair dom1_dom2 = DD3DRebuilt.buildDomainPair(domains[0], domains[1]);
                System.out.println("RATIO: " + dom1_dom2.getScrewaxisresults().getRatio());
                startpdb.addScrewAxes(dom1_dom2, 0.0);
                DomainPair dom1_dom3 = DD3DRebuilt.buildDomainPair(domains[0], domains[2]);
                System.out.println("RATIO: " + dom1_dom3.getScrewaxisresults().getRatio());
                startpdb.addScrewAxes(dom1_dom3, 0.0);
                StringBuilder sb = new StringBuilder();
                sb.append(startpdb.toString());
                DD3DRebuilt.writeFile(new File("nvatest_output.pdb"), sb);
            }
            catch (Exception ex) {
                Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    public static ArrayList<ArrayList<Integer>> readHbrs() {
        ArrayList<ArrayList<Integer>> hbrs = new ArrayList<ArrayList<Integer>>();
        try {
            Scanner scan = new Scanner(new File("unique_bending.txt"));
            while (scan.hasNext()) {
                String[] parts;
                ArrayList<Integer> brs = new ArrayList<Integer>();
                for (String part : parts = scan.nextLine().split(",")) {
                    try {
                        brs.add(Integer.parseInt(part));
                    }
                    catch (Exception ex) {
                        for (int j = part.length() - 1; j >= 0; --j) {
                            if (Character.isDigit(part.charAt(j))) continue;
                            part = part.substring(0, j);
                        }
                    }
                }
                hbrs.add(brs);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        return hbrs;
    }

    public static void runBulk(Parameters params) {
        String outdir = "tmp";
        String group1dir = params.getFiles().getBulk_pdbFolder();
        StringBuilder reportbuilder = new StringBuilder();
        StringBuilder tablebuilder = new StringBuilder();
        int index = 0;
        ArrayList<ArrayList<Integer>> dyndomHbrs = DD3DRebuilt.readHbrs();
        tablebuilder.append(params.toString());
        tablebuilder.append("*****************************\n");
        tablebuilder.append("pdbcode1").append(",").append("chain1").append(",").append("pdbcode2").append(",").append("chain2").append(",").append("truepositives").append(",").append("nearmisses").append(",").append("dyndom_bendingresidues").append(",").append("dd3d_bendingresidues").append(",").append("domains").append(",").append("alldomains").append("\n");
        try {
            Scanner scan = new Scanner(new File(params.getFiles().getBulk_pairFile()));
            while (scan.hasNext()) {
                String[] pair = scan.nextLine().split(",");
                if (pair.length == 4) {
                    Interface intf = new Interface();
                    String filename1 = pair[0] + ".pdb";
                    File testFile = new File(group1dir + "\\" + filename1);
                    if (!testFile.exists()) {
                        filename1 = "pdb" + pair[0] + ".ent";
                    }
                    String chain1 = pair[1];
                    String filename2 = pair[2] + ".pdb";
                    testFile = new File(group1dir + "\\" + filename2);
                    if (!testFile.exists()) {
                        filename2 = "pdb" + pair[2] + ".ent";
                    }
                    String chain2 = pair[3];
                    String outfilename = pair[0] + "-" + pair[2];
                    params.getFiles().setFromPrefix(outfilename);
                    try {
                        ArrayList<PDBFile> newPDBs = intf.run(group1dir, filename1, group1dir, filename2, outdir + File.separator, chain1, chain2);
                        if (newPDBs.size() != 2) {
                            System.out.println("Something went wrong with the alignment");
                        } else {
                            Engine dd3d = new Engine(newPDBs.get(0), newPDBs.get(1), params);
                            RunResults results = dd3d.run();
                            Integer[] dd3dhbrs = results.getPdb_indices_hbr();
                            int domains = results.getNumDomains();
                            ArrayList<Integer> ddhbrs = dyndomHbrs.get(index);
                            int hitcount = 0;
                            int nearmisses = 0;
                            block7: for (int i = 0; i < dd3dhbrs.length; ++i) {
                                int thisres = dd3dhbrs[i];
                                if (ddhbrs.contains(thisres)) {
                                    ++hitcount;
                                    continue;
                                }
                                for (Integer res : ddhbrs) {
                                    if (Math.abs(res - thisres) > 5) continue;
                                    ++nearmisses;
                                    continue block7;
                                }
                            }
                            reportbuilder.append(pair[0]).append(" (").append(chain1).append("), ").append(pair[2]).append(" (").append(chain2).append("): ").append(hitcount).append(" true positive, ").append(ddhbrs.size()).append(" hinge residues in dyndom, ").append(dd3dhbrs.length).append(" hinge residues in DD3D.").append("\n");
                            tablebuilder.append(pair[0]).append(",").append(chain1).append(",").append(pair[2]).append(",").append(chain2).append(",").append(hitcount).append(",").append(nearmisses).append(",").append(ddhbrs.size()).append(",").append(dd3dhbrs.length).append(",").append(domains);
                            tablebuilder.append("\n");
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
                    }
                }
                ++index;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        System.out.println(reportbuilder.toString());
        try {
            String bulkoutdir = params.getFiles().getBulk_outputFolder();
            File output = File.createTempFile("bulk-output", ".txt", new File(bulkoutdir));
            DD3DRebuilt.writeFile(output, tablebuilder);
        }
        catch (IOException ex) {
            Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    private static void writeFile(File filename, StringBuilder contents) {
        try {
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(contents.toString());
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    public static RunResults runSingle(Parameters params) {
        RunResults result = new RunResults();
        Interface intf = new Interface();
        String filename1 = params.getFiles().getInfile_start();
        File file1 = new File(filename1);
        String filename2 = params.getFiles().getInfile_end();
        File file2 = new File(filename2);
        try {
            PDBFile second;
            PDBFile first;
            if (params.isSkipalign()) {
                PDBReader readfirst = new PDBReader(file1.getName(), file1.getParent());
                first = readfirst.read(false);
                PDBReader readsecond = new PDBReader(file2.getName(), file2.getParent());
                second = readsecond.read(false);
            } else {
                ArrayList<PDBFile> newPDBs = intf.run(file1.getParent(), file1.getName(), file2.getParent(), file2.getName(), file1.getParent() + File.separator);
                if (newPDBs.size() != 2) {
                    ArrayList<PDBFile> tmp1 = new ArrayList<PDBFile>();
                    ArrayList<PDBFile> tmp2 = new ArrayList<PDBFile>();
                    String firstcode = file1.getName().replace(".pdb", "");
                    for (int i = 0; i < newPDBs.size(); ++i) {
                        PDBFile thisFile = newPDBs.get(i);
                        if (thisFile.getFile().equals(firstcode)) {
                            tmp1.add(thisFile);
                            continue;
                        }
                        tmp2.add(thisFile);
                    }
                    ArrayList<PDBFile> newlist = new ArrayList<PDBFile>();
                    PDBFile combined1 = (PDBFile)tmp1.get(0);
                    for (int j = 1; j < tmp1.size(); ++j) {
                        combined1.getChains().addAll(((PDBFile)tmp1.get(j)).getChains());
                    }
                    PDBFile combined2 = (PDBFile)tmp2.get(0);
                    for (int k = 1; k < tmp2.size(); ++k) {
                        combined2.getChains().addAll(((PDBFile)tmp2.get(k)).getChains());
                    }
                    newlist.add(combined1);
                    newlist.add(combined2);
                    newPDBs = newlist;
                }
                first = newPDBs.get(0);
                second = newPDBs.get(1);
            }
            Engine dd3d = new Engine(first, second, params);
            return dd3d.run();
        }
        catch (Exception ex) {
            result.setSuccessful(false);
            result.setReport_text(ex.getMessage());
            Logger.getLogger(DD3DRebuilt.class.getName()).log(Level.SEVERE, (String)null, ex);
            return result;
        }
    }
}

