/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import PDBTool.ScrewAxArrowFinder;
import dyndom3D.ClusterResults;
import dyndom3D.Convert;
import dyndom3D.Domain;
import dyndom3D.DomainPair;
import dyndom3D.KMeans;
import dyndom3D.KMeansResults;
import dyndom3D.Lines;
import dyndom3D.PCA;
import dyndom3D.Parameters;
import dyndom3D.PrincipalComponentResults;
import dyndom3D.VoteMngr;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.la4j.Matrix;
import org.la4j.Vector;

public class Clusterer {
    private int k;
    private int k_c;
    private boolean all_domain_pairs;
    private int minSize;
    private int[] atomClusterIds;
    private int[] blockClusterIds;
    private Matrix unit_vectors;
    private Matrix others;
    private Matrix rand_points;
    private Matrix rotationVectors;
    private Matrix paired;
    private Matrix total;
    ArrayList<Domain> domains;
    private VoteMngr votemngr;
    private double[] confidence;
    private boolean atomVoting;
    private Parameters params;
    private int numAtoms;
    private ArrayList<DomainPair> lastTempDomains;
    private ArrayList<DomainPair> lastNonDomains;
    private ArrayList<DomainPair> nonDomainPairs;

    public Clusterer(int k, int minSize, VoteMngr votemngr, boolean atomVoting, Parameters params, int numAtoms) {
        this.k = k;
        this.minSize = minSize;
        this.votemngr = votemngr;
        this.atomVoting = atomVoting;
        this.params = params;
        this.numAtoms = numAtoms;
        this.lastTempDomains = new ArrayList();
        this.lastNonDomains = new ArrayList();
    }

    public Clusterer() {
        this.k = 40;
    }

    public int[] readMtlClus() {
        try {
            Scanner scan = new Scanner(new File("matlabout.txt"));
            int numel = scan.nextInt();
            int[] arr = new int[numel];
            int i = 0;
            while (scan.hasNextInt()) {
                arr[i] = scan.nextInt();
                ++i;
            }
            return arr;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Clusterer.class.getName()).log(Level.SEVERE, (String)null, ex);
            return null;
        }
    }

    public ClusterResults cluster(Matrix ArotationVectors, Matrix Aothers, Matrix Arand_points) {
        int numOfIters = 50;
        int numOfLineDims = ArotationVectors.rows();
        int numOfOtherDims = Aothers.rows();
        int numOfDimsTotal = numOfLineDims + numOfOtherDims;
        int numOfBlocks = ArotationVectors.columns();
        this.others = Aothers.copy();
        this.rand_points = Arand_points.copy();
        this.rotationVectors = ArotationVectors.copy();
        this.unit_vectors = Matrix.zero((int)3, (int)this.rotationVectors.columns());
        System.out.println(this.unit_vectors.getColumn(0).norm());
        for (int i = 0; i < this.rotationVectors.columns(); ++i) {
            this.unit_vectors.setColumn(i, this.rotationVectors.getColumn(i).divide(this.rotationVectors.getColumn(i).norm()));
        }
        if (this.params.getFeaturescaling() == Parameters.FeatureScaling.PCA) {
            this.scaleProposed();
        } else if (this.params.getFeaturescaling() == Parameters.FeatureScaling.SIMPLE) {
            this.scale();
        }
        this.k_c = 1;
        Matrix means = Matrix.zero((int)numOfDimsTotal, (int)this.k_c);
        boolean finished = false;
        ClusterResults clusRes = null;
        this.confidence = new double[this.numAtoms];
        while (!finished) {
            double avdist;
            int k_new;
            int k_split;
            KMeansResults results = KMeans.kmeans(means, this.rand_points, this.others, this.unit_vectors, this.k_c, numOfIters);
            Matrix distancesToMean = results.getDistancesToMeans();
            means = results.getMeans();
            this.blockClusterIds = results.getClusterIds();
            if (this.k_c > 1) {
                int[] residues = this.votemngr.getResidues();
                this.atomClusterIds = this.atomVoting ? this.votemngr.holdVotes(this.k_c, this.blockClusterIds) : this.votemngr.holdVotes(this.k_c, this.blockClusterIds, residues);
                this.domains = this.votemngr.getDomains();
                this.confidence = this.votemngr.getAtomConfidence();
                boolean bl = finished = this.k_c > this.params.getMinimumDomains() && (this.k_c > this.k || !this.meetsMinSize());
                if (!finished) {
                    ArrayList<DomainPair> thisTempDomains = this.meetsRatio();
                    if (this.params.getRatiocriteria() == Parameters.SavingCriteria.ANYDOMAINPAIRS && !thisTempDomains.isEmpty() || this.params.getRatiocriteria() == Parameters.SavingCriteria.ALLDOMAINPAIRS && this.all_domain_pairs) {
                        this.lastTempDomains = thisTempDomains;
                        this.lastNonDomains = this.nonDomainPairs;
                        clusRes = new ClusterResults(Arrays.copyOf(this.atomClusterIds, this.atomClusterIds.length), Arrays.copyOf(this.blockClusterIds, this.blockClusterIds.length), this.k_c, this.confidence, this.rand_points, this.others.slice(0, 0, 3, this.others.columns()), this.unit_vectors, this.others.getRow(3));
                    }
                }
            } else {
                this.atomClusterIds = new int[this.numAtoms];
                clusRes = new ClusterResults(Arrays.copyOf(this.atomClusterIds, this.atomClusterIds.length), Arrays.copyOf(this.blockClusterIds, this.blockClusterIds.length), this.k_c, this.confidence, this.rand_points, this.others.slice(0, 0, 3, this.others.columns()), this.unit_vectors, this.others.getRow(3));
            }
            if (finished) continue;
            if (this.k_c == 1) {
                this.k_c = 2;
                k_split = 0;
                k_new = 1;
                double sumdist = 0.0;
                for (int k = 0; k < numOfBlocks; ++k) {
                    sumdist += distancesToMean.get(0, k);
                }
                avdist = sumdist / (double)numOfBlocks;
            } else {
                ++this.k_c;
                Vector sumdists = Vector.zero((int)this.k_c);
                Vector counts = Vector.zero((int)this.k_c);
                double maxstanddev = -1.0;
                int ind = -1;
                for (int k = 0; k < k_new; ++k) {
                    for (int n = 0; n < numOfBlocks; ++n) {
                        if (this.blockClusterIds[n] != k) continue;
                        counts.set(k, counts.get(k) + 1.0);
                        sumdists.set(k, sumdists.get(k) + distancesToMean.get(k, n));
                    }
                    double standdev = Math.sqrt(sumdists.get(k) / (counts.get(k) - 1.0));
                    if (!(standdev > maxstanddev)) continue;
                    maxstanddev = standdev;
                    ind = k;
                }
                k_split = ind;
                avdist = sumdists.get(k_split) / counts.get(k_split);
            }
            for (int m = 0; m < numOfBlocks; ++m) {
                if (this.blockClusterIds[m] != k_split || !(distancesToMean.get(k_split, m) >= avdist)) continue;
                this.blockClusterIds[m] = k_new;
            }
            Matrix newmeans = Matrix.zero((int)numOfDimsTotal, (int)this.k_c);
            for (int j = 0; j < k_new; ++j) {
                newmeans.setColumn(j, means.getColumn(j));
            }
            means = newmeans;
            means = this.updateMean(k_split, means, numOfBlocks, numOfOtherDims);
            means = this.updateMean(k_new, means, numOfBlocks, numOfOtherDims);
        }
        clusRes.setDomains(this.lastTempDomains);
        clusRes.setNondomains(this.lastNonDomains);
        return clusRes;
    }

    private Matrix updateMean(int index, Matrix means, int numOfBlocks, int numOfOtherDims) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        ArrayList<Vector> units = new ArrayList<Vector>();
        ArrayList<Vector> oth = new ArrayList<Vector>();
        for (int m = 0; m < numOfBlocks; ++m) {
            if (this.blockClusterIds[m] != index) continue;
            points.add(this.rand_points.getColumn(m));
            units.add(this.unit_vectors.getColumn(m));
            oth.add(this.others.getColumn(m));
        }
        if (points.size() > 0) {
            means.setColumn(index, Lines.append(Lines.meanOfLines(points, units), Lines.meanOfOthers(numOfOtherDims, oth)));
        }
        return means;
    }

    private Vector scaleFeature(Vector unscaled) {
        double mean = unscaled.sum() / (double)unscaled.length();
        double std = this.std(unscaled);
        Vector results = unscaled.copy();
        results = results.subtract(mean).divide(std);
        return results;
    }

    private double std(Vector unscaled) {
        double mean = unscaled.sum() / (double)unscaled.length();
        Vector subtsq = unscaled.copy();
        for (int i = 0; i < subtsq.length(); ++i) {
            double crnt = subtsq.get(i);
            subtsq.set(i, Math.pow(crnt - mean, 2.0));
        }
        double std = Math.sqrt(subtsq.sum() / (double)subtsq.length());
        return std;
    }

    private void scale() {
        Vector h;
        int i;
        for (i = 0; i < this.others.rows(); ++i) {
            h = this.others.getRow(i);
            this.others.setRow(i, this.scaleFeature(h));
        }
        for (i = 0; i < this.rand_points.rows(); ++i) {
            h = this.rand_points.getRow(i);
            this.rand_points.setRow(i, this.scaleFeature(h));
        }
    }

    private Matrix scaleOld(Matrix toScale) {
        Vector vcx = toScale.getRow(0);
        Vector vcy = toScale.getRow(1);
        Vector vcz = toScale.getRow(2);
        double diffx = vcx.max() - vcx.min();
        double diffy = vcy.max() - vcy.min();
        double diffz = vcz.max() - vcz.min();
        Vector vce = diffx > diffy ? (diffx > diffz ? vcx : vcz) : (diffy > diffz ? vcy : vcz);
        double meanx = vcx.sum() / (double)vcx.length();
        double meany = vcy.sum() / (double)vcy.length();
        double meanz = vcz.sum() / (double)vcz.length();
        double stdv = this.std(vce);
        toScale.setRow(0, toScale.getRow(0).subtract(meanx).divide(stdv));
        toScale.setRow(1, toScale.getRow(1).subtract(meany).divide(stdv));
        toScale.setRow(2, toScale.getRow(2).subtract(meanz).divide(stdv));
        return toScale;
    }

    private Matrix scalePCASingle(Matrix toScale) {
        double[][] arr = Convert.matrToArray(toScale, true);
        PrincipalComponentResults arr_pcares = PCA.principalComponentAnalysis(arr);
        double scale = arr_pcares.getValues()[2];
        toScale = toScale.divide(Math.sqrt(scale));
        for (int i = 0; i < toScale.rows(); ++i) {
            Vector row = toScale.getRow(i);
            toScale.setRow(i, row.subtract(row.sum() / (double)row.length()));
        }
        return toScale;
    }

    private void scaleProposed() {
        Vector h = this.others.getRow(3);
        int hn = h.length();
        Vector hsq = Vector.zero((int)hn);
        for (int i = 0; i < hn; ++i) {
            hsq.set(i, Math.pow(h.get(i), 2.0));
        }
        double hdenom = Math.sqrt(hsq.sum() / (double)hn);
        Vector hscaled = h.divide(hdenom);
        this.others.setRow(3, hscaled);
        Matrix rotationvectors = this.others.slice(0, 0, 3, this.others.columns());
        Vector thetassq = Vector.zero((int)hn);
        for (int j = 0; j < rotationvectors.columns(); ++j) {
            thetassq.set(j, Math.pow(rotationvectors.getColumn(j).norm(), 2.0));
        }
        double thetdenom = Math.sqrt(thetassq.sum() / (double)hn);
        Matrix rotscaled = rotationvectors.divide(thetdenom);
        for (int k = 0; k < 3; ++k) {
            this.others.setRow(k, rotscaled.getRow(k));
        }
        Vector randsq = Vector.zero((int)hn);
        for (int m = 0; m < this.rand_points.columns(); ++m) {
            randsq.set(m, Math.pow(this.rand_points.getColumn(m).norm(), 2.0));
        }
        double rpdenom = Math.sqrt(randsq.sum() / (double)hn);
        this.rand_points = this.rand_points.divide(rpdenom);
    }

    private void scaleNorm(boolean prop) {
        Vector h = this.others.getRow(3);
        Vector hscaled = h.divide(h.max() - h.min());
        this.others.setRow(3, hscaled);
        if (prop) {
            Matrix rotationvectors = this.others.slice(0, 0, 3, this.others.columns());
            rotationvectors = rotationvectors.divide(rotationvectors.max() - rotationvectors.min());
            for (int i = 0; i < 3; ++i) {
                this.others.setRow(i, rotationvectors.getRow(i));
            }
            this.rand_points = this.rand_points.divide(this.rand_points.max() - this.rand_points.min());
        } else {
            int i;
            Matrix rotationvectors = this.others.slice(0, 0, 3, this.others.columns());
            for (i = 0; i < 3; ++i) {
                Vector thisrow = rotationvectors.getRow(i);
                rotationvectors.setRow(i, thisrow.divide(thisrow.max() - thisrow.min()));
                thisrow = this.rand_points.getRow(i);
                this.rand_points.setRow(i, thisrow.divide(thisrow.max() - thisrow.min()));
            }
            for (i = 0; i < 3; ++i) {
                this.others.setRow(i, rotationvectors.getRow(i));
            }
        }
    }

    private void scaleProposedWMeans() {
        Vector h = this.others.getRow(3);
        int hn = h.length();
        Vector hsq = Vector.zero((int)hn);
        for (int i = 0; i < hn; ++i) {
            hsq.set(i, Math.pow(h.get(i), 2.0));
        }
        double hdenom = Math.sqrt(hsq.sum() / (double)hn);
        Vector hscaled = h.subtract(h.sum() / (double)hn).divide(hdenom);
        this.others.setRow(3, hscaled);
        Matrix rotationvectors = this.rotationVectors.copy();
        Vector thetassq = Vector.zero((int)hn);
        for (int j = 0; j < rotationvectors.columns(); ++j) {
            thetassq.set(j, Math.pow(rotationvectors.getColumn(j).norm(), 2.0));
        }
        double thetdenom = Math.sqrt(thetassq.sum() / (double)hn);
        Matrix rotscaled = Matrix.zero((int)rotationvectors.rows(), (int)rotationvectors.columns());
        for (int k = 0; k < rotationvectors.rows(); ++k) {
            Vector thisrow = rotationvectors.getRow(k);
            rotscaled.setRow(k, thisrow.subtract(thisrow.sum() / (double)thisrow.length()).divide(thetdenom));
        }
        this.rotationVectors = rotscaled;
        Vector randsq = Vector.zero((int)hn);
        for (int m = 0; m < this.rand_points.columns(); ++m) {
            randsq.set(m, Math.pow(this.rand_points.getColumn(m).norm(), 2.0));
        }
        Matrix randscaled = Matrix.zero((int)this.rand_points.rows(), (int)this.rand_points.columns());
        double rpdenom = Math.sqrt(randsq.sum() / (double)hn);
        for (int n = 0; n < this.rand_points.rows(); ++n) {
            Vector thisrow = this.rand_points.getRow(n);
            randscaled.setRow(n, thisrow.subtract(thisrow.sum() / (double)thisrow.length()).divide(rpdenom));
        }
        this.rand_points = randscaled;
    }

    private void scalePCA() {
        Vector h = this.others.getRow(3);
        this.others.setRow(3, this.scaleFeature(h));
        this.rand_points = this.scaleOld(this.rand_points);
        Matrix rotationvectors = this.others.slice(0, 0, 3, this.others.columns());
        rotationvectors = this.scaleOld(rotationvectors);
        for (int i = 0; i < 3; ++i) {
            this.others.setRow(i, rotationvectors.getRow(i));
        }
    }

    private boolean meetsMinSize() {
        int k = this.k_c;
        for (int i = 0; i <= k; ++i) {
            int domsize = this.domains.get(i).getSize();
            if (i <= 0 || domsize >= this.minSize) continue;
            return false;
        }
        return true;
    }

    private ArrayList<DomainPair> meetsRatio() {
        int k = this.k_c;
        ArrayList<DomainPair> thisTempDomains = new ArrayList<DomainPair>();
        this.paired = Matrix.zero((int)(k + 1), (int)(k + 1));
        this.total = Matrix.zero((int)(k + 1), (int)(k + 1));
        this.all_domain_pairs = true;
        this.nonDomainPairs = new ArrayList();
        for (int i = 1; i <= k; ++i) {
            Domain dom1 = this.domains.get(i);
            Matrix dom1c1_saved = dom1.getStartCoordinates().copy();
            Matrix dom1c2_saved = dom1.getEndCoordinates().copy();
            for (int j = i + 1; j <= k; ++j) {
                Matrix comb12c2;
                Matrix dom1c1 = dom1c1_saved.copy();
                Matrix dom1c2 = dom1c2_saved.copy();
                Domain dom2 = this.domains.get(j);
                Matrix dom2c1 = dom2.getStartCoordinates().copy();
                Matrix dom2c1_saved = dom2c1.copy();
                Matrix dom2c2 = dom2.getEndCoordinates().copy();
                Matrix dom2c2_saved = dom2c2.copy();
                Matrix comb12c1 = Lines.append(dom1c1, dom2c1, true);
                ScrewAxArrowFinder ax = new ScrewAxArrowFinder(comb12c1, comb12c2 = Lines.append(dom1c2, dom2c2, true), dom1c1_saved, dom1c2_saved, dom2c1_saved, dom2c2_saved, dom1, dom2);
                DomainPair dom1_dom2 = new DomainPair(dom1, dom2, ax, this.params);
                if (dom1_dom2.getScrewaxisresults().getRatio() >= this.params.getStoppingratio()) {
                    thisTempDomains.add(dom1_dom2);
                    continue;
                }
                this.nonDomainPairs.add(dom1_dom2);
                this.all_domain_pairs = false;
            }
        }
        return thisTempDomains;
    }
}

