/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.Convert;
import dyndom3D.DisplacerResults;
import dyndom3D.Fitter;
import dyndom3D.FitterResults;
import global.GlobalIncludes;
import org.la4j.Matrix;
import org.la4j.Vector;

public class Displacer {
    public static double[] quaternions_to_axisdir(double[][] rotationMatrix) {
        double qw = Math.sqrt(1.0 + rotationMatrix[0][0] + rotationMatrix[1][1] + rotationMatrix[2][2]) / 2.0;
        double angle = Math.acos(qw);
        double nx = (rotationMatrix[2][1] - rotationMatrix[1][2]) / 4.0 * qw * Math.sin(angle);
        double ny = (rotationMatrix[0][2] - rotationMatrix[2][0]) / 4.0 * qw * Math.sin(angle);
        double nz = (rotationMatrix[1][0] - rotationMatrix[0][1]) / 4.0 * qw * Math.sin(angle);
        return new double[]{nx, ny, nz, angle};
    }

    public static DisplacerResults displacement(double[][] coordinates1, double[][] coordinates2, boolean plusAv, String pref) {
        double vmsf = 0.0;
        for (int i = 0; i < coordinates1.length; ++i) {
            double vx = coordinates2[i][0] - coordinates1[i][0];
            double vy = coordinates2[i][1] - coordinates1[i][1];
            double vz = coordinates2[i][2] - coordinates1[i][2];
            vmsf += vx * vx + vy * vy + vz * vz;
        }
        double[][] fittedcoords1 = GlobalIncludes.deepClone(coordinates1);
        Fitter fit = new Fitter();
        FitterResults fitresults = fit.run(Matrix.from2DArray((double[][])coordinates2), Matrix.from2DArray((double[][])fittedcoords1), pref);
        fittedcoords1 = Convert.matrToArray(fitresults.getFittedCoordinates(), false);
        double rmsd = fitresults.getRmsd();
        double[] av = Convert.vecToArray(fitresults.getXc1());
        double externalDisplacement = 0.0;
        for (int j = 0; j < coordinates1.length; ++j) {
            double d1 = fittedcoords1[j][0] - coordinates1[j][0];
            double d2 = fittedcoords1[j][1] - coordinates1[j][1];
            double d3 = fittedcoords1[j][2] - coordinates1[j][2];
            if (plusAv) {
                d1 += av[0];
                d2 += av[1];
                d3 += av[2];
            }
            externalDisplacement += d1 * d1 + d2 * d2 + d3 * d3;
        }
        double internalDisplacement = rmsd * rmsd * (double)coordinates1.length;
        int k = coordinates1.length - 1;
        double extx = fittedcoords1[k][0] - coordinates1[k][0];
        double exty = fittedcoords1[k][1] - coordinates1[k][1];
        double extz = fittedcoords1[k][2] - coordinates1[k][2];
        double[] displacementVector = new double[]{extx, exty, extz};
        if (plusAv) {
            displacementVector[0] = displacementVector[0] + av[0];
            displacementVector[1] = displacementVector[1] + av[1];
            displacementVector[2] = displacementVector[2] + av[2];
        }
        Vector unitVector = fitresults.getUnitVector();
        double theta = fitresults.getAngle();
        return new DisplacerResults(internalDisplacement, externalDisplacement, displacementVector, unitVector, theta, vmsf, rmsd);
    }
}

