/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.Colour;
import org.la4j.Matrix;
import org.la4j.Vector;

public class Domain {
    private int id;
    private Matrix startCoordinates;
    private Matrix endCoordinates;
    private int[] indices;
    private Vector mass;
    private double rmsd;
    private static final double CONNECT_DISTANCE = 16.0;

    public Domain() {
    }

    public Domain(int id, Matrix startCoordinates, Matrix endCoordinates, int[] indices) {
        this.id = id;
        this.startCoordinates = startCoordinates;
        this.endCoordinates = endCoordinates;
        this.indices = indices;
        this.mass = Vector.constant((int)this.getSize(), (double)(1.0 / (double)this.getSize()));
    }

    public Vector getCentreOfMass() {
        Vector com = Vector.zero((int)3);
        for (int i = 0; i < 3; ++i) {
            com.set(i, this.startCoordinates.getRow(i).sum() / (double)this.startCoordinates.columns());
        }
        return com;
    }

    public double getRmsd() {
        return this.rmsd;
    }

    public void setRmsd(double rmsd) {
        this.rmsd = rmsd;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStartCoordinates(Matrix startCoordinates) {
        this.startCoordinates = startCoordinates;
    }

    public void setEndCoordinates(Matrix endCoordinates) {
        this.endCoordinates = endCoordinates;
    }

    public void setIndices(int[] indices) {
        this.indices = indices;
    }

    public Matrix getStartCoordinates() {
        return this.startCoordinates;
    }

    public Matrix getEndCoordinates() {
        return this.endCoordinates;
    }

    public final int getSize() {
        return this.startCoordinates.columns();
    }

    public Vector getMass() {
        return this.mass;
    }

    public static Colour colourForID(int ID) {
        switch (ID) {
            case 1: {
                return new Colour(new int[]{0, 0, 255}, "blue");
            }
            case 2: {
                return new Colour(new int[]{255, 0, 0}, "red");
            }
            case 3: {
                return new Colour(new int[]{255, 255, 0}, "yellow");
            }
            case 4: {
                return new Colour(new int[]{238, 130, 238}, "violet");
            }
            case 5: {
                return new Colour(new int[]{0, 255, 255}, "cyan");
            }
            case 6: {
                return new Colour(new int[]{0, 0, 0}, "black");
            }
            case 7: {
                return new Colour(new int[]{255, 0, 255}, "magenta");
            }
            case 8: {
                return new Colour(new int[]{160, 32, 240}, "purple");
            }
            case 9: {
                return new Colour(new int[]{79, 148, 205}, "steel_blue");
            }
            case 10: {
                return new Colour(new int[]{255, 69, 0}, "orange_red");
            }
            case 11: {
                return new Colour(new int[]{255, 165, 0}, "orange");
            }
            case 12: {
                return new Colour(new int[]{50, 205, 50}, "lime_green");
            }
            case 13: {
                return new Colour(new int[]{255, 192, 203}, "pink");
            }
            case 14: {
                return new Colour(new int[]{255, 127, 80}, "coral");
            }
            case 15: {
                return new Colour(new int[]{87, 87, 87}, "dark_grey");
            }
            case 16: {
                return new Colour(new int[]{139, 69, 19}, "saddle_brown");
            }
            case 17: {
                return new Colour(new int[]{238, 18, 137}, "deep_pink");
            }
            case 18: {
                return new Colour(new int[]{238, 216, 174}, "wheat");
            }
            case 19: {
                return new Colour(new int[]{255, 228, 196}, "bisque");
            }
            case 20: {
                return new Colour(new int[]{245, 255, 250}, "mint_cream");
            }
            case 21: {
                return new Colour(new int[]{230, 230, 250}, "lavender");
            }
            case 22: {
                return new Colour(new int[]{85, 107, 47}, "dark_olive_green");
            }
            case 23: {
                return new Colour(new int[]{100, 149, 237}, "cornflower_blue");
            }
            case 24: {
                return new Colour(new int[]{187, 255, 255}, "pale_turquoise");
            }
            case 25: {
                return new Colour(new int[]{255, 182, 193}, "light_pink");
            }
            case 26: {
                return new Colour(new int[]{72, 209, 204}, "medium_turquoise");
            }
        }
        return new Colour(new int[]{122, 122, 122}, "unassigned");
    }

    public Colour getColour() {
        return Domain.colourForID(this.id);
    }

    public int[] getIndices() {
        return this.indices;
    }
}

