/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.Domain;
import java.util.ArrayList;
import org.la4j.Matrix;
import org.la4j.Vector;

public class DomainBuilder {
    private final ArrayList<Vector> startCoordinates;
    private final ArrayList<Vector> endCoordinates;
    private final ArrayList<Integer> indexList;
    private int id;

    public DomainBuilder() {
        this.startCoordinates = new ArrayList();
        this.endCoordinates = new ArrayList();
        this.indexList = new ArrayList();
    }

    public DomainBuilder(int id) {
        this.id = id;
        this.startCoordinates = new ArrayList();
        this.endCoordinates = new ArrayList();
        this.indexList = new ArrayList();
    }

    private Matrix getCoordinates(ArrayList<Vector> vectorlist) {
        Matrix coords = Matrix.zero((int)3, (int)vectorlist.size());
        for (int i = 0; i < vectorlist.size(); ++i) {
            coords.setColumn(i, vectorlist.get(i));
        }
        return coords;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void addSet(double[] coordsStart, double[] coordsEnd, int index) {
        this.startCoordinates.add(Vector.fromArray((double[])coordsStart));
        this.endCoordinates.add(Vector.fromArray((double[])coordsEnd));
        this.indexList.add(index);
    }

    public Domain build() {
        int[] indArray = new int[this.indexList.size()];
        for (int i = 0; i < this.indexList.size(); ++i) {
            indArray[i] = this.indexList.get(i);
        }
        return new Domain(this.id, this.getCoordinates(this.startCoordinates), this.getCoordinates(this.endCoordinates), indArray);
    }
}

