/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import PDBTool.ScrewAxArrowFinder;
import PDBTool.ScrewAxArrowResults;
import dyndom3D.Colour;
import dyndom3D.Domain;
import dyndom3D.Parameters;

public class DomainPair {
    private final Domain firstDomain;
    private final Domain secondDomain;
    private final ScrewAxArrowFinder screwaxis;
    private ScrewAxArrowResults screwaxisresults;
    private final String arrowfilename;

    public DomainPair(Domain domain1, Domain domain2, ScrewAxArrowFinder screwaxis, Parameters params) {
        this.firstDomain = domain1;
        this.secondDomain = domain2;
        this.screwaxis = screwaxis;
        Colour colDom1 = domain1.getColour();
        Colour colDom2 = domain2.getColour();
        String outdir = params.getFiles().getBulk_outputFolder();
        outdir = outdir == null ? "" : outdir + "//";
        this.arrowfilename = outdir + params.getFiles().getOutfile_prefix() + "arrow_" + colDom1.getName() + "-" + colDom2.getName() + ".pdb";
    }

    public String getArrowfilename() {
        return this.arrowfilename;
    }

    public ScrewAxArrowResults getScrewaxisresults() {
        if (this.screwaxisresults == null) {
            this.screwaxisresults = this.screwaxis.determineScrewAx("dom" + this.firstDomain.getId() + "dom" + this.secondDomain.getId());
        }
        return this.screwaxisresults;
    }

    public void calcScrewAxis() {
        this.screwaxisresults = this.screwaxis.determineScrewAx("dom" + this.firstDomain.getId() + "dom" + this.secondDomain.getId());
    }

    public void setScrewaxisresults(ScrewAxArrowResults screwaxisresults) {
        this.screwaxisresults = screwaxisresults;
    }

    public Domain getFirstDomain() {
        return this.firstDomain;
    }

    public Domain getSecondDomain() {
        return this.secondDomain;
    }
}

