/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import PDBTool.PDBFile;
import PDBTool.PointOnScrewAxFinder;
import PDBTool.PointOnScrewAxResults;
import PDBTool.ScrewAxArrowResults;
import dyndom3D.Block;
import dyndom3D.Cell;
import dyndom3D.ClusterResults;
import dyndom3D.Clusterer;
import dyndom3D.Colour;
import dyndom3D.Domain;
import dyndom3D.DomainPair;
import dyndom3D.FileMngr;
import dyndom3D.JQuatFit;
import dyndom3D.PCA;
import dyndom3D.Parameters;
import dyndom3D.Results;
import dyndom3D.RunResults;
import dyndom3D.VoteMngr;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.la4j.Matrix;
import org.la4j.Vector;

public class Engine {
    private PDBFile firstPDB;
    private PDBFile secondPDB;
    private Parameters params;
    private Results results;
    private double[] minCoordinates;
    private double[] maxCoordinates;
    private double[][] allCoordinates_start;
    private double[][] allCoordinates_end;
    private double[][] prinAxCoordinates;
    private int[] residues;
    private int[] residueCount;
    Matrix others;
    Matrix rand_points;
    Matrix unit_vectors;
    Matrix rotationVectors;
    Matrix extvecs;
    ArrayList<Double> angles;
    ArrayList<Vector> lines;
    ArrayList<Domain> domains;
    ArrayList<Block> blocks;
    private ArrayList<String> tmpatomIdNumbers;
    private String line_equals = "=========================================================================\n";
    private String line_hyphen = "-------------------------------------------------------------------------\n";

    public Engine(PDBFile firstPDB, PDBFile secondPDB, Parameters params) {
        this.firstPDB = firstPDB;
        this.secondPDB = secondPDB;
        this.params = params;
        this.results = null;
    }

    public RunResults run() {
        String reportText;
        int j;
        this.populateCoordinates();
        this.blocks = this.getBlocks();
        this.getRotationVectors(this.blocks);
        boolean[][] connections = null;
        int numOfLines = this.rotationVectors.columns();
        int numOfLineDims = this.minCoordinates.length;
        int numOfOtherDims = 4;
        this.others = Matrix.zero((int)numOfOtherDims, (int)numOfLines);
        this.lines = new ArrayList();
        this.rand_points = Matrix.zero((int)numOfLineDims, (int)numOfLines);
        for (int i = 0; i < numOfLines; ++i) {
            ArrayList<Integer> indices = this.blocks.get(i).getAtmList();
            if (indices.size() <= 0) continue;
            int n = indices.get(indices.size() - 1);
            PointOnScrewAxFinder ax = new PointOnScrewAxFinder(n, Matrix.from2DArray((double[][])this.prinAxCoordinates), this.extvecs.getColumn(i), this.angles.get(i), this.unit_vectors.getColumn(i));
            PointOnScrewAxResults screwaxresults = ax.determineScrewAx();
            this.rand_points.setColumn(i, screwaxresults.getAxisPoint());
            this.lines.add(this.rotationVectors.getColumn(i));
            for (int m = 0; m < 3; ++m) {
                this.others.set(m, i, this.rotationVectors.get(m, i));
            }
            this.others.set(3, i, screwaxresults.getAmptr());
        }
        VoteMngr vm = new VoteMngr(this.prinAxCoordinates, this.allCoordinates_end, this.residueCount, this.blocks, this.params);
        JQuatFit fitter = new JQuatFit(this.prinAxCoordinates);
        fitter.quatfit(this.allCoordinates_end);
        int k = 40;
        Clusterer clst = new Clusterer(k, this.params.getMinSize(), vm, this.params.isAtomVoting(), this.params, this.prinAxCoordinates.length);
        ClusterResults cls_res = clst.cluster(this.rotationVectors, this.others, this.rand_points);
        int[] atomClusterIds = cls_res.getAtomClusterIds();
        int[] blockClusterIds = cls_res.getBlockClusterIds();
        HashSet<Integer> hi = new HashSet<Integer>();
        int hingeCluster = cls_res.getNumClusters() + 1;
        int lastClustID = -1;
        for (j = 0; j < atomClusterIds.length; ++j) {
            int thisClustID = atomClusterIds[j];
            if (lastClustID != -1 && thisClustID != hingeCluster && lastClustID != hingeCluster && thisClustID != lastClustID && lastClustID != 0 && thisClustID != 0) {
                int res = this.residueCount[j];
                int resPrev = this.residueCount[j - 1];
                for (int m = 0; m < this.residueCount.length; ++m) {
                    if (this.residueCount[m] != res && this.residueCount[m] != resPrev) continue;
                    atomClusterIds[m] = hingeCluster;
                }
            }
            lastClustID = thisClustID;
        }
        for (j = 0; j < atomClusterIds.length; ++j) {
            if (atomClusterIds[j] != hingeCluster) continue;
            hi.add(this.residueCount[j]);
        }
        Integer[] hingeindices = new Integer[]{};
        hingeindices = (Integer[])hi.toArray((Object[])hingeindices);
        Arrays.sort((Object[])hingeindices);
        if (this.params.getSaveOutput()) {
            this.rand_points = cls_res.getScaledRandPoints();
            this.rotationVectors = cls_res.getScaledRotationVectors();
            this.unit_vectors = cls_res.getScaledUnitVectors();
            this.writeOutputPdbs(atomClusterIds, blockClusterIds, cls_res.getNumClusters() + 1, cls_res.getConfidence(), cls_res.getScaledH(), cls_res.getDomains());
            reportText = this.writeReport(cls_res);
        } else {
            reportText = "Outputs were not saved";
        }
        return new RunResults(this.params.getFiles().getOutfile_end(), atomClusterIds, cls_res.getNumClusters(), hingeindices, reportText, true);
    }

    private Cell[][][] buildGrid() {
        int gridCellsX = (int)Math.ceil((this.maxCoordinates[0] - this.minCoordinates[0]) / this.params.getGridSize());
        int gridCellsY = (int)Math.ceil((this.maxCoordinates[1] - this.minCoordinates[1]) / this.params.getGridSize());
        int gridCellsZ = (int)Math.ceil((this.maxCoordinates[2] - this.minCoordinates[2]) / this.params.getGridSize());
        Cell[][][] grid = new Cell[gridCellsX][gridCellsY][gridCellsZ];
        for (int x = 0; x < gridCellsX; ++x) {
            for (int y = 0; y < gridCellsY; ++y) {
                for (int z = 0; z < gridCellsZ; ++z) {
                    grid[x][y][z] = new Cell();
                }
            }
        }
        int[] pos = new int[3];
        for (int i = 0; i < this.prinAxCoordinates.length; ++i) {
            for (int j = 0; j < this.minCoordinates.length; ++j) {
                pos[j] = (int)Math.floor((this.prinAxCoordinates[i][j] - this.minCoordinates[j]) / this.params.getGridSize());
            }
            grid[pos[0]][pos[1]][pos[2]].addAtm(i);
        }
        return grid;
    }

    private ArrayList<Block> getBlocks() {
        Date wholenow = new Date();
        Date now = new Date();
        this.orientAlongPrincipalAxis();
        now = new Date();
        this.centreOfMass();
        now = new Date();
        this.results = new Results();
        Cell[][][] grid = this.buildGrid();
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        now = new Date();
        int maxOcc = 0;
        ArrayList<int[]> blockNums = new ArrayList<int[]>();
        for (int i = 0; i < this.params.getBlockFactor(); ++i) {
            for (int j = 0; j < this.params.getBlockFactor(); ++j) {
                int k = 0;
                while (k < this.params.getBlockFactor()) {
                    blockNums.add(new int[]{i, j, k++});
                }
            }
        }
        for (int x = 0; x < grid.length - this.params.getBlockFactor() - 1; ++x) {
            for (int y = 0; y < grid[x].length - this.params.getBlockFactor() - 1; ++y) {
                for (int z = 0; z < grid[x][y].length - this.params.getBlockFactor() - 1; ++z) {
                    Block thisBlock = new Block();
                    for (int j = 0; j < blockNums.size(); ++j) {
                        int[] toAdd = (int[])blockNums.get(j);
                        Cell c1 = grid[x + toAdd[0]][y + toAdd[1]][z + toAdd[2]];
                        thisBlock.addAll(c1);
                    }
                    if (thisBlock.getSize() > maxOcc) {
                        maxOcc = thisBlock.getSize();
                    }
                    allBlocks.add(thisBlock);
                }
            }
        }
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        for (Block block : allBlocks) {
            if (!((double)block.getSize() >= this.params.getOccupancy() * (double)maxOcc)) continue;
            validBlocks.add(block);
        }
        return validBlocks;
    }

    private void getRotationVectors(ArrayList<Block> blocks) {
        Matrix rotVecs = Matrix.zero((int)3, (int)blocks.size());
        Matrix rotUniVecs = Matrix.zero((int)3, (int)blocks.size());
        this.extvecs = Matrix.zero((int)3, (int)blocks.size());
        ArrayList<Double> rotAngs = new ArrayList<Double>();
        JQuatFit wholeFitter = new JQuatFit(this.prinAxCoordinates);
        int[][] allPairs = new int[2][this.prinAxCoordinates.length];
        for (int i = 0; i < this.prinAxCoordinates.length; ++i) {
            allPairs[0][i] = i;
            allPairs[1][i] = i;
        }
        wholeFitter.quatfit(this.allCoordinates_end, allPairs);
        int k = 0;
        Vector thetas = Vector.zero((int)blocks.size());
        for (Block b : blocks) {
            ArrayList<Integer> atmNos = b.getAtmList();
            if (atmNos.size() > 0) {
                double[][] startCoords = new double[atmNos.size()][3];
                double[][] endCoords = new double[atmNos.size()][3];
                double[][] savedCoords = new double[atmNos.size()][3];
                int[][] pairs = new int[2][atmNos.size()];
                for (int j = 0; j < atmNos.size(); ++j) {
                    pairs[0][j] = j;
                    pairs[1][j] = j;
                    for (int m = 0; m < 3; ++m) {
                        startCoords[j][m] = this.prinAxCoordinates[atmNos.get(j)][m];
                        endCoords[j][m] = this.allCoordinates_end[atmNos.get(j)][m];
                        savedCoords[j][m] = this.allCoordinates_end[atmNos.get(j)][m];
                    }
                }
                JQuatFit fitter = new JQuatFit(startCoords);
                fitter.quatfit(endCoords, pairs);
                int n = atmNos.size() - 1;
                Vector vext = Matrix.from2DArray((double[][])savedCoords).getRow(n).subtract(Matrix.from2DArray((double[][])endCoords).getRow(n));
                double[] q = fitter.getQuaternions();
                double theta = 2.0 * Math.acos(q[0]);
                double[] univ = new double[]{q[1] / Math.sin(theta / 2.0), q[2] / Math.sin(theta / 2.0), q[3] / Math.sin(theta / 2.0)};
                if (theta > Math.PI) {
                    theta = Math.PI * 2 - theta;
                    univ[0] = -(q[1] / Math.sin(theta / 2.0));
                    univ[1] = -(q[2] / Math.sin(theta / 2.0));
                    univ[2] = -(q[3] / Math.sin(theta / 2.0));
                }
                Vector unitVector = Vector.fromArray((double[])univ);
                rotUniVecs.setColumn(k, unitVector);
                Vector fullRotVec = unitVector.multiply(theta);
                this.extvecs.setColumn(k, vext);
                rotVecs.setColumn(k, fullRotVec);
                rotAngs.add(theta);
                thetas.set(k, theta);
                ++k;
            } else {
                rotAngs.add(0.0);
            }
            this.rotationVectors = rotVecs;
            this.unit_vectors = rotUniVecs;
            this.angles = rotAngs;
        }
    }

    private void centreOfMass() {
        int j;
        int i;
        double[] centre = new double[3];
        this.maxCoordinates = new double[3];
        this.minCoordinates = new double[3];
        double[] coshift = new double[3];
        double[][] newCoordinates = new double[this.prinAxCoordinates.length][3];
        for (i = 0; i < this.prinAxCoordinates.length; ++i) {
            for (j = 0; j < 3; ++j) {
                if (this.minCoordinates[j] > this.prinAxCoordinates[i][j]) {
                    this.minCoordinates[j] = this.prinAxCoordinates[i][j];
                }
                if (!(this.maxCoordinates[j] < this.prinAxCoordinates[i][j])) continue;
                this.maxCoordinates[j] = this.prinAxCoordinates[i][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            if (!(this.minCoordinates[i] < 0.0)) continue;
            coshift[i] = Math.abs(this.minCoordinates[i]);
            this.minCoordinates[i] = 999.0;
            this.maxCoordinates[i] = 0.0;
        }
        for (i = 0; i < this.prinAxCoordinates.length; ++i) {
            for (j = 0; j < 3; ++j) {
                newCoordinates[i][j] = this.prinAxCoordinates[i][j] + coshift[j];
                centre[j] = centre[j] + newCoordinates[i][j];
                if (this.minCoordinates[j] > newCoordinates[i][j]) {
                    this.minCoordinates[j] = newCoordinates[i][j];
                }
                if (!(this.maxCoordinates[j] < newCoordinates[i][j])) continue;
                this.maxCoordinates[j] = newCoordinates[i][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            centre[i] = centre[i] / (double)this.prinAxCoordinates.length;
        }
        this.prinAxCoordinates = newCoordinates;
    }

    private void populateCoordinates() {
        this.allCoordinates_start = new double[this.firstPDB.countAllAtoms()][3];
        this.allCoordinates_end = new double[this.secondPDB.countAllAtoms()][3];
        this.residues = new int[this.firstPDB.countAllAtoms()];
        this.residueCount = new int[this.firstPDB.countAllAtoms()];
        this.tmpatomIdNumbers = new ArrayList();
        int index = 0;
        int curresind = 0;
        int curres = 0;
        try {
            curres = Integer.parseInt(this.firstPDB.getChains().get((int)0).aminoAcids.get(0).getAminoAcidID());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        for (int i = 0; i < this.firstPDB.getChains().size(); ++i) {
            ArrayList<AminoAcid> aalist2;
            ArrayList<AminoAcid> aalist;
            Chain chain = this.firstPDB.getChains().get(i);
            if (chain.aminoAcids.size() > 0) {
                aalist = chain.aminoAcids;
                aalist2 = this.secondPDB.getChains().get((int)i).aminoAcids;
            } else {
                aalist = chain.nonAminos;
                aalist2 = this.secondPDB.getChains().get((int)i).nonAminos;
            }
            for (int j = 0; j < aalist.size(); ++j) {
                AminoAcid residue = aalist.get(j);
                for (int k = 0; k < residue.getAtoms().size(); ++k) {
                    Atom atm = residue.getAtoms().get(k);
                    this.tmpatomIdNumbers.add(atm.atomID);
                    try {
                        Atom endatm = aalist2.get(j).getAtoms().get(k);
                        this.allCoordinates_start[index][0] = atm.getX();
                        this.allCoordinates_start[index][1] = atm.getY();
                        this.allCoordinates_start[index][2] = atm.getZ();
                        this.allCoordinates_end[index][0] = endatm.getX();
                        this.allCoordinates_end[index][1] = endatm.getY();
                        this.allCoordinates_end[index][2] = endatm.getZ();
                        this.residues[index] = Integer.parseInt(residue.getAminoAcidID());
                        if (curres != this.residues[index]) {
                            curres = this.residues[index];
                        }
                        this.residueCount[index] = ++curresind;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++index;
                }
            }
        }
    }

    private void orientAlongPrincipalAxis() {
        this.prinAxCoordinates = PCA.orientAlongPrincipalAxis(this.allCoordinates_start);
    }

    private void writeFile(String fileName, PDBFile pdbcopy) {
        try {
            FileWriter fstream = new FileWriter(fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(pdbcopy.toString());
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    private void writeFile(String fileName, StringBuilder sb) {
        try {
            FileWriter fstream = new FileWriter(fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(sb.toString());
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    public void writePymolSession(ArrayList<DomainPair> tempDomains, int numClusterIds) {
        StringBuilder sb = new StringBuilder();
        String outdir = this.params.getFiles().getBulk_outputFolder();
        outdir = outdir == null ? "" : outdir + "//";
        String filename = outdir + this.params.getFiles().getOutfile_session();
        sb.append("reinitialize").append("\n");
        sb.append("load ").append(this.params.getFiles().getOutfile_start()).append(", mov \n");
        sb.append("load ").append(this.params.getFiles().getOutfile_end()).append(", mov \n");
        sb.append("bg_color white").append("\n");
        sb.append("color grey").append("\n");
        for (DomainPair domainPair : tempDomains) {
            if (!(domainPair.getScrewaxisresults().getRatio() >= this.params.getStoppingratio())) continue;
            String arrowfile = domainPair.getArrowfilename();
            if (!outdir.isEmpty()) {
                arrowfile = arrowfile.replace(outdir, "");
            }
            sb.append("load ").append(arrowfile).append("\n");
            String objectname = domainPair.getArrowfilename().replace(".pdb", "");
            sb.append("select byobject ").append(objectname).append("\n");
            String shaftname = objectname + "shaft";
            String headname = objectname + "head";
            if (!outdir.isEmpty()) {
                shaftname = shaftname.replace(outdir, "");
                headname = headname.replace(outdir, "");
            }
            sb.append("select ").append(shaftname).append(", ").append(objectname).append(" and (b = ").append(domainPair.getFirstDomain().getId()).append(")").append("\n");
            sb.append("select ").append(headname).append(", ").append(objectname).append(" and (b = ").append(domainPair.getSecondDomain().getId()).append(")").append("\n");
            String shaftlines = shaftname + "_lines";
            String headlines = headname + "_lines";
            sb.append("distance ").append(shaftlines).append(", ").append(shaftname).append(", ").append(shaftname).append("\n");
            sb.append("distance ").append(headlines).append(", ").append(headname).append(", ").append(headname).append("\n");
            Colour shaftcolour = domainPair.getFirstDomain().getColour();
            Colour headcolour = domainPair.getSecondDomain().getColour();
            sb.append("set_color colour_").append(shaftcolour.getName()).append(" = ").append(Arrays.toString(shaftcolour.getRgb())).append("\n");
            sb.append("set_color colour_").append(headcolour.getName()).append(" = ").append(Arrays.toString(headcolour.getRgb())).append("\n");
            sb.append("color colour_").append(shaftcolour.getName()).append(", ").append(shaftlines).append("\n");
            sb.append("color colour_").append(headcolour.getName()).append(", ").append(headlines).append("\n");
            sb.append("hide labels, ").append(shaftlines).append("\n");
            sb.append("hide labels, ").append(headlines).append("\n");
        }
        sb.append("set dash_gap, 0").append("\n");
        sb.append("set dash_radius, 1").append("\n");
        for (int i = 0; i < numClusterIds; ++i) {
            sb.append("select domain_1, (b = ").append(i).append(")").append("\n");
            Colour domainCol = Domain.colourForID(i);
            String colourname = "colour_" + domainCol.getName();
            sb.append("set_color ").append(colourname).append(" = ").append(Arrays.toString(domainCol.getRgb())).append("\n");
            sb.append("color ").append(colourname).append(", domain_1 \n");
        }
        sb.append("select hinges, (b = ").append(numClusterIds).append(")").append("\n");
        sb.append("set_color colour_green = [0  ,255  ,0]").append("\n");
        sb.append("color colour_green, hinges").append("\n");
        sb.append("select none");
        this.writeFile(filename, sb);
    }

    private void writeOutputPdbs(int[] atomClusterIds, int[] blockClusterIds, int hingeDom, double[] confidence, Vector scaled_h, ArrayList<DomainPair> tempDomains) {
        int index = 0;
        String outdir = this.params.getFiles().getBulk_outputFolder();
        outdir = outdir == null ? "" : outdir + "//";
        String outstart = outdir + this.params.getFiles().getOutfile_start();
        String outend = outdir + this.params.getFiles().getOutfile_end();
        String outvec = outdir + this.params.getFiles().getOutfile_vectors();
        String outunitvec = outdir + this.params.getFiles().getOutfile_unitvectors();
        String outax = outdir + this.params.getFiles().getOutfile_axes();
        String outh = outdir + this.params.getFiles().getOutfile_h();
        boolean[] containsHbr = new boolean[this.blocks.size()];
        PDBFile pdbcopy = this.firstPDB;
        for (int i = 0; i < this.firstPDB.getChains().size(); ++i) {
            Chain chain = pdbcopy.getChains().get(i);
            for (int m = 0; m < chain.allAminos.size(); ++m) {
                AminoAcid residue = chain.allAminos.get(m);
                for (int n = 0; n < residue.getAtoms().size(); ++n) {
                    Atom atm = residue.getAtoms().get(n);
                    atm.setX(this.prinAxCoordinates[index][0]);
                    atm.setY(this.prinAxCoordinates[index][1]);
                    atm.setZ(this.prinAxCoordinates[index][2]);
                    if (atomClusterIds != null) {
                        atm.setCluster(atomClusterIds[index]);
                    }
                    ++index;
                }
            }
        }
        JQuatFit wholeFitter = new JQuatFit(this.prinAxCoordinates);
        int[][] allPairs = new int[2][this.prinAxCoordinates.length];
        for (int j = 0; j < this.prinAxCoordinates.length; ++j) {
            allPairs[0][j] = j;
            allPairs[1][j] = j;
        }
        wholeFitter.quatfit(this.allCoordinates_end, allPairs);
        PDBFile pdb2copy = this.secondPDB;
        index = 0;
        for (int k = 0; k < this.secondPDB.getChains().size(); ++k) {
            Chain chain = pdb2copy.getChains().get(k);
            for (int m = 0; m < chain.allAminos.size(); ++m) {
                AminoAcid residue = chain.allAminos.get(m);
                for (int n = 0; n < residue.getAtoms().size(); ++n) {
                    Atom atm = residue.getAtoms().get(n);
                    atm.setX(this.allCoordinates_end[index][0]);
                    atm.setY(this.allCoordinates_end[index][1]);
                    atm.setZ(this.allCoordinates_end[index][2]);
                    if (atomClusterIds != null) {
                        atm.setCluster(atomClusterIds[index]);
                    }
                    ++index;
                }
            }
        }
        this.writeFile(outstart, pdbcopy);
        this.writeFile(outend, pdb2copy);
        PDBFile pdbarrows = new PDBFile();
        for (DomainPair tempDom : tempDomains) {
            if (!(tempDom.getScrewaxisresults().getRatio() >= this.params.getStoppingratio())) continue;
            pdbarrows.getChains().clear();
            pdbarrows.addScrewAxes(tempDom, this.params.getStoppingratio());
            this.writeFile(tempDom.getArrowfilename(), pdbarrows);
        }
        if (this.rotationVectors != null) {
            Atom atom;
            String chainStr;
            ArrayList<Atom> atomlist;
            Chain chain;
            int m;
            Vector thetas = Vector.fromCollection(this.angles);
            index = 0;
            for (m = 0; m < this.firstPDB.getChains().size(); ++m) {
                chain = pdbcopy.getChains().get(m);
                chain.allAminos = new ArrayList();
                chain.aminoAcids = new ArrayList();
                pdbcopy.getChains().set(m, chain);
            }
            for (m = 0; m < this.rotationVectors.columns(); ++m) {
                chain = pdbcopy.getChains().get(0);
                StringBuilder strb = new StringBuilder();
                strb.append("    ");
                strb.append(String.format("%8.3f", this.rotationVectors.get(0, m)));
                strb.append(String.format("%8.3f", this.rotationVectors.get(1, m)));
                strb.append(String.format("%8.3f", this.rotationVectors.get(2, m)));
                strb.append("     ");
                strb.append(String.format("%6.2f", blockClusterIds[m]));
                atomlist = new ArrayList<Atom>();
                chainStr = "A";
                if (containsHbr[m]) {
                    chainStr = "B";
                }
                atom = new Atom("ATOM", "" + m, "CA", " ", "GLY", chainStr, "" + m, strb.toString(), this.rotationVectors.get(0, m), this.rotationVectors.get(1, m), this.rotationVectors.get(2, m));
                atom.setCluster(blockClusterIds[m]);
                atomlist.add(atom);
                chain.aminoAcids.add(new AminoAcid("" + m, "GLY", atomlist, true));
                pdbcopy.getChains().set(0, chain);
            }
            this.writeFile(outvec, pdbcopy);
            if (this.unit_vectors != null) {
                index = 0;
                for (m = 0; m < this.firstPDB.getChains().size(); ++m) {
                    chain = pdbcopy.getChains().get(m);
                    chain.allAminos = new ArrayList();
                    chain.aminoAcids = new ArrayList();
                    pdbcopy.getChains().set(m, chain);
                }
                for (m = 0; m < this.unit_vectors.columns(); ++m) {
                    chain = pdbcopy.getChains().get(0);
                    StringBuilder strb = new StringBuilder();
                    strb.append("    ");
                    strb.append(String.format("%8.3f", this.unit_vectors.get(0, m)));
                    strb.append(String.format("%8.3f", this.unit_vectors.get(1, m)));
                    strb.append(String.format("%8.3f", this.unit_vectors.get(2, m)));
                    strb.append("     ");
                    strb.append(String.format("%6.2f", blockClusterIds[m]));
                    atomlist = new ArrayList();
                    chainStr = "A";
                    if (containsHbr[m]) {
                        chainStr = "B";
                    }
                    atom = new Atom("ATOM", "" + m, "CA", " ", "GLY", chainStr, "" + m, strb.toString(), this.unit_vectors.get(0, m), this.unit_vectors.get(1, m), this.unit_vectors.get(2, m));
                    atom.setCluster(blockClusterIds[m]);
                    atomlist.add(atom);
                    chain.aminoAcids.add(new AminoAcid("" + m, "GLY", atomlist, true));
                    pdbcopy.getChains().set(0, chain);
                }
                this.writeFile(outunitvec, pdbcopy);
            }
            index = 0;
            for (m = 0; m < this.firstPDB.getChains().size(); ++m) {
                chain = pdbcopy.getChains().get(m);
                chain.allAminos = new ArrayList();
                chain.aminoAcids = new ArrayList();
                pdbcopy.getChains().set(m, chain);
            }
            for (m = 0; m < this.rand_points.columns(); ++m) {
                chain = pdbcopy.getChains().get(0);
                StringBuilder strb = new StringBuilder();
                strb.append("    ");
                strb.append(String.format("%8.3f", this.rand_points.get(0, m)));
                strb.append(String.format("%8.3f", this.rand_points.get(1, m)));
                strb.append(String.format("%8.3f", this.rand_points.get(2, m)));
                strb.append("     ");
                strb.append(String.format("%6.2f", blockClusterIds[m]));
                atomlist = new ArrayList();
                chainStr = "A";
                if (containsHbr[m]) {
                    chainStr = "B";
                }
                atom = new Atom("ATOM", "" + m, "CA", " ", "GLY", chainStr, "" + m, strb.toString(), this.rand_points.get(0, m), this.rand_points.get(1, m), this.rand_points.get(2, m));
                atom.setCluster(blockClusterIds[m]);
                atomlist.add(atom);
                chain.aminoAcids.add(new AminoAcid("" + m, "GLY", atomlist, true));
                pdbcopy.getChains().set(0, chain);
            }
            this.writeFile(outax, pdbcopy);
        }
        this.writePymolSession(tempDomains, hingeDom);
    }

    private String writeReport(ClusterResults clusres) {
        FileMngr mngr = this.params.getFiles();
        String outdir = mngr.getBulk_outputFolder();
        StringBuilder sb = new StringBuilder();
        outdir = outdir == null ? "" : outdir + "//";
        String filename = outdir + mngr.getOutfile_report();
        sb.append("DynDom6D INFORMATION FILE\n");
        sb.append("NOTE: Open ").append(mngr.getOutfile_session()).append(" or colour structure by temperature factor to visualise domains\n");
        sb.append("\n");
        sb.append("=========================================================================\n");
        sb.append("DynDom6D input: \n\n");
        sb.append("File name of conformer 1:").append(mngr.getInfile_start()).append(" \n\n");
        sb.append("File name of conformer 2:").append(mngr.getInfile_end()).append(" \n\n");
        sb.append("-------------------------------------------------------------------------\n");
        sb.append("Parameters used to determine dynamic domains: \n");
        sb.append(this.params.toString());
        sb.append("\n");
        sb.append("=========================================================================\n");
        sb.append("DynDom6D output: \n\n");
        sb.append("Number of atoms in both conformations: ").append(this.prinAxCoordinates.length).append("\n");
        sb.append("Total blocks included for calculating rotation vector: ").append(this.blocks.size()).append("\n");
        sb.append("Number of dynamic domains: ").append(clusres.getNumClusters()).append("\n");
        sb.append("Number of dynamic domain pairs: ").append(clusres.getDomains().size()).append("\n");
        sb.append("=========================================================================\n");
        if (!clusres.getDomains().isEmpty() || !clusres.getNondomains().isEmpty()) {
            if (clusres.getDomains().isEmpty()) {
                sb.append("There are no domain pairs for which the ratio criterion is satisfied \n");
            } else {
                sb.append("Following is the result of analysis of domain pairs for which the ratio criterion is satisfied\n");
                sb.append("=========================================================================\n");
                for (DomainPair dp : clusres.getDomains()) {
                    sb.append(this.buildDomainPairReport(dp));
                }
            }
            sb.append("=========================================================================\n");
            if (clusres.getNondomains().isEmpty()) {
                sb.append("The ratio criterion is satisfied for all domain pairs\n");
            } else {
                sb.append("Following is the result of analysis of domain pairs for which the ratio criterion is NOT satisfied\n");
                sb.append("=========================================================================\n");
                for (DomainPair dp : clusres.getNondomains()) {
                    sb.append(this.buildDomainPairReport(dp));
                }
            }
            sb.append("=========================================================================\n");
        }
        sb.append("End of DynDom6D output");
        this.writeFile(filename, sb);
        return sb.toString();
    }

    private String buildDomainPairReport(DomainPair dp) {
        ScrewAxArrowResults scax = dp.getScrewaxisresults();
        StringBuilder sb = new StringBuilder();
        Domain dom1 = dp.getFirstDomain();
        Domain dom2 = dp.getSecondDomain();
        sb.append("First domain: ").append(dom1.getId()).append("(").append(dom1.getColour().getName()).append(")\n");
        sb.append("Size: ").append(dom1.getSize()).append(" atoms\n");
        sb.append("All-atom RMSD on this domain: ").append(String.format("%.3f", dom1.getRmsd())).append("A\n\n");
        sb.append("Second domain: ").append(dom2.getId()).append("(").append(dom2.getColour().getName()).append(")\n");
        sb.append("Size: ").append(dom2.getSize()).append(" atoms\n");
        sb.append("All-atom RMSD on this domain: ").append(String.format("%.3f", dom2.getRmsd())).append("A\n\n");
        sb.append("Ratio of interdomain to intradomain displacement: ").append(String.format("%.3f", scax.getRatio())).append(" \n");
        sb.append("Angle of rotation: ").append(String.format("%.3f", Math.toDegrees(scax.getTheta()))).append(" \n");
        sb.append("Translation along axis: ").append(String.format("%.3f", scax.getAmptr())).append("A \n");
        Vector com1 = dom1.getCentreOfMass();
        Vector com2 = dom2.getCentreOfMass();
        Vector comline = com1.subtract(com2);
        double rl = Math.sqrt(Math.pow(comline.get(0), 2.0) + Math.pow(comline.get(1), 2.0) + Math.pow(comline.get(2), 2.0));
        comline = comline.divide(rl);
        sb.append("Angle between screw axis and line connecting centres of mass: ").append(String.format("%.3f", scax.getAngleToCoMLine(comline))).append(" \n");
        sb.append("Distance between screw axis and line connecting centres of mass: ").append(String.format("%.3f", scax.getDistanceToCoMLine(comline, com1))).append("A \n");
        sb.append("Percentage closure motion: ").append(String.format("%.3f", scax.getDegreeOfClosure(comline))).append("% \n");
        sb.append("-------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public Results getResults() {
        return this.results;
    }

    public PDBFile getFirstPDB() {
        return this.firstPDB;
    }

    public PDBFile getSecondPDB() {
        return this.secondPDB;
    }

    public void setFirstPDB(PDBFile firstPDB) {
        this.firstPDB = firstPDB;
    }

    public void setSecondPDB(PDBFile secondPDB) {
        this.secondPDB = secondPDB;
    }
}

