/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.FitterResults;
import dyndom3D.Jacobi;
import org.la4j.Matrix;
import org.la4j.Vector;

public class Fitter {
    public FitterResults run(Matrix refCoords, Matrix coordsToFit, String pref) {
        return this.run(refCoords, coordsToFit, Vector.constant((int)refCoords.rows(), (double)1.0), pref);
    }

    public FitterResults run(Matrix ArefCoords, Matrix AcoordsToFit, Vector mass, String pref) {
        int i;
        Matrix refCoords = ArefCoords.copy();
        Matrix coordsToFit = AcoordsToFit.copy();
        refCoords = refCoords.transpose();
        coordsToFit = coordsToFit.transpose();
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        double[] xc1arr = new double[3];
        double[] xc2arr = new double[3];
        for (int na = 0; na < refCoords.columns(); ++na) {
            for (int m = 0; m < refCoords.rows(); ++m) {
                xc1arr[m] = xc1arr[m] + refCoords.get(m, na) * mass.get(na);
                xc2arr[m] = xc2arr[m] + coordsToFit.get(m, na) * mass.get(na);
            }
        }
        Vector xc1 = Vector.fromArray((double[])xc1arr);
        Vector xc2 = Vector.fromArray((double[])xc2arr);
        double massTot = mass.sum();
        xc1 = xc1.divide(massTot);
        xc2 = xc2.divide(massTot);
        for (i = 0; i < refCoords.columns(); ++i) {
            refCoords.setColumn(i, refCoords.getColumn(i).subtract(xc1));
        }
        for (i = 0; i < coordsToFit.columns(); ++i) {
            coordsToFit.setColumn(i, coordsToFit.getColumn(i).subtract(xc2));
        }
        for (i = 0; i < refCoords.columns(); ++i) {
            xxyx += mass.get(i) * refCoords.get(0, i) * coordsToFit.get(0, i);
            xxyy += mass.get(i) * refCoords.get(1, i) * coordsToFit.get(0, i);
            xxyz += mass.get(i) * refCoords.get(2, i) * coordsToFit.get(0, i);
            xyyx += mass.get(i) * refCoords.get(0, i) * coordsToFit.get(1, i);
            xyyy += mass.get(i) * refCoords.get(1, i) * coordsToFit.get(1, i);
            xyyz += mass.get(i) * refCoords.get(2, i) * coordsToFit.get(1, i);
            xzyx += mass.get(i) * refCoords.get(0, i) * coordsToFit.get(2, i);
            xzyy += mass.get(i) * refCoords.get(1, i) * coordsToFit.get(2, i);
            xzyz += mass.get(i) * refCoords.get(2, i) * coordsToFit.get(2, i);
        }
        double[][] cr = new double[4][4];
        cr[0][0] = xxyx + xyyy + xzyz;
        cr[0][1] = -xzyy + xyyz;
        cr[1][1] = xxyx - xyyy - xzyz;
        cr[0][2] = -xxyz + xzyx;
        cr[1][2] = xxyy + xyyx;
        cr[2][2] = xyyy - xzyz - xxyx;
        cr[0][3] = -xyyx + xxyy;
        cr[1][3] = xzyx + xxyz;
        cr[2][3] = xyyz + xzyy;
        cr[3][3] = xzyz - xxyx - xyyy;
        Jacobi jac = new Jacobi();
        jac.diagonalisation(4, 4, cr);
        double[][] vecs = jac.getEigenvectors();
        Vector quat = Vector.fromArray((double[])new double[]{vecs[0][3], vecs[1][3], vecs[2][3], vecs[3][3]});
        double[][] rotMatdbl = new double[3][3];
        rotMatdbl[0][0] = Math.pow(quat.get(0), 2.0) + Math.pow(quat.get(1), 2.0) - Math.pow(quat.get(2), 2.0) - Math.pow(quat.get(3), 2.0);
        rotMatdbl[1][0] = 2.0 * (quat.get(1) * quat.get(2) + quat.get(0) * quat.get(3));
        rotMatdbl[2][0] = 2.0 * (quat.get(1) * quat.get(3) - quat.get(0) * quat.get(2));
        rotMatdbl[0][1] = 2.0 * (quat.get(2) * quat.get(1) - quat.get(0) * quat.get(3));
        rotMatdbl[1][1] = Math.pow(quat.get(0), 2.0) - Math.pow(quat.get(1), 2.0) + Math.pow(quat.get(2), 2.0) - Math.pow(quat.get(3), 2.0);
        rotMatdbl[2][1] = 2.0 * (quat.get(2) * quat.get(3) + quat.get(0) * quat.get(1));
        rotMatdbl[0][2] = 2.0 * (quat.get(3) * quat.get(1) + quat.get(0) * quat.get(2));
        rotMatdbl[1][2] = 2.0 * (quat.get(3) * quat.get(2) - quat.get(0) * quat.get(1));
        rotMatdbl[2][2] = Math.pow(quat.get(0), 2.0) - Math.pow(quat.get(1), 2.0) - Math.pow(quat.get(2), 2.0) + Math.pow(quat.get(3), 2.0);
        Matrix rotMat = Matrix.from2DArray((double[][])rotMatdbl);
        for (int j = 0; j < coordsToFit.columns(); ++j) {
            double x = coordsToFit.get(0, j) * rotMat.get(0, 0) + coordsToFit.get(1, j) * rotMat.get(0, 1) + coordsToFit.get(2, j) * rotMat.get(0, 2);
            double y = coordsToFit.get(0, j) * rotMat.get(1, 0) + coordsToFit.get(1, j) * rotMat.get(1, 1) + coordsToFit.get(2, j) * rotMat.get(1, 2);
            double z = coordsToFit.get(0, j) * rotMat.get(2, 0) + coordsToFit.get(1, j) * rotMat.get(2, 1) + coordsToFit.get(2, j) * rotMat.get(2, 2);
            coordsToFit.setColumn(j, Vector.fromArray((double[])new double[]{x, y, z}));
        }
        Matrix fc = coordsToFit;
        double rmsd = 0.0;
        for (int k = 0; k < refCoords.rows(); ++k) {
            for (int m = 0; m < refCoords.columns(); ++m) {
                double delta = fc.get(k, m) - refCoords.get(k, m);
                rmsd += delta * delta;
            }
        }
        rmsd = Math.sqrt(rmsd / (double)refCoords.columns());
        double angle = 2.0 * Math.acos(quat.get(0));
        Vector unitVector = Vector.fromArray((double[])new double[]{quat.get(1) / Math.sin(angle / 2.0), quat.get(2) / Math.sin(angle / 2.0), quat.get(3) / Math.sin(angle / 2.0)});
        if (angle > Math.PI) {
            angle = Math.PI * 2 - angle;
            unitVector = Vector.fromArray((double[])new double[]{-quat.get(1) / Math.sin(angle / 2.0), -quat.get(2) / Math.sin(angle / 2.0), -quat.get(3) / Math.sin(angle / 2.0)});
        }
        return new FitterResults(unitVector, angle, rmsd, fc.transpose(), refCoords.transpose(), xc1, xc2, rotMatdbl, quat);
    }
}

