/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import java.io.Serializable;

public class JQuatFit
implements Serializable {
    private double[][] xyz_f = null;
    private double[][] xyz_r = null;
    private double[][] rot_matrix = null;
    int max_sweeps = 30;
    public double[] q = null;

    public JQuatFit(double[][] referenceCoordinates) {
        this.xyz_r = (double[][])referenceCoordinates.clone();
    }

    public double quatfit(double[][] fitCoordinates) {
        int[][] allPairs = new int[2][fitCoordinates.length];
        for (int i = 0; i < fitCoordinates.length; ++i) {
            allPairs[0][i] = i;
            allPairs[1][i] = i;
        }
        return this.quatfit(fitCoordinates, allPairs);
    }

    public double quatfit(double[][] fitCoordinates, int[][] pairs) {
        double[] weightFrom0 = new double[pairs[0].length];
        for (int i = 0; i < pairs[0].length; ++i) {
            weightFrom0[i] = 1.0;
        }
        return this.quatfit(fitCoordinates, weightFrom0, pairs);
    }

    public double quatfit(double[][] fitCoordinates, double[] weightFrom0) {
        int[][] allPairs = new int[2][fitCoordinates.length];
        for (int i = 0; i < fitCoordinates.length; ++i) {
            allPairs[0][i] = i;
            allPairs[1][i] = i;
        }
        return this.quatfit(fitCoordinates, weightFrom0, allPairs);
    }

    public double quatfit(double[][] fitCoordinates, double[] weightFrom0, int[][] pairs) {
        double[] ref_center = new double[3];
        double[] fit_center = new double[3];
        double[][] u = new double[3][3];
        this.q = new double[4];
        int npairs = pairs[0].length;
        double[] weight = new double[npairs];
        double[][] ref_xyz = new double[npairs][3];
        double[][] fit_xyz = new double[npairs][3];
        weight = weightFrom0;
        this.xyz_f = fitCoordinates;
        int nat_r = this.xyz_r.length;
        int nat_f = this.xyz_f.length;
        for (int i = 0; i < npairs; ++i) {
            for (int k = 0; k < 3; ++k) {
                ref_xyz[i][k] = this.xyz_r[pairs[0][i]][k];
                fit_xyz[i][k] = this.xyz_f[pairs[1][i]][k];
            }
        }
        JQuatFit.center(npairs, ref_xyz, weight, 1, ref_center);
        JQuatFit.center(npairs, fit_xyz, weight, 1, fit_center);
        JQuatFit.qtrfit(npairs, fit_xyz, ref_xyz, weight, this.q, u, this.max_sweeps);
        JQuatFit.center(nat_f, this.xyz_f, weight, 2, fit_center);
        this.rotmol(nat_f, this.xyz_f, this.xyz_f, u);
        this.rotmol(npairs, fit_xyz, fit_xyz, u);
        JQuatFit.center(nat_f, this.xyz_f, weight, 3, ref_center);
        this.rot_matrix = u;
        JQuatFit.center(npairs, fit_xyz, weight, 3, ref_center);
        JQuatFit.center(npairs, ref_xyz, weight, 3, ref_center);
        double dLen = 0.0;
        for (int j = 0; j < ref_xyz.length; ++j) {
            double d0 = ref_xyz[j][0] - fit_xyz[j][0];
            double d1 = ref_xyz[j][1] - fit_xyz[j][1];
            double d2 = ref_xyz[j][2] - fit_xyz[j][2];
            dLen += weight[j] * (d0 * d0 + d1 + d1 + d2 * d2);
        }
        dLen = dLen > 0.0 ? Math.sqrt(dLen / (double)ref_xyz.length) : 0.0;
        return dLen;
    }

    public double[][] getRot_matrix() {
        return this.rot_matrix;
    }

    private static void center(int n, double[][] x, double[] w, int io, double[] o) {
        double modif;
        if (io == 2) {
            modif = -1.0;
        } else if (io == 3) {
            modif = 1.0;
        } else {
            modif = -1.0;
            o[0] = 0.0;
            o[1] = 0.0;
            o[2] = 0.0;
            double wnorm = 0.0;
            for (int j = 0; j < n; ++j) {
                o[0] = o[0] + x[j][0] * Math.sqrt(w[j]);
                o[1] = o[1] + x[j][1] * Math.sqrt(w[j]);
                o[2] = o[2] + x[j][2] * Math.sqrt(w[j]);
                wnorm += Math.sqrt(w[j]);
            }
            o[0] = o[0] / wnorm;
            o[1] = o[1] / wnorm;
            o[2] = o[2] / wnorm;
        }
        for (int i = 0; i < n; ++i) {
            x[i][0] = x[i][0] + modif * o[0];
            x[i][1] = x[i][1] + modif * o[1];
            x[i][2] = x[i][2] + modif * o[2];
        }
    }

    private void rotmol(int n, double[][] x, double[][] y, double[][] u) {
        for (int i = 0; i < n; ++i) {
            double yx = u[0][0] * x[i][0] + u[1][0] * x[i][1] + u[2][0] * x[i][2];
            double yy = u[0][1] * x[i][0] + u[1][1] * x[i][1] + u[2][1] * x[i][2];
            double yz = u[0][2] * x[i][0] + u[1][2] * x[i][1] + u[2][2] * x[i][2];
            y[i][0] = yx;
            y[i][1] = yy;
            y[i][2] = yz;
        }
    }

    public static void jacobi(double[][] a, double[] d, double[][] v, int nrot) {
        int i;
        double small = 1.0E-12;
        double f0 = 0.0;
        double p5 = 0.5;
        double f1 = 1.0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                v[i][j] = 0.0;
            }
            v[i][i] = 1.0;
            d[i] = a[i][i];
        }
        for (int l = 1; l <= nrot; ++l) {
            int j;
            double dnorm = 0.0;
            double onorm = 0.0;
            for (j = 0; j < 4; ++j) {
                dnorm += Math.abs(d[j]);
                for (i = 0; i <= j - 1; ++i) {
                    onorm += Math.abs(a[i][j]);
                }
            }
            if (onorm / dnorm <= 1.0E-12) {
                nrot = l;
                for (j = 0; j < 3; ++j) {
                    int k = j;
                    double dtemp = d[k];
                    for (i = j + 1; i <= 3; ++i) {
                        if (!(d[i] < dtemp)) continue;
                        k = i;
                        dtemp = d[k];
                    }
                    if (k <= j) continue;
                    d[k] = d[j];
                    d[j] = dtemp;
                    for (i = 0; i < 4; ++i) {
                        dtemp = v[i][k];
                        v[i][k] = v[i][j];
                        v[i][j] = dtemp;
                    }
                }
                return;
            }
            for (j = 1; j < 4; ++j) {
                for (i = 0; i < j; ++i) {
                    double atemp;
                    int k;
                    double t;
                    double b = a[i][j];
                    if (!(Math.abs(b) > 0.0)) continue;
                    double dma = d[j] - d[i];
                    if (Math.abs(dma) + Math.abs(b) <= Math.abs(dma)) {
                        t = b / dma;
                    } else {
                        double q = 0.5 * dma / b;
                        t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
                        if (q < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double s = t * c;
                    a[i][j] = 0.0;
                    for (k = 0; k < i; ++k) {
                        atemp = c * a[k][i] - s * a[k][j];
                        a[k][j] = s * a[k][i] + c * a[k][j];
                        a[k][i] = atemp;
                    }
                    for (k = i + 1; k < j; ++k) {
                        atemp = c * a[i][k] - s * a[k][j];
                        a[k][j] = s * a[i][k] + c * a[k][j];
                        a[i][k] = atemp;
                    }
                    for (k = j + 1; k < 4; ++k) {
                        atemp = c * a[i][k] - s * a[j][k];
                        a[j][k] = s * a[i][k] + c * a[j][k];
                        a[i][k] = atemp;
                    }
                    for (k = 0; k < 4; ++k) {
                        double vtemp = c * v[k][i] - s * v[k][j];
                        v[k][j] = s * v[k][i] + c * v[k][j];
                        v[k][i] = vtemp;
                    }
                    double dtemp = c * c * d[i] + s * s * d[j] - 2.0 * c * s * b;
                    d[j] = s * s * d[i] + c * c * d[j] + 2.0 * c * s * b;
                    d[i] = dtemp;
                }
            }
        }
    }

    private static void q2mat(double[] q, double[][] u) {
        double f2 = 2.0;
        u[0][0] = q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3];
        u[0][1] = 2.0 * (q[1] * q[2] - q[0] * q[3]);
        u[0][2] = 2.0 * (q[1] * q[3] + q[0] * q[2]);
        u[1][0] = 2.0 * (q[2] * q[1] + q[0] * q[3]);
        u[1][1] = q[0] * q[0] - q[1] * q[1] + q[2] * q[2] - q[3] * q[3];
        u[1][2] = 2.0 * (q[2] * q[3] - q[0] * q[1]);
        u[2][0] = 2.0 * (q[3] * q[1] - q[0] * q[2]);
        u[2][1] = 2.0 * (q[3] * q[2] + q[0] * q[1]);
        u[2][2] = q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3];
    }

    private static void qtrfit(int n, double[][] x, double[][] y, double[] w, double[] q, double[][] u, int nr) {
        int i;
        double[][] c = new double[4][4];
        double[][] v = new double[4][4];
        double[] d = new double[4];
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        for (i = 0; i < n; ++i) {
            xxyx += x[i][0] * y[i][0] * w[i];
            xxyy += x[i][0] * y[i][1] * w[i];
            xxyz += x[i][0] * y[i][2] * w[i];
            xyyx += x[i][1] * y[i][0] * w[i];
            xyyy += x[i][1] * y[i][1] * w[i];
            xyyz += x[i][1] * y[i][2] * w[i];
            xzyx += x[i][2] * y[i][0] * w[i];
            xzyy += x[i][2] * y[i][1] * w[i];
            xzyz += x[i][2] * y[i][2] * w[i];
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                c[i][j] = 0.0;
            }
        }
        c[0][0] = xxyx + xyyy + xzyz;
        c[0][1] = xzyy - xyyz;
        c[1][1] = xxyx - xyyy - xzyz;
        c[0][2] = xxyz - xzyx;
        c[1][2] = xxyy + xyyx;
        c[2][2] = xyyy - xzyz - xxyx;
        c[0][3] = xyyx - xxyy;
        c[1][3] = xzyx + xxyz;
        c[2][3] = xyyz + xzyy;
        c[3][3] = xzyz - xxyx - xyyy;
        JQuatFit.jacobi(c, d, v, nr);
        q[0] = v[0][3];
        q[1] = v[1][3];
        q[2] = v[2][3];
        q[3] = v[3][3];
        JQuatFit.q2mat(q, u);
    }

    public double[] getQuaternions() {
        return this.q;
    }
}

