/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

public class Jacobi {
    private double[] eigenvalues;
    private double[][] eigenvectors;

    public void diagonalisation(int dim, int dimPhys, double[][] matr) {
        int maxrot = 100;
        int nrot = 0;
        this.eigenvalues = new double[dimPhys];
        double[] b = new double[dimPhys];
        double[] z = new double[dimPhys];
        this.eigenvectors = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            this.eigenvectors[i][i] = 1.0;
            b[i] = matr[i][i];
            this.eigenvalues[i] = b[i];
        }
        for (int j = 0; j < maxrot; ++j) {
            int i1;
            double sm = 0.0;
            for (int m = 0; m < dim - 1; ++m) {
                for (i1 = m + 1; i1 < dim; ++i1) {
                    sm += Math.abs(matr[m][i1]);
                }
            }
            if (sm == 0.0 && nrot == maxrot) {
                System.out.println("Jacobi matrix diagonalization not converged");
            }
            double tresh = j < 3 ? 0.2 * sm / Math.pow(dim, 2.0) : 0.0;
            for (int n = 0; n < dim - 1; ++n) {
                for (i1 = n + 1; i1 < dim; ++i1) {
                    int i2;
                    double t;
                    double g = 100.0 * Math.abs(matr[n][i1]);
                    if (j > 3 && Math.abs(this.eigenvalues[n]) + g == Math.abs(this.eigenvalues[n]) && Math.abs(this.eigenvalues[i1]) + g == Math.abs(this.eigenvalues[i1])) {
                        matr[n][i1] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(matr[n][i1]) > tresh)) continue;
                    double h = this.eigenvalues[i1] - this.eigenvalues[n];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = matr[n][i1] / h;
                    } else {
                        double theta = 0.5 * h / matr[n][i1];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + Math.pow(theta, 2.0)));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + Math.pow(t, 2.0));
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * matr[n][i1];
                    z[n] = z[n] - h;
                    z[i1] = z[i1] + h;
                    this.eigenvalues[n] = this.eigenvalues[n] - h;
                    this.eigenvalues[i1] = this.eigenvalues[i1] + h;
                    matr[n][i1] = 0.0;
                    for (i2 = 0; i2 < n; ++i2) {
                        g = matr[i2][n];
                        h = matr[i2][i1];
                        matr[i2][n] = g - s * (h + g * tau);
                        matr[i2][i1] = h + s * (g - h * tau);
                    }
                    for (i2 = n + 1; i2 < i1; ++i2) {
                        g = matr[n][i2];
                        h = matr[i2][i1];
                        matr[n][i2] = g - s * (h + g * tau);
                        matr[i2][i1] = h + s * (g - h * tau);
                    }
                    for (i2 = i1 + 1; i2 < dim; ++i2) {
                        g = matr[n][i2];
                        h = matr[i1][i2];
                        matr[n][i2] = g - s * (h + g * tau);
                        matr[i1][i2] = h + s * (g - h * tau);
                    }
                    for (i2 = 0; i2 < dim; ++i2) {
                        g = this.eigenvectors[i2][n];
                        h = this.eigenvectors[i2][i1];
                        this.eigenvectors[i2][n] = g - s * (h + g * tau);
                        this.eigenvectors[i2][i1] = h + s * (g - h * tau);
                    }
                    ++nrot;
                }
            }
            for (int l = 0; l < dim; ++l) {
                b[l] = b[l] + z[l];
                this.eigenvalues[l] = b[l];
                z[l] = 0.0;
            }
        }
        for (int k = 0; k < dim; ++k) {
            int n;
            int m = k;
            double p = this.eigenvalues[k];
            for (n = k + 1; n < dim; ++n) {
                if (!(this.eigenvalues[n] < p)) continue;
                m = n;
                p = this.eigenvalues[n];
            }
            if (m == k) continue;
            this.eigenvalues[m] = this.eigenvalues[k];
            this.eigenvalues[k] = p;
            for (n = 0; n < dim; ++n) {
                p = this.eigenvectors[n][k];
                this.eigenvectors[n][k] = this.eigenvectors[n][m];
                this.eigenvectors[n][m] = p;
            }
        }
    }

    public double[] getEigenvalues() {
        return this.eigenvalues;
    }

    public double[][] getEigenvectors() {
        return this.eigenvectors;
    }
}

