/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.KMeansResults;
import dyndom3D.Lines;
import java.util.ArrayList;
import org.la4j.Matrix;
import org.la4j.Vector;

public class KMeans {
    public static KMeansResults kmeans(Matrix means, Matrix rand_points, Matrix others, Matrix unit_vectors, int k, int iters) {
        int numOfBlocks = unit_vectors.columns();
        int numOfOtherDims = others.rows();
        int numOfLineDims = rand_points.rows();
        int[] clusterIds = new int[numOfBlocks];
        Matrix distancesToMean = null;
        for (int iter = 0; iter < iters; ++iter) {
            distancesToMean = Matrix.zero((int)k, (int)numOfBlocks);
            for (int j = 0; j < k; ++j) {
                for (int n = 0; n < numOfBlocks; ++n) {
                    distancesToMean.set(j, n, Lines.lineToPointSquared(means.slice(0, j, numOfLineDims, j + 1).toColumnVector(), rand_points.getColumn(n), unit_vectors.getColumn(n)));
                    for (int i1 = 0; i1 < numOfOtherDims; ++i1) {
                        double part = Math.pow(means.get(numOfLineDims + i1, j) - others.get(i1, n), 2.0);
                        distancesToMean.set(j, n, distancesToMean.get(j, n) + part);
                    }
                }
            }
            for (int i = 0; i < numOfBlocks; ++i) {
                int minId = 0;
                double minValue = distancesToMean.get(0, i);
                for (int n = 0; n < k; ++n) {
                    double tmpValue = distancesToMean.get(n, i);
                    if (!(tmpValue < minValue)) continue;
                    minId = n;
                    minValue = tmpValue;
                }
                clusterIds[i] = minId;
            }
            Matrix oldMeans = means.copy();
            for (int m = 0; m < k; ++m) {
                ArrayList<Vector> points = new ArrayList<Vector>();
                ArrayList<Vector> units = new ArrayList<Vector>();
                ArrayList<Vector> oth = new ArrayList<Vector>();
                for (int n = 0; n < numOfBlocks; ++n) {
                    if (clusterIds[n] != m) continue;
                    points.add(rand_points.getColumn(n));
                    units.add(unit_vectors.getColumn(n));
                    oth.add(others.getColumn(n));
                }
                if (points.size() <= 0) continue;
                means.setColumn(m, Lines.append(Lines.meanOfLines(points, units), Lines.meanOfOthers(numOfOtherDims, oth)));
            }
            if (oldMeans.equals(means, 0.001)) break;
        }
        return new KMeansResults(clusterIds, means, distancesToMean);
    }
}

