/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.LinearSystemSolver;

public class Lines {
    public static Vector meanOfLines(ArrayList<Vector> points, ArrayList<Vector> nUnit) {
        Matrix n = Matrix.zero((int)3, (int)3);
        Matrix n_it = Matrix.zero((int)3, (int)3);
        Vector p = Vector.zero((int)3);
        for (int i = 0; i < points.size(); ++i) {
            n_it.set(0, 0, Math.pow(nUnit.get(i).get(1), 2.0) + Math.pow(nUnit.get(i).get(2), 2.0));
            n_it.set(1, 1, Math.pow(nUnit.get(i).get(0), 2.0) + Math.pow(nUnit.get(i).get(2), 2.0));
            n_it.set(2, 2, Math.pow(nUnit.get(i).get(0), 2.0) + Math.pow(nUnit.get(i).get(1), 2.0));
            n_it.set(0, 1, -nUnit.get(i).get(0) * nUnit.get(i).get(1));
            n_it.set(0, 2, -nUnit.get(i).get(0) * nUnit.get(i).get(2));
            n_it.set(1, 2, -nUnit.get(i).get(1) * nUnit.get(i).get(2));
            n_it.set(1, 0, n_it.get(0, 1));
            n_it.set(2, 0, n_it.get(0, 2));
            n_it.set(2, 1, n_it.get(1, 2));
            n = n.add(n_it);
            Vector p_it = n_it.multiply(points.get(i));
            p = p.add(p_it);
        }
        Vector results = null;
        try {
            Matrix n_rounded = Matrix.zero((int)n.rows(), (int)n.columns());
            for (int j = 0; j < n.rows(); ++j) {
                for (int k = 0; k < n.columns(); ++k) {
                    n_rounded.set(j, k, BigDecimal.valueOf(n.get(j, k)).setScale(3, 4).doubleValue());
                }
            }
            LinearSystemSolver solver = LinearAlgebra.SOLVER.create(n_rounded);
            Vector pcol = p.toColumnMatrix().toColumnVector();
            results = solver.solve(pcol);
        }
        catch (Exception e) {
            System.err.print(e);
            System.out.println("n: " + n.toString());
            System.out.println("p: " + p.toString());
        }
        return results;
    }

    public static Vector append(Vector first, Vector second) {
        int firstLength = first.length();
        Vector result = Vector.zero((int)(firstLength + second.length()));
        for (int i = 0; i < firstLength; ++i) {
            result.set(i, first.get(i));
        }
        for (int j = 0; j < second.length(); ++j) {
            result.set(firstLength + j, second.get(j));
        }
        return result;
    }

    public static double lineToPointSquared(Vector point, Vector pointOnLine, Vector unitVector) {
        Vector diff = point.subtract(pointOnLine);
        Vector dist = Lines.cross(diff, unitVector);
        return Math.pow(dist.norm(), 2.0);
    }

    public static Vector meanOfOthers(int numOfDims, ArrayList<Vector> values) {
        Vector mean = Vector.zero((int)numOfDims);
        for (int i = 0; i < values.size(); ++i) {
            Vector val = values.get(i);
            for (int j = 0; j < numOfDims; ++j) {
                mean.set(j, mean.get(j) + val.get(j));
            }
        }
        return mean.divide((double)values.size());
    }

    public static Vector cross(Vector one, Vector other) {
        double[] resultCoords = new double[one.length()];
        resultCoords[0] = one.get(1) * other.get(2) - other.get(1) * one.get(2);
        resultCoords[1] = one.get(2) * other.get(0) - other.get(2) * one.get(0);
        resultCoords[2] = one.get(0) * other.get(1) - other.get(0) * one.get(1);
        return Vector.fromArray((double[])resultCoords);
    }

    public static Matrix append(Matrix m1, Matrix m2, boolean toRight) {
        Matrix result;
        if (toRight) {
            int dim1 = Math.max(m1.rows(), m2.rows());
            int dim2 = m1.columns() + m2.columns();
            result = Matrix.zero((int)dim1, (int)dim2);
            for (int i = 0; i < dim1; ++i) {
                result.setRow(i, Lines.append(m1.getRow(i), m2.getRow(i)));
            }
        } else {
            int dim1 = m1.rows() + m2.rows();
            int dim2 = Math.max(m1.columns(), m2.columns());
            result = Matrix.zero((int)dim1, (int)dim2);
            for (int i = 0; i < dim2; ++i) {
                result.setColumn(i, Lines.append(m1.getColumn(i), m2.getColumn(i)));
            }
        }
        return result;
    }

    public static double[][] append(double[][] arr1, double[][] arr2) {
        int i;
        double[][] result = new double[arr1.length + arr2.length][arr1[0].length];
        for (i = 0; i < arr1.length; ++i) {
            result[i] = arr1[i];
        }
        for (i = 0; i < arr2.length; ++i) {
            result[arr1.length + i] = arr2[i];
        }
        return result;
    }
}

