/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.Jacobi;
import dyndom3D.PrincipalComponentResults;

public class PCA {
    public static PrincipalComponentResults principalComponentAnalysis(double[][] coordinates) {
        double[] sums = new double[3];
        double[] means = new double[3];
        int total = coordinates.length;
        for (int i = 0; i < total; ++i) {
            for (int n = 0; n < sums.length; ++n) {
                sums[n] = sums[n] + coordinates[i][n];
            }
        }
        for (int j = 0; j < sums.length; ++j) {
            means[j] = sums[j] / (double)total;
        }
        double[][] inertiaTensor = new double[3][3];
        for (int k = 0; k < total; ++k) {
            for (int n = 0; n < sums.length; ++n) {
                coordinates[k][n] = coordinates[k][n] - means[n];
            }
            inertiaTensor[0][0] = inertiaTensor[0][0] + Math.pow(coordinates[k][1], 2.0) + Math.pow(coordinates[k][2], 2.0);
            inertiaTensor[1][1] = inertiaTensor[1][1] + Math.pow(coordinates[k][0], 2.0) + Math.pow(coordinates[k][2], 2.0);
            inertiaTensor[2][2] = inertiaTensor[2][2] + Math.pow(coordinates[k][0], 2.0) + Math.pow(coordinates[k][1], 2.0);
            inertiaTensor[1][0] = inertiaTensor[1][0] - coordinates[k][0] * coordinates[k][1];
            inertiaTensor[2][0] = inertiaTensor[2][0] - coordinates[k][0] * coordinates[k][2];
            inertiaTensor[2][1] = inertiaTensor[2][1] - coordinates[k][1] * coordinates[k][2];
        }
        inertiaTensor[0][0] = inertiaTensor[0][0] / (double)total;
        inertiaTensor[1][1] = inertiaTensor[1][1] / (double)total;
        inertiaTensor[2][2] = inertiaTensor[2][2] / (double)total;
        inertiaTensor[1][0] = inertiaTensor[1][0] / (double)total;
        inertiaTensor[2][0] = inertiaTensor[2][0] / (double)total;
        inertiaTensor[2][1] = inertiaTensor[2][1] / (double)total;
        inertiaTensor[0][1] = inertiaTensor[1][0];
        inertiaTensor[0][2] = inertiaTensor[2][0];
        inertiaTensor[1][2] = inertiaTensor[2][1];
        Jacobi jac = new Jacobi();
        jac.diagonalisation(3, 3, inertiaTensor);
        double[][] vec = jac.getEigenvectors();
        double det = 0.0;
        block5: for (int m = 0; m <= 2; ++m) {
            for (int n = 0; n < total; ++n) {
                det = vec[0][m] * coordinates[n][0] + vec[1][m] * coordinates[n][1] + vec[2][m] * coordinates[n][2];
                if (det > 0.0) {
                    for (int i1 = 0; i1 < 3; ++i1) {
                        vec[i1][m] = -vec[i1][m];
                    }
                }
                if (det == 0.0) continue block5;
            }
        }
        double xterm = vec[0][0] * (vec[1][1] * vec[2][2] - vec[1][2] * vec[2][1]);
        double yterm = vec[1][0] * (vec[0][2] * vec[2][1] - vec[0][1] * vec[2][2]);
        double zterm = vec[2][0] * (vec[0][1] * vec[1][2] - vec[0][2] * vec[1][1]);
        det = xterm + yterm + zterm;
        if (det < 0.0) {
            for (int n = 0; n < 3; ++n) {
                vec[n][2] = -vec[n][2];
            }
        }
        int[] order = xterm > yterm && xterm > zterm ? (yterm > zterm ? new int[]{0, 1, 2} : new int[]{0, 2, 1}) : (yterm > xterm && yterm > zterm ? (xterm > zterm ? new int[]{1, 0, 2} : new int[]{1, 2, 0}) : (xterm > yterm ? new int[]{2, 0, 1} : new int[]{2, 1, 0}));
        PrincipalComponentResults results = new PrincipalComponentResults(new double[]{xterm, yterm, zterm}, order, vec, jac.getEigenvalues());
        return results;
    }

    public static double[][] orientAlongPrincipalAxis(double[][] startingCoordinates) {
        int total = startingCoordinates.length;
        double[][] resultingCoordinates = new double[total][3];
        PrincipalComponentResults results = PCA.principalComponentAnalysis(startingCoordinates);
        double[][] vec = results.getVectors();
        for (int i = 0; i < total; ++i) {
            for (int j = 0; j < 3; ++j) {
                resultingCoordinates[i][j] = vec[0][j] * startingCoordinates[i][0] + vec[1][j] * startingCoordinates[i][1] + vec[2][j] * startingCoordinates[i][2];
            }
        }
        return resultingCoordinates;
    }
}

