/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.FileMngr;

public class Parameters {
    private double gridSize;
    private int blockFactor;
    private double occupancy;
    private int minSize;
    private FileMngr files;
    private boolean atomVoting;
    private double confidenceThreshold;
    private int minimumDomains;
    private boolean saveOutput;
    private FeatureScaling featurescaling;
    private boolean scaleUnitVectors;
    private double stoppingratio;
    private SavingCriteria ratiocriteria;
    private boolean bulkMode;
    private boolean skipalign;

    public Parameters(String outfile_prefix, String infile_start, String infile_end) {
        this.setdefaults();
        this.files = new FileMngr(outfile_prefix);
        this.files.setInfile_start(infile_start);
        this.files.setInfile_end(infile_end);
    }

    public Parameters() {
        this.setdefaults();
    }

    private void setdefaults() {
        this.gridSize = 4.0;
        this.blockFactor = 2;
        this.occupancy = 0.4;
        this.minSize = 200;
        this.files = new FileMngr("out");
        this.saveOutput = true;
        this.minimumDomains = 1;
        this.atomVoting = false;
        this.featurescaling = FeatureScaling.PCA;
        this.ratiocriteria = SavingCriteria.ANYDOMAINPAIRS;
        this.scaleUnitVectors = true;
        this.bulkMode = false;
        this.skipalign = false;
    }

    public boolean isSkipalign() {
        return this.skipalign;
    }

    public void setSkipalign(boolean skipalign) {
        this.skipalign = skipalign;
    }

    public Parameters(double gridSize, int blockFactor, double occupancy, int minSize, String outfile_prefix, String infile_start, String infile_end) {
        this.setdefaults();
        this.gridSize = gridSize;
        this.blockFactor = blockFactor;
        this.occupancy = occupancy;
        this.minSize = minSize;
        this.files = new FileMngr(outfile_prefix);
        this.files.setInfile_start(infile_start);
        this.files.setInfile_end(infile_end);
    }

    public String toString() {
        if (this.bulkMode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("gridSize: ").append(this.gridSize).append("\n");
            stringBuilder.append("blockFactor: ").append(this.blockFactor).append("\n");
            stringBuilder.append("occupancy: ").append(this.occupancy).append("\n");
            stringBuilder.append("minSize: ").append(this.minSize).append("\n");
            stringBuilder.append("atomVoting: ").append(this.atomVoting).append("\n");
            stringBuilder.append("confidenceThreshold: ").append(this.confidenceThreshold).append("\n");
            stringBuilder.append("ratio: ").append(this.stoppingratio).append("\n");
            if (this.ratiocriteria == SavingCriteria.ANYDOMAINPAIRS) {
                stringBuilder.append("savingCriteria: ").append("any").append("\n");
            } else {
                stringBuilder.append("savingCriteria: ").append("all").append("\n");
            }
            return stringBuilder.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Grid size: ").append(this.gridSize).append("\n");
        sb.append("Block factor: ").append(this.blockFactor).append("\n");
        sb.append("Occupancy: ").append(this.occupancy).append("\n");
        sb.append("Minimum domain size: ").append(this.minSize).append(" atoms\n");
        char[] av = String.valueOf(this.atomVoting).toCharArray();
        av[0] = Character.toUpperCase(av[0]);
        sb.append("Atom voting: ").append(av).append("\n");
        sb.append("Bending threshold: ").append(this.confidenceThreshold).append("\n");
        sb.append("Minimum ratio of external to internal motion: ").append(this.stoppingratio).append("\n");
        return sb.toString();
    }

    public void setBulkMode(boolean bulkMode) {
        this.bulkMode = bulkMode;
    }

    public boolean isBulkMode() {
        return this.bulkMode;
    }

    public FileMngr getFiles() {
        return this.files;
    }

    public SavingCriteria getRatiocriteria() {
        return this.ratiocriteria;
    }

    public void setRatiocriteria(SavingCriteria ratiocriteria) {
        this.ratiocriteria = ratiocriteria;
    }

    public void setStoppingratio(double stoppingratio) {
        this.stoppingratio = stoppingratio;
    }

    public double getStoppingratio() {
        return this.stoppingratio;
    }

    public boolean isScaleUnitVectors() {
        return this.scaleUnitVectors;
    }

    public void setScaleUnitVectors(boolean scaleUnitVectors) {
        this.scaleUnitVectors = scaleUnitVectors;
    }

    public void setOccupancy(double occupancy) {
        this.occupancy = occupancy;
    }

    public void setFeaturescaling(FeatureScaling featurescaling) {
        this.featurescaling = featurescaling;
    }

    public FeatureScaling getFeaturescaling() {
        return this.featurescaling;
    }

    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public boolean isAtomVoting() {
        return this.atomVoting;
    }

    public void setAtomVoting(boolean atomVoting) {
        this.atomVoting = atomVoting;
    }

    public void setConfidenceThreshold(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public void setMinimumDomains(int minimumDomains) {
        this.minimumDomains = minimumDomains;
    }

    public int getMinimumDomains() {
        return this.minimumDomains;
    }

    public int getBlockFactor() {
        return this.blockFactor;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public double getOccupancy() {
        return this.occupancy;
    }

    public boolean getSaveOutput() {
        return this.saveOutput;
    }

    public void setSaveOutput(boolean saveOutput) {
        this.saveOutput = saveOutput;
    }

    public static enum SavingCriteria {
        ALLDOMAINPAIRS,
        ANYDOMAINPAIRS;

    }

    public static enum FeatureScaling {
        NONE,
        SIMPLE,
        PCA;

    }
}

