/*
 * Decompiled with CFR 0.152.
 */
package dyndom3D;

import dyndom3D.Block;
import dyndom3D.Domain;
import dyndom3D.DomainBuilder;
import dyndom3D.Parameters;
import dyndom3D.Vote;
import dyndom3D.VoteResults;
import java.util.ArrayList;
import java.util.HashSet;

public class VoteMngr {
    private final double[][] startCoordinates;
    private final double[][] endCoordinates;
    private final int[] residues;
    private int[] residueDomains;
    private ArrayList<Integer>[] all_indices;
    private double[] residueConfidence;
    private double[] atomConfidence;
    private final ArrayList<Block> blocks;
    private int[] atomClusterIds;
    private ArrayList<Domain> domains;
    private Parameters params;

    public VoteMngr(double[][] startCoordinates, double[][] endCoordinates, int[] residues, ArrayList<Block> blocks, Parameters params) {
        this.startCoordinates = startCoordinates;
        this.endCoordinates = endCoordinates;
        this.residues = residues;
        this.blocks = blocks;
        this.domains = new ArrayList();
        this.residueDomains = null;
        this.params = params;
    }

    private int getMaxVotes(ArrayList<Vote> votemngrs) {
        int maxVotes = 0;
        for (int i = 0; i < votemngrs.size(); ++i) {
            int thisVotes = votemngrs.get(i).getVotes().size();
            if (thisVotes <= maxVotes) continue;
            maxVotes = thisVotes;
        }
        return maxVotes;
    }

    public int[] holdVotes(int k, int[] blockClusterIds) {
        int j;
        int i;
        this.atomClusterIds = new int[this.startCoordinates.length];
        this.atomConfidence = new double[this.startCoordinates.length];
        ArrayList<Vote> votemngrs = new ArrayList<Vote>();
        for (i = 0; i < this.atomClusterIds.length; ++i) {
            votemngrs.add(new Vote());
        }
        for (i = 0; i < blockClusterIds.length; ++i) {
            Block block = this.blocks.get(i);
            ArrayList<Integer> indices = block.getAtmList();
            for (Integer ind : indices) {
                ((Vote)votemngrs.get(ind)).vote(blockClusterIds[i] + 1);
            }
        }
        for (i = 0; i < this.startCoordinates.length; ++i) {
            Vote vm = (Vote)votemngrs.get(i);
            VoteResults vr = vm.modeVote(false);
            int tempClusterId = vr.getModeVote();
            this.atomConfidence[i] = vm.getVotes().isEmpty() ? 0.0 : (double)(vr.getNumMostVotes() / vm.getVotes().size());
            if (this.atomConfidence[i] < this.params.getConfidenceThreshold()) {
                tempClusterId = k + 1;
            }
            this.atomClusterIds[i] = tempClusterId;
        }
        ArrayList<DomainBuilder> provdomainbuilders = new ArrayList<DomainBuilder>();
        this.domains = new ArrayList();
        for (j = 0; j <= k; ++j) {
            DomainBuilder domain = new DomainBuilder(j);
            provdomainbuilders.add(domain);
        }
        for (j = 0; j < this.startCoordinates.length; ++j) {
            if (this.atomClusterIds[j] > k) continue;
            ((DomainBuilder)provdomainbuilders.get(this.atomClusterIds[j])).addSet(this.startCoordinates[j], this.endCoordinates[j], j);
        }
        for (j = 0; j <= k; ++j) {
            this.domains.add(((DomainBuilder)provdomainbuilders.get(j)).build());
        }
        this.smooth();
        return this.atomClusterIds;
    }

    public int[] holdVotes(int k, int[] blockClusterIds, int[] residues) {
        int m;
        int i;
        HashSet<Integer> unq_res = new HashSet<Integer>();
        for (int b = 0; b < residues.length; ++b) {
            unq_res.add(residues[b]);
        }
        this.residueDomains = new int[unq_res.size()];
        this.residueConfidence = new double[unq_res.size()];
        this.atomClusterIds = new int[this.startCoordinates.length];
        this.atomConfidence = new double[this.startCoordinates.length];
        ArrayList<Vote> votemngrs = new ArrayList<Vote>();
        for (i = 0; i < this.residueConfidence.length; ++i) {
            votemngrs.add(new Vote());
        }
        for (i = 0; i < blockClusterIds.length; ++i) {
            Block block = this.blocks.get(i);
            ArrayList<Integer> indices = block.getAtmList();
            for (Integer ind : indices) {
                ((Vote)votemngrs.get(residues[ind])).vote(blockClusterIds[i] + 1);
            }
        }
        for (i = 0; i < this.residueConfidence.length; ++i) {
            Vote vm = (Vote)votemngrs.get(i);
            VoteResults vr = vm.modeVote(false);
            int tempResDomain = vr.getModeVote();
            this.residueConfidence[i] = vm.getVotes().isEmpty() ? 0.0 : (double)vr.getNumMostVotes() / (double)vm.getVotes().size();
            if (this.residueConfidence[i] < this.params.getConfidenceThreshold()) {
                tempResDomain = k + 1;
            }
            this.residueDomains[i] = tempResDomain;
        }
        for (i = 0; i < residues.length; ++i) {
            this.atomClusterIds[i] = this.residueDomains[residues[i]];
            this.atomConfidence[i] = this.residueConfidence[residues[i]];
        }
        ArrayList<DomainBuilder> provdomainbuilders = new ArrayList<DomainBuilder>();
        this.domains = new ArrayList();
        for (m = 0; m <= k; ++m) {
            DomainBuilder domain = new DomainBuilder(m);
            provdomainbuilders.add(domain);
        }
        for (m = 0; m < this.startCoordinates.length; ++m) {
            if (this.atomClusterIds[m] > k) continue;
            ((DomainBuilder)provdomainbuilders.get(this.atomClusterIds[m])).addSet(this.startCoordinates[m], this.endCoordinates[m], m);
        }
        for (m = 0; m <= k; ++m) {
            this.domains.add(((DomainBuilder)provdomainbuilders.get(m)).build());
        }
        this.smooth();
        return this.atomClusterIds;
    }

    public double[] getAtomConfidence() {
        return this.atomConfidence;
    }

    public ArrayList<Domain> getDomains() {
        return this.domains;
    }

    public int[] getAtomClusterIds() {
        return this.atomClusterIds;
    }

    private void smooth() {
    }

    public int[] getResidueDomains() {
        return this.residueDomains;
    }

    public int[] getResidues() {
        return this.residues;
    }

    public double[] getResidueConfidence() {
        return this.residueConfidence;
    }

    public ArrayList<Integer>[] getAll_indices() {
        return this.all_indices;
    }
}

