/*
 * Decompiled with CFR 0.152.
 */
package global;

import PDBTool.AminoAcid;
import PDBTool.Atom;
import PDBTool.Chain;
import dyndom3D.Engine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalIncludes {
    public static final String site_path = "/local/dyndom2/dyndom3d-webapp/";
    public static final String pdb_tmp = "/dyndom/home/dyndom/tmp/";
    public static final String dyndom_tmp = "/dyndom/home/dyndom/dyndom3d-webapp/dyndom_tmp/";
    public static final String dyndom_archive = "/dyndom/home/dyndom/dyndom3d-webapp/dyndom_archive/";
    public static final String path_jmol = "/dyndom/home/dyndom/dyndom3d-webapp/jmol/";
    public static final String pdb_repo = "/dyndom/home/dyndom/PDB-ebi-mirror/pdb/";
    public static final String web_path = "/dyndom/3D/";
    public static final boolean clean_errors = true;
    public static final boolean linux_environment = true;
    public static final String[] domain_colours = new String[]{"white", "red", "yellow", "violet", "cyan", "blue", "magenta", "purple", "steel blue", "orange", "red", "orange", "lime green", "pink", "coral", "dark grey", "saddle brown", "deep pink", "wheat", "bisque", "mint cream", "lavender", "dark olive green", "cornflower blue", "pale turquoise", "light pink", "medium turquoise"};

    public static double[][] deepClone(double[][] arr) {
        double[][] clone = (double[][])arr.clone();
        for (int i = 0; i < arr.length; ++i) {
            clone[i] = (double[])arr[i].clone();
        }
        return clone;
    }

    public static void sendEmail(String body, Exception exception, String subject) {
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            body = body + sw.toString();
        }
    }

    private static Chain buildChain(double[][] coordinates, int b) {
        Chain chain = new Chain("A", new ArrayList<AminoAcid>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<AminoAcid>(), "");
        for (int j = 0; j < coordinates.length; ++j) {
            StringBuilder strb = new StringBuilder();
            int i = 0;
            strb.append("    ");
            double x = coordinates[j][0];
            double y = coordinates[j][1];
            double z = coordinates[j][2];
            strb.append(String.format("%8.3f", x));
            strb.append(String.format("%8.3f", y));
            strb.append(String.format("%8.3f", z));
            strb.append("     ");
            strb.append(String.format("%6.2f", b));
            ArrayList<Atom> atomlist = new ArrayList<Atom>();
            String chainStr = "A";
            Atom atom = new Atom("ATOM", "" + i, "CA", " ", "GLY", chainStr, "" + i, strb.toString(), x, y, z);
            atom.setCluster(b);
            atomlist.add(atom);
            chain.allAminos.add(new AminoAcid("" + i, "GLY", atomlist, true));
        }
        return chain;
    }

    public static void writeFile(String fileName, StringBuilder sb) {
        try {
            FileWriter fstream = new FileWriter(fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(sb.toString());
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    public static void writeCsv(String fileName, double[][] data) {
        StringBuilder sb = new StringBuilder();
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double cell : row = dArray[i]) {
                sb.append(cell).append("\t");
            }
            sb.append("\n");
        }
        GlobalIncludes.writeFile(fileName, sb);
    }

    public static void writeCsv(String fileName, double[] data) {
        StringBuilder sb = new StringBuilder();
        for (double cell : data) {
            sb.append(cell).append("\t");
        }
        GlobalIncludes.writeFile(fileName, sb);
    }
}

