/*
 * Decompiled with CFR 0.152.
 */
package ui;

import dd3d.rebuilt.DD3DRebuilt;
import dyndom3D.Parameters;
import dyndom3D.RunResults;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import ui.DoubleSpinner;

public class Mainform
extends JFrame {
    private JFileChooser fc;
    private boolean hasRun = false;
    private Parameters lastrunparams = new Parameters();
    private JRadioButton allsaving;
    private JRadioButton anysaving;
    private JSpinner blockFactor;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JSpinner confthres;
    private JLabel fileLocationLabel;
    private Box.Filler filler2;
    private JTextField firstStructure;
    private JButton firstStructureButton;
    private JRadioButton fsnone;
    private JRadioButton fspca;
    private JSpinner gridSize;
    private JPanel inputtab;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JSpinner minSize;
    private JSpinner occupancy;
    private JButton openEnd;
    private JButton openPymol;
    private JButton openStart;
    private JTextField output;
    private JPanel outputtab;
    private JTextField pymolDir;
    private JButton pymolDirButton;
    private JTextArea reportArea;
    private JButton runSingle;
    private JTextField secondStructure;
    private JButton secondStructureButton;
    private JRadioButton voteAtom;
    private JRadioButton voteResidue;

    public Mainform() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.filler2 = new Box.Filler(new Dimension(3, 0), new Dimension(3, 0), new Dimension(3, Short.MAX_VALUE));
        this.jTabbedPane1 = new JTabbedPane();
        this.inputtab = new JPanel();
        this.firstStructure = new JTextField();
        this.firstStructureButton = new JButton();
        this.secondStructure = new JTextField();
        this.secondStructureButton = new JButton();
        this.jLabel1 = new JLabel();
        this.gridSize = new DoubleSpinner(4.0, 0.0, 100.0, 0.1);
        this.jLabel2 = new JLabel();
        this.blockFactor = new JSpinner();
        this.jLabel3 = new JLabel();
        this.occupancy = new DoubleSpinner(0.4, 0.0, 1.0, 0.01);
        this.jLabel4 = new JLabel();
        this.minSize = new JSpinner();
        this.confthres = new DoubleSpinner(0.51, 0.0, 1.0, 0.01);
        this.jLabel6 = new JLabel();
        this.runSingle = new JButton();
        this.voteResidue = new JRadioButton();
        this.voteAtom = new JRadioButton();
        this.fsnone = new JRadioButton();
        this.fspca = new JRadioButton();
        this.output = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.anysaving = new JRadioButton();
        this.allsaving = new JRadioButton();
        this.outputtab = new JPanel();
        this.jPanel4 = new JPanel();
        this.pymolDir = new JTextField();
        this.pymolDirButton = new JButton();
        this.jLabel7 = new JLabel();
        this.openEnd = new JButton();
        this.openStart = new JButton();
        this.jLabel8 = new JLabel();
        this.fileLocationLabel = new JLabel();
        this.openPymol = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.reportArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("DynDom6D");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                Mainform.this.formWindowOpened(evt);
            }
        });
        this.firstStructure.setFocusable(false);
        this.firstStructureButton.setText("First file...");
        this.firstStructureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.firstStructureButtonActionPerformed(evt);
            }
        });
        this.secondStructure.setFocusable(false);
        this.secondStructureButton.setText("Second file...");
        this.secondStructureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.secondStructureButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Grid Size (\u00c5)");
        this.gridSize.setValue(4.0);
        this.jLabel2.setText("Block Factor");
        this.blockFactor.setValue(2);
        this.jLabel3.setText("Occupancy");
        this.occupancy.setValue(0.4);
        this.jLabel4.setText("Min Domain Size (number of atoms)");
        this.minSize.setValue(200);
        this.confthres.setValue(0.51);
        this.jLabel6.setText("Bending Threshold");
        this.runSingle.setText("Run DynDom6D");
        this.runSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.runSingleActionPerformed(evt);
            }
        });
        this.voteResidue.setSelected(true);
        this.voteResidue.setText("Residue");
        this.voteResidue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.voteResidueActionPerformed(evt);
            }
        });
        this.voteAtom.setText("Atom");
        this.voteAtom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.voteAtomActionPerformed(evt);
            }
        });
        this.fsnone.setText("No feature scaling");
        this.fsnone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.fsnoneActionPerformed(evt);
            }
        });
        this.fspca.setSelected(true);
        this.fspca.setText("Feature scaling");
        this.fspca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.fspcaActionPerformed(evt);
            }
        });
        this.output.setText("out");
        this.jLabel5.setText("Output filename prefix");
        this.jLabel9.setText("Assign domains to each atom or to each residue?");
        this.jLabel10.setText("Perform feature scaling?");
        this.jLabel11.setText("Criteria for saving clustering results:");
        this.anysaving.setText("ANY domain pair meets ratio");
        this.anysaving.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.anysavingActionPerformed(evt);
            }
        });
        this.allsaving.setSelected(true);
        this.allsaving.setText("ALL domain pairs meet ratio");
        this.allsaving.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.allsavingActionPerformed(evt);
            }
        });
        GroupLayout inputtabLayout = new GroupLayout(this.inputtab);
        this.inputtab.setLayout(inputtabLayout);
        inputtabLayout.setHorizontalGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputtabLayout.createSequentialGroup().addContainerGap().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputtabLayout.createSequentialGroup().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runSingle, -1, -1, Short.MAX_VALUE).addGroup(inputtabLayout.createSequentialGroup().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.firstStructure).addComponent(this.secondStructure)).addGap(8, 8, 8).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secondStructureButton).addComponent(this.firstStructureButton, -2, 97, -2))).addComponent(this.jLabel9).addGroup(inputtabLayout.createSequentialGroup().addComponent(this.fsnone).addGap(76, 76, 76).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.voteResidue).addComponent(this.fspca)))).addContainerGap()).addGroup(inputtabLayout.createSequentialGroup().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.voteAtom).addComponent(this.jLabel5).addComponent(this.jLabel11).addGroup(inputtabLayout.createSequentialGroup().addComponent(this.anysaving).addGap(28, 28, 28).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allsaving).addComponent(this.output, -2, 123, -2))).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, inputtabLayout.createSequentialGroup().addComponent(this.jLabel6, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.confthres, -2, 67, -2)).addGroup(GroupLayout.Alignment.LEADING, inputtabLayout.createSequentialGroup().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 92, -2).addComponent(this.jLabel2, -2, 92, -2).addComponent(this.jLabel3, -2, 92, -2).addComponent(this.jLabel4)).addGap(39, 39, 39).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minSize, -2, 67, -2).addComponent(this.occupancy, -2, 67, -2).addComponent(this.blockFactor, -2, 67, -2).addComponent(this.gridSize, GroupLayout.Alignment.LEADING, -2, 67, -2))))).addGap(0, 0, Short.MAX_VALUE)))));
        inputtabLayout.setVerticalGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputtabLayout.createSequentialGroup().addContainerGap().addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.firstStructure, -2, -1, -2).addComponent(this.firstStructureButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secondStructure, -2, -1, -2).addComponent(this.secondStructureButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gridSize, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.blockFactor, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.occupancy, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minSize, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.confthres, -2, -1, -2)).addGap(15, 15, 15).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.voteAtom).addComponent(this.voteResidue)).addGap(15, 15, 15).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fsnone).addComponent(this.fspca)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.anysaving).addComponent(this.allsaving)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputtabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.output, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runSingle, -2, 38, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Input", this.inputtab);
        this.pymolDir.setFocusable(false);
        this.pymolDirButton.setText("Pymol .exe...");
        this.pymolDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.pymolDirButtonActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Select a Pymol executable to open output files");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.pymolDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pymolDirButton)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pymolDir, -2, -1, -2).addComponent(this.pymolDirButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.openEnd.setText("Open end structure");
        this.openEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.openEndActionPerformed(evt);
            }
        });
        this.openStart.setText("Open start structure");
        this.openStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.openStartActionPerformed(evt);
            }
        });
        this.jLabel8.setText("DynDom6D run completed. Report saved to:");
        this.fileLocationLabel.setText("file-location");
        this.openPymol.setText("Open Pymol session");
        this.openPymol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Mainform.this.openPymolActionPerformed(evt);
            }
        });
        this.reportArea.setEditable(false);
        this.reportArea.setColumns(20);
        this.reportArea.setLineWrap(true);
        this.reportArea.setRows(5);
        this.jScrollPane1.setViewportView(this.reportArea);
        GroupLayout outputtabLayout = new GroupLayout(this.outputtab);
        this.outputtab.setLayout(outputtabLayout);
        outputtabLayout.setHorizontalGroup(outputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputtabLayout.createSequentialGroup().addContainerGap().addGroup(outputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputtabLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.fileLocationLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, outputtabLayout.createSequentialGroup().addGroup(outputtabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.openPymol, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.openStart, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.openEnd, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, outputtabLayout.createSequentialGroup().addComponent(this.jLabel8).addGap(0, 382, Short.MAX_VALUE))).addContainerGap()))));
        outputtabLayout.setVerticalGroup(outputtabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputtabLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileLocationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openPymol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openEnd).addContainerGap()));
        this.jTabbedPane1.addTab("Output", this.outputtab);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jTabbedPane1, -1, 620, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler2, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(202, 202, 202).addComponent(this.filler2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jTabbedPane1));
        this.jTabbedPane1.remove(this.outputtab);
        this.pack();
    }

    private String chooseFolder() {
        this.fc.setFileSelectionMode(1);
        String result = this.chooseFile();
        this.fc.setFileSelectionMode(0);
        return result;
    }

    private String chooseFile() {
        String result = "";
        int returnVal = this.fc.showOpenDialog(this.jPanel4);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            result = file.getAbsolutePath();
        }
        return result;
    }

    private void pymolDirButtonActionPerformed(ActionEvent evt) {
        this.pymolDir.setText(this.chooseFile());
    }

    private void formWindowOpened(WindowEvent evt) {
        this.fc = new JFileChooser();
        this.fc.setPreferredSize(new Dimension(850, 600));
        this.fc.setCurrentDirectory(new File("."));
        File settings = new File("dd3d-settings.ini");
        if (settings.exists()) {
            try {
                Scanner scan = new Scanner(settings);
                while (scan.hasNext()) {
                    String[] parts;
                    String line = scan.nextLine();
                    if (!line.contains("=") || (parts = line.split("=")).length != 2) continue;
                    switch (parts[0]) {
                        case "pymoldir": {
                            this.pymolDir.setText(parts[1]);
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
            }
        }
    }

    private void openStartActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec(this.pymolDir.getText() + " " + this.lastrunparams.getFiles().getOutfile_start());
        }
        catch (IOException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    private void openEndActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec(this.pymolDir.getText() + " " + this.lastrunparams.getFiles().getOutfile_end());
        }
        catch (IOException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    private void fspcaActionPerformed(ActionEvent evt) {
        this.fsnone.setSelected(false);
        this.fspca.setSelected(true);
    }

    private void fsnoneActionPerformed(ActionEvent evt) {
        this.fsnone.setSelected(true);
        this.fspca.setSelected(false);
    }

    private void voteAtomActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("disable")) {
            this.voteAtom.setSelected(false);
            this.voteResidue.setSelected(true);
        } else {
            this.voteAtom.setSelected(true);
            this.voteResidue.setSelected(false);
        }
    }

    private void voteResidueActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("disable")) {
            this.voteAtom.setSelected(true);
            this.voteResidue.setSelected(false);
        } else {
            this.voteAtom.setSelected(false);
            this.voteResidue.setSelected(true);
        }
    }

    private void runSingleActionPerformed(ActionEvent evt) {
        Parameters params = new Parameters((Double)this.gridSize.getValue(), (Integer)this.blockFactor.getValue(), (Double)this.occupancy.getValue(), (Integer)this.minSize.getValue(), this.output.getText(), this.firstStructure.getText(), this.secondStructure.getText());
        params.setAtomVoting(this.voteAtom.isSelected());
        params.setConfidenceThreshold((Double)this.confthres.getValue());
        if (this.anysaving.isSelected()) {
            params.setRatiocriteria(Parameters.SavingCriteria.ANYDOMAINPAIRS);
        } else {
            params.setRatiocriteria(Parameters.SavingCriteria.ALLDOMAINPAIRS);
        }
        Parameters.FeatureScaling fs = this.fspca.isSelected() ? Parameters.FeatureScaling.PCA : Parameters.FeatureScaling.NONE;
        params.setFeaturescaling(fs);
        params.setStoppingratio(1.0);
        params.setScaleUnitVectors(true);
        if (params.getFiles().readyToGo()) {
            RunResults result = DD3DRebuilt.runSingle(params);
            this.lastrunparams = params;
            this.hasRun = true;
            this.jTabbedPane1.addTab("Output", this.outputtab);
            this.jTabbedPane1.setSelectedIndex(1);
            this.fileLocationLabel.setText(new File(params.getFiles().getOutfile_report()).getAbsolutePath());
            this.reportArea.setText(result.getReport_text());
            this.reportArea.setCaretPosition(0);
            this.openPymol.setEnabled(result.wasSuccessful());
            this.openStart.setEnabled(result.wasSuccessful());
            this.openEnd.setEnabled(result.wasSuccessful());
        }
    }

    private boolean validFile(String chosenFile, String[] possibleExtensions) {
        if (chosenFile.isEmpty()) {
            return true;
        }
        int period = chosenFile.lastIndexOf(".");
        if (period == -1) {
            int optres = JOptionPane.showConfirmDialog(this, "This file does not seem to have a file extension.\nAre you sure you want to proceed using:\n" + chosenFile + "?");
            return optres == 0;
        }
        String fileext = chosenFile.substring(period + 1);
        boolean isvalid = false;
        for (String ext : possibleExtensions) {
            if (!ext.equalsIgnoreCase(fileext)) continue;
            isvalid = true;
        }
        if (!isvalid) {
            int optres = JOptionPane.showConfirmDialog(this, "This file has an unexpected file extension (" + fileext + ").\nAre you sure you want to proceed using:\n" + chosenFile + "?");
            isvalid = optres == 0;
        }
        return isvalid;
    }

    private void secondStructureButtonActionPerformed(ActionEvent evt) {
        String filename = this.chooseFile();
        boolean validname = this.validFile(filename, new String[]{"pdb", "ent", "cif"});
        if (validname) {
            this.secondStructure.setText(filename);
        }
    }

    private void firstStructureButtonActionPerformed(ActionEvent evt) {
        String filename = this.chooseFile();
        boolean validname = this.validFile(filename, new String[]{"pdb", "ent", "cif"});
        if (validname) {
            this.firstStructure.setText(filename);
        }
    }

    private void openPymolActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec(this.pymolDir.getText() + " " + this.lastrunparams.getFiles().getOutfile_session());
        }
        catch (IOException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
    }

    private void anysavingActionPerformed(ActionEvent evt) {
        this.allsaving.setSelected(false);
    }

    private void allsavingActionPerformed(ActionEvent evt) {
        this.anysaving.setSelected(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Mainform.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Mainform().setVisible(true);
            }
        });
    }
}

