/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.interfaces;

import java.util.Iterator;
import java.util.Set;
import org.jgrapht.Graph;

public interface MinimumVertexCoverAlgorithm<V, E> {
    public VertexCover<V> getVertexCover(Graph<V, E> var1);

    public static class VertexCoverImpl<V>
    implements VertexCover<V> {
        protected Set<V> cover;
        protected double weight;

        public VertexCoverImpl(Set<V> cover, double weight) {
            this.cover = cover;
            this.weight = weight;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public Set<V> getVertices() {
            return this.cover;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Cover(");
            builder.append(this.getWeight());
            builder.append("): ");
            builder.append(this.getVertices().toString());
            return builder.toString();
        }
    }

    public static interface VertexCover<V>
    extends Iterable<V> {
        public double getWeight();

        public Set<V> getVertices();

        @Override
        default public Iterator<V> iterator() {
            return this.getVertices().iterator();
        }
    }
}

