/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import org.rcsb.mmtf.codec.ArrayConverters;
import org.rcsb.mmtf.codec.CodecInterface;
import org.rcsb.mmtf.codec.FloatCodecInterface;
import org.rcsb.mmtf.codec.OptionParser;
import org.rcsb.mmtf.decoder.ArrayDecoders;
import org.rcsb.mmtf.encoder.ArrayEncoders;

public enum FloatCodecs implements FloatCodecInterface,
CodecInterface
{
    INT_DELTA_RECURSIVE(10, "Delta"){

        @Override
        public byte[] encode(float[] inputData, int param) {
            return ArrayConverters.convertIntegersToTwoBytes(ArrayConverters.recursiveIndexEncode(ArrayEncoders.deltaEncode(ArrayConverters.convertFloatsToInts(inputData, param))));
        }

        @Override
        public float[] decode(byte[] inputData, int param) {
            int[] intArr = ArrayDecoders.deltaDecode(ArrayConverters.recursiveIndexDecode(ArrayConverters.convertTwoByteToIntegers(inputData)));
            return ArrayConverters.convertIntsToFloats(intArr, param);
        }
    }
    ,
    INT_RUNLENGTH(9, "Run length"){

        @Override
        public byte[] encode(float[] inputData, int param) {
            return ArrayConverters.convertIntegersToFourByte(ArrayEncoders.runlengthEncode(ArrayConverters.convertFloatsToInts(inputData, param)));
        }

        @Override
        public float[] decode(byte[] inputData, int param) {
            return ArrayConverters.convertIntsToFloats(ArrayDecoders.runlengthDecode(ArrayConverters.convertFourByteToIntegers(inputData)), param);
        }
    };

    private final int codecId;
    private final String codecName;

    private FloatCodecs(int codecId, String codecName) {
        this.codecId = codecId;
        this.codecName = codecName;
    }

    public static FloatCodecs getCodec(int codecId) {
        for (FloatCodecs codecs : FloatCodecs.values()) {
            if (codecId != codecs.codecId) continue;
            return codecs;
        }
        throw new IllegalArgumentException(codecId + " not recognised as codec strategy.");
    }

    public static float[] decodeArr(byte[] inputData) {
        OptionParser optionParser = new OptionParser(inputData);
        FloatCodecs codecs = FloatCodecs.getCodec(optionParser.methodNumber);
        return codecs.decode(optionParser.data, optionParser.param);
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public int getCodecId() {
        return this.codecId;
    }
}

