/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.decoder;

import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;

public class DecoderUtils {
    public static void generateBioAssembly(StructureDataInterface dataApi, StructureAdapterInterface structInflator) {
        for (int i = 0; i < dataApi.getNumBioassemblies(); ++i) {
            for (int j = 0; j < dataApi.getNumTransInBioassembly(i); ++j) {
                structInflator.setBioAssemblyTrans(i, dataApi.getChainIndexListForTransform(i, j), dataApi.getMatrixForTransform(i, j), Integer.toString(i + 1));
            }
        }
    }

    public static void addInterGroupBonds(StructureDataInterface dataApi, StructureAdapterInterface structInflator) {
        for (int i = 0; i < dataApi.getInterGroupBondOrders().length; ++i) {
            structInflator.setInterGroupBond(dataApi.getInterGroupBondIndices()[i * 2], dataApi.getInterGroupBondIndices()[i * 2 + 1], dataApi.getInterGroupBondOrders()[i]);
        }
    }

    public static void addHeaderInfo(StructureDataInterface dataApi, StructureAdapterInterface structInflator) {
        structInflator.setHeaderInfo(dataApi.getRfree(), dataApi.getRwork(), dataApi.getResolution(), dataApi.getTitle(), dataApi.getDepositionDate(), dataApi.getReleaseDate(), dataApi.getExperimentalMethods());
    }

    public static void addXtalographicInfo(StructureDataInterface dataApi, StructureAdapterInterface structInflator) {
        if (dataApi.getUnitCell() != null) {
            structInflator.setXtalInfo(dataApi.getSpaceGroup(), dataApi.getUnitCell(), dataApi.getNcsOperatorList());
        }
    }

    public static void addEntityInfo(StructureDataInterface dataApi, StructureAdapterInterface structInflator) {
        for (int i = 0; i < dataApi.getNumEntities(); ++i) {
            structInflator.setEntityInfo(dataApi.getEntityChainIndexList(i), dataApi.getEntitySequence(i), dataApi.getEntityDescription(i), dataApi.getEntityType(i));
        }
    }
}

