/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.decoder;

import java.io.Serializable;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.decoder.DecoderUtils;

public class StructureDataToAdapter
implements Serializable {
    private static final long serialVersionUID = 1304850018382353781L;
    private StructureAdapterInterface structInflator;
    private StructureDataInterface dataApi;
    private int modelCounter = 0;
    private int chainCounter = 0;
    private int groupCounter = 0;
    private int atomInGroupCounter = 0;
    private int atomInStructureCounter = 0;

    public StructureDataToAdapter(StructureDataInterface inputApi, StructureAdapterInterface inputInflator) {
        this.dataApi = inputApi;
        this.structInflator = inputInflator;
        this.structInflator.initStructure(this.dataApi.getNumBonds(), this.dataApi.getNumAtoms(), this.dataApi.getNumGroups(), this.dataApi.getNumChains(), this.dataApi.getNumModels(), this.dataApi.getStructureId());
        this.addAtomicInformation();
        DecoderUtils.addHeaderInfo(this.dataApi, this.structInflator);
        DecoderUtils.addXtalographicInfo(this.dataApi, this.structInflator);
        DecoderUtils.generateBioAssembly(this.dataApi, this.structInflator);
        DecoderUtils.addInterGroupBonds(this.dataApi, this.structInflator);
        DecoderUtils.addEntityInfo(this.dataApi, this.structInflator);
        this.structInflator.finalizeStructure();
    }

    private void addAtomicInformation() {
        for (int modelChains : this.dataApi.getChainsPerModel()) {
            int lastChainCounter;
            this.structInflator.setModelInfo(this.modelCounter, modelChains);
            int totChainsThisModel = this.chainCounter + modelChains;
            for (int chainIndex = lastChainCounter = this.chainCounter; chainIndex < totChainsThisModel; ++chainIndex) {
                this.addOrUpdateChainInfo(chainIndex);
            }
            ++this.modelCounter;
        }
    }

    private void addOrUpdateChainInfo(int chainIndex) {
        int lastGroupCount;
        String currentChainId = this.dataApi.getChainIds()[chainIndex];
        String currentChainName = this.dataApi.getChainNames()[chainIndex];
        int groupsThisChain = this.dataApi.getGroupsPerChain()[chainIndex];
        this.structInflator.setChainInfo(currentChainId, currentChainName, groupsThisChain);
        int nextInd = this.groupCounter + groupsThisChain;
        for (int currentGroupNumber = lastGroupCount = this.groupCounter; currentGroupNumber < nextInd; ++currentGroupNumber) {
            this.addGroup(currentGroupNumber);
            ++this.groupCounter;
        }
        ++this.chainCounter;
    }

    private int addGroup(int currentGroupIndex) {
        int groupInd = this.dataApi.getGroupTypeIndices()[currentGroupIndex];
        int atomCount = this.dataApi.getNumAtomsInGroup(groupInd);
        int currentGroupNumber = this.dataApi.getGroupIds()[currentGroupIndex];
        char insertionCode = this.dataApi.getInsCodes()[currentGroupIndex];
        this.structInflator.setGroupInfo(this.dataApi.getGroupName(groupInd), currentGroupNumber, insertionCode, this.dataApi.getGroupChemCompType(groupInd), atomCount, this.dataApi.getNumBonds(), this.dataApi.getGroupSingleLetterCode(groupInd), this.dataApi.getGroupSequenceIndices()[currentGroupIndex], this.dataApi.getSecStructList()[currentGroupIndex]);
        this.atomInGroupCounter = 0;
        for (int i = 0; i < atomCount; ++i) {
            this.addAtomData(this.dataApi.getGroupAtomNames(groupInd), this.dataApi.getGroupElementNames(groupInd), this.dataApi.getGroupAtomCharges(groupInd), this.atomInStructureCounter);
            ++this.atomInStructureCounter;
            ++this.atomInGroupCounter;
        }
        this.addGroupBonds(this.dataApi.getGroupBondIndices(groupInd), this.dataApi.getGroupBondOrders(groupInd));
        return atomCount;
    }

    private void addAtomData(String[] atomNames, String[] elementNames, int[] atomCharges, int currentAtomIndex) {
        String atomName = atomNames[this.atomInGroupCounter];
        String element = elementNames[this.atomInGroupCounter];
        int charge = atomCharges[this.atomInGroupCounter];
        char alternativeLocationId = this.dataApi.getAltLocIds()[currentAtomIndex];
        int serialNumber = this.dataApi.getAtomIds()[currentAtomIndex];
        float x = this.dataApi.getxCoords()[currentAtomIndex];
        float z = this.dataApi.getzCoords()[currentAtomIndex];
        float y = this.dataApi.getyCoords()[currentAtomIndex];
        float occupancy = this.dataApi.getOccupancies()[currentAtomIndex];
        float temperatureFactor = this.dataApi.getbFactors()[currentAtomIndex];
        this.structInflator.setAtomInfo(atomName, serialNumber, alternativeLocationId, x, y, z, occupancy, temperatureFactor, element, charge);
    }

    private void addGroupBonds(int[] bondInds, int[] bondOrders) {
        for (int thisBond = 0; thisBond < bondOrders.length; ++thisBond) {
            int thisBondOrder = bondOrders[thisBond];
            int thisBondIndOne = bondInds[thisBond * 2];
            int thisBondIndTwo = bondInds[thisBond * 2 + 1];
            this.structInflator.setGroupBond(thisBondIndOne, thisBondIndTwo, thisBondOrder);
        }
    }
}

