C
C VERSION 1.5
C
      PROGRAM DynDom 
C
C-------------------------------------------------------------
C
C SEE http://www.sys.uea.ac.uk/~sjh/DynDom/dyndom.home.html
C
C------------------------------------------------------------
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C 
      INTEGER NCLUSTER,ITER,DOMIN,WINDLEN
      INTEGER NATOT1,NATOT2,IAT,I,J
      INTEGER NRES,NBB,NRES1,NRES2,NBB1,NBB2
      INTEGER NI(NRESMX),CA(NRESMX),CB(NRESMX),CP(NRESMX)
      INTEGER IER,DOMA,DOMB,DOMSIZE(NDOMX)
      INTEGER NWIND,IDOM
      INTEGER IB,IWIND,NBBWIND
      INTEGER IRES,IAT1,IAT2,IAT3,IAT4
      INTEGER MM,NDIM
      INTEGER DMSUM1,DMSUM2,IWORK(NRESMX)
      INTEGER DOMORD(NDOMX),NDOMO,NDOM
      INTEGER NCON(NDOMX),DOMCON(NDOMX,NDOMX)
      INTEGER NSEG(NDOMX),ND(NDOMX),NND,ISEG
      INTEGER IRESBEG(NDOMX,NSEGMX),IRESEND(NDOMX,NSEGMX)
      INTEGER NAAT1(NRESMX),NAAT2(NRESMX)
      INTEGER ATLIST1(NRESMX,NAATMX),ATLIST2(NRESMX,NAATMX)
      INTEGER IN1,IN2,IOUT1,IOUT3,IOUT4,IOUT6,IOUT7
      INTEGER IEND1,IEND2  
      REAL*8 EXTCRIT,AMPTHETAV,SCALE
      REAL*8 COO1(3,NUMATMX),COO2(3,NUMATMX)
      REAL*8 COOBB1(3,NBBMX),COOBB2(3,NBBMX)
      REAL*8 COOBB1F(3,NBBMX),COOBB2F(3,NBBMX)
      REAL*8 MASS(NUMATMX),R(3,3),AC1(3),RC1(3),RMSD
      REAL*8 COBB1(3,NBBMX),COBB2(3,NBBMX)
      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF
      REAL*8 WORK(NARB),SUM(7,NRESMX,NDOMX)
      REAL*8 UNTHX,UNTHY,UNTHZ,AMPTHET(NRESMX),AMP,AMPTR,XAX,YAX,ZAX
      REAL*8 ROT(NRESMX,3),TRACER
      REAL*8 EXTINT(NDOMX,NDOMX)
      CHARACTER*4 ATYP1(NUMATMX),ATYP2(NUMATMX)
      CHARACTER*4 RESTYP1(NUMATMX),RESTYP2(NUMATMX)
      CHARACTER*5 RESNUM1(NUMATMX),RESNUM2(NUMATMX)
      CHARACTER*1 CHAINID1,CHAINID2
      CHARACTER*5 RESPDBNUM1(NRESMX),RESPDBNUM2(NRESMX)
      CHARACTER*4 RESPDBTYP1(NRESMX),RESPDBTYP2(NRESMX)
      CHARACTER*200 FILEIN1,FILEIN2 
C
      DATA MASS/NUMATMX*1.0/
C 
C READ INPUT AND INITIALIZE OUTPUT
C
      CALL INOUTPUTR(IN1,IN2,IOUT1,IOUT3,IOUT4,IOUT6,
     &   IOUT7,CHAINID1,CHAINID2,NCLUSTER,ITER,DOMIN,WINDLEN,
     &   EXTCRIT,FILEIN1,IEND1,FILEIN2,IEND2)
C
C READ IN PDB FILE OF FIRST CONFORMATION
C
      CALL READPDB(IN1,NATOT1,CHAINID1,ATYP1,RESTYP1,
     &   RESNUM1,COO1)
C
C READ IN PDB FILE OF SECOND CONFORMATION
C
      CALL READPDB(IN2,NATOT2,CHAINID2,ATYP2,RESTYP2,
     &   RESNUM2,COO2)
C
C IDENTIFY RESIDUES OF FIRST CONFORMATION
C
      CALL RESIDEN(NATOT1,RESTYP1,RESNUM1,NRES1,
     &   RESPDBNUM1,RESPDBTYP1,NAAT1,ATLIST1)
C
C IDENTIFY RESIDUES OF SECOND CONFORMATION
C
      CALL RESIDEN(NATOT2,RESTYP2,RESNUM2,NRES2,
     &   RESPDBNUM2,RESPDBTYP2,NAAT2,ATLIST2)
C
      IF(NRES1.EQ.0) THEN
        WRITE(6,'(A)')'NO RESIDUES FOUND IN 1ST CHAIN: CHECK FILE NAME A
     &ND CHAIN IDENTIFIER'
        WRITE(6,'(A)')
        STOP
      ENDIF
C
      IF(NRES2.EQ.0) THEN
        WRITE(6,'(A)')'NO RESIDUES FOUND IN 2ND CHAIN: CHECK FILE NAME A
     &ND CHAIN IDENTIFIER'
        WRITE(6,'(A)')
        STOP
      ENDIF
C
      IF(NRES1.NE.NRES2) THEN
        WRITE(6,'(A,I4,I4)')'WARNING NUMBER OF RESIDUES IN CHAINS IS DIF
     &FERENT',NRES1,NRES2
        WRITE(6,'(A)')
      ENDIF
C
      WRITE(6,'(A)')'determining backbone atoms of first conformer'
      WRITE(6,'(A)')
C
      CALL BACKBONE(ATYP1,COO1,NRES1,NAAT1,ATLIST1,
     & RESPDBNUM1,RESPDBTYP1,NBB1,COOBB1,NI,CA,CB,CP)
C
      WRITE(6,'(A)')'determining backbone atoms of second conformer'
      WRITE(6,'(A)')
C
      CALL BACKBONE(ATYP2,COO2,NRES2,NAAT2,ATLIST2,
     & RESPDBNUM2,RESPDBTYP2,NBB2,COOBB2,NI,CA,CB,CP)
C
C KEEP OLD BACKBONE COORDINATES
C
      DO 201 IB=1,NBB1
        COOBB1F(1,IB)=COOBB1(1,IB)
        COOBB1F(2,IB)=COOBB1(2,IB)
        COOBB1F(3,IB)=COOBB1(3,IB)
201   CONTINUE
C
      DO 202 IB=1,NBB2
        COOBB2F(1,IB)=COOBB2(1,IB)
        COOBB2F(2,IB)=COOBB2(2,IB)
        COOBB2F(3,IB)=COOBB2(3,IB)
202   CONTINUE
C
      IF(NBB1.LE.NBB2) THEN
        NRES=NRES1
        NBB=NBB1
      ELSE
        NRES=NRES2
        NBB=NBB2
      END IF
C
      WRITE(6,'(A,I4)')'number of residues used for analysis: ',NRES
      WRITE(6,'(A)')
C
      IF(WINDLEN.GT.NRES) THEN
        WRITE(6,'(A)')'YOUR WINDOW LENGTH IS MUCH TOO LONG'
        WRITE(6,'(A)')'THE WHOLE PROTEIN IS A DOMAIN!'
        STOP
      ENDIF
C
      IF(DOMIN.GT.NRES) THEN
        WRITE(6,'(A)')'YOUR MINIMUM DOMAIN SIZE IS MUCH TOO LONG'
        WRITE(6,'(A)')'THE WHOLE PROTEIN IS A DOMAIN!'
        STOP
      ENDIF
C
C START OFF WITH THE WHOLE PROTEIN AS A DOMAIN
C
      NDOM=1
      IDOM=1
      NSEG(1)=1
      IRESBEG(1,1)=1
      IRESEND(1,1)=NRES
C
C BEST FIT BACKBONE ATOMS FROM TWO CONFORMATIONS
C
      CALL ROTVECFIELD(NBB,NRES,IDOM,NSEG,IRESBEG,IRESEND,NI,CA,CP,CB,
     & WINDLEN,COOBB1,COOBB2,ROT,AMPTHET,AMPTHETAV,MASS,RMSD)
C
      WRITE (6,'(A,F8.3,A)') 'rmsd of whole protein best fit: ',RMSD,'A'
C
      NWIND=NRES-WINDLEN+1 
C
      DMSUM1=7
      DMSUM2=3
      MM=NRESMX
      NDIM=3
C
C DETERMINE CLUSTERS OF ROTATION VECTORS AND CORRESPONDING 
C DOMAINS THAT SATISFY CRITERIA TO BE ANALYZED FOR THE INTERDOMAIN
C MOTION
C
      CALL CLUSTER2(MM,NWIND,NDIM,ROT,NCLUSTER,
     & ITER,DMSUM1,DMSUM2,SUM,IWORK,WORK,NDOM,
     & DOMIN,NRES,WINDLEN,NAAT1,NAAT2,ATLIST1,ATLIST2,
     & COO1,COO2,IRESBEG,IRESEND,NSEG,
     & NI,CA,CP,CB,COOBB1,COOBB2,MASS,NDOMO,NCON,
     & DOMCON,DOMORD,EXTCRIT,EXTINT)
C
       IF(NDOMO.EQ.0) THEN
         WRITE(6,'(A)')'NO DYNAMIC DOMAINS FOUND'
         WRITE(6,'(A)')'IT COULD BE YOUR PROTEIN DOESNT HAVE A DOMAIN'
         WRITE(6,'(A)')'MOTION. BUT,TRY ALTERING VALUES OF PARAMETERS wi
     &ndow AND domain'
         WRITE(6,'(A)')
         GOTO 999
       ENDIF
C
C OUTPUT BOTH CONFORMERS SUPERIMPOSED ON THEIR FIXED DOMAIN IF
C THERE IS ONLY ONE FIXED DOMAIN OTHERWISE JUST OUTPUT 1ST CONFORMER
C
      IF(NDOMO.EQ.1) THEN
        DOMA=DOMORD(1) 
C
        CALL FITCONFORMERS(NBB,DOMA,NSEG,IRESBEG,IRESEND,NATOT1,NATOT2,
     &   ATYP1,ATYP2,RESTYP1,RESTYP2,FILEIN1,IEND1,FILEIN2,IEND2,
     &   CHAINID1,CHAINID2,RESNUM1,RESNUM2,NI,CA,CP,CB,COOBB1F,COOBB2F,
     &   COO1,COO2,MASS,NRES1,NAAT1,NRES,ATLIST1,WINDLEN,IOUT6)
C
      ELSEIF(NDOMO.GT.1) THEN
C
        WRITE(IOUT6,'(A10,A,A1,A1)')'Chain is: ',FILEIN1(1:IEND1),
     &'_',CHAINID1 
C
        DO 72 IAT=1,NATOT1
          WRITE(IOUT6,3000)'ATOM',IAT,ATYP1(IAT),RESTYP1(IAT),CHAINID1,
     &     RESNUM1(IAT),COO1(1,IAT),COO1(2,IAT),COO1(3,IAT)
72      CONTINUE
        WRITE(IOUT6,'(A)')'TER'
C
      ENDIF
C
C FOLLOWING COUNTS THE NUMBER OF DOMAINS AND DETERMINES THEIR SIZE
C
      DO 100 I=1,NDOMX
        ND(I)=0
100   CONTINUE
C
      DO 80 I=1,NDOMO
        DOMA=DOMORD(I)
        DOMSIZE(DOMA)=0
        DO 89 ISEG=1,NSEG(DOMA)
          DOMSIZE(DOMA)=DOMSIZE(DOMA)+IRESEND(DOMA,ISEG)-
     &IRESBEG(DOMA,ISEG)+1
89      CONTINUE
        DO 70 J=1,NCON(DOMA)
          DOMB=DOMCON(DOMA,J)
          DOMSIZE(DOMB)=0
          DO 79 ISEG=1,NSEG(DOMB)
            DOMSIZE(DOMB)=DOMSIZE(DOMB)+IRESEND(DOMB,ISEG)-
     &IRESBEG(DOMB,ISEG)+1
79        CONTINUE
          IF(EXTINT(DOMA,DOMB).GE.EXTCRIT) THEN
            ND(DOMA)=ND(DOMA)+1
            ND(DOMB)=ND(DOMB)+1
          ENDIF
70      CONTINUE
80    CONTINUE
C
      NND=0
      DO 90 I=1,NDOM
        IF(ND(I).GE.1) THEN
          NND=NND+1
        ENDIF
90    CONTINUE
C
      WRITE(IOUT1,'(A10,I3,A8)')'THERE ARE ',NND,' DOMAINS' 
C
C DETERMINE INTERDOMAIN SCREW AXES
C
      CALL HINGEAXES2(NDOM,WINDLEN,NRES,NBB,RESPDBNUM1,RESPDBTYP1,
     & NI,CA,CP,CB,NSEG,IRESBEG,IRESEND,COOBB1F,COOBB2F,
     & MASS,NDOMO,NCON,DOMCON,DOMORD,EXTINT,EXTCRIT,NRES1,CHAINID1,
     & DOMSIZE,IOUT1,IOUT3,IOUT6,IOUT7)
C
      IF(NDOMO.EQ.1) THEN
        WRITE(IOUT3,'(A7,A4,A1,A4,A1)')'select ',RESPDBNUM2(1),'-',
     &  RESPDBNUM2(NRES2),CHAINID2
        WRITE(IOUT3,'(A)')'backbone 50'
        WRITE(IOUT3,'(A)')'colour white'
        WRITE(IOUT3,'(A)')'select all'
      ENDIF
C
      WRITE(IOUT3,'(A)')'echo IF DISPLAYING "rotvecs" FILE USE SPACEFILL
     &'
C
999   CONTINUE
C
C OUTPUT OF ROTATION VECTORS
C
      SCALE=20.0/AMPTHETAV
      DO 51 IWIND=1,NWIND
        WRITE(IOUT4,2000)'ATOM','CA  ',RESPDBTYP1(IWIND+(WINDLEN/2)),
     &  CHAINID1,RESPDBNUM1(IWIND+(WINDLEN/2)),ROT(IWIND,1)*SCALE,
     &  ROT(IWIND,2)*SCALE,ROT(IWIND,3)*SCALE
51    CONTINUE
C
2000  FORMAT(A4,9X,A4,A4,A1,A5,3X,3F8.3)
3000  FORMAT(A4,2X,I5,2X,A4,A4,A1,A5,3X,3F8.3)
C
      CLOSE (IN1)
      CLOSE (IN2)
      CLOSE (IOUT1)
      CLOSE (IOUT3)
      CLOSE (IOUT4)
      CLOSE (IOUT6)
      CLOSE (IOUT7)
C 
      STOP
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward 2002
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
