C
C SUBROUTINE TO DETERMINE BACKBONE ATOMS
C
      SUBROUTINE BACKBONE(ATYP,COO,NRES,NAAT,ATLIST,
     & RESPDBNUM,RESPDBTYP,NBB,COOBB,NI,CA,CB,CP)
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      INTEGER IRES,IAT,IAA,IBB,IBBN,NRES,NBB,IBEF
      INTEGER NI(*),CA(*),CB(*),CP(*),NAAT(*),ATLIST(NRESMX,*)
      CHARACTER*2 ATYP2
      CHARACTER*4 ATYP(*)
      CHARACTER*5 RESPDBNUM(*)
      CHARACTER*4 RESPDBTYP(*)
      REAL*8 COO(3,*),COOBB(3,*)
      LOGICAL NON,NOCA,NOC,NOCB
C
      IBB=0
      IBEF=0
      DO 1 IRES=1,NRES
        NON=.TRUE.
        NOCA=.TRUE.
        NOC=.TRUE.
        NOCB=.TRUE.
        DO 2 IAA=1,NAAT(IRES)
          IAT=ATLIST(IRES,IAA)
          READ(ATYP(IAT)(1:),'(A)')ATYP2
          IF(ATYP2.EQ.'N '.AND.NON) THEN
            NON=.FALSE.
            IBB=IBEF+1
            NI(IRES)=IBB
            COOBB(1,IBB)=COO(1,IAT)
            COOBB(2,IBB)=COO(2,IAT)
            COOBB(3,IBB)=COO(3,IAT)
          ELSEIF (ATYP2.EQ.'CA'.AND.NOCA) THEN
            NOCA=.FALSE.
            IBB=IBEF+2
	    CA(IRES)=IBB
            COOBB(1,IBB)=COO(1,IAT)
            COOBB(2,IBB)=COO(2,IAT)
            COOBB(3,IBB)=COO(3,IAT)
          ELSEIF (ATYP2.EQ.'C '.AND.NOC) THEN
            NOC=.FALSE.
            IBB=IBEF+3
            CP(IRES)=IBB
            COOBB(1,IBB)=COO(1,IAT)
            COOBB(2,IBB)=COO(2,IAT)
            COOBB(3,IBB)=COO(3,IAT)
          ELSEIF (ATYP2.EQ.'CB'.AND.NOCB) THEN
            NOCB=.FALSE.
            IBB=IBEF+4
            CB(IRES)=IBB
            COOBB(1,IBB)=COO(1,IAT)
            COOBB(2,IBB)=COO(2,IAT)
            COOBB(3,IBB)=COO(3,IAT)
          ENDIF
2       CONTINUE
C
        IF(NON) THEN
          WRITE(6,'(A,A5)')'BACKBONE NITROGEN MISSING; RESIDUE:',
     &     RESPDBNUM(IRES)
          STOP
        ENDIF
C
        IF(NOCA) THEN
          WRITE(6,'(A,A5)')'BACKBONE ALPHA CARBON MISSING; RESIDUE:',
     &     RESPDBNUM(IRES)
          STOP
        ENDIF
C
        IF(NOC) THEN
          WRITE(6,'(A,A5)')'BACKBONE CARBONYL CARBON MISSING; RESIDUE:',
     &     RESPDBNUM(IRES)
          STOP
        ENDIF
C
C MODEL MISSING C-BETA ATOM, ALSO FOR GLYCINE
C
        IF(NOCB) THEN
          IBBN=IBEF+1
          CALL MODCBETA(COOBB(1,IBBN))
          IBB=IBEF+4
          CB(IRES)=IBB
        ENDIF
C
        IBEF=IBEF+4
C
1     CONTINUE
      NBB=IBB
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
