C
C RATIO OF EXTERNAL TO INTERNAL MOTION FOR A PAIR OF DOMAINS
C INDEPENDENT OF RELATIVE SIZE OF DOMAINS. CALCULATED BY 
C "MASS" WEIGHTING BY INVERSE OF NUMBER OF RESIDUES IN DOMAIN
C
      SUBROUTINE EXTSTOP2 (NRES,NDOM,NSEG,IRESBEG,IRESEND,
     &NI,CA,CP,CB,COOBB1,COOBB2,MASS,ONEOK,ALLOK,
     &NDOMO,NCON,DOMCON,DOMORD,EXTCRIT,EXTINT)
C 
      IMPLICIT NONE
C 
      include 'DynDom.param'
C 
      INTEGER NDOM,DOMORD(*),NDOMO,IRES
      INTEGER NCON(*),DOMCON(NDOMX,*)
      INTEGER NRES,NTOT,IER
      INTEGER I,M,NDOMA,NDOMB,ISEG,NSEG(*)
      INTEGER IDOM,JDOM,IORD,JORD,NOCONDOM
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*)
      INTEGER NI(*),CA(*),CB(*),CP(*)
      REAL*8 MASS(*),R(3,3),RC1(3),AC1(3),RMSD
      REAL*8 COOBB1(3,*),COOBB2(3,*)
      REAL*8 CO1(3,NBBMX),CO2(3,NBBMX)
      REAL*8 VEXTMSFA,VINTMSFA,VMSFA
      REAL*8 VEXTMSFB,VINTMSFB,VMSFB
      REAL*8 VEXT,VINT,EXTCRIT
      REAL*8 EXTINT(NDOMX,*)
      LOGICAL ONEOK,ALLOK
C 
      ONEOK=.FALSE.
      ALLOK=.TRUE.
C 
      DO 80 IORD=1,NDOMO
        IDOM=DOMORD(IORD)
C
C DOMAIN A
C 
        NOCONDOM=0 
        M=0
        DO 20 ISEG=1,NSEG(IDOM)
          DO 10 IRES=IRESBEG(IDOM,ISEG),IRESEND(IDOM,ISEG)
            M=M+1
            CO1(1,M)=COOBB1(1,NI(IRES))
            CO1(2,M)=COOBB1(2,NI(IRES))
            CO1(3,M)=COOBB1(3,NI(IRES))
            CO2(1,M)=COOBB2(1,NI(IRES))
            CO2(2,M)=COOBB2(2,NI(IRES))
            CO2(3,M)=COOBB2(3,NI(IRES))
            M=M+1
            CO1(1,M)=COOBB1(1,CA(IRES))
            CO1(2,M)=COOBB1(2,CA(IRES))
            CO1(3,M)=COOBB1(3,CA(IRES))
            CO2(1,M)=COOBB2(1,CA(IRES))
            CO2(2,M)=COOBB2(2,CA(IRES))
            CO2(3,M)=COOBB2(3,CA(IRES))
            M=M+1
            CO1(1,M)=COOBB1(1,CP(IRES))
            CO1(2,M)=COOBB1(2,CP(IRES))
            CO1(3,M)=COOBB1(3,CP(IRES))
            CO2(1,M)=COOBB2(1,CP(IRES))
            CO2(2,M)=COOBB2(2,CP(IRES))
            CO2(3,M)=COOBB2(3,CP(IRES))
            M=M+1
            CO1(1,M)=COOBB1(1,CB(IRES))
            CO1(2,M)=COOBB1(2,CB(IRES))
            CO1(3,M)=COOBB1(3,CB(IRES))
            CO2(1,M)=COOBB2(1,CB(IRES))
            CO2(2,M)=COOBB2(2,CB(IRES))
            CO2(3,M)=COOBB2(3,CB(IRES))
10        CONTINUE
20      CONTINUE
        NDOMA=M
C 
C DOMAINS B
C 
        DO 70 JORD=1,NCON(IDOM)
          JDOM=DOMCON(IDOM,JORD)
          NOCONDOM=NOCONDOM+1
C
          NDOMB=0
          M=NDOMA
          DO 40 ISEG=1,NSEG(JDOM)
            DO 30 IRES=IRESBEG(JDOM,ISEG),IRESEND(JDOM,ISEG)
              M=M+1
              NDOMB=NDOMB+1
              CO1(1,M)=COOBB1(1,NI(IRES))
              CO1(2,M)=COOBB1(2,NI(IRES))
              CO1(3,M)=COOBB1(3,NI(IRES))
              CO2(1,M)=COOBB2(1,NI(IRES))
              CO2(2,M)=COOBB2(2,NI(IRES))
              CO2(3,M)=COOBB2(3,NI(IRES))
              M=M+1
              NDOMB=NDOMB+1
              CO1(1,M)=COOBB1(1,CA(IRES))
              CO1(2,M)=COOBB1(2,CA(IRES))
              CO1(3,M)=COOBB1(3,CA(IRES))
              CO2(1,M)=COOBB2(1,CA(IRES))
              CO2(2,M)=COOBB2(2,CA(IRES))
              CO2(3,M)=COOBB2(3,CA(IRES))
              M=M+1
              NDOMB=NDOMB+1
              CO1(1,M)=COOBB1(1,CP(IRES))
              CO1(2,M)=COOBB1(2,CP(IRES))
              CO1(3,M)=COOBB1(3,CP(IRES))
              CO2(1,M)=COOBB2(1,CP(IRES))
              CO2(2,M)=COOBB2(2,CP(IRES))
              CO2(3,M)=COOBB2(3,CP(IRES))
              M=M+1
              NDOMB=NDOMB+1
              CO1(1,M)=COOBB1(1,CB(IRES))
              CO1(2,M)=COOBB1(2,CB(IRES))
              CO1(3,M)=COOBB1(3,CB(IRES))
              CO2(1,M)=COOBB2(1,CB(IRES))
              CO2(2,M)=COOBB2(2,CB(IRES))
              CO2(3,M)=COOBB2(3,CB(IRES))
30          CONTINUE
40        CONTINUE
          NTOT=NDOMA+NDOMB
C
C BEST FIT BACKBONE ATOMS FROM TWO CONFORMATIONS SO THAT IT IS INDEPENDENT
C OF NUMBER OF ATOMS IN THE DOMAINS
C
          DO 100 I=1,NDOMA
            MASS(I)=1.0/REAL(NDOMA)
100       CONTINUE
C
          DO 101 I=NDOMA+1,NTOT
            MASS(I)=1.0/REAL(NDOMB)
101       CONTINUE
C
          CALL BSTFT(NTOT,CO1,CO2,RMSD,RC1,AC1,R,IER,MASS)
C 
C RESET MASSES TO 1.0
C
          DO 102 I=1,NTOT
            MASS(I)=1.0
102       CONTINUE
C
          CALL EXTMSF (NDOMA,MASS,CO1,CO2,VEXTMSFA,VINTMSFA,VMSFA)
C 
          CALL EXTMSF (NDOMB,MASS(NDOMA+1),CO1(1,NDOMA+1),
     &                 CO2(1,NDOMA+1),VEXTMSFB,VINTMSFB,VMSFB)
C
          VEXT=(VEXTMSFA)/NDOMA+(VEXTMSFB)/NDOMB
          VINT=(VINTMSFA)/NDOMA+(VINTMSFB)/NDOMB
          EXTINT(IDOM,JDOM)=SQRT(VEXT/VINT)
          WRITE(6,'(A,F8.3)')'ratio of interdomain to intradomain displa
     &cement:',EXTINT(IDOM,JDOM)
          IF(EXTINT(IDOM,JDOM).GE.EXTCRIT) THEN
            ONEOK=.TRUE.
            WRITE(6,'(A)')'domain pair accepted'
          ELSE
            ALLOK=.FALSE.
            WRITE(6,'(A)')'domain pair not accepted'
          ENDIF
C
C RESET DOMAIN A COORDINATES
C
          M=0
          DO 21 ISEG=1,NSEG(IDOM)
            DO 11 IRES=IRESBEG(IDOM,ISEG),IRESEND(IDOM,ISEG)
              M=M+1
              CO1(1,M)=COOBB1(1,NI(IRES))
              CO1(2,M)=COOBB1(2,NI(IRES))
              CO1(3,M)=COOBB1(3,NI(IRES))
              CO2(1,M)=COOBB2(1,NI(IRES))
              CO2(2,M)=COOBB2(2,NI(IRES))
              CO2(3,M)=COOBB2(3,NI(IRES))
              M=M+1
              CO1(1,M)=COOBB1(1,CA(IRES))
              CO1(2,M)=COOBB1(2,CA(IRES))
              CO1(3,M)=COOBB1(3,CA(IRES))
              CO2(1,M)=COOBB2(1,CA(IRES))
              CO2(2,M)=COOBB2(2,CA(IRES))
              CO2(3,M)=COOBB2(3,CA(IRES))
              M=M+1
              CO1(1,M)=COOBB1(1,CP(IRES))
              CO1(2,M)=COOBB1(2,CP(IRES))
              CO1(3,M)=COOBB1(3,CP(IRES))
              CO2(1,M)=COOBB2(1,CP(IRES))
              CO2(2,M)=COOBB2(2,CP(IRES))
              CO2(3,M)=COOBB2(3,CP(IRES))
              M=M+1
              CO1(1,M)=COOBB1(1,CB(IRES))
              CO1(2,M)=COOBB1(2,CB(IRES))
              CO1(3,M)=COOBB1(3,CB(IRES))
              CO2(1,M)=COOBB2(1,CB(IRES))
              CO2(2,M)=COOBB2(2,CB(IRES))
              CO2(3,M)=COOBB2(3,CB(IRES))
11          CONTINUE
21        CONTINUE
C
70      CONTINUE
80    CONTINUE
C
      IF(NOCONDOM.EQ.0) ALLOK=.FALSE. 
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
