C
C ROUTINE TO FIT THE FIXED DOMAIN CONFORMER 1 TO CONFORMER 2 
C FOR DISPLAY
C

      SUBROUTINE FITCONFORMERS(NBB,DOMA,NSEG,IRESBEG,IRESEND,NATOT1,
     &   NATOT2,ATYP1,ATYP2,RESTYP1,RESTYP2,FILEIN1,IEND1,FILEIN2,
     &   IEND2,CHAINID1,CHAINID2,RESNUM1,RESNUM2,NI,CA,CP,CB,COOBB1,
     &   COOBB2,COO1,COO2,MASS,NRES1,NAAT1,NRES,ATLIST1,WINDLEN,IOUT6)  
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      INTEGER DOMA,IOUT6,NATOT1,NATOT2,ISEG,IAT,M,I,IB
      INTEGER NSEG(*),IRESBEG(NDOMX,*),IRESEND(NDOMX,*),IRES,IAAT
      INTEGER NI(*),CA(*),CB(*),CP(*),WINDLEN,NBB,NRES
      INTEGER NRES1,NAAT1(*),ATLIST1(NRESMX,*),NDOM,IWIND  
      INTEGER IEND1,IEND2  
      REAL*8 COOBB1(3,*),COOBB2(3,*),COOBB2F(3,NBBMX),MASS(*),RMSD
      REAL*8 CO1(3,NBBMX),CO2(3,NBBMX),ROT(NRESMX,3)    
      REAL*8 COO1(3,*),COO2(3,*),AMPTHET(NRESMX),AMPTHETAV,AMP
      CHARACTER*4 ATYP1(*),ATYP2(*)
      CHARACTER*4 RESTYP1(*),RESTYP2(*)
      CHARACTER*5 RESNUM1(*),RESNUM2(*)
      CHARACTER*1 CHAINID1,CHAINID2
      CHARACTER*200 FILEIN1,FILEIN2
C
      DO 12 IB=1,NBB
        COOBB2F(1,IB)=COOBB2(1,IB)
        COOBB2F(2,IB)=COOBB2(2,IB)
        COOBB2F(3,IB)=COOBB2(3,IB)
12    CONTINUE
C
C FIT CONFORMERS AT DOMAIN A AND DETERMINE ROTATION VECTORS
C
        CALL ROTVECFIELD(NBB,NRES,DOMA,NSEG,IRESBEG,IRESEND,NI,CA,
     & CP,CB,WINDLEN,COOBB1,COOBB2,ROT,AMPTHET,AMPTHETAV,MASS,RMSD) 
C
      M=0
      DO 20 ISEG=1,NSEG(DOMA)
        DO 10 IRES=IRESBEG(DOMA,ISEG),IRESEND(DOMA,ISEG)
          M=M+1
          CO1(1,M)=COOBB1(1,NI(IRES))
          CO1(2,M)=COOBB1(2,NI(IRES))
          CO1(3,M)=COOBB1(3,NI(IRES))
          CO2(1,M)=COOBB2F(1,NI(IRES))
          CO2(2,M)=COOBB2F(2,NI(IRES))
          CO2(3,M)=COOBB2F(3,NI(IRES))
          M=M+1
          CO1(1,M)=COOBB1(1,CA(IRES))
          CO1(2,M)=COOBB1(2,CA(IRES))
          CO1(3,M)=COOBB1(3,CA(IRES))
          CO2(1,M)=COOBB2F(1,CA(IRES))
          CO2(2,M)=COOBB2F(2,CA(IRES))
          CO2(3,M)=COOBB2F(3,CA(IRES))
          M=M+1
          CO1(1,M)=COOBB1(1,CP(IRES))
          CO1(2,M)=COOBB1(2,CP(IRES))
          CO1(3,M)=COOBB1(3,CP(IRES))
          CO2(1,M)=COOBB2F(1,CP(IRES))
          CO2(2,M)=COOBB2F(2,CP(IRES))
          CO2(3,M)=COOBB2F(3,CP(IRES))
          M=M+1
          CO1(1,M)=COOBB1(1,CB(IRES))
          CO1(2,M)=COOBB1(2,CB(IRES))
          CO1(3,M)=COOBB1(3,CB(IRES))
          CO2(1,M)=COOBB2F(1,CB(IRES))
          CO2(2,M)=COOBB2F(2,CB(IRES))
          CO2(3,M)=COOBB2F(3,CB(IRES))
10      CONTINUE
20    CONTINUE
      NDOM=M
C 
C FIT DOMAIN A OF CONFORMATION 2 TO DOMAIN A OF CONFORMATION 1 RELOCATING
C WHOLE OF CONFORMATION 2 ACCORDINGLY
C 
       CALL FITPART (NDOM,NATOT2,CO1,CO2,COO2,MASS,RMSD)
C
C OUTPUT BOTH CONFORMERS SUPERIMPOSED ON THEIR FIXED DOMAIN IF
C THERE IS ONLY ONE FIXED DOMAIN
C
        WRITE(IOUT6,'(A18,A,A1,A1)')'1st chain (A) is: ',
     &   FILEIN1(1:IEND1),'_',CHAINID1 
        WRITE(IOUT6,'(A18,A,A1,A1)')'2nd chain (B) is: ',
     &   FILEIN2(1:IEND2),'_',CHAINID2 
        CHAINID1='A'
        CHAINID2='B'
        IWIND=0
        DO 71 IRES=1,NRES1
          IF(IRES.LE.WINDLEN/2.OR.IRES.GT.NRES-(WINDLEN/2)) THEN
            AMP=0
          ELSE
            IWIND=IWIND+1
            AMP=AMPTHET(IWIND)
          ENDIF
          DO 73 IAAT=1,NAAT1(IRES)
            IAT=ATLIST1(IRES,IAAT)
            WRITE(IOUT6,2000)'ATOM',IAT,ATYP1(IAT),RESTYP1(IAT),CHAINID1
     &       ,RESNUM1(IAT),COO1(1,IAT),COO1(2,IAT),COO1(3,IAT),
     &       AMP
73        CONTINUE
71      CONTINUE
        WRITE(IOUT6,'(A)')'TER'
C
        DO 72 IAT=1,NATOT2
          WRITE(IOUT6,2000)'ATOM',IAT,ATYP2(IAT),RESTYP2(IAT),CHAINID2,
     &     RESNUM2(IAT),COO2(1,IAT),COO2(2,IAT),COO2(3,IAT)
72      CONTINUE
        WRITE(IOUT6,'(A)')'TER'
C
2000  FORMAT(A4,2X,I5,2X,A4,A4,A1,A5,3X,3F8.3,6X,F6.2) 
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------

