C
C ROUTINE TO FIT TWO CONFORMATIONS AND CALCULATE ROTATION VECTORS 
C FOR EACH WINDOW SEGMENT
C
      SUBROUTINE ROTVECFIELD(NBB,NRES,IDOM,NSEG,IRESBEG,IRESEND,NI,CA,
     & CP,CB,WINDLEN,COOBB1,COOBB2,ROT,AMPTHET,AMPTHETAV,MASS,RMSDW) 
C
      IMPLICIT NONE
C
      include 'DynDom.param'           
C
      INTEGER WINDLEN,IDOM,NSEG(*),IRESBEG(NDOMX,*),IRESEND(NDOMX,*)
      INTEGER NBB,NRES,NI(*),CA(*),CP(*),CB(*),IRES
      INTEGER NWIND,IWIND,IB,IAT1,IAT2,IAT3,IAT4,NBBWIND
      REAL*8 COOBB1(3,*),COOBB2(3,*),MASS(*) 
      REAL*8 ROT(NRESMX,*),AMP,AMPTHET(*),AMPTHETAV
      REAL*8 COBB1(3,NBBMX),COBB2(3,NBBMX)
      REAL*8 VEXT(12),VEXTMSF,VINTMSF,VMSF,TRACER  
      REAL*8 UNTHX,UNTHY,UNTHZ,RMSD,RMSDW  
C
      CALL FITDOM(NBB,IDOM,NSEG,IRESBEG,IRESEND,NI,CA,CP,CB,
     & COOBB1,COOBB2,MASS,RMSDW)
C
      NWIND=NRES-WINDLEN+1
C
      AMPTHETAV=0.0
      DO 50 IWIND=1,NWIND
C
C DETERMINE BACKBONE ATOMS FOR EACH WINDOW
C
        IB=0
        DO 20 IRES=IWIND,IWIND+WINDLEN-1
          IB=IB+1
          IAT1=IB
          COBB1(1,IB)=COOBB1(1,NI(IRES))
          COBB1(2,IB)=COOBB1(2,NI(IRES))
          COBB1(3,IB)=COOBB1(3,NI(IRES))
          COBB2(1,IB)=COOBB2(1,NI(IRES))
          COBB2(2,IB)=COOBB2(2,NI(IRES))
          COBB2(3,IB)=COOBB2(3,NI(IRES))
          IB=IB+1
          IAT2=IB
          COBB1(1,IB)=COOBB1(1,CA(IRES))
          COBB1(2,IB)=COOBB1(2,CA(IRES))
          COBB1(3,IB)=COOBB1(3,CA(IRES))
          COBB2(1,IB)=COOBB2(1,CA(IRES))
          COBB2(2,IB)=COOBB2(2,CA(IRES))
          COBB2(3,IB)=COOBB2(3,CA(IRES))
          IB=IB+1
          IAT3=IB
          COBB1(1,IB)=COOBB1(1,CP(IRES))
          COBB1(2,IB)=COOBB1(2,CP(IRES))
          COBB1(3,IB)=COOBB1(3,CP(IRES))
          COBB2(1,IB)=COOBB2(1,CP(IRES))
          COBB2(2,IB)=COOBB2(2,CP(IRES))
          COBB2(3,IB)=COOBB2(3,CP(IRES))
          IB=IB+1
          IAT4=IB
          COBB1(1,IB)=COOBB1(1,CB(IRES))
          COBB1(2,IB)=COOBB1(2,CB(IRES))
          COBB1(3,IB)=COOBB1(3,CB(IRES))
          COBB2(1,IB)=COOBB2(1,CB(IRES))
          COBB2(2,IB)=COOBB2(2,CB(IRES))
          COBB2(3,IB)=COOBB2(3,CB(IRES))
20      CONTINUE
C
        NBBWIND=IB
C
C DETERMINE EXTERNAL COMPONENT TO MOTION
C
        CALL EXTCOMP2(NBBWIND,IAT1,IAT2,IAT3,IAT4,MASS,COBB1,COBB2,
     & VEXT,VEXTMSF,VINTMSF,VMSF,TRACER,RMSD)
C
C DETERMINE ROTATION VECTOR
C
        CALL ROTVEC(IAT1,IAT2,IAT3,IAT4,COBB1,VEXT,TRACER,AMP,
     &              UNTHX,UNTHY,UNTHZ)
C
        AMPTHET(IWIND)=AMP
        ROT(IWIND,1)=UNTHX*AMP
        ROT(IWIND,2)=UNTHY*AMP
        ROT(IWIND,3)=UNTHZ*AMP
C
        AMPTHETAV=AMPTHETAV+AMP
C
50    CONTINUE
C
      AMPTHETAV=AMPTHETAV/NWIND
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------

