C
C ROUTINE TO DETERMINE SCREW AXES OF DYNAMICAL DOMAINS
C
        SUBROUTINE SCREWAX(IAT1,IAT2,IAT3,IAT4,CO,V,AMPTHET,
     &                     UNTHX,UNTHY,UNTHZ,AMPTR,XAX1,YAX1,ZAX1)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
       INTEGER IAT1,IAT2,IAT3,IAT4,M
       REAL*8 V(*),COMP1,COMP2,COMP3,COMP4
       REAL*8 TRPARX1,TRPARY1,TRPARZ1,TRPARX2,TRPARY2,TRPARZ2
       REAL*8 TRPARX3,TRPARY3,TRPARZ3,TRPARX4,TRPARY4,TRPARZ4
       REAL*8 ROTX1,ROTY1,ROTZ1,ROTX2,ROTY2,ROTZ2,ROTX3,ROTY3,ROTZ3
       REAL*8 ROTX4,ROTY4,ROTZ4,AMPROT1,AMPROT2,AMPROT3,AMPROT4
       REAL*8 UNROTX1,UNROTY1,UNROTZ1,UNROTX2,UNROTY2,UNROTZ2
       REAL*8 UNROTX3,UNROTY3,UNROTZ3,UNROTX4,UNROTY4,UNROTZ4
       REAL*8 AXIX1,AXIY1,AXIZ1,AXIX2,AXIY2,AXIZ2
       REAL*8 AXIX3,AXIY3,AXIZ3,AXIX4,AXIY4,AXIZ4
       REAL*8 RAXIX1,RAXIY1,RAXIZ1,RAXIX2,RAXIY2,RAXIZ2
       REAL*8 RAXIX3,RAXIY3,RAXIZ3,RAXIX4,RAXIY4,RAXIZ4
       REAL*8 XAX1,YAX1,ZAX1,XAX2,YAX2,ZAX2
       REAL*8 XAX3,YAX3,ZAX3,XAX4,YAX4,ZAX4
       REAL*8 CO(3,*),HTAN,DIST,AMPTR
       REAL*8 UNTHX,UNTHY,UNTHZ,AMPTHET 
C
          M=0
C
          COMP1=V(1*3-2)*UNTHX+V(1*3-1)*UNTHY+V(1*3)*UNTHZ
          COMP2=V(2*3-2)*UNTHX+V(2*3-1)*UNTHY+V(2*3)*UNTHZ
          COMP3=V(3*3-2)*UNTHX+V(3*3-1)*UNTHY+V(3*3)*UNTHZ
          COMP4=V(4*3-2)*UNTHX+V(4*3-1)*UNTHY+V(4*3)*UNTHZ
          TRPARX1=COMP1*UNTHX
          TRPARY1=COMP1*UNTHY
          TRPARZ1=COMP1*UNTHZ
          TRPARX2=COMP2*UNTHX
          TRPARY2=COMP2*UNTHY
          TRPARZ2=COMP2*UNTHZ
          TRPARX3=COMP3*UNTHX
          TRPARY3=COMP3*UNTHY
          TRPARZ3=COMP3*UNTHZ
          TRPARX4=COMP4*UNTHX
          TRPARY4=COMP4*UNTHY
          TRPARZ4=COMP4*UNTHZ
          AMPTR=(COMP1+COMP2+COMP3+COMP4)/4.0
C
C NOW CALCULATE DIFFERENCE BETWEEN DISPLACEMENTS AND PARALLEL TRANSLATIONS
C TO GIVE ROTATIONAL PARTS
C
          ROTX1=V(1*3-2)-TRPARX1
          ROTY1=V(1*3-1)-TRPARY1
          ROTZ1=V(1*3  )-TRPARZ1
          ROTX2=V(2*3-2)-TRPARX2
          ROTY2=V(2*3-1)-TRPARY2
          ROTZ2=V(2*3  )-TRPARZ2
          ROTX3=V(3*3-2)-TRPARX3
          ROTY3=V(3*3-1)-TRPARY3
          ROTZ3=V(3*3  )-TRPARZ3
          ROTX4=V(4*3-2)-TRPARX4
          ROTY4=V(4*3-1)-TRPARY4
          ROTZ4=V(4*3  )-TRPARZ4
          AMPROT1=SQRT(ROTX1**2+ROTY1**2+ROTZ1**2)
          AMPROT2=SQRT(ROTX2**2+ROTY2**2+ROTZ2**2)
          AMPROT3=SQRT(ROTX3**2+ROTY3**2+ROTZ3**2)
          AMPROT4=SQRT(ROTX4**2+ROTY4**2+ROTZ4**2)
C
C CALCULATE UNIT VECTORS IN DIRECTION OF ROTATIONAL PARTS
C
          UNROTX1=ROTX1/AMPROT1
          UNROTY1=ROTY1/AMPROT1
          UNROTZ1=ROTZ1/AMPROT1
          UNROTX2=ROTX2/AMPROT2
          UNROTY2=ROTY2/AMPROT2
          UNROTZ2=ROTZ2/AMPROT2
          UNROTX3=ROTX3/AMPROT3
          UNROTY3=ROTY3/AMPROT3
          UNROTZ3=ROTZ3/AMPROT3
          UNROTX4=ROTX4/AMPROT4
          UNROTY4=ROTY4/AMPROT4
          UNROTZ4=ROTZ4/AMPROT4
C
C CALCULATE VECTORS IN DIRECTION FROM ATOMS TO AXIS (PERPENDICULARLY)
C
          AXIX1=(UNROTY1*UNTHZ-UNROTZ1*UNTHY)
          AXIY1=(UNROTZ1*UNTHX-UNROTX1*UNTHZ)
          AXIZ1=(UNROTX1*UNTHY-UNROTY1*UNTHX)
          AXIX2=(UNROTY2*UNTHZ-UNROTZ2*UNTHY)
          AXIY2=(UNROTZ2*UNTHX-UNROTX2*UNTHZ)
          AXIZ2=(UNROTX2*UNTHY-UNROTY2*UNTHX)
          AXIX3=(UNROTY3*UNTHZ-UNROTZ3*UNTHY)
          AXIY3=(UNROTZ3*UNTHX-UNROTX3*UNTHZ)
          AXIZ3=(UNROTX3*UNTHY-UNROTY3*UNTHX)
          AXIX4=(UNROTY4*UNTHZ-UNROTZ4*UNTHY)
          AXIY4=(UNROTZ4*UNTHX-UNROTX4*UNTHZ)
          AXIZ4=(UNROTX4*UNTHY-UNROTY4*UNTHX)
C
          HTAN=2*TAN(0.5*AMPTHET)
          RAXIX1=AMPROT1*AXIX1/HTAN
          RAXIY1=AMPROT1*AXIY1/HTAN
          RAXIZ1=AMPROT1*AXIZ1/HTAN
          RAXIX2=AMPROT2*AXIX2/HTAN
          RAXIY2=AMPROT2*AXIY2/HTAN
          RAXIZ2=AMPROT2*AXIZ2/HTAN
          RAXIX3=AMPROT3*AXIX3/HTAN
          RAXIY3=AMPROT3*AXIY3/HTAN
          RAXIZ3=AMPROT3*AXIZ3/HTAN
          RAXIX4=AMPROT4*AXIX4/HTAN
          RAXIY4=AMPROT4*AXIY4/HTAN
          RAXIZ4=AMPROT4*AXIZ4/HTAN
C
C SUBSTRACT THESE VECTORS FROM POSITION VECTORS TO GET POINTS ON AXIS
C
          XAX1=CO(1,IAT1)+(0.5*ROTX1)-RAXIX1
          YAX1=CO(2,IAT1)+(0.5*ROTY1)-RAXIY1
          ZAX1=CO(3,IAT1)+(0.5*ROTZ1)-RAXIZ1
          XAX2=CO(1,IAT2)+(0.5*ROTX2)-RAXIX2
          YAX2=CO(2,IAT2)+(0.5*ROTY2)-RAXIY2
          ZAX2=CO(3,IAT2)+(0.5*ROTZ2)-RAXIZ2
          XAX3=CO(1,IAT3)+(0.5*ROTX3)-RAXIX3
          YAX3=CO(2,IAT3)+(0.5*ROTY3)-RAXIY3
          ZAX3=CO(3,IAT3)+(0.5*ROTZ3)-RAXIZ3
          XAX4=CO(1,IAT4)+(0.5*ROTX4)-RAXIX4
          YAX4=CO(2,IAT4)+(0.5*ROTY4)-RAXIY4
          ZAX4=CO(3,IAT4)+(0.5*ROTZ4)-RAXIZ4
C           
        RETURN                                                            
        END                                                             
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
