C
C CHECKS THAT SEGMENTS CONNECT IN SPACE TO FORM A SINGLE DOMAIN
C USING A DISTANCE CRITERION "DISTCRIT", IF NOT A NEW DOMAIN IS CREATED
C
C THIS VERSION (2) COUNTS NUMBER OF TIMES CLUSTERS DO NOT 
C RESULT IN ANY DOMAINS AND PASSES THIS NUMBER (ISTOP) BACK 
C TO CLUSTER2 ROUTINE
C
      SUBROUTINE SEGCONNECT2(DOMIN,NDOM,NAAT1,NAAT2,ATLIST1,
     & ATLIST2,COO1,COO2,IRESBEG,IRESEND,NSEG,NONDOM,NONRESBEG,NONRESEND
     & ,NONSEG,CLUSNO)
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      INTEGER IDOM,NDOM,NDOMI,NEWDOM,NSEG(*),NONDOM
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*),NEWSEG(NDOMX)
      INTEGER NONRESBEG(NDOMX,*),NONRESEND(NDOMX,*),NONSEG(NDOMX)
      INTEGER IRESBEGN(NDOMX,NSEGMX),IRESENDN(NDOMX,NSEGMX),I,J
      INTEGER ISEG,JSEG,STORESEG(NSEGMX),DROPN(NSEGMX),IC(NSEGMX)
      INTEGER DROP(NSEGMX),DROPNUM(NSEGMX,NSEGMX),DROPMIN,K,L,M,N
      INTEGER DOMIN,DOMSIZE(NDOMX),CLUSNO
      INTEGER NAAT1(*),NAAT2(*)
      INTEGER ATLIST1(NRESMX,*),ATLIST2(NRESMX,*)
      REAL*8 COO1(3,*),COO2(3,*)
      LOGICAL CONTACTOK,CON1,CON2,FLAG,STOPCLUSN,STOPCLUS,STOPCLUS2
C
      CLUSNO=0
C
      DO 100 I=1,NDOMX 
        DOMSIZE(I)=0
100   CONTINUE
C
      NDOMI=NDOM
      STOPCLUS=.FALSE.
C
C LOOP OVER CLUSTERS
C
      DO 1 IDOM=1,NDOM
C
        STOPCLUS2=.FALSE.
C
        IF(NSEG(IDOM).EQ.0) GOTO 1
C
        DO 31 ISEG=1,NSEG(IDOM)
          DROP(ISEG)=0
          DROPN(ISEG)=0
31      CONTINUE
C
C LOOK FOR CONTACTING SEGMENTS WITHIN A DOMAIN AND GIVE
C ALL CONTACTING SEGMENTS, JSEG, A DROP VALUE OF THE CURRENT SEGMENT 
C ISEG
C
        DO 2 ISEG=1,NSEG(IDOM)
          K=0
          DO 3 JSEG=1,NSEG(IDOM)
            CON1=CONTACTOK(IDOM,JSEG,ISEG,IRESBEG,IRESEND,
     &NAAT1,ATLIST1,COO1)
            CON2=CONTACTOK(IDOM,JSEG,ISEG,IRESBEG,IRESEND,
     &NAAT2,ATLIST2,COO2)
            IF(CON1.AND.CON2) THEN
              K=K+1
              DROPN(JSEG)=ISEG
              STORESEG(K)=JSEG
            ENDIF
3         CONTINUE
C
C IF CONNECTING SEGMENTS ARE ALSO CONNECTING SEGMENTS OF A PREVIOUS
C SEGMENT, THEN DETERMINE MINIMUM DROP NUMBER FOR THESE CONNECTING 
C SEGMENTS
C
          FLAG=.TRUE.
          DROPMIN=NSEG(IDOM)+1
          DO 5 L=1,K
            IF(DROP(STORESEG(L)).NE.0) THEN
              FLAG=.FALSE.
              IF(DROP(STORESEG(L)).LT.DROPMIN) THEN
                DROPMIN=DROP(STORESEG(L))
              ENDIF
            ENDIF
5         CONTINUE
C
C IF THE CONNECTING SEGMENTS WITH CURRENT SEGMENT DO NOT CONNECT
C TO ANY CONNECTING SEGMENTS OF A PREVIOUS SEGMENT, THEN STORE THESE
C SEGMENTS IN DROP WITH CURRENT SEGMENT NUMBER
C 
          IF(FLAG) THEN
            DO 10 L=1,K
              DROP(STORESEG(L))=DROPN(STORESEG(L))
10          CONTINUE
            GOTO 2
          ENDIF
C
C GIVE ALL THOSE PREVIOUS SEGMENTS THAT HAVE CONNECTION WITH
C SEGMENTS OF CURRENT SEGMENT, MINIMUM DROP VALUE
C
          DO 6 M=1,K
            DO 7 N=1,NSEG(IDOM)
              IF(DROP(N).EQ.DROP(STORESEG(M)).AND.DROP(N).NE.0)
     & THEN
                DROP(N)=DROPMIN
              ENDIF
7           CONTINUE
6         CONTINUE
C
          DO 8 L=1,K
            DROP(STORESEG(L))=DROPMIN
8         CONTINUE
C
2       CONTINUE
C
        DO 13 I=1,NSEG(IDOM)
          IC(I)=0
13      CONTINUE
C
C IC COUNTS NUMBER OF SEGMENTS WITH SAME DROP NUMBER
C DROPNUM GIVES SEGMENT NUMBERS IN EACH DROP 
C
        DO 12 I=1,NSEG(IDOM)
          IC(DROP(I))=IC(DROP(I))+1
          DROPNUM(IC(DROP(I)),DROP(I))=I
12      CONTINUE
C
        STOPCLUSN=.TRUE.
        NEWDOM=0
        DO 14 I=1,NSEG(IDOM)
          IF(IC(I).EQ.0) GOTO 14
          NEWDOM=NEWDOM+1
          IF(NEWDOM.EQ.1) THEN
            NEWSEG(IDOM)=IC(I)
            DO 15 J=1,IC(I)
              IRESBEGN(IDOM,J)=IRESBEG(IDOM,DROPNUM(J,I))
              IRESENDN(IDOM,J)=IRESEND(IDOM,DROPNUM(J,I))
              DOMSIZE(IDOM)=DOMSIZE(IDOM)+(IRESENDN(IDOM,J)
     &-IRESBEGN(IDOM,J)+1)
15          CONTINUE
C
C CREATE NEW CLUSTER
C
C STOP CLUSTERING ALGORITHM IF ANY CLUSTER DOESN'T HAVE A DOMAIN 
C WITH AT LEAST "DOMIN" RESIDUES
C
            IF(DOMSIZE(IDOM).GE.DOMIN) STOPCLUSN=.FALSE.
          ELSE
            NDOMI=NDOMI+1
C
            IF(NDOMI.GT.NDOMX) THEN
              WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF DOMAINS 
     &HAS BEEN EXCEEDED: ',NDOMX,NDOMI
              WRITE(6,'(A)')'CHANGE VALUE OF "NDOMX" IN "DynDom.param"'
              STOP
            ENDIF
C
            NEWSEG(NDOMI)=IC(I)
            DO 16 J=1,IC(I)
              IRESBEGN(NDOMI,J)=IRESBEG(IDOM,DROPNUM(J,I))
              IRESENDN(NDOMI,J)=IRESEND(IDOM,DROPNUM(J,I))
              DOMSIZE(NDOMI)=DOMSIZE(NDOMI)+(IRESENDN(NDOMI,J)
     &-IRESBEGN(NDOMI,J)+1)
16          CONTINUE
            IF(DOMSIZE(NDOMI).GE.DOMIN) STOPCLUSN=.FALSE.
          ENDIF
14      CONTINUE
C
        IF(STOPCLUSN) STOPCLUS=.TRUE.
        IF(STOPCLUSN) STOPCLUS2=.TRUE.
C
        IF(STOPCLUS2) THEN
          CLUSNO=CLUSNO+1
        ENDIF
C
1     CONTINUE
C
C DOMAINS OF SIZE LESS THAN DOMIN ARE NOT INCLUDED
C
      M=0
      N=0
      DO 18 I=1,NDOMI
        IF(DOMSIZE(I).LT.DOMIN) THEN
          N=N+1
          NONSEG(N)=NEWSEG(I)
          DO 21 K=1,NONSEG(N)
            NONRESBEG(N,K)=IRESBEGN(I,K)
            NONRESEND(N,K)=IRESENDN(I,K)
21        CONTINUE
          GOTO 18
        ENDIF
        M=M+1
        NSEG(M)=NEWSEG(I)
        DO 19 J=1,NSEG(M)
          IRESBEG(M,J)=IRESBEGN(I,J)
          IRESEND(M,J)=IRESENDN(I,J)
19      CONTINUE
18    CONTINUE
      NDOM=M
      NONDOM=N
C
      RETURN
      END
C
C
      FUNCTION CONTACTOK(IDOM,JSEG,ISEG,IRESBEG,IRESEND,
     &NAAT,ATLIST,COO)
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      LOGICAL CONTACTOK
      INTEGER IRESBEG(NDOMX,*),IRESEND(NDOMX,*)
      INTEGER IDOM,ISEG,JSEG,IRESI,IRESJ,IAAI,IAAJ
      INTEGER IATI,IATJ
      INTEGER NAAT(*),ATLIST(NRESMX,*)
      REAL*8 COO(3,*),DIST,DISTX,DISTY,DISTZ
C
      CONTACTOK=.FALSE.
C
      DO 1 IRESI=IRESBEG(IDOM,ISEG),IRESEND(IDOM,ISEG)
        DO 2 IRESJ=IRESBEG(IDOM,JSEG),IRESEND(IDOM,JSEG)
          DO 3 IAAI=1,NAAT(IRESI)
            IATI=ATLIST(IRESI,IAAI)
            DO 4 IAAJ=1,NAAT(IRESJ)
              IATJ=ATLIST(IRESJ,IAAJ)
              DISTX=COO(1,IATI)-COO(1,IATJ)
              DISTY=COO(2,IATI)-COO(2,IATJ)
              DISTZ=COO(3,IATI)-COO(3,IATJ)
              DIST=SQRT(DISTX**2+DISTY**2+DISTZ**2)
              IF(DIST.LE.DISTCRIT) THEN
                CONTACTOK=.TRUE.
                RETURN
              ENDIF
4           CONTINUE
3         CONTINUE
2       CONTINUE
1     CONTINUE
C 
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
