C
C ROUTINE TO DETERMINE DIHEDRAL ANGLE CHANGES AND SCALAR PRODUCTS 
C OF AXES WITH SCREW AXIS
C
      SUBROUTINE TORDIFF(IRES,NI,CA,CP,CB,MASS,COOBB1,COOBB2,
     & UX,UY,UZ,IOUT7)
C
      IMPLICIT NONE
C
      include 'DynDom.param'
C
      INTEGER NI(*),CA(*),CP(*),CB(*),IRES,IOUT7
      REAL*8 COOBB1(3,*),COOBB2(3,*) 
      REAL*8 UNTHX,UNTHY,UNTHZ
      REAL*8 UPHIX1,UPHIY1,UPHIZ1,UPSIX1,UPSIY1,UPSIZ1,LENGTH
      REAL*8 UPHIX2,UPHIY2,UPHIZ2,UPSIX2,UPSIY2,UPSIZ2
      REAL*8 PHI1,PSI1,PHI2,PSI2
      REAL*8 PHIDIFF,PSIDIFF
      REAL*8 SCALARPS1,SCALARPH1,SCALARPS2,SCALARPH2
      REAL*8 MASS(*)
      REAL*8 UX,UY,UZ
C
C DETERMINE MAIN-CHAIN DIHEDRAL ANGLE CHANGES
C
      CALL TORDET(COOBB1,NI(IRES),CA(IRES),CP(IRES),NI(IRES+1),PSI1)
      CALL TORDET(COOBB1,CP(IRES),NI(IRES+1),CA(IRES+1),CP(IRES+1)
     & ,PHI1)
C
      CALL TORDET(COOBB2,NI(IRES),CA(IRES),CP(IRES),NI(IRES+1),PSI2)
      CALL TORDET(COOBB2,CP(IRES),NI(IRES+1),CA(IRES+1),CP(IRES+1)
     & ,PHI2)
C
      UPSIX1=COOBB1(1,CP(IRES))-COOBB1(1,CA(IRES))
      UPSIY1=COOBB1(2,CP(IRES))-COOBB1(2,CA(IRES))
      UPSIZ1=COOBB1(3,CP(IRES))-COOBB1(3,CA(IRES))
      LENGTH=SQRT(UPSIX1**2+UPSIY1**2+UPSIZ1**2)
      UPSIX1=UPSIX1/LENGTH
      UPSIY1=UPSIY1/LENGTH
      UPSIZ1=UPSIZ1/LENGTH
C
      UPHIX1=COOBB1(1,CA(IRES+1))-COOBB1(1,NI(IRES+1))
      UPHIY1=COOBB1(2,CA(IRES+1))-COOBB1(2,NI(IRES+1))
      UPHIZ1=COOBB1(3,CA(IRES+1))-COOBB1(3,NI(IRES+1))
      LENGTH=SQRT(UPHIX1**2+UPHIY1**2+UPHIZ1**2)
      UPHIX1=UPHIX1/LENGTH
      UPHIY1=UPHIY1/LENGTH
      UPHIZ1=UPHIZ1/LENGTH
C
      UPSIX2=COOBB2(1,CP(IRES))-COOBB2(1,CA(IRES))
      UPSIY2=COOBB2(2,CP(IRES))-COOBB2(2,CA(IRES))
      UPSIZ2=COOBB2(3,CP(IRES))-COOBB2(3,CA(IRES))
      LENGTH=SQRT(UPSIX2**2+UPSIY2**2+UPSIZ2**2)
      UPSIX2=UPSIX2/LENGTH
      UPSIY2=UPSIY2/LENGTH
      UPSIZ2=UPSIZ2/LENGTH
C
      UPHIX2=COOBB2(1,CA(IRES+1))-COOBB2(1,NI(IRES+1))
      UPHIY2=COOBB2(2,CA(IRES+1))-COOBB2(2,NI(IRES+1))
      UPHIZ2=COOBB2(3,CA(IRES+1))-COOBB2(3,NI(IRES+1))
      LENGTH=SQRT(UPHIX2**2+UPHIY2**2+UPHIZ2**2)
      UPHIX2=UPHIX2/LENGTH
      UPHIY2=UPHIY2/LENGTH
      UPHIZ2=UPHIZ2/LENGTH
C
      PHIDIFF=PHI2-PHI1
      IF(PHIDIFF.GT.180) PHIDIFF=-(360-PHIDIFF)
      IF(PHIDIFF.LT.-180) PHIDIFF=360+PHIDIFF
C
      PSIDIFF=PSI2-PSI1
      IF(PSIDIFF.GT.180) PSIDIFF=-(360-PSIDIFF)
      IF(PSIDIFF.LT.-180) PSIDIFF=360+PSIDIFF
C
      SCALARPH1=UX*UPHIX1+UY*UPHIY1+UZ*UPHIZ1
      SCALARPS1=UX*UPSIX1+UY*UPSIY1+UZ*UPSIZ1
      SCALARPH2=UX*UPHIX2+UY*UPHIY2+UZ*UPHIZ2
      SCALARPS2=UX*UPSIX2+UY*UPSIY2+UZ*UPSIZ2
C
      WRITE(IOUT7,'(A)')'phi and psi rotations and comparison of dihedra
     &l axes with screw axis'
      WRITE(IOUT7,'(A)')'      A        B       F        G        H     
     &   I'
      WRITE(IOUT7,'(6(1X,F8.3))') PSIDIFF,PHIDIFF,SCALARPS1,SCALARPH1,
     &SCALARPS2,SCALARPH2 
C
      RETURN
      END
